/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.render.remote;

import com.ge.med.jnu.statistics.JnHistogram;
import com.ge.med.terra.jami.CodecUtils;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpPixelStatistics;
import com.ge.med.terra.jami.remote.XpRemoteMedicalImage;
import com.ge.med.terra.jami.roi.RoiStatistics;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class RemoteRoiStatistics
implements RoiStatistics {
    private static final byte ROI_RECTANGLE = 0;
    private static final byte ROI_ELLIPSE = 1;
    private static final byte ROI_POLYGON = 2;
    private XpImage img = null;
    private XpPixelStatistics ps = new XpPixelStatistics();
    private int width = 0;
    private int height = 0;
    private double rescaleSlope = 1.0;
    private double rescaleIntercept = 0.0;

    @Override
    public JnHistogram calcHistogram(Shape s2, double angle, JnHistogram histogram) {
        return null;
    }

    public static int encode(Shape s2, double angle, byte[] buff, int startOffset) {
        int offset = startOffset;
        if (s2 instanceof Rectangle2D) {
            Rectangle2D r2 = (Rectangle2D)s2;
            buff[offset] = 0;
            CodecUtils.putDouble(buff, ++offset, angle);
            CodecUtils.putDouble(buff, offset += 8, r2.getX());
            CodecUtils.putDouble(buff, offset += 8, r2.getY());
            CodecUtils.putDouble(buff, offset += 8, r2.getWidth());
            CodecUtils.putDouble(buff, offset += 8, r2.getHeight());
            offset += 8;
        } else if (s2 instanceof Ellipse2D) {
            Ellipse2D e2 = (Ellipse2D)s2;
            buff[offset] = 1;
            CodecUtils.putDouble(buff, ++offset, angle);
            CodecUtils.putDouble(buff, offset += 8, e2.getX());
            CodecUtils.putDouble(buff, offset += 8, e2.getY());
            CodecUtils.putDouble(buff, offset += 8, e2.getWidth());
            CodecUtils.putDouble(buff, offset += 8, e2.getHeight());
            offset += 8;
        } else if (s2 instanceof GeneralPath) {
            // empty if block
        }
        return offset;
    }

    public static int decode(byte[] buff, int startOffset, Shape[] shape, double[] angle) {
        int offset = startOffset;
        byte roiType = buff[offset];
        angle[0] = CodecUtils.getDouble(buff, ++offset);
        offset += 8;
        switch (roiType) {
            case 0: {
                double x2 = CodecUtils.getDouble(buff, offset);
                double y2 = CodecUtils.getDouble(buff, offset += 8);
                double w2 = CodecUtils.getDouble(buff, offset += 8);
                double h2 = CodecUtils.getDouble(buff, offset += 8);
                offset += 8;
                shape[0] = new Rectangle2D.Double(x2, y2, w2, h2);
                break;
            }
            case 1: {
                double x3 = CodecUtils.getDouble(buff, offset);
                double y3 = CodecUtils.getDouble(buff, offset += 8);
                double w3 = CodecUtils.getDouble(buff, offset += 8);
                double h3 = CodecUtils.getDouble(buff, offset += 8);
                offset += 8;
                shape[0] = new Ellipse2D.Double(x3, y3, w3, h3);
            }
        }
        return offset;
    }

    @Override
    public double getArea(Shape s2, double angle) {
        if (this.img != null) {
            double[] stats = ((XpRemoteMedicalImage)this.img).getStatistics(s2, angle);
            return stats[7];
        }
        return 0.0;
    }

    @Override
    public double getLength(Shape s2, double angle) {
        if (this.img != null) {
            double[] stats = ((XpRemoteMedicalImage)this.img).getStatistics(s2, angle);
            return stats[8];
        }
        return -1.0;
    }

    @Override
    public XpPixelStatistics getPixelStatistics(Shape s2, double angle) {
        if (this.img != null) {
            double[] stats = ((XpRemoteMedicalImage)this.img).getStatistics(s2, angle);
            this.ps.min = stats[0];
            this.ps.max = stats[1];
            this.ps.sum = stats[2];
            this.ps.sumSq = stats[3];
            this.ps.mean = stats[4];
            this.ps.variance = stats[5];
            this.ps.npixels = (int)stats[6];
        }
        return this.ps;
    }

    @Override
    public BufferedImage getPixels(Shape s2, double angle) {
        return null;
    }

    @Override
    public void setImage(XpImage img) {
        this.img = img;
        if (img != null) {
            this.width = img.getSlice().width;
            this.height = img.getSlice().height;
            this.rescaleSlope = img.getRescaleSlope();
            this.rescaleIntercept = img.getRescaleIntercept();
        }
    }
}

