/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.render.remote;

import com.ge.med.terra.jami.CodecUtils;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.remote.RmCommand;
import com.ge.med.terra.jami.remote.RmServerDataManager;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.render.remote.Rm2DDispatcher;
import com.ge.med.terra.jami.render.remote.RmServer2DEngine;
import java.nio.ByteBuffer;

public class Rm2DServerDispatcher
extends Rm2DDispatcher {
    private RmServer2DEngine server_engine = null;
    private Object[] server_args = new Object[10];
    private byte[] outbuffer = new byte[4096];
    private XpImage[] images = null;
    private int curImgSetID = -1;
    private XpImageRenderAttributes ira = new XpImageRenderAttributes();

    public int createEngine(String rengine) {
        this.server_engine = new RmServer2DEngine();
        return this.server_engine.getServer2DEngineId();
    }

    public ByteBuffer processCommand(byte[] in) {
        byte cmdId = in[0];
        switch (cmdId) {
            case 1: {
                this.server_args[0] = new Integer(CodecUtils.getInt(in, 1));
                this.server_args[1] = new Integer(CodecUtils.getInt(in, 5));
                this.server_args[2] = new Byte(in[9]);
                break;
            }
            case 10: {
                break;
            }
            case 9: {
                int width = CodecUtils.getInt(in, 1);
                int height = CodecUtils.getInt(in, 5);
                this.outbuffer = new byte[width * height * 4];
                this.server_args[0] = new Integer(width);
                this.server_args[1] = new Integer(height);
                break;
            }
            case 11: {
                break;
            }
            case 2: {
                this.server_args[0] = new Boolean(CodecUtils.getBoolean(in, 1));
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                int setId = CodecUtils.getInt(in, 1);
                int id = CodecUtils.getInt(in, 5);
                if (this.images == null || this.curImgSetID != setId) {
                    this.curImgSetID = setId;
                    this.loadImageSet(this.curImgSetID);
                }
                if (this.images == null) break;
                this.server_args[0] = this.images[id];
                break;
            }
            case 5: {
                break;
            }
            case 12: {
                this.server_args[0] = new Integer(CodecUtils.getInt(in, 1));
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                double angle = CodecUtils.getDouble(in, 1);
                double panX = CodecUtils.getDouble(in, 9);
                double panY = CodecUtils.getDouble(in, 17);
                int pSize = CodecUtils.getInt(in, 25);
                double wl = CodecUtils.getDouble(in, 29);
                double ww = CodecUtils.getDouble(in, 37);
                double zoom = CodecUtils.getDouble(in, 45);
                this.ira.setAngle(angle);
                this.ira.setPan(panX, panY);
                this.ira.setPresentationSizeMode(pSize);
                this.ira.setWindowing(ww, wl);
                this.ira.setZoom(zoom);
                this.server_args[0] = this.ira;
                break;
            }
            case 8: {
                this.server_args[0] = new Boolean(CodecUtils.getBoolean(in, 1));
            }
        }
        RmCommand rmcmd = new RmCommand(cmdId, this.server_args);
        Object retval = this.server_engine.executeCommand(rmcmd);
        ByteBuffer xm_retval = null;
        switch (cmdId) {
            case 1: {
                Object[] retvals = (Object[])retval;
                int pblen = (Integer)retvals[0];
                byte[] pbencode = (byte[])retvals[1];
                xm_retval = ByteBuffer.wrap(pbencode, 0, pblen);
                break;
            }
            case 10: {
                String mpass_ret = "";
                Class[] malg = (Class[])retval;
                if (malg == null) break;
                mpass_ret = malg[0].getCanonicalName();
                for (int i2 = 1; i2 < malg.length; ++i2) {
                    mpass_ret = mpass_ret + "#" + malg[i2].getCanonicalName();
                }
                CodecUtils.putString(this.outbuffer, 0, mpass_ret);
                xm_retval = ByteBuffer.wrap(this.outbuffer, 0, 2 * mpass_ret.length() + 2);
                break;
            }
            case 9: {
                break;
            }
            case 11: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                boolean ftvp = (Boolean)retval;
                CodecUtils.putBoolean(this.outbuffer, 0, ftvp);
                xm_retval = ByteBuffer.wrap(this.outbuffer, 0, 1);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                int layer = (Integer)retval;
                CodecUtils.putInt(this.outbuffer, 0, layer);
                xm_retval = ByteBuffer.wrap(this.outbuffer, 0, 4);
                break;
            }
            case 12: {
                break;
            }
            case 6: {
                int layers = (Integer)retval;
                CodecUtils.putInt(this.outbuffer, 0, layers);
                xm_retval = ByteBuffer.wrap(this.outbuffer, 0, 4);
                break;
            }
            case 7: {
                break;
            }
        }
        return xm_retval;
    }

    private void loadImageSet(int imageSetID) {
        this.images = (XpImage[])RmServerDataManager.instance().getDataObject(imageSetID);
    }
}

