/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.roi;

import com.ge.med.jnu.statistics.JnHistogram;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImageUtils;
import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.XpPixelStatistics;
import com.ge.med.terra.jami.roi.RoiStatistics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import javax.swing.SwingUtilities;

public class JamiRoiStatistics
implements RoiStatistics {
    public static final double ZERO = 1.0E-4;
    private static final int BLOCK_DIM = 32;
    private XpImage img = null;
    private XpPixelStatistics ps = new XpPixelStatistics();
    private BufferedImage bitimg = null;
    private int width = 0;
    private int height = 0;
    private double rescaleSlope = 1.0;
    private double rescaleIntercept = 0.0;
    private Point2D[] pts = null;
    private Point2D bbox_p0 = new Point2D.Double();
    private Point2D bbox_p1 = new Point2D.Double();
    private int ROWLEN_BITMAP = 0;
    private Point2D temp_pt = new Point2D.Double();
    private Point2D bbpt = new Point2D.Double();
    private AffineTransform rotMatrix = new AffineTransform();
    private Point2D temppt = new Point2D.Double();
    private Point2D dirx = new Point2D.Double();
    private Point2D diry = new Point2D.Double();
    private Point2D rowstart = new Point2D.Double();
    private double[] _reg = new double[6];
    private int[] xpos = null;
    private int[] ypos = null;
    private int readpos = 0;
    private int writepos = 0;
    private static final byte[] bitmasks = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};
    private static final byte EDGE = 2;
    private static final byte UNDEF = 1;
    private static final byte EMPTY = 0;
    private static byte[] internalBuffer = null;
    private static int[] stack = null;
    private static int len = 0;

    @Override
    public void setImage(XpImage img) {
        this.img = img;
        if (img != null) {
            this.syncBitmap2Image();
        }
    }

    protected XpImage getImage() {
        return this.img;
    }

    private void syncBitmap2Image() {
        this.width = this.img.getSlice().width;
        this.height = this.img.getSlice().height;
        this.rescaleSlope = this.img.getRescaleSlope();
        this.rescaleIntercept = this.img.getRescaleIntercept();
        if (this.bitimg == null || this.width != this.bitimg.getWidth() || this.height != this.bitimg.getHeight()) {
            this.bitimg = new BufferedImage(this.width, this.height, 12);
            this.ROWLEN_BITMAP = this.width / 8;
            if ((this.width & 7) != 0) {
                ++this.ROWLEN_BITMAP;
            }
        }
    }

    private static Raster getRaster(RenderedImage ri) {
        Raster r2 = null;
        if (ri != null) {
            r2 = ri instanceof BufferedImage ? ((BufferedImage)ri).getRaster() : ri.getData();
        }
        return r2;
    }

    protected void calculateStatistics(int x1, int y1, int x2, int y2, XpPixelStatistics pixelStats) {
        if (this.img != null) {
            int pixelRepresentation = XpImageUtils.getPixelRepresentation(this.img);
            XpImageUtils.calcStats(this.img.getPixelData(), this.bitimg, this.rescaleSlope, this.rescaleIntercept, pixelRepresentation, x1, y1, x2, y2, pixelStats);
        }
    }

    public RenderedImage getPixelData() {
        if (this.img != null) {
            return this.img.getPixelData();
        }
        return null;
    }

    protected BufferedImage getBitImage() {
        return this.bitimg;
    }

    public double getRescaleSlope() {
        return this.rescaleSlope;
    }

    public double getRescaleIntercept() {
        return this.rescaleIntercept;
    }

    @Override
    public BufferedImage getPixels(Shape s2, double angle) {
        if (this.img != null) {
            this.syncBitmap(s2, angle);
            return this.bitimg;
        }
        return null;
    }

    private void calcBoundingBox(Rectangle2D r2d, double angle) {
        double w2 = r2d.getWidth();
        double h2 = r2d.getHeight();
        double x2 = r2d.getX();
        double y2 = r2d.getY();
        double theta = angle;
        double bx1 = x2;
        double by1 = y2;
        double bx2 = x2 + w2;
        double by2 = y2 + h2;
        if (angle != 0.0) {
            this.rotMatrix.setToRotation(theta, x2 + w2 * 0.5, y2 + h2 * 0.5);
            this.bbpt.setLocation(x2, y2);
            this.rotMatrix.transform(this.bbpt, this.temp_pt);
            bx1 = this.temp_pt.getX();
            by1 = this.temp_pt.getY();
            bx2 = this.temp_pt.getX();
            by2 = this.temp_pt.getY();
            this.bbpt.setLocation(x2 + w2, y2);
            this.rotMatrix.transform(this.bbpt, this.temp_pt);
            bx1 = Math.min(bx1, this.temp_pt.getX());
            by1 = Math.min(by1, this.temp_pt.getY());
            bx2 = Math.max(bx2, this.temp_pt.getX());
            by2 = Math.max(by2, this.temp_pt.getY());
            this.bbpt.setLocation(x2, y2 + h2);
            this.rotMatrix.transform(this.bbpt, this.temp_pt);
            bx1 = Math.min(bx1, this.temp_pt.getX());
            by1 = Math.min(by1, this.temp_pt.getY());
            bx2 = Math.max(bx2, this.temp_pt.getX());
            by2 = Math.max(by2, this.temp_pt.getY());
            this.bbpt.setLocation(x2 + w2, y2 + h2);
            this.rotMatrix.transform(this.bbpt, this.temp_pt);
            bx1 = Math.min(bx1, this.temp_pt.getX());
            by1 = Math.min(by1, this.temp_pt.getY());
            bx2 = Math.max(bx2, this.temp_pt.getX());
            by2 = Math.max(by2, this.temp_pt.getY());
        }
        bx1 -= 1.0;
        by1 -= 1.0;
        bx2 += 1.0;
        by2 += 1.0;
        if (bx1 < 0.0) {
            bx1 = 0.0;
        }
        if (bx2 > (double)(this.width - 1)) {
            bx2 = this.width - 1;
        }
        if (by1 < 0.0) {
            by1 = 0.0;
        }
        if (by2 > (double)(this.height - 1)) {
            by2 = this.height - 1;
        }
        this.bbox_p0.setLocation(bx1, by1);
        this.bbox_p1.setLocation(bx2, by2);
    }

    private void syncBitmap(final Shape s2, final double angle) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.sync(s2, angle);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        JamiRoiStatistics.this.sync(s2, angle);
                    }
                });
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
            }
            catch (InvocationTargetException e3) {
                e3.printStackTrace();
            }
        }
    }

    private void sync(Shape s2, double angle) {
        byte[] bits = ((DataBufferByte)this.bitimg.getRaster().getDataBuffer()).getData();
        this.calcBoundingBox(s2.getBounds2D(), angle);
        int x0 = (int)this.bbox_p0.getX();
        int y0 = (int)this.bbox_p0.getY();
        int x1 = (int)this.bbox_p1.getX();
        int y1 = (int)this.bbox_p1.getY();
        Arrays.fill(bits, (byte)0);
        if (s2 instanceof Ellipse2D) {
            Ellipse2D e2 = (Ellipse2D)s2;
            double cx = e2.getCenterX();
            double cy = e2.getCenterY();
            double rx = e2.getWidth() * 0.5;
            double ry = e2.getHeight() * 0.5;
            this.fillEllipse(cx, cy, rx, ry, angle, bits, this.ROWLEN_BITMAP, x0, y0, x1, y1);
        } else if (s2 instanceof Rectangle2D) {
            Rectangle2D r2 = (Rectangle2D)s2;
            double cx = r2.getCenterX();
            double cy = r2.getCenterY();
            double rw = r2.getWidth() * 0.5;
            double rh = r2.getHeight() * 0.5;
            this.fillRectangle(cx, cy, rw, rh, angle, bits, this.ROWLEN_BITMAP, x0, y0, x1, y1);
        } else if (s2 instanceof GeneralPath) {
            if (this.pts == null) {
                this.initPts();
            }
            int npts = this.getPoints((GeneralPath)s2, this.pts);
            Graphics2D g2 = (Graphics2D)this.bitimg.getGraphics();
            g2.draw(s2);
            g2.fill(s2);
        } else {
            Graphics2D g2 = (Graphics2D)this.bitimg.getGraphics();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Rectangle2D bounds = s2.getBounds2D();
            double cx = bounds.getCenterX();
            double cy = bounds.getCenterY();
            g2.rotate(-angle, cx, cy);
            g2.draw(s2);
            g2.fill(s2);
        }
    }

    @Override
    public double getArea(Shape s2, double angle) {
        if (this.img != null) {
            double pdx = this.img.getPixelDimensionX();
            double pdy = this.img.getPixelDimensionY();
            this.getPixelStatistics(s2, angle);
            return (double)this.ps.npixels * pdx * pdy;
        }
        return -1.0;
    }

    @Override
    public double getLength(Shape s2, double angle) {
        if (this.img != null) {
            double pdx = this.img.getPixelDimensionX();
            double pdy = this.img.getPixelDimensionY();
            return XpImageUtils.calcShapeLength(s2, pdx, pdy);
        }
        return -1.0;
    }

    @Override
    public XpPixelStatistics getPixelStatistics(Shape s2, double angle) {
        if (this.img != null) {
            this.syncBitmap2Image();
            this.syncBitmap(s2, angle);
            int x1 = (int)this.bbox_p0.getX();
            int y1 = (int)this.bbox_p0.getY();
            int x2 = (int)this.bbox_p1.getX();
            int y2 = (int)this.bbox_p1.getY();
            this.calculateStatistics(x1, y1, x2, y2, this.ps);
        }
        return this.ps;
    }

    @Override
    public JnHistogram calcHistogram(Shape s2, double angle, JnHistogram hist) {
        if (this.img != null) {
            if (hist == null) {
                hist = new JnHistogram(128);
            }
            int[] histogram = hist.histogram;
            Point maximumPt = hist.maximumPt;
            Arrays.fill(histogram, 0);
            XpPixelStatistics ps = this.getPixelStatistics(s2, angle);
            double maxval = (ps.max - this.rescaleIntercept) / this.rescaleSlope;
            double minval = (ps.min - this.rescaleIntercept) / this.rescaleSlope;
            double BUCKETSIZE = (maxval - minval) / (double)histogram.length;
            Raster r2 = JamiRoiStatistics.getRaster(this.img.getPixelData());
            if (r2 != null) {
                DataBuffer db = r2.getDataBuffer();
                short[] sdata = null;
                byte[] bdata = null;
                int[] idata = null;
                if (db instanceof DataBufferUShort) {
                    sdata = ((DataBufferUShort)db).getData();
                } else if (db instanceof DataBufferShort) {
                    sdata = ((DataBufferShort)db).getData();
                } else if (db instanceof DataBufferByte) {
                    bdata = ((DataBufferByte)db).getData();
                } else if (db instanceof DataBufferInt) {
                    idata = ((DataBufferInt)db).getData();
                }
                int maxX = 0;
                int maxY = 0;
                byte[] bitmap = ((DataBufferByte)this.bitimg.getRaster().getDataBuffer()).getData();
                int sX = ps.bounds.x;
                int sY = ps.bounds.y;
                int eX = ps.bounds.x + ps.bounds.width;
                int eY = ps.bounds.y + ps.bounds.height;
                for (int y2 = sY; y2 <= eY; ++y2) {
                    int idx_offset = y2 * this.ROWLEN_BITMAP;
                    for (int x2 = sX; x2 <= eX; ++x2) {
                        int bit = x2 & 7;
                        int idx = idx_offset + x2 / 8;
                        int on = XpPixelStatistics.bitmasks[bit] & bitmap[idx];
                        if (on == 0) continue;
                        int pval = 0;
                        if (sdata != null) {
                            pval = sdata[y2 * this.width + x2];
                        } else if (bdata != null) {
                            pval = bdata[y2 * this.width + x2] & 0xFF;
                        } else if (idata != null) {
                            pval = idata[y2 * this.width + x2];
                        }
                        int bucket = (int)(((double)pval - minval) / BUCKETSIZE);
                        if (bucket >= histogram.length) {
                            bucket = histogram.length - 1;
                        }
                        try {
                            int n2 = bucket;
                            histogram[n2] = histogram[n2] + 1;
                            if (histogram[bucket] <= maxY) continue;
                            maxY = histogram[bucket];
                            maxX = bucket;
                            continue;
                        }
                        catch (Exception ex) {
                            XpLog.logger().warning("Histogram Array Indexing problem: bucket=" + bucket + " | min=" + ps.min + " | pval=" + pval + " | BucketSize=" + BUCKETSIZE);
                        }
                    }
                }
                hist.bucketSize = BUCKETSIZE;
                hist.startX = ps.min;
                hist.endX = ps.max;
                maximumPt.setLocation(maxX, maxY);
            } else {
                throw new RuntimeException("No image raster to calculate histogram from");
            }
        }
        return hist;
    }

    private static void markBits(byte[] bitimg, int ROWLEN_BITMAP, int x0, int y0, int x1, int y1) {
        for (int y2 = y0; y2 <= y1; ++y2) {
            int yoffset = y2 * ROWLEN_BITMAP;
            for (int x2 = x0; x2 <= x1; ++x2) {
                int bidx = yoffset + (x2 >> 3);
                byte bmod = XpPixelStatistics.bitmasks[x2 & 7];
                bitimg[bidx] = (byte)(bitimg[bidx] | bmod);
            }
        }
    }

    private static void labelCorners(byte[] bitimg, int ROWLEN_BITMAP, int x0, int y0, int x1, int y1, int w2, int h2) {
        for (int y2 = y0; y2 <= y1; ++y2) {
            int yoffset0 = y2 * ROWLEN_BITMAP;
            int yoffset1 = (y2 + 1) * ROWLEN_BITMAP;
            for (int x2 = x0; x2 <= x1; ++x2) {
                int bidx0 = x2 >> 3;
                int bmod0 = x2 & 7;
                byte mask = XpPixelStatistics.bitmasks[bmod0];
                int on = bitimg[yoffset0 + bidx0] & mask;
                if (on != 0) continue;
                int bidx1 = x2 + 1 >> 3;
                int bmod1 = x2 + 1 & 7;
                if (x2 + 1 < w2 && (on = bitimg[yoffset0 + bidx1] & XpPixelStatistics.bitmasks[bmod1]) != 0) {
                    bitimg[yoffset0 + bidx0] = (byte)(bitimg[yoffset0 + bidx0] | mask);
                    continue;
                }
                if (x2 + 1 < w2 && y2 + 1 < h2 && (on = bitimg[yoffset1 + bidx1] & XpPixelStatistics.bitmasks[bmod1]) != 0) {
                    bitimg[yoffset0 + bidx0] = (byte)(bitimg[yoffset0 + bidx0] | mask);
                    continue;
                }
                if (y2 + 1 >= h2 || (on = bitimg[yoffset1 + bidx0] & mask) == 0) continue;
                bitimg[yoffset0 + bidx0] = (byte)(bitimg[yoffset0 + bidx0] | mask);
            }
        }
    }

    protected void fillEllipse(double cx, double cy, double rx, double ry, double angle, byte[] bitimg, int ROWLEN_BITMAP, int x0, int y0, int x1, int y1) {
        double yy3;
        double xx3;
        double ell3;
        double yy2;
        double xx2;
        double ell2;
        double yy1;
        double xx1;
        double ell1;
        double ell0;
        double yy0;
        int bidx;
        double theta = angle;
        double aa2 = 1.0 / (rx * rx);
        double bb = 1.0 / (ry * ry);
        this.rotMatrix.setToRotation(theta, cx, cy);
        this.temppt.setLocation(x0, y0);
        this.rotMatrix.transform(this.temppt, this.rowstart);
        this.rotMatrix.setToRotation(theta);
        this.temppt.setLocation(1.0, 0.0);
        this.rotMatrix.transform(this.temppt, this.dirx);
        this.temppt.setLocation(0.0, 1.0);
        this.rotMatrix.transform(this.temppt, this.diry);
        for (int y2 = y0; y2 <= y1; ++y2) {
            int yoffset = y2 * ROWLEN_BITMAP;
            this.temppt.setLocation(this.rowstart);
            for (int x2 = x0; x2 <= x1; ++x2) {
                double yy02;
                bidx = x2 >> 3;
                int bmod = x2 & 7;
                double xx0 = this.temppt.getX() - cx;
                double ell02 = xx0 * xx0 * aa2 + (yy02 = this.temppt.getY() - cy) * yy02 * bb;
                if (ell02 <= 1.0) {
                    bitimg[yoffset + bidx] = (byte)(bitimg[yoffset + bidx] | XpPixelStatistics.bitmasks[bmod]);
                }
                this.temppt.setLocation(this.temppt.getX() + this.dirx.getX(), this.temppt.getY() + this.dirx.getY());
            }
            this.rowstart.setLocation(this.rowstart.getX() + this.diry.getX(), this.rowstart.getY() + this.diry.getY());
        }
        JamiRoiStatistics.labelCorners(bitimg, ROWLEN_BITMAP, x0, y0, x1, y1, this.width, this.height);
        if (x1 == this.width - 1) {
            this.rotMatrix.setToRotation(theta, cx, cy);
            this.temppt.setLocation(this.width - 1, y0);
            this.rotMatrix.transform(this.temppt, this.rowstart);
            int bmod = this.width - 1 & 7;
            for (int y3 = y0; y3 <= y1; ++y3) {
                int yoffset = y3 * ROWLEN_BITMAP;
                this.temppt.setLocation(this.rowstart);
                bidx = yoffset + (this.width - 1 >> 3);
                double xx0 = this.temppt.getX() - cx;
                yy0 = this.temppt.getY() - cy;
                ell0 = xx0 * xx0 * aa2 + yy0 * yy0 * bb;
                if (ell0 <= 1.0) {
                    bitimg[bidx] = (byte)(bitimg[bidx] | XpPixelStatistics.bitmasks[bmod]);
                }
                if ((ell1 = (xx1 = Math.abs(this.temppt.getX() + this.dirx.getX() - cx)) * xx1 * aa2 + (yy1 = Math.abs(this.temppt.getY() + this.dirx.getY() - cy)) * yy1 * bb) <= 1.0) {
                    bitimg[bidx] = (byte)(bitimg[bidx] | XpPixelStatistics.bitmasks[bmod]);
                }
                if ((ell2 = (xx2 = Math.abs(this.temppt.getX() + this.diry.getX() - cx)) * xx2 * aa2 + (yy2 = Math.abs(this.temppt.getY() + this.diry.getY() - cy)) * yy2 * bb) <= 1.0) {
                    bitimg[bidx] = (byte)(bitimg[bidx] | XpPixelStatistics.bitmasks[bmod]);
                }
                if ((ell3 = (xx3 = Math.abs(this.temppt.getX() + this.dirx.getX() + this.diry.getX() - cx)) * xx3 * aa2 + (yy3 = Math.abs(this.temppt.getY() + this.dirx.getY() + this.diry.getY() - cy)) * yy3 * bb) <= 1.0) {
                    bitimg[bidx] = (byte)(bitimg[bidx] | XpPixelStatistics.bitmasks[bmod]);
                }
                this.rowstart.setLocation(this.rowstart.getX() + this.diry.getX(), this.rowstart.getY() + this.diry.getY());
            }
        }
        if (y1 == this.height - 1) {
            this.rotMatrix.setToRotation(theta, cx, cy);
            this.rowstart.setLocation(x0, this.height - 1);
            this.rotMatrix.transform(this.rowstart, this.temppt);
            int yoffset = (this.height - 1) * ROWLEN_BITMAP;
            for (int x3 = x0; x3 <= x1; ++x3) {
                int bmod = x3 & 7;
                bidx = yoffset + (x3 >> 3);
                double xx0 = this.temppt.getX() - cx;
                ell0 = xx0 * xx0 * aa2 + (yy0 = this.temppt.getY() - cy) * yy0 * bb;
                if (ell0 <= 1.0) {
                    bitimg[bidx] = (byte)(bitimg[bidx] | XpPixelStatistics.bitmasks[bmod]);
                }
                if ((ell1 = (xx1 = Math.abs(this.temppt.getX() + this.dirx.getX() - cx)) * xx1 * aa2 + (yy1 = Math.abs(this.temppt.getY() + this.dirx.getY() - cy)) * yy1 * bb) <= 1.0) {
                    bitimg[bidx] = (byte)(bitimg[bidx] | XpPixelStatistics.bitmasks[bmod]);
                }
                if ((ell2 = (xx2 = Math.abs(this.temppt.getX() + this.diry.getX() - cx)) * xx2 * aa2 + (yy2 = Math.abs(this.temppt.getY() + this.diry.getY() - cy)) * yy2 * bb) <= 1.0) {
                    bitimg[bidx] = (byte)(bitimg[bidx] | XpPixelStatistics.bitmasks[bmod]);
                }
                if ((ell3 = (xx3 = Math.abs(this.temppt.getX() + this.dirx.getX() + this.diry.getX() - cx)) * xx3 * aa2 + (yy3 = Math.abs(this.temppt.getY() + this.dirx.getY() + this.diry.getY() - cy)) * yy3 * bb) <= 1.0) {
                    bitimg[bidx] = (byte)(bitimg[bidx] | XpPixelStatistics.bitmasks[bmod]);
                }
                this.temppt.setLocation(this.temppt.getX() + this.dirx.getX(), this.temppt.getY() + this.dirx.getY());
            }
        }
    }

    protected void fillRectangle(double cx, double cy, double rw, double rh, double angle, byte[] bitimg, int ROWLEN_BITMAP, int x0, int y0, int x1, int y1) {
        double theta = angle;
        this.rotMatrix.setToRotation(theta, cx, cy);
        this.temppt.setLocation(x0, y0);
        this.rotMatrix.transform(this.temppt, this.rowstart);
        this.rotMatrix.setToRotation(theta);
        this.temppt.setLocation(1.0, 0.0);
        this.rotMatrix.transform(this.temppt, this.dirx);
        this.temppt.setLocation(0.0, 1.0);
        this.rotMatrix.transform(this.temppt, this.diry);
        for (int y2 = y0; y2 <= y1; ++y2) {
            int yoffset = y2 * ROWLEN_BITMAP;
            this.temppt.setLocation(this.rowstart);
            for (int x2 = x0; x2 <= x1; ++x2) {
                int bidx = x2 >> 3;
                int bmod = x2 & 7;
                double xx0 = Math.abs(this.temppt.getX() - cx);
                double yy0 = Math.abs(this.temppt.getY() - cy);
                if (xx0 <= rw && yy0 <= rh) {
                    bitimg[yoffset + bidx] = (byte)(bitimg[yoffset + bidx] | XpPixelStatistics.bitmasks[bmod]);
                }
                double xx1 = Math.abs(this.temppt.getX() + this.dirx.getX() - cx);
                double yy1 = Math.abs(this.temppt.getY() + this.dirx.getY() - cy);
                if (xx1 <= rw && yy1 <= rh) {
                    bitimg[yoffset + bidx] = (byte)(bitimg[yoffset + bidx] | XpPixelStatistics.bitmasks[bmod]);
                }
                double xx2 = Math.abs(this.temppt.getX() + this.diry.getX() - cx);
                double yy2 = Math.abs(this.temppt.getY() + this.diry.getY() - cy);
                if (xx2 <= rw && yy2 <= rh) {
                    bitimg[yoffset + bidx] = (byte)(bitimg[yoffset + bidx] | XpPixelStatistics.bitmasks[bmod]);
                }
                double xx3 = Math.abs(this.temppt.getX() + this.dirx.getX() + this.diry.getX() - cx);
                double yy3 = Math.abs(this.temppt.getY() + this.dirx.getY() + this.diry.getY() - cy);
                if (xx3 <= rw && yy3 <= rh) {
                    bitimg[yoffset + bidx] = (byte)(bitimg[yoffset + bidx] | XpPixelStatistics.bitmasks[bmod]);
                }
                this.temppt.setLocation(this.temppt.getX() + this.dirx.getX(), this.temppt.getY() + this.dirx.getY());
            }
            this.rowstart.setLocation(this.rowstart.getX() + this.diry.getX(), this.rowstart.getY() + this.diry.getY());
        }
    }

    private void initPts() {
        this.pts = new Point2D[4096];
        for (int i2 = 0; i2 < this.pts.length; ++i2) {
            this.pts[i2] = new Point2D.Double();
        }
    }

    private int getPoints(GeneralPath shape, Point2D[] pts) {
        int idx = 0;
        PathIterator pi = shape.getPathIterator(null, 1.0);
        while (!pi.isDone()) {
            pi.currentSegment(this._reg);
            double x2 = this._reg[0];
            double y2 = this._reg[1];
            int segType = pi.getWindingRule();
            switch (segType) {
                case 0: {
                    pts[idx++].setLocation(x2, y2);
                    break;
                }
                case 1: {
                    pts[idx++].setLocation(x2, y2);
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
            }
            pi.next();
            if (!pi.isDone()) continue;
            break;
        }
        return idx;
    }

    protected void drawPolygon(Point2D[] pts, int npts, byte[] bitmap, int ROWLEN_BITMAP, int w2, int h2) {
        boolean closed;
        double minX = pts[0].getX();
        double minY = pts[0].getY();
        double maxX = pts[0].getX();
        double maxY = pts[0].getY();
        for (int i2 = 0; i2 < npts - 1; ++i2) {
            double dx0 = pts[i2].getX();
            double dy0 = pts[i2].getY();
            double dx1 = pts[i2 + 1].getX();
            double dy1 = pts[i2 + 1].getY();
            JamiRoiStatistics.lineIdeal(dx0, dy0, dx1, dy1, bitmap, ROWLEN_BITMAP, w2, h2);
            if (dx1 < minX) {
                minX = dx1;
            }
            if (dy1 < minY) {
                minY = dy1;
            }
            if (dx1 > maxX) {
                maxX = dx1;
            }
            if (!(dy1 > maxY)) continue;
            maxY = dy1;
        }
        int x0 = (int)pts[npts - 1].getX();
        int y0 = (int)pts[npts - 1].getY();
        int x1 = (int)pts[0].getX();
        int y1 = (int)pts[0].getY();
        boolean bl = closed = x0 == x1 && y0 == y1;
        if (closed) {
            minX = Math.floor(minX);
            minY = Math.floor(minY);
            maxX = Math.ceil(maxX);
            maxY = Math.ceil(maxY);
            double d2 = minX < 0.0 ? 0.0 : (minX = minX > (double)(w2 - 1) ? (double)(w2 - 1) : minX);
            double d3 = minY < 0.0 ? 0.0 : (minY = minY > (double)(h2 - 1) ? (double)(h2 - 1) : minY);
            double d4 = maxX < 0.0 ? 0.0 : (maxX = maxX > (double)(w2 - 1) ? (double)(w2 - 1) : maxX);
            maxY = maxY < 0.0 ? 0.0 : (maxY > (double)(h2 - 1) ? (double)(h2 - 1) : maxY);
            int iminX = (int)minX;
            int iminY = (int)minY;
            int imaxX = (int)maxX;
            int imaxY = (int)maxY;
            int seedx = -1;
            int seedy = -1;
            boolean foundseed = false;
            for (int y2 = iminY; y2 <= imaxY; ++y2) {
                int offset = y2 * ROWLEN_BITMAP;
                boolean hit = false;
                for (int x2 = iminX; x2 < imaxX; ++x2) {
                    boolean on;
                    int bidx = offset + (x2 >> 3);
                    int bmod = x2 & 7;
                    boolean bl2 = on = (bitmap[bidx] & XpPixelStatistics.bitmasks[bmod]) != 0;
                    if (on && !hit) {
                        boolean non;
                        int nbidx = offset + (x2 + 1 >> 3);
                        int nbmod = x2 + 1 & 7;
                        boolean bl3 = non = (bitmap[nbidx] & XpPixelStatistics.bitmasks[nbmod]) != 0;
                        if (non) continue;
                        seedx = x2 + 1;
                        seedy = y2;
                        hit = true;
                        continue;
                    }
                    if (!on || !hit) continue;
                    foundseed = true;
                    break;
                }
                if (foundseed) break;
            }
            if (foundseed) {
                this.floodfill(bitmap, ROWLEN_BITMAP, seedx, seedy);
            }
        }
    }

    private void floodfill(byte[] bitmap, int ROWLEN_BITMAP, int seedx, int seedy) {
        this.writepos = 0;
        this.readpos = 0;
        if (this.xpos == null || this.ypos == null) {
            this.xpos = new int[2 * (this.width + this.height)];
            this.ypos = new int[2 * (this.width + this.height)];
        }
        this.xpos[0] = seedx;
        this.ypos[0] = seedy;
        ++this.writepos;
        int npixels = 0;
        int nneigh = 0;
        while (this.writepos - this.readpos != 0) {
            int bbidx;
            int x2 = this.xpos[this.readpos];
            int y2 = this.ypos[this.readpos];
            this.readpos = (this.readpos + 1) % this.xpos.length;
            ++npixels;
            int bidx = y2 * ROWLEN_BITMAP + x2 / 8;
            int bmod = x2 & 7;
            bitmap[bidx] = (byte)(bitmap[bidx] | XpPixelStatistics.bitmasks[bmod]);
            for (int yy = -1; yy <= 1; yy += 2) {
                boolean on;
                int ny = y2 + yy;
                if (ny < 0 || ny >= this.height) continue;
                bbidx = ny * ROWLEN_BITMAP + x2 / 8;
                boolean bl = on = (bitmap[bbidx] & XpPixelStatistics.bitmasks[bmod]) != 0;
                if (on) continue;
                this.xpos[this.writepos] = x2;
                this.ypos[this.writepos] = ny;
                this.writepos = (this.writepos + 1) % this.xpos.length;
                bitmap[bbidx] = (byte)(bitmap[bbidx] | XpPixelStatistics.bitmasks[bmod]);
                ++nneigh;
            }
            for (int xx = -1; xx <= 1; xx += 2) {
                boolean on;
                int nx = x2 + xx;
                if (nx < 0 || nx >= this.width) continue;
                bbidx = y2 * ROWLEN_BITMAP + nx / 8;
                int bbmod = nx & 7;
                boolean bl = on = (bitmap[bbidx] & XpPixelStatistics.bitmasks[bbmod]) != 0;
                if (on) continue;
                this.xpos[this.writepos] = nx;
                this.ypos[this.writepos] = y2;
                this.writepos = (this.writepos + 1) % this.xpos.length;
                bitmap[bbidx] = (byte)(bitmap[bbidx] | XpPixelStatistics.bitmasks[bbmod]);
                ++nneigh;
            }
        }
    }

    protected static void lineIdeal(double x0, double y0, double x1, double y1, byte[] bitmap, int rblen, int w2, int h2) {
        double minx = Math.min(x0, x1);
        double maxx = Math.max(x0, x1);
        double miny = Math.min(y0, y1);
        double maxy = Math.max(y0, y1);
        int iminx = (int)minx;
        int imaxx = (int)maxx;
        int iminy = (int)miny;
        int imaxy = (int)maxy;
        if (maxx - minx < 1.0E-4) {
            int bmod = iminx & 7;
            for (int y2 = iminy; y2 <= imaxy; ++y2) {
                int bidx = y2 * rblen + (iminx >> 3);
                byte bmask = XpPixelStatistics.bitmasks[bmod];
                bitmap[bidx] = (byte)(bitmap[bidx] | bmask);
            }
        } else if (maxy - miny < 1.0E-4) {
            for (int x2 = iminx; x2 <= imaxx; ++x2) {
                int bidx = iminy * rblen + (x2 >> 3);
                int bmod = x2 & 7;
                byte bmask = XpPixelStatistics.bitmasks[bmod];
                bitmap[bidx] = (byte)(bitmap[bidx] | bmask);
            }
        } else {
            double slope;
            double deltax = maxx - minx;
            double deltay = maxy - miny;
            if (deltax > deltay) {
                slope = (y1 - y0) / (x1 - x0);
                int mx0 = Math.max(iminx + 1, 1);
                int mx1 = Math.min(imaxx, w2 - 1);
                for (int x3 = mx0; x3 <= mx1; ++x3) {
                    double y3 = slope * ((double)x3 - x0) + y0;
                    int iy = (int)y3;
                    if (iy < 0 || iy >= h2) continue;
                    int bidx0 = iy * rblen + (x3 - 1 >> 3);
                    int bmod0 = x3 - 1 & 7;
                    bitmap[bidx0] = (byte)(bitmap[bidx0] | XpPixelStatistics.bitmasks[bmod0]);
                    int bidx1 = iy * rblen + (x3 >> 3);
                    int bmod1 = x3 & 7;
                    bitmap[bidx1] = (byte)(bitmap[bidx1] | XpPixelStatistics.bitmasks[bmod1]);
                }
            } else {
                slope = (x1 - x0) / (y1 - y0);
                int my0 = Math.max(iminy + 1, 1);
                int my1 = Math.min(imaxy, h2 - 1);
                for (int y4 = my0; y4 <= my1; ++y4) {
                    double x4 = slope * ((double)y4 - y0) + x0;
                    int ix = (int)x4;
                    if (ix < 0 || ix >= w2) continue;
                    int bidx0 = (y4 - 1) * rblen + (ix >> 3);
                    int bmod = ix & 7;
                    bitmap[bidx0] = (byte)(bitmap[bidx0] | XpPixelStatistics.bitmasks[bmod]);
                    int bidx1 = y4 * rblen + (ix >> 3);
                    bitmap[bidx1] = (byte)(bitmap[bidx1] | XpPixelStatistics.bitmasks[bmod]);
                }
            }
            int ix0 = (int)x0;
            int iy0 = (int)y0;
            int ix1 = (int)x1;
            int iy1 = (int)y1;
            if (ix0 >= 0 && ix0 < w2 && iy0 >= 0 && iy0 < h2) {
                int bidx0 = iy0 * rblen + (ix0 >> 3);
                int bmod0 = ix0 & 7;
                bitmap[bidx0] = (byte)(bitmap[bidx0] | XpPixelStatistics.bitmasks[bmod0]);
            }
            if (ix1 >= 0 && ix1 < w2 && iy1 >= 0 && iy1 < h2) {
                int bidx1 = iy1 * rblen + (ix1 >> 3);
                int bmod1 = ix1 & 7;
                bitmap[bidx1] = (byte)(bitmap[bidx1] | XpPixelStatistics.bitmasks[bmod1]);
            }
        }
    }

    protected static void lineBresenham(int x0, int y0, int x1, int y1, byte[] bitmap, int rblen, int w2, int h2) {
        int bmod;
        int bidx;
        int yoffset;
        int fraction;
        int stepx;
        int stepy;
        int dy = y1 - y0;
        int dx = x1 - x0;
        if (dy < 0) {
            dy = -dy;
            stepy = -1;
        } else {
            stepy = 1;
        }
        if (dx < 0) {
            dx = -dx;
            stepx = -1;
        } else {
            stepx = 1;
        }
        dy <<= 1;
        dx <<= 1;
        if (y0 >= 0 && y0 < h2 && x0 >= 0 && x0 < w2) {
            int yoffset2 = y0 * rblen;
            int bidx2 = x0 / 8;
            int bmod2 = x0 & 7;
            byte bmask = XpPixelStatistics.bitmasks[bmod2];
            bitmap[yoffset2 + bidx2] = (byte)(bitmap[yoffset2 + bidx2] | bmask);
        }
        if (dx > dy) {
            fraction = dy - (dx >> 1);
            while (x0 != x1) {
                if (fraction >= 0) {
                    y0 += stepy;
                    fraction -= dx;
                }
                fraction += dy;
                if (y0 < 0 || y0 >= h2 || (x0 += stepx) < 0 || x0 >= w2) continue;
                yoffset = y0 * rblen;
                bidx = x0 / 8;
                bmod = x0 & 7;
                byte bmask = XpPixelStatistics.bitmasks[bmod];
                bitmap[yoffset + bidx] = (byte)(bitmap[yoffset + bidx] | bmask);
            }
        } else {
            fraction = dx - (dy >> 1);
            while (y0 != y1) {
                if (fraction >= 0) {
                    x0 += stepx;
                    fraction -= dy;
                }
                fraction += dx;
                if ((y0 += stepy) < 0 || y0 >= h2 || x0 < 0 || x0 >= w2) continue;
                yoffset = y0 * rblen;
                bidx = x0 / 8;
                bmod = x0 & 7;
                byte bmask = XpPixelStatistics.bitmasks[bmod];
                bitmap[yoffset + bidx] = (byte)(bitmap[yoffset + bidx] | bmask);
            }
        }
    }

    private static void polyLineFill(BufferedImage drawbuffer, int numPoints, Point2D[] imagePoints) {
        int j2;
        int i2;
        int maxy;
        int maxx;
        byte[] bitmap = ((DataBufferByte)drawbuffer.getRaster().getDataBuffer()).getData();
        int dbwidth = drawbuffer.getWidth();
        int dbheight = drawbuffer.getHeight();
        int len = dbwidth * dbheight;
        Arrays.fill(bitmap, (byte)0);
        int nrowbytes = (int)Math.ceil((double)dbwidth / 8.0);
        if (numPoints < 2) {
            return;
        }
        int minx = maxx = (int)imagePoints[0].getX();
        int miny = maxy = (int)imagePoints[0].getY();
        for (i2 = 1; i2 < numPoints; ++i2) {
            if (imagePoints[i2].getX() > (double)maxx) {
                maxx = (int)imagePoints[i2].getX();
            } else if (imagePoints[i2].getX() < (double)minx) {
                minx = (int)imagePoints[i2].getX();
            }
            if (imagePoints[i2].getY() > (double)maxy) {
                maxy = (int)imagePoints[i2].getY();
                continue;
            }
            if (!(imagePoints[i2].getY() < (double)miny)) continue;
            miny = (int)imagePoints[i2].getY();
        }
        int ox = minx;
        int oy = miny;
        int width = maxx - minx + 1;
        int height = maxy - miny + 1;
        if (internalBuffer == null || internalBuffer.length != len) {
            internalBuffer = new byte[len];
        }
        Arrays.fill(internalBuffer, (byte)1);
        if (width * height > 1) {
            i2 = 0;
            for (j2 = 1; j2 < numPoints; ++j2) {
                JamiRoiStatistics.DrawLine(imagePoints, i2, j2, bitmap, internalBuffer, dbwidth, dbheight);
                ++i2;
            }
            JamiRoiStatistics.DrawLine(imagePoints, i2, 0, bitmap, internalBuffer, dbwidth, dbheight);
            int start = oy * dbwidth;
            for (i2 = ox; i2 < ox + width; ++i2) {
                if (internalBuffer[start + i2] == 2 || internalBuffer[start + i2] == 0) continue;
                JamiRoiStatistics.FillArea(i2, oy, internalBuffer, dbwidth, dbheight, ox, oy, width, height);
            }
            for (i2 = ox; i2 < ox + width; ++i2) {
                if (internalBuffer[i2 + (height - 1) * dbwidth] == 2 || internalBuffer[i2 + (height - 1) * dbwidth] == 0) continue;
                JamiRoiStatistics.FillArea(i2, oy + height - 1, internalBuffer, dbwidth, dbheight, ox, oy, width, height);
            }
            for (i2 = oy; i2 < oy + height; ++i2) {
                if (internalBuffer[(i2 + 1) * dbwidth - 1] == 2 || internalBuffer[(i2 + 1) * dbwidth - 1] == 0) continue;
                JamiRoiStatistics.FillArea(ox + width - 1, i2, internalBuffer, dbwidth, dbheight, ox, oy, width, height);
            }
            for (i2 = oy; i2 < oy + height; ++i2) {
                if (internalBuffer[i2 * dbwidth] == 2 || internalBuffer[i2 * dbwidth] == 0) continue;
                JamiRoiStatistics.FillArea(ox, i2, internalBuffer, dbwidth, dbheight, ox, oy, width, height);
            }
        }
        for (j2 = oy; j2 < oy + height; ++j2) {
            int offset = j2 * nrowbytes;
            int rowoffset = j2 * dbwidth;
            for (i2 = ox; i2 < ox + width; ++i2) {
                int bitidx = offset + i2 / 8;
                if (internalBuffer[rowoffset + i2] == 0) continue;
                int n2 = bitidx;
                bitmap[n2] = (byte)(bitmap[n2] | bitmasks[i2 & 7]);
            }
        }
    }

    private static void DrawLine(Point2D[] imagePoints, int i2, int j2, byte[] bitmap, byte[] internalBuffer, int width, int height) {
        int pixelsInLine;
        double dy;
        double dx;
        double adeltaY;
        int nrowbytes = (int)Math.ceil((double)width / 8.0);
        double startX = (int)imagePoints[i2].getX();
        double startY = (int)imagePoints[i2].getY();
        double endX = (int)imagePoints[j2].getX();
        double endY = (int)imagePoints[j2].getY();
        double deltaX = endX - startX;
        double deltaY = endY - startY;
        double adeltaX = Math.abs(deltaX);
        if (adeltaX > (adeltaY = Math.abs(deltaY))) {
            dx = deltaX / adeltaX;
            dy = deltaY / adeltaX;
            pixelsInLine = (int)Math.ceil(adeltaX + 1.0);
        } else if (adeltaY > 0.0) {
            dx = deltaX / adeltaY;
            dy = deltaY / adeltaY;
            pixelsInLine = (int)Math.ceil(adeltaY + 1.0);
        } else {
            dx = 0.0;
            dy = 0.0;
            pixelsInLine = 0;
        }
        double x2 = startX;
        double y2 = startY;
        for (int d2 = 0; d2 < pixelsInLine; ++d2) {
            int bitidx;
            int ix = (int)(x2 + 0.5);
            int iy = (int)(y2 + 0.5);
            if (ix < 0) {
                ix = 0;
            } else if (ix >= width) {
                ix = width - 1;
            }
            if (iy < 0) {
                iy = 0;
            } else if (iy >= height) {
                iy = height - 1;
            }
            internalBuffer[ix + iy * width] = 2;
            int n2 = bitidx = iy * nrowbytes + ix / 8;
            bitmap[n2] = (byte)(bitmap[n2] | bitmasks[ix & 7]);
            x2 += dx;
            y2 += dy;
        }
    }

    private static int PUSH(int sp, int X, int Y) {
        JamiRoiStatistics.stack[2 * sp] = X;
        JamiRoiStatistics.stack[2 * sp + 1] = Y;
        return sp + 1;
    }

    private static void FillArea(int i2, int j2, byte[] internalBuffer, int width, int height, int ox, int oy, int domainWidth, int domainHeight) {
        int floodWidth = width + 2;
        int floodHeight = height + 2;
        if (floodWidth * floodHeight * 4 > len) {
            len = floodWidth * floodHeight * 4;
            stack = new int[2 * len];
        }
        int sp = 0;
        sp = JamiRoiStatistics.PUSH(sp, i2, j2);
        while (sp > 0) {
            int m2;
            i2 = stack[2 * --sp];
            j2 = stack[2 * sp + 1];
            if (i2 < ox || i2 >= ox + domainWidth || j2 < oy || j2 >= oy + domainHeight || internalBuffer[m2 = i2 + j2 * width] == 0 || internalBuffer[m2] == 2) continue;
            internalBuffer[m2] = 0;
            sp = JamiRoiStatistics.PUSH(sp, i2 + 1, j2);
            sp = JamiRoiStatistics.PUSH(sp, i2 - 1, j2);
            sp = JamiRoiStatistics.PUSH(sp, i2, j2 + 1);
            sp = JamiRoiStatistics.PUSH(sp, i2, j2 + 1);
        }
    }
}

