/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.roi;

import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.CTransform;
import com.ge.med.terra.jami.GSPSGraphic;
import com.ge.med.terra.jami.XpAnchorable;
import com.ge.med.terra.jami.XpGeomUtils;
import com.ge.med.terra.jami.XpHandle;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpMedicalImage2DVc;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.roi.XpRoiEventListener;
import com.ge.med.terra.jami.roi.XpRoiHandleContainer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class XpImageShutter
extends XpRoiHandleContainer
implements Cloneable,
Serializable {
    private CPoint display_pt = new CPoint(1);
    private CPoint img_pt = new CPoint(0);
    private transient GeneralPath polygon = null;
    private transient GeneralPath clipPolygon = null;
    private transient XpImage myImage = null;
    private boolean selected = true;
    private boolean burned = false;
    private transient XpMedicalImage2DVc mivc = null;
    private transient XpGeomUtils gu = new XpGeomUtils();
    private transient Point2D Pi = new Point2D.Double();
    private transient Point2D Pj = new Point2D.Double();
    private transient Point2D Ptmp = new Point2D.Double();
    private transient Point2D I0 = new Point2D.Double();
    private transient Point2D I1 = new Point2D.Double();
    private transient Line2D S1 = new Line2D.Double();
    private transient Line2D S2 = new Line2D.Double();
    private transient Point2D[] pts = null;

    public XpImageShutter(XpMedicalImage2DVc mivc, Point2D[] pts) {
        this.mivc = mivc;
        int npts = pts.length;
        this.pts = new Point2D[npts];
        for (int i2 = 0; i2 < npts; ++i2) {
            XpHandle handle = new XpHandle((XpAnchorable)this, i2, 16);
            handle.setFilled(false);
            this.add(handle);
            handle.setLocation(pts[i2]);
            this.pts[i2] = new Point2D.Double(pts[i2].getX(), pts[i2].getY());
        }
        this.polygon = new GeneralPath();
        this.clipPolygon = new GeneralPath();
    }

    public Object clone() {
        XpImageShutter ccr = new XpImageShutter(new XpMedicalImage2DVc(), new Point2D[0]);
        this.copyObject(ccr);
        return ccr;
    }

    @Override
    protected void copyObject(Object o2) {
        XpImageShutter is = (XpImageShutter)o2;
        is.display_pt = (CPoint)this.display_pt.clone();
        is.img_pt = (CPoint)this.img_pt.clone();
        is.polygon = (GeneralPath)this.polygon.clone();
        is.clipPolygon = (GeneralPath)this.clipPolygon.clone();
        is.myImage = this.myImage;
        is.selected = this.selected;
        this.burned = this.burned;
        is.gu = new XpGeomUtils();
        is.Pi = (Point2D)this.Pi.clone();
        is.Pj = (Point2D)this.Pj.clone();
        is.Ptmp = (Point2D)this.Ptmp.clone();
        is.I0 = (Point2D)this.I0.clone();
        is.I1 = (Point2D)this.I1.clone();
        is.S1 = (Line2D)this.S1.clone();
        is.S2 = (Line2D)this.S2.clone();
    }

    public void burn() {
        this.burned = true;
        this.mivc.setImageClip((Shape)this.clipPolygon.clone());
        this.clearHandles();
    }

    private void syncPts(XpVisualComponent vc) {
        int npts = this.getNumHandles();
        this.polygon.reset();
        this.clipPolygon.reset();
        CTransform t2 = vc.getTransform((byte)0, (byte)1);
        this.img_pt.setLocation(this.get(0).getX(), this.get(0).getY(), 0.0);
        t2.transform(this.img_pt, this.display_pt);
        this.polygon.moveTo((float)this.display_pt.x, (float)this.display_pt.y);
        this.clipPolygon.moveTo((float)this.get(0).getX(), (float)this.get(0).getY());
        for (int i2 = 1; i2 < npts; ++i2) {
            this.img_pt.setLocation(this.get(i2).getX(), this.get(i2).getY(), 0.0);
            t2.transform(this.img_pt, this.display_pt);
            this.polygon.lineTo((float)this.display_pt.x, (float)this.display_pt.y);
            this.clipPolygon.lineTo((float)this.get(i2).getX(), (float)this.get(i2).getY());
        }
        this.polygon.closePath();
        this.clipPolygon.closePath();
    }

    @Override
    public void paintShape(XpVisualComponent vc, Graphics2D g2) {
        if (!this.burned) {
            Graphics2D g22 = g2;
            this.syncPts(vc);
            Color c2 = g22.getColor();
            g22.setColor(Color.orange);
            g22.draw(this.polygon);
            g22.setColor(c2);
        }
    }

    @Override
    public boolean containsROI(XpVisualComponent vc, int x2, int y2) {
        return false;
    }

    @Override
    public void setImage(XpImage image) {
        this.myImage = image;
    }

    @Override
    public final XpImage getImage() {
        return this.myImage;
    }

    @Override
    public void setSelected(boolean selection) {
        this.selected = selection;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    private boolean legalMove() {
        int nSegs = this.getNumHandles();
        if (nSegs <= 2) {
            return true;
        }
        for (int i2 = 0; i2 < nSegs; ++i2) {
            int cs = i2;
            int ps = i2;
            int ns = i2;
            XpHandle h2 = this.get(i2);
            this.Pi.setLocation(h2.getX(), h2.getY());
            ps = i2 == 0 ? nSegs - 1 : i2 - 1;
            if (i2 < nSegs - 1) {
                h2 = this.get(i2 + 1);
                this.S1.setLine(this.Pi.getX(), this.Pi.getY(), h2.getX(), h2.getY());
                ns = i2 + 1;
            } else {
                h2 = this.get(0);
                this.S1.setLine(this.Pi.getX(), this.Pi.getY(), h2.getX(), h2.getY());
                ns = 0;
            }
            for (int j2 = 0; j2 < nSegs; ++j2) {
                if (j2 == cs || j2 == ns || j2 == ps) continue;
                h2 = this.get(j2);
                this.Pj.setLocation(h2.getX(), h2.getY());
                if (j2 < nSegs - 1) {
                    h2 = this.get(j2 + 1);
                    this.S2.setLine(this.Pj.getX(), this.Pj.getY(), h2.getX(), h2.getY());
                } else {
                    h2 = this.get(0);
                    this.S2.setLine(this.Pj.getX(), this.Pj.getY(), h2.getX(), h2.getY());
                }
                int code = this.gu.intersect2DSegments(this.S1, this.S2, this.I0, this.I1);
                if (code == 0) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void anchorDragged(MouseEvent e2, CPoint drag, Object source) {
        XpHandle xph = (XpHandle)source;
        double x2 = xph.getX() + drag.x;
        double y2 = xph.getY() + drag.y;
        double oldX = xph.getX();
        double oldY = xph.getY();
        xph.setLocation(x2, y2);
        if (this.legalMove()) {
            XpVisualComponent vc = (XpVisualComponent)e2.getSource();
            this.syncPts(vc);
            vc.repaint();
        } else {
            xph.setLocation(oldX, oldY);
        }
    }

    @Override
    public void anchorPressed(MouseEvent e2, Object source) {
    }

    @Override
    public void anchorReleased(MouseEvent e2, Object source) {
    }

    @Override
    public final GSPSGraphic gspsDescription() {
        return null;
    }

    @Override
    public void addRoiEventListener(XpRoiEventListener rel) {
    }

    @Override
    public void removeRoiEventListener(XpRoiEventListener rel) {
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        try {
            s2.defaultWriteObject();
            s2.writeInt(this.pts.length);
            for (int i2 = 0; i2 < this.pts.length; ++i2) {
                s2.writeDouble(this.pts[i2].getX());
                s2.writeDouble(this.pts[i2].getY());
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException {
        try {
            s2.defaultReadObject();
            int npts = s2.readInt();
            this.pts = new Point2D[npts];
            for (int i2 = 0; i2 < npts; ++i2) {
                XpHandle handle = new XpHandle((XpAnchorable)this, i2, 16);
                handle.setFilled(false);
                this.add(handle);
                this.pts[i2] = new Point2D.Double(s2.readDouble(), s2.readDouble());
                handle.setLocation(this.pts[i2]);
            }
            this.polygon = new GeneralPath();
            this.clipPolygon = new GeneralPath();
            this.gu = new XpGeomUtils();
            this.Pi = new Point2D.Double();
            this.Pj = new Point2D.Double();
            this.Ptmp = new Point2D.Double();
            this.I0 = new Point2D.Double();
            this.I1 = new Point2D.Double();
            this.S1 = new Line2D.Double();
            this.S2 = new Line2D.Double();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

