/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.roi;

import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.GSPSGraphic;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpAnchorable;
import com.ge.med.terra.jami.XpHandle;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.capable.TooltipCapable;
import com.ge.med.terra.jami.capable.Visible;
import com.ge.med.terra.jami.roi.XpRoiEventListener;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Vector;
import javax.swing.event.MouseInputListener;

public class XpRoiHandleContainer
implements RoiActor,
XpAnchorable,
Visible,
TooltipCapable {
    public static final int SHOW_HANDLES_ALLWAYS_POLICY = 0;
    public static final int SHOW_HANDLES_ONLYSELECTED_POLICY = 1;
    private boolean visible = true;
    private int handlePolicy = 1;
    private Vector handles = new Vector();
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private String tip = "";
    MouseInputListener listener = new MouseInputListener(){
        XpHandle clickHandle;
        XpHandle enteredHandle;
        boolean clickROI = false;
        boolean enteredROI = false;

        @Override
        public void mouseClicked(MouseEvent e2) {
            if (this.clickHandle != null) {
                this.clickHandle.handleClicked(e2);
            } else if (this.clickROI) {
                XpRoiHandleContainer.this.roiClicked(e2);
            }
        }

        @Override
        public void mousePressed(MouseEvent e2) {
            if (this.clickHandle != null) {
                return;
            }
            this.clickHandle = XpRoiHandleContainer.this.whichHandle((XpVisualComponent)e2.getSource(), e2.getX(), e2.getY());
            if (this.clickHandle != null && this.clickHandle.buttonTrigger(e2)) {
                this.clickHandle.handlePressed(e2);
            } else if (XpRoiHandleContainer.this.containsROI((XpVisualComponent)e2.getSource(), e2.getX(), e2.getY())) {
                this.clickROI = true;
                XpRoiHandleContainer.this.roiPressed(e2);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
            if (this.clickHandle != null) {
                this.clickHandle.handleReleased(e2);
            } else if (this.clickROI) {
                XpRoiHandleContainer.this.roiReleased(e2);
            }
            this.clickHandle = null;
            this.clickROI = false;
        }

        @Override
        public void mouseEntered(MouseEvent e2) {
            if (this.enteredHandle != null) {
                return;
            }
            this.enteredHandle = XpRoiHandleContainer.this.whichHandle((XpVisualComponent)e2.getSource(), e2.getX(), e2.getY());
            if (this.enteredHandle != null) {
                this.enteredHandle.handleEntered(e2);
                this.enteredROI = false;
            } else if (XpRoiHandleContainer.this.containsROI((XpVisualComponent)e2.getSource(), e2.getX(), e2.getY())) {
                this.enteredROI = true;
                XpRoiHandleContainer.this.roiEntered(e2);
            }
        }

        @Override
        public void mouseExited(MouseEvent e2) {
            if (this.enteredHandle != null) {
                this.enteredHandle.handleExited(e2);
                this.enteredHandle = null;
            } else if (this.enteredROI) {
                XpRoiHandleContainer.this.roiExited(e2);
                this.enteredROI = false;
            }
        }

        @Override
        public void mouseDragged(MouseEvent e2) {
            if (this.clickHandle != null) {
                this.clickHandle.handleDragged(e2);
            } else if (this.clickROI) {
                XpRoiHandleContainer.this.roiDragged(e2);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e2) {
            XpHandle tmp = XpRoiHandleContainer.this.whichHandle((XpVisualComponent)e2.getSource(), e2.getX(), e2.getY());
            if (tmp != this.enteredHandle) {
                this.mouseExited(e2);
                this.mouseEntered(e2);
            } else if (tmp != null) {
                tmp.handleMove(e2);
            } else {
                XpRoiHandleContainer.this.roiMove(e2);
            }
        }
    };

    public XpHandle get(int index) {
        return (XpHandle)this.handles.get(index);
    }

    public int getNumHandles() {
        return this.handles.size();
    }

    public void add(XpHandle h2) {
        this.handles.add(h2);
    }

    public void remove(XpHandle h2) {
        this.handles.remove(h2);
    }

    public void add(int idx, XpHandle h2) {
        this.handles.add(idx, h2);
    }

    public void clearHandles() {
        this.handles.clear();
    }

    @Override
    public void setToolTipText(String text) {
        this.tip = text;
    }

    @Override
    public String getToolTipText() {
        return this.tip;
    }

    public final int getHandlePolicy() {
        return this.handlePolicy;
    }

    public final void setHandlePolicy(int handlePolicy) {
        this.handlePolicy = handlePolicy;
    }

    protected void copyObject(Object o2) {
        XpRoiHandleContainer rhc = (XpRoiHandleContainer)o2;
        int len = this.handles.size();
        for (int i2 = 0; i2 < len; ++i2) {
            XpHandle nh = rhc.get(i2);
            XpHandle h2 = this.get(i2);
            nh.setLocation(h2.getX(), h2.getY());
        }
    }

    @Override
    public MouseInputListener getMouseInputListener() {
        return this.listener;
    }

    @Override
    public void setSelected(boolean selection) {
    }

    @Override
    public boolean isSelected() {
        return false;
    }

    @Override
    public void anchorDragged(MouseEvent e2, CPoint drag, Object source) {
    }

    @Override
    public void anchorPressed(MouseEvent e2, Object source) {
    }

    @Override
    public void anchorReleased(MouseEvent e2, Object source) {
    }

    @Override
    public void paintRoi(XpVisualComponent vc, Graphics2D g2) {
        block2: {
            block3: {
                if (!this.visible) break block2;
                this.paintShape(vc, g2);
                if (this.isSelected()) break block3;
                if (this.handlePolicy != 0) break block2;
            }
            this.paintHandles(vc, g2);
        }
    }

    public void paintShape(XpVisualComponent vc, Graphics2D g2) {
    }

    public void paintHandles(XpVisualComponent vc, Graphics2D g2) {
        int n2 = this.handles.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            XpHandle h2 = (XpHandle)this.handles.get(i2);
            h2.paintHandle(vc, g2);
        }
    }

    @Override
    public boolean contains(XpVisualComponent vc, int x2, int y2) {
        if (this.visible) {
            if (this.containsHandles(vc, x2, y2)) {
                return true;
            }
            return this.containsROI(vc, x2, y2);
        }
        return false;
    }

    public boolean containsHandles(XpVisualComponent vc, int x2, int y2) {
        block4: {
            block3: {
                if (this.isSelected()) break block3;
                if (this.handlePolicy != 0) break block4;
            }
            int n2 = this.handles.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                XpHandle h2 = (XpHandle)this.handles.get(i2);
                if (!h2.contains(vc, x2, y2)) continue;
                return true;
            }
        }
        return false;
    }

    private XpHandle whichHandle(XpVisualComponent vc, int x2, int y2) {
        block4: {
            block3: {
                if (this.isSelected()) break block3;
                if (this.handlePolicy != 0) break block4;
            }
            int n2 = this.handles.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                XpHandle h2 = (XpHandle)this.handles.get(i2);
                if (!h2.contains(vc, x2, y2)) continue;
                return h2;
            }
        }
        return null;
    }

    public boolean containsROI(XpVisualComponent vc, int x2, int y2) {
        return false;
    }

    @Override
    public void setImage(XpImage image) {
    }

    @Override
    public XpImage getImage() {
        return null;
    }

    @Override
    public void removePropertyChangeListener(String propName, PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(propName, pcl);
    }

    @Override
    public void addPropertyChangeListener(String propName, PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(propName, pcl);
    }

    protected final void firePropertyChange(String property, Object value) {
        PropertyChangeEvent e2 = new PropertyChangeEvent(this, property, null, value);
        this.pcs.firePropertyChange(e2);
    }

    @Override
    public GSPSGraphic gspsDescription() {
        return null;
    }

    @Override
    public void addRoiEventListener(XpRoiEventListener rel) {
    }

    @Override
    public void removeRoiEventListener(XpRoiEventListener rel) {
    }

    public void roiDragged(MouseEvent e2) {
    }

    public void roiMove(MouseEvent e2) {
    }

    public void roiClicked(MouseEvent e2) {
    }

    public void roiEntered(MouseEvent e2) {
    }

    public void roiExited(MouseEvent e2) {
    }

    public void roiPressed(MouseEvent e2) {
    }

    public void roiReleased(MouseEvent e2) {
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
        this.firePropertyChange("ROI_MODEL", this);
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    protected static class GraphicDescriptor
    implements GSPSGraphic {
        private String gtype = "POINT";
        private boolean filled = false;
        private Point2D[] pts = null;

        public GraphicDescriptor(String gtype, Point2D[] pts) {
            this.gtype = gtype;
            this.pts = pts;
        }

        public GraphicDescriptor(String gtype, Point2D[] pts, boolean filled) {
            this(gtype, pts);
            this.filled = filled;
        }

        @Override
        public final String getGraphicType() {
            return this.gtype;
        }

        @Override
        public final Point2D[] getPoints() {
            return this.pts;
        }

        @Override
        public boolean isGraphicFilled() {
            return this.filled;
        }
    }
}

