/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.roi.aw;

import com.ge.med.idc.ComponentCreator;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.GSPSGraphic;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpAnchorable;
import com.ge.med.terra.jami.XpGeomUtils;
import com.ge.med.terra.jami.XpHandle;
import com.ge.med.terra.jami.XpHandleVc;
import com.ge.med.terra.jami.XpPixelStatistics;
import com.ge.med.terra.jami.XpPropertiesManager;
import com.ge.med.terra.jami.XpRoiComponentCreator;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.roi.RoiShapeModel;
import com.ge.med.terra.jami.roi.XpRoiHandleContainer;
import com.ge.med.terra.jami.roi.XpStatisticsRoi;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class XpANTEVRoi
extends XpStatisticsRoi
implements Cloneable,
Serializable {
    private static final String DEG_SYMBOL = new String(new char[]{'\u00b0'});
    private static int LINE_SENSITIVITY = 10;
    private transient GeneralPath polygon = null;
    private transient GeneralPath drawPolygon = new GeneralPath();
    private transient List points = new ArrayList();
    private transient List txpoints = new ArrayList();
    private transient Point2D tmpPoint1 = new Point2D.Double();
    private transient Point2D tmpPoint2 = new Point2D.Double();
    private transient Point2D containsTemp = new Point2D.Double();
    private transient Point2D clipPt = new Point2D.Double();
    private transient List approxPts = new ArrayList();
    private double minX = 0.0;
    private double maxX = 0.0;
    private double minY = 0.0;
    private double maxY = 0.0;
    private double minX1 = 0.0;
    private double maxX1 = 0.0;
    private double minY1 = 0.0;
    private double maxY1 = 0.0;
    private transient Point2D accumPoint = new Point2D.Double();
    private transient Point2D firstPtOffset = new Point2D.Double();
    private boolean closed = false;
    private boolean idealMetrics = true;
    private boolean doHandles = true;
    double _centerX = 0.0;
    double _centerY = 0.0;
    public static int ARROWLENGTH;
    public static int ARROWHALFWIDTH;

    public XpANTEVRoi(Point2D[] pts) {
        super(new GeneralPath());
        this.init(pts, false, true);
    }

    public XpANTEVRoi(Point2D[] pts, boolean calcPixelStatistics) {
        super(new GeneralPath());
        this.init(pts, calcPixelStatistics, true);
    }

    public XpANTEVRoi(Point2D[] pts, boolean calcPixelStatistics, boolean doHandles) {
        super(new GeneralPath());
        this.init(pts, calcPixelStatistics, doHandles);
    }

    private void init(Point2D[] pts, boolean pixStats, boolean doHandles) {
        this.polygon = (GeneralPath)this.getModelShape();
        this.setCalcPixelStats(pixStats);
        this.doHandles = doHandles;
        if (pts != null && pts.length > 0 && pts.length == 4) {
            for (int i2 = 0; i2 < pts.length; ++i2) {
                this.points.add(pts[i2]);
                this.txpoints.add(new Point2D.Double());
                XpHandle handle = new XpHandle((XpAnchorable)this, i2, 16);
                handle.setFilled(false);
                this.add(handle);
            }
        } else {
            System.out.println("Need four Points for creation ====>");
            return;
        }
        XpHandle handle = new XpHandle((XpAnchorable)this, 4, 16);
        handle.setFilled(false);
        handle.setShape(XpHandle.HANDLE_CROSSHAIR, XpHandle.HANDLE_BOX);
        this.points.add(new Point2D.Double(this._centerX, this._centerY));
        this.txpoints.add(new Point2D.Double());
        this.add(handle);
        this.calculateCenter();
        this.generateModelPolygon();
    }

    @Override
    public Object clone() {
        int len = this.points.size();
        Point2D[] ptarray = new Point2D[len];
        for (int i2 = 0; i2 < len; ++i2) {
            Point2D thept = (Point2D)this.points.get(i2);
            ptarray[i2] = (Point2D)thept.clone();
        }
        XpANTEVRoi ccr = new XpANTEVRoi(ptarray);
        this.copyObject(ccr);
        return ccr;
    }

    @Override
    protected void copyObject(Object o2) {
        XpANTEVRoi pr = (XpANTEVRoi)o2;
        super.copyObject(pr);
        pr.closed = this.closed;
        pr.idealMetrics = this.idealMetrics;
        pr.doHandles = this.doHandles;
    }

    @Override
    public final Shape getDrawShape() {
        this.generateDrawPolygon();
        return this.drawPolygon;
    }

    @Override
    public final String createRoiStatLabel(XpPixelStatistics ps) {
        double angle;
        String roiStat = this.getRoiLabel() + ": ";
        double pixelSizeX = this.getImage().getPixelDimensionX();
        double pixelSizeY = this.getImage().getPixelDimensionY();
        Point2D p1 = (Point2D)this.points.get(0);
        Point2D p2 = (Point2D)this.points.get(1);
        Point2D p3 = (Point2D)this.points.get(2);
        Point2D p4 = (Point2D)this.points.get(3);
        double dx = (p1.getX() - p2.getX()) * pixelSizeX;
        double dy = (p1.getY() - p2.getY()) * pixelSizeY;
        double dx1 = (p4.getX() - p3.getX()) * pixelSizeX;
        double dy1 = (p4.getY() - p3.getY()) * pixelSizeY;
        double angle1 = Math.atan2(dy, dx) * 180.0 / Math.PI;
        double angle2 = Math.atan2(dy1, dx1) * 180.0 / Math.PI;
        if (angle1 > 180.0) {
            angle1 = 360.0 - angle1;
        }
        if (angle2 > 180.0) {
            angle2 = 360.0 - angle2;
        }
        if ((angle = angle1 - angle2) < 0.0) {
            angle = -angle;
        }
        if (angle > 180.0) {
            angle = 360.0 - angle;
        }
        if (angle > 90.0) {
            angle = 180.0 - angle;
        }
        if (angle < 0.0) {
            angle = -angle;
        }
        roiStat = roiStat + "angle " + this.statFormat(angle) + DEG_SYMBOL;
        return roiStat;
    }

    public double getStats() {
        double angle;
        double pixelSizeX = this.getImage().getPixelDimensionX();
        double pixelSizeY = this.getImage().getPixelDimensionY();
        Point2D p1 = (Point2D)this.points.get(0);
        Point2D p2 = (Point2D)this.points.get(1);
        Point2D p3 = (Point2D)this.points.get(2);
        Point2D p4 = (Point2D)this.points.get(3);
        double dx = (p1.getX() - p2.getX()) * pixelSizeX;
        double dy = (p1.getY() - p2.getY()) * pixelSizeY;
        double dx1 = (p4.getX() - p3.getX()) * pixelSizeX;
        double dy1 = (p4.getY() - p3.getY()) * pixelSizeY;
        double angle1 = Math.atan2(dy, dx) * 180.0 / Math.PI;
        double angle2 = Math.atan2(dy1, dx1) * 180.0 / Math.PI;
        if (angle1 > 180.0) {
            angle1 = 360.0 - angle1;
        }
        if (angle2 > 180.0) {
            angle2 = 360.0 - angle2;
        }
        if ((angle = angle1 - angle2) < 0.0) {
            angle = -angle;
        }
        if (angle > 180.0) {
            angle = 360.0 - angle;
        }
        if (angle > 90.0) {
            angle = 180.0 - angle;
        }
        if (angle < 0.0) {
            angle = -angle;
        }
        return angle;
    }

    @Override
    public final void render(XpVisualComponent vc, Graphics2D g2) {
        super.render(vc, g2);
        g2.setColor(XpHandleVc.getHandleColor());
        this.drawRoiId(g2, this.firstPtOffset.getX(), this.firstPtOffset.getY());
    }

    public final Point2D getPoint(int i2) {
        return (Point2D)this.points.get(i2);
    }

    public final int getNumPoints() {
        return this.points.size();
    }

    private final void generateModelPolygon() {
        this.polygon.reset();
        this.approxPts.clear();
        int nPts = this.points.size();
        if (nPts > 0) {
            Point2D p2;
            Point2D prev = p2 = (Point2D)this.points.get(0);
            this.approxPts.add(p2);
            float x2 = (float)p2.getX();
            float y2 = (float)p2.getY();
            this.polygon.moveTo(x2, y2);
            for (int i2 = 1; i2 < nPts; ++i2) {
                p2 = (Point2D)this.points.get(i2);
                x2 = (float)p2.getX();
                y2 = (float)p2.getY();
                this.polygon.lineTo(x2, y2);
                double distance = p2.distanceSq(prev);
                if (!(distance > 6.0) && nPts >= 100) continue;
                this.approxPts.add(p2);
                prev = p2;
            }
            if (this.closed && nPts > 2) {
                this.polygon.closePath();
            }
        }
    }

    @Override
    public void roiDragged(MouseEvent e2) {
        super.roiDragged(e2);
        this.calculateCenter();
    }

    public void calculateCenter() {
        Point2D c1 = new Point2D.Double(0.0, 0.0);
        Point2D c2 = new Point2D.Double(0.0, 0.0);
        Point2D c3 = new Point2D.Double(0.0, 0.0);
        Point2D c4 = new Point2D.Double(0.0, 0.0);
        c1 = (Point2D)this.points.get(0);
        c2 = (Point2D)this.points.get(1);
        c3 = (Point2D)this.points.get(2);
        c4 = (Point2D)this.points.get(3);
        double _centerX1 = (c1.getX() + c2.getX()) / 2.0;
        double _centerY1 = (c1.getY() + c2.getY()) / 2.0;
        double _centerX2 = (c3.getX() + c4.getX()) / 2.0;
        double _centerY2 = (c3.getY() + c4.getY()) / 2.0;
        this._centerX = (_centerX1 + _centerX2) / 2.0;
        this._centerY = (_centerY1 + _centerY2) / 2.0;
        ((Point2D)this.points.get(4)).setLocation(this._centerX, this._centerY);
    }

    private final void generateDrawPolygon() {
        this.polygon.reset();
        this.drawPolygon.reset();
        int nPts = this.points.size();
        if (nPts > 0) {
            Point2D p2 = (Point2D)this.points.get(0);
            float x2 = (float)p2.getX();
            float y2 = (float)p2.getY();
            this.getDisplayPoint(p2, this.tmpPoint1);
            float t_x = (float)this.tmpPoint1.getX();
            float t_y = (float)this.tmpPoint1.getY();
            this.polygon.moveTo(x2, y2);
            this.drawPolygon.moveTo(t_x, t_y);
            this.firstPtOffset.setLocation(t_x + 4.0f, t_y - 2.0f);
            this.minX = this.maxX = (double)x2;
            this.minY = this.maxY = (double)y2;
            p2 = (Point2D)this.points.get(1);
            x2 = (float)p2.getX();
            y2 = (float)p2.getY();
            this.getDisplayPoint(p2, this.tmpPoint1);
            t_x = (float)this.tmpPoint1.getX();
            t_y = (float)this.tmpPoint1.getY();
            this.polygon.lineTo(x2, y2);
            this.drawPolygon.lineTo(t_x, t_y);
            if ((double)x2 < this.minX) {
                this.minX = x2;
            }
            if ((double)x2 > this.maxX) {
                this.maxX = x2;
            }
            if ((double)y2 < this.minY) {
                this.minY = y2;
            }
            if ((double)y2 > this.maxY) {
                this.maxY = y2;
            }
            p2 = (Point2D)this.points.get(2);
            x2 = (float)p2.getX();
            y2 = (float)p2.getY();
            this.getDisplayPoint(p2, this.tmpPoint1);
            t_x = (float)this.tmpPoint1.getX();
            t_y = (float)this.tmpPoint1.getY();
            this.polygon.moveTo(x2, y2);
            this.drawPolygon.moveTo(t_x, t_y);
            this.minX1 = this.maxX1 = (double)x2;
            this.minY1 = this.maxY1 = (double)y2;
            p2 = (Point2D)this.points.get(3);
            x2 = (float)p2.getX();
            y2 = (float)p2.getY();
            this.getDisplayPoint(p2, this.tmpPoint1);
            t_x = (float)this.tmpPoint1.getX();
            t_y = (float)this.tmpPoint1.getY();
            this.polygon.lineTo(x2, y2);
            this.drawPolygon.lineTo(t_x, t_y);
            if ((double)x2 < this.minX1) {
                this.minX1 = x2;
            }
            if ((double)x2 > this.maxX1) {
                this.maxX1 = x2;
            }
            if ((double)y2 < this.minY1) {
                this.minY1 = y2;
            }
            if ((double)y2 > this.maxY1) {
                this.maxY1 = y2;
            }
            if (this.closed && nPts > 2) {
                this.polygon.closePath();
                this.drawPolygon.closePath();
            }
        }
    }

    @Override
    public void anchorPressed(MouseEvent e2, Object source) {
        super.anchorPressed(e2, source);
        XpHandle xph = (XpHandle)source;
        int i2 = xph.getAnchorPointIndex();
        Point2D p2 = (Point2D)this.points.get(i2);
        this.accumPoint.setLocation(p2);
    }

    @Override
    public void anchorDragged(MouseEvent e2, CPoint drag, Object source) {
        super.anchorDragged(e2, drag, source);
        XpHandle xph = (XpHandle)source;
        int i2 = xph.getAnchorPointIndex();
        Point2D p2 = (Point2D)this.points.get(i2);
        this.accumPoint.setLocation(this.accumPoint.getX() + drag.x, this.accumPoint.getY() + drag.y);
        double x2 = this.accumPoint.getX();
        double y2 = this.accumPoint.getY();
        this.clipPoint(x2, y2, this.clipPt);
        if (x2 == this.clipPt.getX() && y2 == this.clipPt.getY()) {
            p2.setLocation(this.clipPt);
            if (i2 == 4) {
                Point2D p1 = (Point2D)this.points.get(0);
                Point2D p22 = (Point2D)this.points.get(1);
                Point2D p3 = (Point2D)this.points.get(2);
                Point2D p4 = (Point2D)this.points.get(3);
                p1.setLocation(p1.getX() + drag.x, p1.getY() + drag.y);
                p22.setLocation(p22.getX() + drag.x, p22.getY() + drag.y);
                p3.setLocation(p3.getX() + drag.x, p3.getY() + drag.y);
                p4.setLocation(p4.getX() + drag.x, p4.getY() + drag.y);
            }
        }
        if (i2 != 4) {
            this.calculateCenter();
        }
        this.syncModel();
    }

    @Override
    public boolean containsROI(XpVisualComponent vc, int x2, int y2) {
        this.getImagePoint(x2, y2, this.containsTemp);
        double xx = this.containsTemp.getX();
        double yy = this.containsTemp.getY();
        if (xx > this.minX && xx < this.maxX && yy > this.minY && yy < this.maxY) {
            Point2D first;
            Point2D prev = first = (Point2D)this.approxPts.get(0);
            int len = this.approxPts.size();
            for (int i2 = 1; i2 < len - 2; ++i2) {
                Point2D p2 = (Point2D)this.approxPts.get(i2);
                if (XpGeomUtils.containsCoord((int)xx, (int)yy, prev, p2, LINE_SENSITIVITY)) {
                    return true;
                }
                prev = p2;
            }
            if (this.closed && XpGeomUtils.containsCoord((int)xx, (int)yy, prev, first, LINE_SENSITIVITY)) {
                return true;
            }
        } else if (xx > this.minX1 && xx < this.maxX1 && yy > this.minY1 && yy < this.maxY1) {
            Point2D first;
            Point2D prev = first = (Point2D)this.approxPts.get(2);
            int len = this.approxPts.size();
            for (int i3 = 2; i3 < len; ++i3) {
                Point2D p3 = (Point2D)this.approxPts.get(i3);
                if (XpGeomUtils.containsCoord((int)xx, (int)yy, prev, p3, LINE_SENSITIVITY)) {
                    return true;
                }
                prev = p3;
            }
            if (this.closed && XpGeomUtils.containsCoord((int)xx, (int)yy, prev, first, LINE_SENSITIVITY)) {
                return true;
            }
        }
        return false;
    }

    public static ComponentCreator getComponentCreator(int ccid) {
        if (ccid == 0) {
            return new XpANTEVComponentCreator();
        }
        return null;
    }

    private void translate(double tx, double ty) {
        Point2D txp;
        Point2D p2;
        int i2;
        int len = this.points.size();
        boolean dotranslate = true;
        for (i2 = 0; i2 < len; ++i2) {
            p2 = (Point2D)this.points.get(i2);
            txp = (Point2D)this.txpoints.get(i2);
            double x2 = p2.getX() + tx;
            double y2 = p2.getY() + ty;
            this.clipPoint(x2, y2, this.clipPt);
            double cx = this.clipPt.getX();
            double cy = this.clipPt.getY();
            if ((x2 != cx || y2 != cy) && this.isClipRoi()) {
                dotranslate = false;
                break;
            }
            txp.setLocation(cx, cy);
        }
        if (dotranslate) {
            for (i2 = 0; i2 < len; ++i2) {
                p2 = (Point2D)this.points.get(i2);
                txp = (Point2D)this.txpoints.get(i2);
                p2.setLocation(txp);
            }
            this.generateDrawPolygon();
        }
    }

    @Override
    protected final void dragMouse(CPoint drag) {
        this.translate(drag.x, drag.y);
        this.syncModel();
    }

    @Override
    protected void updateHandles() {
        int len = this.points.size();
        for (int i2 = 0; i2 < len; ++i2) {
            XpHandle h2 = this.get(i2);
            Point2D p2 = (Point2D)this.points.get(i2);
            h2.setLocation(p2);
        }
    }

    public final boolean isClosed() {
        return this.closed;
    }

    public final void setClosed(boolean closed) {
        this.closed = closed;
    }

    @Override
    public GSPSGraphic gspsDescription() {
        int len = this.points.size();
        Point2D[] pts = new Point2D[len];
        for (int i2 = 0; i2 < len; ++i2) {
            Point2D p2 = (Point2D)this.points.get(i2);
            pts[i2] = new Point2D.Double(p2.getX(), p2.getY());
        }
        XpRoiHandleContainer.GraphicDescriptor description = new XpRoiHandleContainer.GraphicDescriptor("POLYLINE", pts);
        return description;
    }

    public void setIdealMetrics(boolean idealMetric) {
        this.idealMetrics = idealMetric;
    }

    public boolean isIdealMetrics() {
        return this.idealMetrics;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        int i2;
        s2.defaultWriteObject();
        if (this.points != null && this.points.size() > 0) {
            s2.writeInt(this.points.size());
            for (i2 = 0; i2 < this.points.size(); ++i2) {
                s2.writeDouble(((Point2D)this.points.get(i2)).getX());
                s2.writeDouble(((Point2D)this.points.get(i2)).getY());
            }
        }
        s2.writeInt(this.approxPts.size());
        for (i2 = 0; i2 < this.approxPts.size(); ++i2) {
            s2.writeDouble(((Point2D)this.approxPts.get(i2)).getX());
            s2.writeDouble(((Point2D)this.approxPts.get(i2)).getY());
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException {
        try {
            int i2;
            s2.defaultReadObject();
            int size = s2.readInt();
            ArrayList ds_points = new ArrayList();
            ArrayList ds_txpoints = new ArrayList();
            ArrayList<Point2D.Double> ds_approxPts = new ArrayList<Point2D.Double>();
            Point2D[] pts = new Point2D[size];
            for (i2 = 0; i2 < size; ++i2) {
                double x2 = s2.readDouble();
                double y2 = s2.readDouble();
                pts[i2] = new Point2D.Double(x2, y2);
            }
            size = s2.readInt();
            for (i2 = 0; i2 < size; ++i2) {
                ds_approxPts.add(new Point2D.Double(s2.readDouble(), s2.readDouble()));
            }
            this.points = ds_points;
            this.txpoints = ds_txpoints;
            this.approxPts = ds_approxPts;
            this.drawPolygon = new GeneralPath();
            this.tmpPoint1 = new Point2D.Double();
            this.tmpPoint2 = new Point2D.Double();
            this.containsTemp = new Point2D.Double();
            this.clipPt = new Point2D.Double();
            this.accumPoint = new Point2D.Double();
            this.firstPtOffset = new Point2D.Double();
            this.setRoiShapeModel(new RoiShapeModel(new GeneralPath()));
            this.init(pts, true, true);
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    static {
        String ls = XpPropertiesManager.getProperty("jami.roi.polygon.linesensitivity");
        int ils = 4;
        if (ls != null && (ils = Integer.parseInt(ls)) <= 0) {
            ils = 4;
        }
        LINE_SENSITIVITY = ils;
        ARROWLENGTH = 8;
        ARROWHALFWIDTH = 4;
    }

    private static class XpANTEVComponentCreator
    extends XpRoiComponentCreator {
        private XpANTEVComponentCreator() {
        }

        @Override
        public RoiActor getRoiActor(double x2, double y2) {
            Point2D[] pts2 = new Point2D[]{new Point2D.Double(x2, y2), new Point2D.Double(x2 + 30.0, y2), new Point2D.Double(x2, y2 + 30.0), new Point2D.Double(x2 + 30.0, y2 + 32.0)};
            XpANTEVRoi antev = new XpANTEVRoi(pts2);
            return antev;
        }
    }
}

