/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.roi.aw;

import com.ge.med.idc.ComponentCapable;
import com.ge.med.idc.ComponentCreator;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.GSPSGraphic;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpAnchorable;
import com.ge.med.terra.jami.XpGeomUtils;
import com.ge.med.terra.jami.XpHandle;
import com.ge.med.terra.jami.XpHandleVc;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpPixelStatistics;
import com.ge.med.terra.jami.XpPropertiesManager;
import com.ge.med.terra.jami.XpRoiComponentCreator;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.roi.RoiShapeModel;
import com.ge.med.terra.jami.roi.XpRoiHandleContainer;
import com.ge.med.terra.jami.roi.XpStatisticsRoi;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class XpAwDistanceRoi
extends XpStatisticsRoi
implements Cloneable,
Serializable {
    private static final String DEG_SYMBOL = new String(new char[]{'\u00b0'});
    private static int LINE_SENSITIVITY = 4;
    private transient GeneralPath polygon = null;
    private transient GeneralPath drawPolygon = new GeneralPath();
    private transient List points = new ArrayList();
    private transient List txpoints = new ArrayList();
    private transient List handle_points = new ArrayList();
    private transient Point2D tmpPoint1 = new Point2D.Double();
    private transient Point2D tmpPoint2 = new Point2D.Double();
    private transient Point2D containsTemp = new Point2D.Double();
    private transient Point2D clipPt = new Point2D.Double();
    private transient List approxPts = new ArrayList();
    private double minX = 0.0;
    private double maxX = 0.0;
    private double minY = 0.0;
    private double maxY = 0.0;
    private transient Point2D accumPoint = new Point2D.Double();
    private transient Point2D firstPtOffset = new Point2D.Double();
    private boolean closed = false;
    private boolean idealMetrics = true;
    private boolean doHandles = true;
    private int a_handlegap = 10;
    public static int ARROWLENGTH = 8;
    public static int ARROWHALFWIDTH = 4;

    public XpAwDistanceRoi(Point2D[] pts) {
        super(new GeneralPath());
        this.init(pts, false, true);
    }

    public XpAwDistanceRoi(Point2D[] pts, boolean calcPixelStatistics) {
        super(new GeneralPath());
        this.init(pts, calcPixelStatistics, true);
    }

    public XpAwDistanceRoi(Point2D[] pts, boolean calcPixelStatistics, boolean doHandles) {
        super(new GeneralPath());
        this.init(pts, calcPixelStatistics, doHandles);
    }

    private void init(Point2D[] pts, boolean pixStats, boolean doHandles) {
        this.polygon = (GeneralPath)this.getModelShape();
        this.setCalcPixelStats(pixStats);
        this.doHandles = doHandles;
        if (pts != null && pts.length > 0 && pts.length == 2) {
            for (int i2 = 0; i2 < pts.length; ++i2) {
                this.points.add(pts[i2]);
                this.txpoints.add(new Point2D.Double());
                XpHandle handle = new XpHandle((XpAnchorable)this, i2, 16);
                handle.setFilled(true);
                this.add(handle);
            }
            this.setGapHandle(this.a_handlegap);
            this.generateModelPolygon();
        }
    }

    @Override
    public Object clone() {
        int len = this.points.size();
        Point2D[] ptarray = new Point2D[len];
        for (int i2 = 0; i2 < len; ++i2) {
            Point2D thept = (Point2D)this.points.get(i2);
            ptarray[i2] = (Point2D)thept.clone();
        }
        XpAwDistanceRoi ccr = new XpAwDistanceRoi(ptarray);
        this.copyObject(ccr);
        return ccr;
    }

    @Override
    protected void copyObject(Object o2) {
        XpAwDistanceRoi pr = (XpAwDistanceRoi)o2;
        super.copyObject(pr);
        pr.closed = this.closed;
        pr.idealMetrics = this.idealMetrics;
        pr.doHandles = this.doHandles;
    }

    @Override
    public final Shape getDrawShape() {
        this.generateDrawPolygon();
        return this.drawPolygon;
    }

    public final double getLineAngle() {
        return this.getLineAngle(0);
    }

    public final double getLineAngle(int pairIdx) {
        int len = this.points.size();
        if (len == 2) {
            Point2D p1 = (Point2D)this.points.get(0);
            Point2D p2 = (Point2D)this.points.get(1);
            double dy = Math.abs(p2.getY() - p1.getY());
            double dx = Math.abs(p2.getX() - p1.getX());
            return Math.atan2(dx, dy);
        }
        return 0.0;
    }

    @Override
    public final String createRoiStatLabel(XpPixelStatistics ps) {
        double angle = Math.toDegrees(this.getLineAngle());
        double distance = this.getLength();
        int len = this.points.size();
        String roiStat = this.getRoiLabel() + ": ";
        if (len == 2) {
            roiStat = roiStat + "distance " + this.statFormat0(distance) + " mm";
            roiStat = roiStat + ", angle " + this.statFormat(angle) + DEG_SYMBOL;
        }
        return roiStat;
    }

    @Override
    public final void render(XpVisualComponent vc, Graphics2D g2) {
        super.render(vc, g2);
        g2.setColor(XpHandleVc.getHandleColor());
        this.drawRoiId(g2, this.firstPtOffset.getX(), this.firstPtOffset.getY());
    }

    public final void addPoint(Point2D p2) {
        this.points.add(p2);
        this.txpoints.add(new Point2D.Double());
        int new_id = this.getNumHandles();
        XpHandle handle = new XpHandle((XpAnchorable)this, new_id, 16);
        handle.setFilled(false);
        this.add(handle);
        this.generateModelPolygon();
        this.syncModel();
    }

    public final Point2D getPoint(int i2) {
        return (Point2D)this.points.get(i2);
    }

    public final int getNumPoints() {
        return this.points.size();
    }

    private final void generateModelPolygon() {
        this.polygon.reset();
        this.approxPts.clear();
        int nPts = this.points.size();
        if (nPts > 0) {
            Point2D p2;
            Point2D prev = p2 = (Point2D)this.points.get(0);
            this.approxPts.add(p2);
            float x2 = (float)p2.getX();
            float y2 = (float)p2.getY();
            this.polygon.moveTo(x2, y2);
            for (int i2 = 1; i2 < nPts; ++i2) {
                p2 = (Point2D)this.points.get(i2);
                x2 = (float)p2.getX();
                y2 = (float)p2.getY();
                this.polygon.lineTo(x2, y2);
                double distance = p2.distanceSq(prev);
                if (!(distance > 6.0) && nPts >= 100) continue;
                this.approxPts.add(p2);
                prev = p2;
            }
            if (this.closed && nPts > 2) {
                this.polygon.closePath();
            }
        }
    }

    private final void generateDrawPolygon() {
        this.polygon.reset();
        this.drawPolygon.reset();
        int nPts = this.points.size();
        if (nPts > 0) {
            Point2D p2 = (Point2D)this.points.get(0);
            float x2 = (float)p2.getX();
            float y2 = (float)p2.getY();
            this.getDisplayPoint(p2, this.tmpPoint1);
            float t_x = (float)this.tmpPoint1.getX();
            float t_y = (float)this.tmpPoint1.getY();
            this.polygon.moveTo(x2, y2);
            this.drawPolygon.moveTo(t_x, t_y);
            this.firstPtOffset.setLocation(t_x + 4.0f, t_y - 2.0f);
            this.minX = this.maxX = (double)x2;
            this.minY = this.maxY = (double)y2;
            for (int i2 = 1; i2 < nPts; ++i2) {
                p2 = (Point2D)this.points.get(i2);
                x2 = (float)p2.getX();
                y2 = (float)p2.getY();
                this.getDisplayPoint(p2, this.tmpPoint1);
                t_x = (float)this.tmpPoint1.getX();
                t_y = (float)this.tmpPoint1.getY();
                this.polygon.lineTo(x2, y2);
                this.drawPolygon.lineTo(t_x, t_y);
                if ((double)x2 < this.minX) {
                    this.minX = x2;
                }
                if ((double)x2 > this.maxX) {
                    this.maxX = x2;
                }
                if ((double)y2 < this.minY) {
                    this.minY = y2;
                }
                if (!((double)y2 > this.maxY)) continue;
                this.maxY = y2;
            }
            Point2D firstp = (Point2D)this.points.get(0);
            Point2D secondp = (Point2D)this.points.get(1);
            this.drawArrow(secondp.getX() + 0.5, secondp.getY(), firstp.getX() + 0.5, firstp.getY());
            this.drawArrow(firstp.getX(), firstp.getY() + 0.5, secondp.getX(), secondp.getY() + 0.5);
            if (this.closed && nPts > 2) {
                this.polygon.closePath();
                this.drawPolygon.closePath();
            }
        }
    }

    public void setGapHandle(int gap) {
        Point2D p1 = (Point2D)this.points.get(0);
        Point2D p2 = (Point2D)this.points.get(1);
        Point2D.Double v2 = this.getVector(p1, p2);
        Point2D.Double multH = new Point2D.Double(v2.getX() * (double)gap, v2.getY() * (double)gap);
        double hx = p1.getX() - multH.getX();
        double hy = p1.getY() - multH.getY();
        double hx1 = p2.getX() + multH.getX();
        double hy1 = p2.getY() + multH.getY();
        this.handle_points.add(new Point2D.Double(hx, hy));
        this.handle_points.add(new Point2D.Double(hx1, hy1));
    }

    public void updateGapHandle(int gap) {
        Point2D p1 = (Point2D)this.points.get(0);
        Point2D p2 = (Point2D)this.points.get(1);
        Point2D.Double v2 = this.getVector(p1, p2);
        Point2D.Double h1 = new Point2D.Double(0.0, 0.0);
        Point2D.Double h2 = new Point2D.Double(0.0, 0.0);
        Point2D.Double multH = new Point2D.Double(v2.getX() * (double)gap, v2.getY() * (double)gap);
        double hx = p1.getX() - multH.getX();
        double hy = p1.getY() - multH.getY();
        double hx1 = p2.getX() + multH.getX();
        double hy1 = p2.getY() + multH.getY();
        ((Point2D)this.handle_points.get(0)).setLocation(new Point2D.Double(hx, hy));
        ((Point2D)this.handle_points.get(1)).setLocation(new Point2D.Double(hx1, hy1));
    }

    public Point2D.Double getVector(Point2D p1, Point2D p2) {
        Point2D.Double v2 = new Point2D.Double(p2.getX() - p1.getX(), p2.getY() - p1.getY());
        double nv = XpGeomUtils.norm(v2);
        if (nv == 0.0) {
            v2.setLocation(1.0, 0.0);
        } else {
            double vx = v2.x / nv;
            double vy = v2.y / nv;
            v2.setLocation(vx, vy);
        }
        return v2;
    }

    @Override
    public void roiDragged(MouseEvent e2) {
        super.roiDragged(e2);
        this.updateGapHandle(this.a_handlegap);
    }

    public void drawArrow(double x1, double y1, double x2, double y2) {
        double angle = Math.atan2(y2 - y1, x2 - x1);
        Point2D.Double v1 = new Point2D.Double((int)Math.floor((double)ARROWLENGTH * Math.cos(angle)), (int)Math.floor((double)ARROWLENGTH * Math.sin(angle)));
        Point2D.Double v2 = new Point2D.Double((int)Math.floor((double)ARROWHALFWIDTH * Math.sin(angle)), -((int)Math.floor((double)ARROWHALFWIDTH * Math.cos(angle))));
        Point2D.Double p1 = new Point2D.Double(x2, y2);
        p1.x += v1.x;
        p1.y += v1.y;
        p1.x += v2.x;
        p1.y += v2.y;
        Point2D.Double p2 = new Point2D.Double(x2, y2);
        p2.x += v1.x;
        p2.y += v1.y;
        p2.x -= v2.x;
        p2.y -= v2.y;
        Point2D.Double p1Disp = new Point2D.Double(0.0, 0.0);
        Point2D.Double p2Disp = new Point2D.Double(0.0, 0.0);
        Point2D.Double x2Disp = new Point2D.Double(0.0, 0.0);
        this.getDisplayPoint(p1, p1Disp);
        this.getDisplayPoint(p2, p2Disp);
        this.getDisplayPoint(new Point2D.Double(x2, y2), x2Disp);
        this.drawPolygon.moveTo((float)p1Disp.getX(), (float)p1Disp.getY());
        this.drawPolygon.lineTo((float)x2Disp.getX(), (float)x2Disp.getY());
        this.drawPolygon.moveTo((float)p2Disp.x, (float)p2Disp.y);
        this.drawPolygon.lineTo((float)x2Disp.getX(), (float)x2Disp.getY());
    }

    @Override
    public void anchorPressed(MouseEvent e2, Object source) {
        super.anchorPressed(e2, source);
        XpHandle xph = (XpHandle)source;
        int i2 = xph.getAnchorPointIndex();
        Point2D p2 = (Point2D)this.points.get(i2);
        this.accumPoint.setLocation(p2);
    }

    @Override
    public void anchorDragged(MouseEvent e2, CPoint drag, Object source) {
        super.anchorDragged(e2, drag, source);
        XpHandle xph = (XpHandle)source;
        int i2 = xph.getAnchorPointIndex();
        Point2D p2 = (Point2D)this.points.get(i2);
        this.accumPoint.setLocation(this.accumPoint.getX() + drag.x, this.accumPoint.getY() + drag.y);
        double x2 = this.accumPoint.getX();
        double y2 = this.accumPoint.getY();
        this.clipPoint(x2, y2, this.clipPt);
        if (x2 == this.clipPt.getX() && y2 == this.clipPt.getY()) {
            p2.setLocation(this.clipPt);
            this.updateGapHandle(this.a_handlegap);
        }
        this.syncModel();
    }

    @Override
    public boolean containsROI(XpVisualComponent vc, int x2, int y2) {
        this.getImagePoint(x2, y2, this.containsTemp);
        double xx = this.containsTemp.getX();
        double yy = this.containsTemp.getY();
        if (xx > this.minX && xx < this.maxX && yy > this.minY && yy < this.maxY) {
            Point2D first;
            Point2D prev = first = (Point2D)this.approxPts.get(0);
            int len = this.approxPts.size();
            for (int i2 = 1; i2 < len; ++i2) {
                Point2D p2 = (Point2D)this.approxPts.get(i2);
                if (XpGeomUtils.containsCoord((int)xx, (int)yy, prev, p2, LINE_SENSITIVITY)) {
                    return true;
                }
                prev = p2;
            }
            if (this.closed && XpGeomUtils.containsCoord((int)xx, (int)yy, prev, first, LINE_SENSITIVITY)) {
                return true;
            }
        }
        return false;
    }

    public static ComponentCreator getLineComponentCreator(int ccid) {
        if (ccid == 0) {
            return new PolygonComponentCreator(1);
        }
        return null;
    }

    private void translate(double tx, double ty) {
        Point2D txp;
        Point2D p2;
        int i2;
        int len = this.points.size();
        boolean dotranslate = true;
        for (i2 = 0; i2 < len; ++i2) {
            p2 = (Point2D)this.points.get(i2);
            txp = (Point2D)this.txpoints.get(i2);
            double x2 = p2.getX() + tx;
            double y2 = p2.getY() + ty;
            this.clipPoint(x2, y2, this.clipPt);
            double cx = this.clipPt.getX();
            double cy = this.clipPt.getY();
            if ((x2 != cx || y2 != cy) && this.isClipRoi()) {
                dotranslate = false;
                break;
            }
            txp.setLocation(cx, cy);
        }
        if (dotranslate) {
            for (i2 = 0; i2 < len; ++i2) {
                p2 = (Point2D)this.points.get(i2);
                txp = (Point2D)this.txpoints.get(i2);
                p2.setLocation(txp);
            }
            this.generateDrawPolygon();
        }
    }

    @Override
    protected final void dragMouse(CPoint drag) {
        this.translate(drag.x, drag.y);
        this.syncModel();
    }

    @Override
    protected void updateHandles() {
        int len = this.points.size();
        for (int i2 = 0; i2 < len; ++i2) {
            XpHandle h2 = this.get(i2);
            Point2D p2 = (Point2D)this.handle_points.get(i2);
            h2.setLocation(p2);
        }
    }

    public final boolean isClosed() {
        return this.closed;
    }

    public final void setClosed(boolean closed) {
        this.closed = closed;
    }

    @Override
    public GSPSGraphic gspsDescription() {
        int len = this.points.size();
        Point2D[] pts = new Point2D[len];
        for (int i2 = 0; i2 < len; ++i2) {
            Point2D p2 = (Point2D)this.points.get(i2);
            pts[i2] = new Point2D.Double(p2.getX(), p2.getY());
        }
        XpRoiHandleContainer.GraphicDescriptor description = new XpRoiHandleContainer.GraphicDescriptor("POLYLINE", pts);
        return description;
    }

    public void setIdealMetrics(boolean idealMetric) {
        this.idealMetrics = idealMetric;
    }

    public boolean isIdealMetrics() {
        return this.idealMetrics;
    }

    @Override
    public double getLength() {
        if (!this.idealMetrics) {
            return super.getLength();
        }
        XpImage img = this.getImage();
        int size = this.points.size();
        double len = 0.0;
        if (img != null) {
            double pdx = img.getPixelDimensionX();
            double pdy = img.getPixelDimensionY();
            for (int i2 = 1; i2 < size; ++i2) {
                Point2D p1 = (Point2D)this.points.get(i2);
                Point2D p0 = (Point2D)this.points.get(i2 - 1);
                double x1 = p1.getX() * pdx;
                double y1 = p1.getY() * pdy;
                double x0 = p0.getX() * pdx;
                double y0 = p0.getY() * pdy;
                double dx = x1 - x0;
                double dy = y1 - y0;
                double l2 = Math.sqrt(dx * dx + dy * dy);
                len += l2;
            }
        }
        return len;
    }

    public static ComponentCreator getComponentCreator(int ccid) {
        if (ccid == 0) {
            return new XpDistanceComponentCreator();
        }
        return null;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        int i2;
        s2.defaultWriteObject();
        if (this.points != null && this.points.size() > 0) {
            s2.writeInt(this.points.size());
            for (i2 = 0; i2 < this.points.size(); ++i2) {
                s2.writeDouble(((Point2D)this.points.get(i2)).getX());
                s2.writeDouble(((Point2D)this.points.get(i2)).getY());
            }
        }
        s2.writeInt(this.approxPts.size());
        for (i2 = 0; i2 < this.approxPts.size(); ++i2) {
            s2.writeDouble(((Point2D)this.approxPts.get(i2)).getX());
            s2.writeDouble(((Point2D)this.approxPts.get(i2)).getY());
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException {
        try {
            int i2;
            s2.defaultReadObject();
            int size = s2.readInt();
            ArrayList ds_points = new ArrayList();
            ArrayList ds_txpoints = new ArrayList();
            ArrayList<Point2D.Double> ds_approxPts = new ArrayList<Point2D.Double>();
            Point2D[] pts = new Point2D[size];
            for (i2 = 0; i2 < size; ++i2) {
                double x2 = s2.readDouble();
                double y2 = s2.readDouble();
                pts[i2] = new Point2D.Double(x2, y2);
            }
            size = s2.readInt();
            for (i2 = 0; i2 < size; ++i2) {
                ds_approxPts.add(new Point2D.Double(s2.readDouble(), s2.readDouble()));
            }
            this.points = ds_points;
            this.txpoints = ds_txpoints;
            this.approxPts = ds_approxPts;
            this.drawPolygon = new GeneralPath();
            this.tmpPoint1 = new Point2D.Double();
            this.tmpPoint2 = new Point2D.Double();
            this.containsTemp = new Point2D.Double();
            this.clipPt = new Point2D.Double();
            this.accumPoint = new Point2D.Double();
            this.firstPtOffset = new Point2D.Double();
            this.setRoiShapeModel(new RoiShapeModel(new GeneralPath()));
            this.init(pts, true, true);
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    static {
        String ls = XpPropertiesManager.getProperty("jami.roi.polygon.linesensitivity");
        int ils = 4;
        if (ls != null && (ils = Integer.parseInt(ls)) <= 0) {
            ils = 4;
        }
        LINE_SENSITIVITY = ils;
    }

    private static class XpDistanceComponentCreator
    extends XpRoiComponentCreator {
        private XpDistanceComponentCreator() {
        }

        @Override
        public RoiActor getRoiActor(double x2, double y2) {
            Point2D[] pts1 = new Point2D[]{new Point2D.Double(x2, y2), new Point2D.Double(x2 + 50.0, y2)};
            XpAwDistanceRoi distanceRoi = new XpAwDistanceRoi(pts1);
            return distanceRoi;
        }
    }

    private static class PolygonComponentCreator
    extends XpRoiComponentCreator {
        private XpAwDistanceRoi pm = null;
        private int nSegments = -1;
        private int segments = 0;

        public PolygonComponentCreator(int nSegments) {
            this.nSegments = nSegments;
        }

        public PolygonComponentCreator() {
        }

        @Override
        public RoiActor getRoiActor(double x2, double y2) {
            Point2D[] pts = new Point2D[]{new Point2D.Double(x2 - 1.0, y2), new Point2D.Double(x2, y2)};
            this.pm = new XpAwDistanceRoi(pts);
            this.segments = 1;
            return this.pm;
        }

        @Override
        public void mouseDragged(MouseEvent me) {
            XpVisualComponent jc = (XpVisualComponent)me.getSource();
            int modifiers = me.getModifiers();
            int mbutton1 = modifiers & 0x10;
            int mbutton2 = modifiers & 8;
            int x2 = me.getX();
            int y2 = me.getY();
            if (mbutton1 != 0 && this.pm != null) {
                int nPts = this.pm.getNumPoints();
                Point2D p2 = this.pm.getPoint(nPts - 1);
                CPoint img_pt = this.getImgPt(jc, x2, y2);
                double xx = img_pt.x;
                double yy = img_pt.y;
                p2.setLocation(xx, yy);
                this.pm.generateDrawPolygon();
                this.pm.syncModel();
                jc.repaint();
            }
        }

        @Override
        public void mouseClicked(MouseEvent me) {
        }

        @Override
        public void mousePressed(MouseEvent me) {
            XpVisualComponent vc = (XpVisualComponent)me.getSource();
            int modifiers = me.getModifiers();
            int mbutton1 = modifiers & 0x10;
            int mbutton2 = modifiers & 8;
            int x2 = me.getX();
            int y2 = me.getY();
            if (mbutton1 != 0) {
                if (this.pm == null) {
                    this.dropRoi(me);
                } else if (this.nSegments == -1 || this.segments < this.nSegments) {
                    CPoint img_pt = this.getImgPt(vc, x2, y2);
                    int xx = (int)img_pt.x;
                    int yy = (int)img_pt.y;
                    this.pm.addPoint(new Point2D.Double(xx, yy));
                    ++this.segments;
                    this.pm.setSelected(true);
                }
                vc.repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            XpVisualComponent jc = (XpVisualComponent)me.getSource();
            int modifiers = me.getModifiers();
            int mbutton1 = modifiers & 0x10;
            int mbutton2 = modifiers & 8;
            int x2 = me.getX();
            int y2 = me.getY();
            this.pm.generateDrawPolygon();
            jc.repaint();
            if (mbutton1 == 0 || mbutton1 != 0 && this.segments == this.nSegments) {
                if (!this.isPerpetual()) {
                    ComponentCapable cc = this.getComponentCapable(jc);
                    this.shutdown(cc);
                } else {
                    this.pm = null;
                    this.segments = 0;
                }
            }
        }
    }
}

