/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.roi.aw;

import com.ge.med.idc.ComponentCreator;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpAnchorable;
import com.ge.med.terra.jami.XpHandle;
import com.ge.med.terra.jami.XpRoiComponentCreator;
import com.ge.med.terra.jami.roi.XpRectangularRoi;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public class XpAwRectangle
extends XpRectangularRoi.Rectangle {
    private int centerHandleId = this.getNumHandles();
    private XpHandle centerHandle = new XpHandle((XpAnchorable)this, this.centerHandleId, 16);

    public XpAwRectangle(Rectangle2D r2) {
        super(r2);
        this.add(this.centerHandle);
        double hx = r2.getX() + r2.getWidth() * 0.5;
        double hy = r2.getY() + r2.getHeight() * 0.5;
        this.centerHandle.setLocation(hx, hy);
    }

    @Override
    public void anchorPressed(MouseEvent e2, Object jc) {
        int noHandles = this.getNumHandles();
        for (int i2 = 0; i2 < noHandles; ++i2) {
            this.get(i2).setVisible(false);
        }
        super.anchorPressed(e2, jc);
        XpHandle xph = (XpHandle)jc;
        int handleIdx = xph.getAnchorPointIndex();
        if (handleIdx == this.centerHandleId) {
            super.roiPressed(e2);
        }
    }

    @Override
    public void anchorReleased(MouseEvent e2, Object jc) {
        int noHandles = this.getNumHandles();
        for (int i2 = 0; i2 < noHandles; ++i2) {
            this.get(i2).setVisible(true);
        }
        this.sync();
        super.anchorReleased(e2, jc);
    }

    @Override
    public void anchorDragged(MouseEvent e2, CPoint drag, Object jc) {
        XpHandle xph = (XpHandle)jc;
        int handleIdx = xph.getAnchorPointIndex();
        if (handleIdx == this.centerHandleId) {
            super.roiDragged(e2);
            RectangularShape r2 = (RectangularShape)this.getModelShape();
            double hx = r2.getX() + r2.getWidth() * 0.5;
            double hy = r2.getY() + r2.getHeight() * 0.5;
            this.centerHandle.setLocation(hx, hy);
            this.syncModel();
        } else {
            super.anchorDragged(e2, drag, jc);
        }
    }

    @Override
    public void roiDragged(MouseEvent e2) {
        super.roiDragged(e2);
        RectangularShape r2 = (RectangularShape)this.getModelShape();
        double hx = r2.getX() + r2.getWidth() * 0.5;
        double hy = r2.getY() + r2.getHeight() * 0.5;
        this.centerHandle.setLocation(hx, hy);
        this.syncModel();
    }

    public static ComponentCreator getComponentCreator(int ccid) {
        if (ccid == 0) {
            return new AwRectangleCreator();
        }
        return null;
    }

    public static abstract class RectComponentCreator
    extends XpRoiComponentCreator {
        private final int resizeIdx = 2;

        @Override
        public void mouseDragged(MouseEvent me) {
            XpRectangularRoi rrm = (XpRectangularRoi)this.getCreatedRoiActor();
            XpHandle resize = rrm.getHandle(2);
            resize.handleDragged(me);
        }

        @Override
        public void mousePressed(MouseEvent me) {
            super.mousePressed(me);
            XpRectangularRoi rrm = (XpRectangularRoi)this.getCreatedRoiActor();
            XpHandle resize = rrm.getHandle(2);
            resize.handlePressed(me);
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            XpRectangularRoi rrm = (XpRectangularRoi)this.getCreatedRoiActor();
            XpHandle resize = rrm.getHandle(2);
            resize.handleReleased(me);
            super.mouseReleased(me);
        }
    }

    private static class AwRectangleCreator
    extends RectComponentCreator {
        private AwRectangleCreator() {
        }

        @Override
        public RoiActor getRoiActor(double x2, double y2) {
            return new XpAwRectangle(new Rectangle2D.Double(x2 - 5.0, y2 - 3.0, 5.0, 3.0));
        }
    }
}

