/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.roi.j3d;

import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.CTransform;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpImageRoiVc;
import com.ge.med.terra.jami.XpImageUtils;
import com.ge.med.terra.jami.XpPixelStatistics;
import com.ge.med.terra.jami.XpPropertiesManager;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.capable.FrameOwner;
import com.ge.med.terra.jami.j3d.T3DComponent;
import com.ge.med.terra.jami.roi.RoiStatistics;
import com.ge.med.terra.jami.roi.XpRoiEvent;
import com.ge.med.terra.jami.roi.XpRoiEventListener;
import com.ge.med.terra.jami.roi.XpStatisticsRoi;
import com.ge.med.terra.jami.roi.j3d.Jami3DRoiStatistics;
import com.ge.med.terra.jami.roi.j3d.Roi3DStatImage;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JFrame;

public class Xp3DRoiVc
extends XpImageRoiVc
implements XpRoiEventListener,
PropertyChangeListener {
    private static double PLANE_THRESHOLD = 0.005;
    private boolean viewInit = false;
    private boolean viewLock = true;
    private CTransform ct = new CTransform();
    private boolean dirtyStats = true;
    private JFrame jf = null;
    private boolean displayRoiDebug = false;
    private CTransform rsImg2Ras = new CTransform();
    private CTransform csRas2Img = new CTransform();
    private BufferedImage old_bitimg = null;
    private String statsInfo = "";
    private boolean initPaint = true;
    private boolean isRoiVisible = false;

    public Xp3DRoiVc(RoiActor roiActor) {
        this(roiActor, true);
    }

    public Xp3DRoiVc(RoiActor roiActor, boolean viewLock) {
        super(roiActor);
        this.setViewLock(viewLock);
        if (roiActor instanceof XpStatisticsRoi) {
            XpStatisticsRoi sr = (XpStatisticsRoi)roiActor;
            sr.setInstanceRoiStatisticsCreator(new Jami3DRoiStatistics.Jami3DRoiStatisticsCreator());
        }
        roiActor.addPropertyChangeListener("ROI_MODEL", this);
    }

    public Xp3DRoiVc(RoiActor roiActor, boolean viewLock, boolean viewInit) {
        this(roiActor, viewLock);
        this.viewInit = viewInit;
    }

    @Override
    public boolean contains(int x2, int y2) {
        if (this.isRoiVisible) {
            return super.contains(x2, y2);
        }
        return false;
    }

    public boolean isRoiVisible() {
        return this.isRoiVisible;
    }

    @Override
    public void setRoiActor(RoiActor roiActor) {
        if (roiActor != null) {
            roiActor.addRoiEventListener(this);
        }
        super.setRoiActor(roiActor);
    }

    public void setViewLock(boolean viewLock) {
        this.viewLock = viewLock;
    }

    public boolean isViewLock() {
        return this.viewLock;
    }

    public boolean isViewChanged() {
        XpSlice slice = this.getSlice();
        Roi3DStatImage rsimg = (Roi3DStatImage)this.getRoiActor().getImage();
        if (rsimg != null) {
            XpSlice refslice = rsimg.getReferenceSlice();
            double dot = refslice.N.dot(slice.N);
            double diff = Math.abs(Math.abs(dot) - 1.0);
            CPoint ref_cp = new CPoint(2);
            CPoint curr_cp = new CPoint(2);
            refslice.getSliceCenter(ref_cp);
            slice.getSliceCenter(curr_cp);
            curr_cp.sub(ref_cp);
            boolean lpInPlane = true;
            if (curr_cp.length() > 1.0E-5) {
                curr_cp.normalize();
                double dotlp = Math.abs(refslice.N.dot(curr_cp));
                if (dotlp > 1.0E-5) {
                    lpInPlane = false;
                }
            }
            return !(diff < PLANE_THRESHOLD) || !lpInPlane;
        }
        return false;
    }

    @Override
    public CTransform getTransform(byte inCoord, byte outCoord) {
        if (inCoord == 1 && outCoord == 0) {
            this.calcImage2Display();
            return this.ct.inverse();
        }
        if (inCoord == 0 && outCoord == 1) {
            this.calcImage2Display();
            return this.ct;
        }
        return super.getTransform(inCoord, outCoord);
    }

    protected XpSlice getSlice() {
        FrameOwner frameOwner = (FrameOwner)((Object)this.getParent());
        XpSlice slice = frameOwner.getFrame().getSlice();
        return slice;
    }

    private void calcImage2Display() {
        Roi3DStatImage rsimg;
        this.ct.loadIdentity();
        if (this.viewInit && (rsimg = (Roi3DStatImage)this.getRoiActor().getImage()) != null) {
            XpSlice refslice = rsimg.getReferenceSlice();
            XpSlice currslice = this.getSlice();
            this.rsImg2Ras.load(refslice.imageToRas);
            this.csRas2Img.load(currslice.rasToImage);
            this.rsImg2Ras.leftMultiply(this.csRas2Img, this.ct);
        }
    }

    public String getInfoLabel() {
        XpStatisticsRoi sr;
        RoiStatistics rs;
        RoiActor ra;
        if (this.dirtyStats && (ra = this.getRoiActor()) instanceof XpStatisticsRoi && (rs = (sr = (XpStatisticsRoi)ra).getRoiStatistics()) != null) {
            XpPixelStatistics ps = rs.getPixelStatistics(sr.getModelShape(), sr.getAngle());
            this.statsInfo = sr.createRoiStatLabel(ps);
            if (this.displayRoiDebug) {
                BufferedImage bitimg = sr.getDisplayBitmap();
                if (this.old_bitimg != bitimg) {
                    if (this.jf != null) {
                        this.jf.setVisible(false);
                        this.jf.dispose();
                    }
                    this.jf = XpImageUtils.displayImage(bitimg);
                    this.old_bitimg = bitimg;
                }
                this.jf.repaint();
            }
            if (this.isViewLock()) {
                this.dirtyStats = false;
            }
        }
        return this.statsInfo;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e2) {
        String pName = e2.getPropertyName();
        if (pName.equals("ROI_MODEL")) {
            this.dirtyStats = true;
        }
        super.propertyChange(e2);
    }

    @Override
    public void roiPressed(XpRoiEvent re) {
    }

    @Override
    public void roiReleased(XpRoiEvent re) {
    }

    @Override
    public void roiDragged(XpRoiEvent re) {
        this.dirtyStats = true;
    }

    @Override
    public void imageChanged(XpRoiEvent re) {
    }

    @Override
    public void paintComponent(Graphics g2) {
        T3DComponent tc = (T3DComponent)this.getParent();
        if (!this.viewInit) {
            Roi3DStatImage rsimg = (Roi3DStatImage)this.getRoiActor().getImage();
            rsimg.syncReferenceSlice();
            this.viewInit = true;
        }
        this.isRoiVisible = false;
        boolean draw = false;
        if (!draw) {
            boolean bl = draw = !this.isViewChanged() || this.initPaint;
        }
        if (draw) {
            super.paintComponent(g2);
            this.isRoiVisible = true;
        }
        this.initPaint = false;
    }

    static {
        PLANE_THRESHOLD = Double.parseDouble(XpPropertiesManager.getProperty("jami.roi.j3d.roi3dvc.plane.threshold", "0.003"));
    }
}

