/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.seg;

import com.ge.med.idc.TaskMonitor;
import com.ge.med.terra.jami.ParallelTaskManager;
import com.ge.med.terra.jami.Worker;
import com.ge.med.terra.jami.seg.BinVolume;
import com.ge.med.terra.jami.seg.SegDefs;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class BinSeg
extends BinVolume
implements SegDefs {
    private static final Logger LOGGER = Logger.getLogger(BinSeg.class.getName());
    public short[] seg_list = null;
    public int[] offlist = null;
    public int[] first_seg = null;
    public int[] last_seg = null;
    public int[] first_offptr = null;
    public int[] last_offptr = null;
    public int[] last_pos = null;
    protected int point_count = -1;
    protected int[] cc_label_map = null;
    protected int[] cc_sizes = null;
    protected int numCC = -1;
    private static final ParallelTaskManager ptm = new ParallelTaskManager();
    private static BinsegCreateWorker[] bcw = null;
    private static final int ZERO_IN = 0;
    private static final int ZERO_OUT = 1;
    private static final int ONE_RUN = 2;
    private static final short L_INFINITY = 16384;

    public BinSeg(Object voldata, int vol_offset, byte[] bingrid, int dx, int dy, int dz) {
        super(voldata, vol_offset, dx, dy, dz);
        this.init(bingrid);
    }

    public BinSeg(Object voldata, int vol_offset, int dx, int dy, int dz) {
        super(voldata, vol_offset, dx, dy, dz);
        this.init();
    }

    public BinSeg(BinSeg src, short[] seg_list) {
        super(src.voldata, src.vol_offset, src.dx, src.dy, src.dz);
        this.seg_list = seg_list;
        this.alloc();
        this.recalc_offlist_hlist();
    }

    public static SegAlgorithm createSegAlgorithm(String className) {
        try {
            Class<?> cl = Class.forName(className);
            Constructor<?> c2 = cl.getConstructor(null);
            SegAlgorithm sa = (SegAlgorithm)c2.newInstance(null);
            return sa;
        }
        catch (ClassNotFoundException e2) {
            e2.printStackTrace();
        }
        catch (SecurityException e3) {
            e3.printStackTrace();
        }
        catch (NoSuchMethodException e4) {
            e4.printStackTrace();
        }
        catch (IllegalArgumentException e5) {
            e5.printStackTrace();
        }
        catch (InstantiationException e6) {
            e6.printStackTrace();
        }
        catch (IllegalAccessException e7) {
            e7.printStackTrace();
        }
        catch (InvocationTargetException e8) {
            e8.printStackTrace();
        }
        return null;
    }

    private void alloc() {
        this.first_seg = new int[this.dy * this.dz];
        this.last_seg = new int[this.dy * this.dz];
        this.first_offptr = new int[this.dy * this.dz];
        this.last_offptr = new int[this.dy * this.dz];
        this.last_pos = new int[this.dy * this.dz];
    }

    private void init() {
        this.seg_list = new short[3 * this.dy * this.dz + this.dz + 1];
        this.alloc();
        int idx = 0;
        for (int z2 = 0; z2 < this.dz; ++z2) {
            for (int y2 = 0; y2 < this.dy; ++y2) {
                this.seg_list[idx++] = 0;
                this.seg_list[idx++] = (short)this.dx;
                this.seg_list[idx++] = -1;
            }
            this.seg_list[idx++] = -2;
        }
        this.seg_list[idx++] = -3;
        this.recalc_offlist_hlist();
    }

    public void recalc_offlist_hlist() {
        this.prepare_offlist();
        this.prepare_hlist();
    }

    public static void execute(Worker[] w2, Object data) {
        ptm.setWorkers(w2);
        ptm.launch(data);
        ptm.setWorkers(null);
    }

    private void init(byte[] bingrid) {
        ptm.setWorkers(bcw);
        BinsegCreateData bcd = new BinsegCreateData(bingrid, this.dx, this.dy, this.dz);
        ptm.launch(bcd);
        int segidx = 0;
        for (int i2 = 0; i2 < bcd.seg_lineCnt.length; ++i2) {
            segidx += bcd.seg_lineCnt[i2];
        }
        this.seg_list = new short[segidx += this.dz + 1];
        int dest_idx = 0;
        for (int z2 = 0; z2 < this.dz; ++z2) {
            int zoffset = z2 * this.dy;
            for (int y2 = 0; y2 < this.dy; ++y2) {
                int idx = zoffset + y2;
                int lineCnt = bcd.seg_lineCnt[idx];
                System.arraycopy(bcd.seg_lines[idx], 0, this.seg_list, dest_idx, lineCnt);
                dest_idx += lineCnt;
            }
            this.seg_list[dest_idx++] = -2;
        }
        this.seg_list[dest_idx++] = -3;
        this.alloc();
        this.prepare_offlist();
        this.prepare_hlist();
        ptm.setWorkers(null);
    }

    private void init2(byte[] bingrid) {
        int PGSIZE = this.dx * this.dy;
        this.seg_list = new short[128 * this.dy * this.dz + this.dz + 1];
        int segidx = 0;
        for (int z2 = 0; z2 < this.dz; ++z2) {
            int zoffset = z2 * PGSIZE;
            for (int y2 = 0; y2 < this.dy; ++y2) {
                int crun = 0;
                int offset = zoffset + y2 * this.dx;
                boolean onerun = false;
                for (int x2 = 0; x2 < this.dx; ++x2) {
                    int idx = offset + x2;
                    int bidx = idx >> 3;
                    int mod = idx & 7;
                    if (onerun) {
                        if ((bingrid[bidx] & 1 << mod) != 0) {
                            ++crun;
                            continue;
                        }
                        this.seg_list[segidx++] = (short)crun;
                        crun = 1;
                        onerun = false;
                        continue;
                    }
                    if ((bingrid[bidx] & 1 << mod) == 0) {
                        ++crun;
                        continue;
                    }
                    this.seg_list[segidx++] = (short)crun;
                    crun = 1;
                    onerun = true;
                }
                if (crun > 0 && onerun) {
                    this.seg_list[segidx++] = (short)crun;
                }
                this.seg_list[segidx++] = -1;
            }
            this.seg_list[segidx++] = -2;
        }
        this.seg_list[segidx++] = -3;
        this.seg_list = BinSeg.resize(this.seg_list, segidx);
        this.alloc();
        this.prepare_offlist();
        this.prepare_hlist();
    }

    private void prepare_offlist() {
        int acount = (this.seg_list.length - this.dz * (1 + this.dy)) / 2;
        this.offlist = new int[acount];
        int olist_idx = 0;
        int seg = 0;
        int off = 0;
        short com = 0;
        while (true) {
            if ((com = this.seg_list[seg++]) >= 0) {
                this.offlist[olist_idx++] = off;
                off += this.seg_list[seg++];
                continue;
            }
            if (com == -3) break;
        }
    }

    private void prepare_hlist() {
        int hlist_idx = 0;
        int seg_idx = 0;
        short com = 0;
        this.point_count = 0;
        int optr = 0;
        int ymin = -1;
        int y2 = 0;
        int z2 = 0;
        while ((com = this.seg_list[seg_idx++]) != -3) {
            if (com == -2) {
                ymin = -1;
                y2 = 0;
                ++z2;
                continue;
            }
            this.first_seg[hlist_idx] = seg_idx - 1;
            this.first_offptr[hlist_idx] = optr;
            int delta = 0;
            if (com >= 0) {
                do {
                    this.point_count += this.seg_list[seg_idx];
                    delta += com;
                    delta += this.seg_list[seg_idx++];
                    ++optr;
                } while ((com = this.seg_list[seg_idx++]) >= 0);
                if (ymin < 0) {
                    ymin = y2;
                }
            }
            if (delta != 0) {
                this.last_seg[hlist_idx] = seg_idx - 2;
                this.last_offptr[hlist_idx] = optr - 1;
                this.last_pos[hlist_idx] = delta - 1;
            } else {
                this.last_seg[hlist_idx] = seg_idx - 1;
                this.last_offptr[hlist_idx] = optr;
                this.last_pos[hlist_idx] = 0;
            }
            ++hlist_idx;
            ++y2;
        }
    }

    public boolean sanityCheck() {
        int lineno = 0;
        int sliceno = 0;
        int nlines = 0;
        for (int i2 = 0; i2 < this.seg_list.length; ++i2) {
            if (lineno == this.dy) {
                if (this.seg_list[i2] != -2) {
                    System.err.println("PROBLEM: No EOI marker at slice=" + sliceno + "  lineno=" + lineno);
                    return false;
                }
                lineno = 0;
            }
            if (this.seg_list[i2] == -1) {
                nlines = ++lineno;
            }
            if (this.seg_list[i2] != -2) continue;
            ++sliceno;
        }
        int badoff = 0;
        for (int z2 = 0; z2 < this.dz; ++z2) {
            int zoffset = z2 * this.dy;
            for (int y2 = 0; y2 < this.dy; ++y2) {
                for (int l2 = this.first_offptr[zoffset + y2]; l2 <= this.last_offptr[zoffset + y2]; ++l2) {
                    if (l2 >= 0 && l2 <= this.offlist.length) continue;
                    ++badoff;
                }
            }
        }
        System.err.println(">>>> BINSEG CHECK: " + badoff + "  lines=" + nlines + "  slices=" + sliceno);
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof BinSeg) {
            return Arrays.equals(((BinSeg)obj).seg_list, this.seg_list);
        }
        return false;
    }

    public BinSeg threshold(int v0, int v1) {
        short[] vol_data = (short[])this.voldata;
        if (this.voldata == null) {
            throw new RuntimeException("Volume data is null within BinSeg object.");
        }
        short[] newseg_list = new short[3 * this.dy * this.dz + (this.dy * this.dz + this.dz + 1)];
        int newseg_idx = 0;
        short[] rle = new short[512];
        int PGSIZE = this.dx * this.dy;
        for (int z2 = 0; z2 < this.dz; ++z2) {
            int ZOFFSET = this.vol_offset + z2 * PGSIZE;
            for (int y2 = 0; y2 < this.dy; ++y2) {
                int OFFSET = ZOFFSET + y2 * this.dx;
                int start = this.first_seg[z2 * this.dy + y2];
                int end = this.last_seg[z2 * this.dy + y2];
                int rleidx = 0;
                int offset = OFFSET;
                short crun = 0;
                int state = 1;
                for (int i2 = start; i2 <= end; ++i2) {
                    short segrun = this.seg_list[i2];
                    if (segrun < 0) continue;
                    switch (state) {
                        case 1: {
                            state = 0;
                            crun = (short)(crun + segrun);
                            break;
                        }
                        default: {
                            block10: for (int x2 = offset; x2 < offset + segrun; ++x2) {
                                switch (state) {
                                    case 0: {
                                        if (vol_data[x2] >= v0 && vol_data[x2] <= v1) {
                                            rle[rleidx++] = crun;
                                            crun = 1;
                                            state = 2;
                                            continue block10;
                                        }
                                        crun = (short)(crun + 1);
                                        continue block10;
                                    }
                                    case 2: {
                                        if (vol_data[x2] >= v0 && vol_data[x2] <= v1) {
                                            crun = (short)(crun + 1);
                                            continue block10;
                                        }
                                        rle[rleidx++] = crun;
                                        crun = 1;
                                        state = 0;
                                    }
                                }
                            }
                            if (state == 2) {
                                rle[rleidx++] = crun;
                                crun = 0;
                            }
                            state = 1;
                        }
                    }
                    offset += segrun;
                }
                if (rleidx + newseg_idx >= newseg_list.length) {
                    short[] temp = newseg_list;
                    newseg_list = new short[(int)(1.5 * (double)temp.length)];
                    System.arraycopy(temp, 0, newseg_list, 0, newseg_idx);
                }
                System.arraycopy(rle, 0, newseg_list, newseg_idx, rleidx);
                newseg_idx += rleidx;
                newseg_list[newseg_idx++] = -1;
            }
            newseg_list[newseg_idx++] = -2;
        }
        newseg_list[newseg_idx++] = -3;
        newseg_list = BinSeg.resize(newseg_list, newseg_idx);
        BinSeg bs = new BinSeg(this, newseg_list);
        return bs;
    }

    public BinSeg selectSegFromMask(short bitMask) {
        short[] vol_data = (short[])this.voldata;
        if (this.voldata == null) {
            throw new RuntimeException("Volume data is null within BinSeg object.");
        }
        short[] newseg_list = new short[3 * this.dy * this.dz + (this.dy * this.dz + this.dz + 1)];
        int newseg_idx = 0;
        short[] rle = new short[512];
        int PGSIZE = this.dx * this.dy;
        for (int z2 = 0; z2 < this.dz; ++z2) {
            int ZOFFSET = this.vol_offset + z2 * PGSIZE;
            for (int y2 = 0; y2 < this.dy; ++y2) {
                int OFFSET = ZOFFSET + y2 * this.dx;
                int start = this.first_seg[z2 * this.dy + y2];
                int end = this.last_seg[z2 * this.dy + y2];
                int rleidx = 0;
                int offset = OFFSET;
                short crun = 0;
                int state = 1;
                for (int i2 = start; i2 <= end; ++i2) {
                    short segrun = this.seg_list[i2];
                    if (segrun < 0) continue;
                    switch (state) {
                        case 1: {
                            state = 0;
                            crun = (short)(crun + segrun);
                            break;
                        }
                        default: {
                            block10: for (int x2 = offset; x2 < offset + segrun; ++x2) {
                                switch (state) {
                                    case 0: {
                                        if ((vol_data[x2] & bitMask) == bitMask) {
                                            rle[rleidx++] = crun;
                                            crun = 1;
                                            state = 2;
                                            continue block10;
                                        }
                                        crun = (short)(crun + 1);
                                        continue block10;
                                    }
                                    case 2: {
                                        if ((vol_data[x2] & bitMask) == bitMask) {
                                            crun = (short)(crun + 1);
                                            continue block10;
                                        }
                                        rle[rleidx++] = crun;
                                        crun = 1;
                                        state = 0;
                                    }
                                }
                            }
                            if (state == 2) {
                                rle[rleidx++] = crun;
                                crun = 0;
                            }
                            state = 1;
                        }
                    }
                    offset += segrun;
                }
                if (rleidx + newseg_idx >= newseg_list.length) {
                    short[] temp = newseg_list;
                    newseg_list = new short[2 * temp.length];
                    System.arraycopy(temp, 0, newseg_list, 0, newseg_idx);
                }
                System.arraycopy(rle, 0, newseg_list, newseg_idx, rleidx);
                newseg_idx += rleidx;
                newseg_list[newseg_idx++] = -1;
            }
            newseg_list[newseg_idx++] = -2;
        }
        newseg_list[newseg_idx++] = -3;
        newseg_list = BinSeg.resize(newseg_list, newseg_idx);
        BinSeg bs = new BinSeg(this, newseg_list);
        return bs;
    }

    public BinSeg not() {
        short[] newseg_list = new short[this.seg_list.length * 3];
        int newsegidx = 0;
        int segidx = 0;
        int sliceno = 0;
        while (this.seg_list[segidx] != -3) {
            int lineno = 0;
            while (this.seg_list[segidx] != -2) {
                short segrun = this.seg_list[segidx];
                if (segrun == -1) {
                    newseg_list[newsegidx++] = 0;
                    newseg_list[newsegidx++] = (short)this.dx;
                    newseg_list[newsegidx++] = -1;
                } else {
                    short com = 0;
                    if (segrun > 0) {
                        newseg_list[newsegidx++] = 0;
                    } else {
                        ++segidx;
                    }
                    short remaining = (short)this.dx;
                    while ((com = this.seg_list[segidx]) >= 0) {
                        newseg_list[newsegidx++] = com;
                        ++segidx;
                        remaining = (short)(remaining - com);
                    }
                    if (remaining > 0) {
                        newseg_list[newsegidx++] = remaining;
                    }
                    int n2 = --newsegidx;
                    ++newsegidx;
                    newseg_list[n2] = -1;
                }
                ++segidx;
                ++lineno;
            }
            newseg_list[newsegidx++] = -2;
            ++segidx;
            ++sliceno;
        }
        newseg_list[newsegidx++] = -3;
        newseg_list = BinSeg.resize(newseg_list, newsegidx);
        BinSeg bs = new BinSeg(this, newseg_list);
        return bs;
    }

    private static void slice_union(short[][] op, short[] out, int[] idx) {
        int x2;
        int x1;
        short[] seg_out = out;
        short[] sega_list = op[0];
        short[] segb_list = op[1];
        int segidx_a = idx[0];
        int segidx_b = idx[1];
        int segidx_out = idx[2];
        block0: while ((x1 = sega_list[segidx_a++]) != -2 && (x2 = segb_list[segidx_b++]) != -2) {
            if (x1 < 0) {
                while (true) {
                    int n2 = segidx_out++;
                    int n3 = --segidx_b;
                    ++segidx_b;
                    seg_out[n2] = segb_list[n3];
                    if (seg_out[n2] < 0) continue block0;
                    seg_out[segidx_out++] = segb_list[segidx_b++];
                }
            }
            if (x2 < 0) {
                while (true) {
                    int n4 = segidx_out++;
                    int n5 = --segidx_a;
                    ++segidx_a;
                    seg_out[n4] = sega_list[n5];
                    if (seg_out[n4] < 0) continue block0;
                    seg_out[segidx_out++] = sega_list[segidx_a++];
                }
            }
            int state = 0;
            int x3 = 0;
            while (true) {
                int com;
                int t2;
                if (x1 < x2) {
                    t2 = x1;
                    if ((com = sega_list[segidx_a++]) >= 0) {
                        x1 += com;
                    } else {
                        if ((state & 2) != 0) {
                            seg_out[segidx_out++] = (short)(x2 - x3);
                        } else {
                            seg_out[segidx_out++] = (short)(t2 - x3);
                            seg_out[segidx_out++] = (short)(x2 - t2);
                            seg_out[segidx_out++] = segb_list[segidx_b++];
                        }
                        while ((seg_out[segidx_out++] = segb_list[segidx_b++]) >= 0) {
                            seg_out[segidx_out++] = segb_list[segidx_b++];
                        }
                        continue block0;
                    }
                    state ^= 1;
                } else if (x1 == x2) {
                    t2 = x1;
                    if ((com = sega_list[segidx_a++]) >= 0) {
                        x1 += com;
                    } else {
                        com = t2 - x3;
                        if ((state & 2) == 0) {
                            com += segb_list[segidx_b++];
                        }
                        seg_out[segidx_out++] = (short)com;
                        while ((seg_out[segidx_out++] = segb_list[segidx_b++]) >= 0) {
                            seg_out[segidx_out++] = segb_list[segidx_b++];
                        }
                        continue block0;
                    }
                    com = segb_list[segidx_b++];
                    if (com >= 0) {
                        x2 += com;
                    } else {
                        if ((state & 1) != 0) {
                            x1 = t2;
                        }
                        seg_out[segidx_out++] = (short)(x1 - x3);
                        while (true) {
                            int n6 = segidx_out++;
                            int n7 = --segidx_a;
                            ++segidx_a;
                            seg_out[n6] = sega_list[n7];
                            if (seg_out[n6] < 0) continue block0;
                            seg_out[segidx_out++] = sega_list[segidx_a++];
                        }
                    }
                    state ^= 3;
                } else {
                    t2 = x2;
                    if ((com = segb_list[segidx_b++]) >= 0) {
                        x2 += com;
                    } else {
                        if ((state & 1) != 0) {
                            seg_out[segidx_out++] = (short)(x1 - x3);
                        } else {
                            seg_out[segidx_out++] = (short)(t2 - x3);
                            seg_out[segidx_out++] = (short)(x1 - t2);
                            seg_out[segidx_out++] = sega_list[segidx_a++];
                        }
                        while ((seg_out[segidx_out++] = sega_list[segidx_a++]) >= 0) {
                            seg_out[segidx_out++] = sega_list[segidx_a++];
                        }
                        continue block0;
                    }
                    state ^= 2;
                }
                if (state == 0 || state >= 5) continue;
                seg_out[segidx_out++] = (short)(t2 - x3);
                x3 = t2;
                state ^= 4;
            }
        }
        seg_out[segidx_out++] = -2;
        idx[0] = segidx_a;
        idx[1] = ++segidx_b;
        idx[2] = segidx_out;
    }

    private static int union(short[] sega_list, short[] segb_list, short[] seg_out) {
        short[][] ops = new short[][]{sega_list, segb_list};
        int[] idx = new int[3];
        int segidx_a = 0;
        int segidx_b = 0;
        int segidx_out = 0;
        do {
            BinSeg.slice_union(ops, seg_out, idx);
            segidx_a = idx[0];
            segidx_b = idx[1];
            segidx_out = idx[2];
        } while (sega_list[segidx_a] != -3 && segb_list[segidx_b] != -3);
        seg_out[segidx_out++] = -3;
        return segidx_out;
    }

    public BinSeg union(BinSeg op) {
        short[] seg_out = new short[Math.max(this.seg_list.length, op.seg_list.length) * 2];
        short[] sega_list = this.seg_list;
        short[] segb_list = op.seg_list;
        int segidx_out = BinSeg.union(sega_list, segb_list, seg_out);
        seg_out = BinSeg.resize(seg_out, segidx_out);
        BinSeg bs = new BinSeg(this, seg_out);
        return bs;
    }

    private static void slice_intersection(short[][] op, short[] out, int[] idx) {
        int x2;
        int x1;
        short[] seg_out = out;
        short[] sega_list = op[0];
        short[] segb_list = op[1];
        int segidx_a = idx[0];
        int segidx_b = idx[1];
        int segidx_out = idx[2];
        while ((x1 = sega_list[segidx_a++]) != -2 && (x2 = segb_list[segidx_b++]) != -2) {
            if (x1 < 0) {
                while (true) {
                    int n2 = --segidx_b;
                    ++segidx_b;
                    if (segb_list[n2] < 0) break;
                    ++segidx_b;
                }
                seg_out[segidx_out++] = -1;
                continue;
            }
            if (x2 < 0) {
                while (true) {
                    int n3 = --segidx_a;
                    ++segidx_a;
                    if (sega_list[n3] < 0) break;
                    ++segidx_a;
                }
                seg_out[segidx_out++] = -1;
                continue;
            }
            int state = 0;
            int x3 = 0;
            block3: while (true) {
                short com;
                int t2;
                if (x1 < x2) {
                    t2 = x1;
                    if ((com = sega_list[segidx_a++]) >= 0) {
                        x1 += com;
                    } else {
                        if ((state & 4) != 0) {
                            seg_out[segidx_out++] = (short)(t2 - x3);
                        }
                        while (true) {
                            int n4 = ++segidx_b;
                            ++segidx_b;
                            if (segb_list[n4] < 0) break block3;
                            ++segidx_b;
                        }
                    }
                    state ^= 1;
                } else if (x1 == x2) {
                    t2 = x1;
                    if ((com = sega_list[segidx_a++]) >= 0) {
                        x1 += com;
                    } else {
                        if ((state & 4) != 0) {
                            seg_out[segidx_out++] = (short)(t2 - x3);
                        }
                        while (true) {
                            int n5 = ++segidx_b;
                            ++segidx_b;
                            if (segb_list[n5] < 0) break block3;
                            ++segidx_b;
                        }
                    }
                    com = segb_list[segidx_b++];
                    if (com >= 0) {
                        x2 += com;
                    } else {
                        if ((state & 4) != 0) {
                            seg_out[segidx_out++] = (short)(t2 - x3);
                        }
                        while (true) {
                            int n6 = ++segidx_a;
                            ++segidx_a;
                            if (sega_list[n6] < 0) break block3;
                            ++segidx_a;
                        }
                    }
                    state ^= 3;
                } else {
                    t2 = x2;
                    if ((com = segb_list[segidx_b++]) >= 0) {
                        x2 += com;
                    } else {
                        if ((state & 4) != 0) {
                            seg_out[segidx_out++] = (short)(t2 - x3);
                        }
                        while (true) {
                            int n7 = ++segidx_a;
                            ++segidx_a;
                            if (sega_list[n7] < 0) break block3;
                            ++segidx_a;
                        }
                    }
                    state ^= 2;
                }
                if (state <= 2 || state >= 7) continue;
                seg_out[segidx_out++] = (short)(t2 - x3);
                x3 = t2;
                state ^= 4;
            }
            seg_out[segidx_out++] = -1;
        }
        seg_out[segidx_out++] = -2;
        idx[0] = segidx_a;
        idx[1] = ++segidx_b;
        idx[2] = segidx_out;
    }

    private static int intersection(short[] sega_list, short[] segb_list, short[] seg_out) {
        short[][] ops = new short[][]{sega_list, segb_list};
        int[] idx = new int[3];
        int segidx_a = 0;
        int segidx_b = 0;
        int segidx_out = 0;
        do {
            BinSeg.slice_intersection(ops, seg_out, idx);
            segidx_a = idx[0];
            segidx_b = idx[1];
            segidx_out = idx[2];
        } while (sega_list[segidx_a] != -3 && segb_list[segidx_b] != -3);
        seg_out[segidx_out++] = -3;
        return segidx_out;
    }

    public BinSeg intersection(BinSeg op) {
        short[] seg_out = new short[this.seg_list.length * 4];
        short[] sega_list = this.seg_list;
        short[] segb_list = op.seg_list;
        int segidx_out = BinSeg.intersection(sega_list, segb_list, seg_out);
        seg_out = BinSeg.resize(seg_out, segidx_out);
        BinSeg bs = new BinSeg(this, seg_out);
        return bs;
    }

    public BinSeg diff(BinSeg op) {
        short[] seg_out = new short[this.seg_list.length * 4];
        short[] sega_list = this.seg_list;
        short[] segb_list = op.seg_list;
        int segidx_a = 0;
        int segidx_b = 0;
        int segidx_out = 0;
        block0: while (true) {
            int x2;
            int x1;
            if ((x1 = sega_list[segidx_a++]) != -2 && (x2 = segb_list[segidx_b++]) != -2) {
                int t2;
                if (x1 < 0) {
                    while (true) {
                        int n2 = --segidx_b;
                        ++segidx_b;
                        if (segb_list[n2] < 0) break;
                        ++segidx_b;
                    }
                    seg_out[segidx_out++] = -1;
                    continue;
                }
                if (x2 < 0) {
                    while (true) {
                        int n3 = segidx_out++;
                        int n4 = --segidx_a;
                        ++segidx_a;
                        seg_out[n3] = sega_list[n4];
                        if (seg_out[n3] < 0) continue block0;
                        seg_out[segidx_out++] = sega_list[segidx_a++];
                    }
                }
                short com1 = sega_list[segidx_a++];
                short com2 = segb_list[segidx_b++];
                int state = 0;
                int x3 = 0;
                while ((t2 = x1 < x2 ? x1 : x2) != 16384) {
                    if (t2 == x1) {
                        if (com1 >= 0) {
                            x1 += com1;
                            com1 = sega_list[segidx_a++];
                        } else {
                            x1 = 16384;
                        }
                        state ^= 1;
                    }
                    if (t2 == x2) {
                        if (com2 >= 0) {
                            x2 += com2;
                            com2 = segb_list[segidx_b++];
                        } else {
                            x2 = 16384;
                        }
                        state ^= 2;
                    }
                    if (state != 1 && state != 4 && state <= 5) continue;
                    seg_out[segidx_out++] = (short)(t2 - x3);
                    x3 = t2;
                    state ^= 4;
                }
                seg_out[segidx_out++] = -1;
                continue;
            }
            seg_out[segidx_out++] = -2;
            if (sega_list[segidx_a] == -3 || segb_list[++segidx_b] == -3) break;
        }
        seg_out[segidx_out++] = -3;
        seg_out = BinSeg.resize(seg_out, segidx_out);
        BinSeg bs = new BinSeg(this, seg_out);
        return bs;
    }

    public BinSeg delta(BinSeg op) {
        short[] seg_out = new short[this.seg_list.length * 4];
        short[] sega_list = this.seg_list;
        short[] segb_list = op.seg_list;
        int segidx_a = 0;
        int segidx_b = 0;
        int segidx_out = 0;
        block0: while (true) {
            int x2;
            int x1;
            if ((x1 = sega_list[segidx_a++]) != -2 && (x2 = segb_list[segidx_b++]) != -2) {
                int t2;
                if (x1 < 0) {
                    while (true) {
                        int n2 = segidx_out++;
                        int n3 = --segidx_b;
                        ++segidx_b;
                        seg_out[n2] = segb_list[n3];
                        if (seg_out[n2] < 0) continue block0;
                        seg_out[segidx_out++] = segb_list[segidx_b++];
                    }
                }
                if (x2 < 0) {
                    while (true) {
                        int n4 = segidx_out++;
                        int n5 = --segidx_a;
                        ++segidx_a;
                        seg_out[n4] = sega_list[n5];
                        if (seg_out[n4] < 0) continue block0;
                        seg_out[segidx_out++] = sega_list[segidx_a++];
                    }
                }
                short com1 = sega_list[segidx_a++];
                short com2 = segb_list[segidx_b++];
                int s3 = 0;
                int s2 = 0;
                int s1 = 0;
                int x3 = 0;
                while ((t2 = x1 < x2 ? x1 : x2) != 16384) {
                    if (t2 == x1) {
                        if (com1 >= 0) {
                            x1 += com1;
                            com1 = sega_list[segidx_a++];
                        } else {
                            x1 = 16384;
                        }
                        s1 ^= 1;
                    }
                    if (t2 == x2) {
                        if (com2 >= 0) {
                            x2 += com2;
                            com2 = segb_list[segidx_b++];
                        } else {
                            x2 = 16384;
                        }
                        s2 ^= 1;
                    }
                    if (!(s1 ^ s2 ^ s3) && !(s1 & s2 & s3)) continue;
                    seg_out[segidx_out++] = (short)(t2 - x3);
                    x3 = t2;
                    s3 ^= 1;
                }
                seg_out[segidx_out++] = -1;
                continue;
            }
            seg_out[segidx_out++] = -2;
            if (sega_list[segidx_a] == -3 || segb_list[++segidx_b] == -3) break;
        }
        seg_out[segidx_out++] = -3;
        seg_out = BinSeg.resize(seg_out, segidx_out);
        BinSeg bs = new BinSeg(this, seg_out);
        return bs;
    }

    private static int erode_x(short[] seg_list, short[] seg_out) {
        int segidx = 0;
        int segidx_out = 0;
        boolean size = true;
        int size2 = 2;
        do {
            short com = 0;
            while ((com = seg_list[segidx++]) != -2) {
                if (com >= 0) {
                    short length = 0;
                    do {
                        length = (short)(length + com);
                        if ((com = seg_list[segidx++]) <= 2) {
                            length = (short)(length + com);
                            continue;
                        }
                        seg_out[segidx_out++] = (short)(length + 1);
                        seg_out[segidx_out++] = (short)(com - 2);
                        length = 1;
                    } while ((com = seg_list[segidx++]) >= 0);
                }
                seg_out[segidx_out++] = -1;
            }
            seg_out[segidx_out++] = -2;
        } while (seg_list[segidx] != -3);
        seg_out[segidx_out++] = -3;
        return segidx_out;
    }

    private static int dilate_x(short[] seg_list, short[] seg_out) {
        int segidx = 0;
        int segidx_out = 0;
        boolean size = true;
        int size2 = 2;
        do {
            short com = 0;
            short l2 = 0;
            while ((com = seg_list[segidx++]) != -2) {
                if (com >= 0) {
                    if (com >= 1) {
                        seg_out[segidx_out++] = (short)(com - 1);
                        l2 = 1;
                    } else {
                        seg_out[segidx_out++] = 0;
                        l2 = com;
                    }
                    l2 = (short)(l2 + (seg_list[segidx++] + 1));
                    while ((com = seg_list[segidx++]) >= 0) {
                        if (com > 2) {
                            seg_out[segidx_out++] = l2;
                            seg_out[segidx_out++] = (short)(com - 2);
                            l2 = (short)(2 + seg_list[segidx++]);
                            continue;
                        }
                        l2 = (short)(l2 + (com + seg_list[segidx++]));
                    }
                    seg_out[segidx_out++] = l2;
                }
                seg_out[segidx_out++] = -1;
            }
            seg_out[segidx_out++] = -2;
        } while (seg_list[segidx] != -3);
        seg_out[segidx_out++] = -3;
        return segidx_out;
    }

    public BinSeg erode_x() {
        short[] seg_out = new short[this.seg_list.length * 2];
        int segidx_out = BinSeg.erode_x(this.seg_list, seg_out);
        seg_out = BinSeg.resize(seg_out, segidx_out);
        BinSeg bs = new BinSeg(this, seg_out);
        return bs;
    }

    public BinSeg dilate_x() {
        short[] seg_out = new short[this.seg_list.length * 2];
        int segidx_out = BinSeg.dilate_x(this.seg_list, seg_out);
        seg_out = BinSeg.resize(seg_out, segidx_out);
        BinSeg bs = new BinSeg(this, seg_out);
        return bs;
    }

    private int shiftYZ(int ydelta, int zdelta, short[] segout) {
        int segidx_out = 0;
        for (int z2 = 0; z2 < this.dz; ++z2) {
            int zsrc = z2 + zdelta;
            for (int y2 = 0; y2 < this.dy; ++y2) {
                int ysrc = y2 + ydelta;
                if (zsrc >= 0 && zsrc < this.dz && ysrc >= 0 && ysrc < this.dy) {
                    int fidx = this.first_seg[zsrc * this.dy + ysrc];
                    int lidx = this.last_seg[zsrc * this.dy + ysrc];
                    int len = lidx - fidx + 1;
                    try {
                        len = len == 1 ? 0 : len;
                        System.arraycopy(this.seg_list, fidx, segout, segidx_out, len);
                    }
                    catch (RuntimeException e2) {
                        System.err.println("** fidx=" + fidx + "  lidx=" + lidx + "  len=" + len);
                    }
                    segidx_out += len;
                }
                segout[segidx_out++] = -1;
            }
            segout[segidx_out++] = -2;
        }
        segout[segidx_out++] = -3;
        return segidx_out;
    }

    public BinSeg dilate() {
        short[] shifted_seg = new short[this.seg_list.length * 2];
        short[] temp1 = new short[this.seg_list.length * 2];
        short[] temp2 = new short[this.seg_list.length * 2];
        short[] seg_out = null;
        int segidx_out = 0;
        segidx_out = BinSeg.dilate_x(this.seg_list, temp1);
        for (int z2 = -1; z2 <= 1; ++z2) {
            for (int y2 = -1; y2 <= 1; ++y2) {
                if (y2 == 0 && z2 == 0 || y2 != 0 && z2 != 0) continue;
                this.shiftYZ(y2, z2, shifted_seg);
                segidx_out = BinSeg.union(shifted_seg, temp1, temp2);
                seg_out = temp2;
                temp2 = temp1;
                temp1 = seg_out;
            }
        }
        seg_out = BinSeg.resize(seg_out, segidx_out);
        segidx_out = 0;
        while (seg_out[segidx_out] != -3) {
            while (seg_out[segidx_out] != -2) {
                int lineLength = 0;
                while (seg_out[segidx_out] != -1) {
                    lineLength += seg_out[segidx_out++];
                    lineLength += seg_out[segidx_out++];
                }
                if (lineLength > this.dx) {
                    int n2 = segidx_out - 1;
                    seg_out[n2] = (short)(seg_out[n2] - (lineLength - this.dx));
                }
                ++segidx_out;
            }
            ++segidx_out;
        }
        BinSeg result = new BinSeg(this, seg_out);
        return result;
    }

    public BinSeg dilate2D_4connected() {
        short[] shifted_seg = new short[this.seg_list.length * 2];
        short[] temp1 = new short[this.seg_list.length * 2];
        short[] temp2 = new short[this.seg_list.length * 2];
        short[] seg_out = null;
        int segidx_out = 0;
        segidx_out = BinSeg.dilate_x(this.seg_list, temp1);
        int z2 = 0;
        for (int y2 = -1; y2 <= 1; ++y2) {
            if (y2 == 0 && z2 == 0 || y2 != 0 && z2 != 0) continue;
            this.shiftYZ(y2, z2, shifted_seg);
            segidx_out = BinSeg.union(shifted_seg, temp1, temp2);
            seg_out = temp2;
            temp2 = temp1;
            temp1 = seg_out;
        }
        seg_out = BinSeg.resize(seg_out, segidx_out);
        segidx_out = 0;
        while (seg_out[segidx_out] != -3) {
            while (seg_out[segidx_out] != -2) {
                int lineLength = 0;
                while (seg_out[segidx_out] != -1) {
                    lineLength += seg_out[segidx_out++];
                    lineLength += seg_out[segidx_out++];
                }
                if (lineLength > this.dx) {
                    int n2 = segidx_out - 1;
                    seg_out[n2] = (short)(seg_out[n2] - (lineLength - this.dx));
                }
                ++segidx_out;
            }
            ++segidx_out;
        }
        BinSeg result = new BinSeg(this, seg_out);
        return result;
    }

    public BinSeg dilate2D_8connected() {
        short[] shifted_seg = new short[this.seg_list.length * 2];
        short[] temp1 = new short[this.seg_list.length * 2];
        short[] temp2 = new short[this.seg_list.length * 2];
        short[] temp3 = null;
        short[] seg_out = new short[this.seg_list.length * 2];
        int segidx_out = 0;
        System.arraycopy(this.seg_list, 0, temp1, 0, this.seg_list.length);
        int z2 = 0;
        for (int y2 = -1; y2 <= 1; ++y2) {
            if (y2 == 0 && z2 == 0 || y2 != 0 && z2 != 0) continue;
            this.shiftYZ(y2, z2, shifted_seg);
            segidx_out = BinSeg.union(shifted_seg, temp1, temp2);
            temp3 = temp2;
            temp2 = temp1;
            temp1 = temp3;
        }
        segidx_out = BinSeg.dilate_x(temp1, seg_out);
        seg_out = BinSeg.resize(seg_out, segidx_out);
        segidx_out = 0;
        while (seg_out[segidx_out] != -3) {
            while (seg_out[segidx_out] != -2) {
                int lineLength = 0;
                while (seg_out[segidx_out] != -1) {
                    lineLength += seg_out[segidx_out++];
                    lineLength += seg_out[segidx_out++];
                }
                if (lineLength > this.dx) {
                    int n2 = segidx_out - 1;
                    seg_out[n2] = (short)(seg_out[n2] - (lineLength - this.dx));
                }
                ++segidx_out;
            }
            ++segidx_out;
        }
        BinSeg result = new BinSeg(this, seg_out);
        return result;
    }

    public BinSeg dilateN(int numSteps) {
        BinSeg dilated = this;
        for (int i2 = 0; i2 < numSteps; ++i2) {
            dilated = dilated.dilate();
        }
        return dilated;
    }

    public BinSeg erode() {
        short[] temp0 = new short[this.seg_list.length * 2];
        short[] temp1 = new short[this.seg_list.length * 2];
        short[] seg_out = new short[this.seg_list.length * 2];
        int segidx_out = 0;
        System.arraycopy(this.seg_list, 0, temp1, 0, this.seg_list.length);
        for (int z2 = -1; z2 <= 1; ++z2) {
            for (int y2 = -1; y2 <= 1; ++y2) {
                if (y2 == 0 && z2 == 0) continue;
                int segidx_shft = this.shiftYZ(y2, z2, temp0);
                segidx_out = BinSeg.intersection(temp0, temp1, seg_out);
                System.arraycopy(seg_out, 0, temp1, 0, segidx_out + 1);
            }
        }
        segidx_out = BinSeg.erode_x(temp1, seg_out);
        seg_out = BinSeg.resize(seg_out, segidx_out);
        BinSeg result = new BinSeg(this, seg_out);
        return result;
    }

    public BinSeg erode2D() {
        short[] temp0 = new short[this.seg_list.length * 2];
        short[] temp1 = new short[this.seg_list.length * 2];
        short[] seg_out = new short[this.seg_list.length * 2];
        int segidx_out = 0;
        System.arraycopy(this.seg_list, 0, temp1, 0, this.seg_list.length);
        int z2 = 0;
        for (int y2 = -1; y2 <= 1; ++y2) {
            if (y2 == 0 && z2 == 0) continue;
            this.shiftYZ(y2, z2, temp0);
            segidx_out = BinSeg.intersection(temp0, temp1, seg_out);
            System.arraycopy(seg_out, 0, temp1, 0, segidx_out + 1);
        }
        segidx_out = BinSeg.erode_x(temp1, seg_out);
        seg_out = BinSeg.resize(seg_out, segidx_out);
        BinSeg result = new BinSeg(this, seg_out);
        return result;
    }

    public BinSeg erodeN(int numSteps) {
        BinSeg eroded = this;
        for (int i2 = 0; i2 < numSteps; ++i2) {
            eroded = eroded.erode();
        }
        return eroded;
    }

    public void uncompress(byte[] bingrid) {
        Arrays.fill(bingrid, (byte)-1);
        this.and(bingrid);
    }

    public void convertToImageVolume(short[] imageVol, int volOffset, short inValue, short outValue) {
        Arrays.fill(imageVol, volOffset, volOffset + this.dx * this.dy * this.dz, outValue);
        int com = -1;
        int segIndex = 0;
        int dxy = this.dx * this.dy;
        int x2 = 0;
        int y2 = 0;
        int z2 = 0;
        while (this.seg_list[segIndex] != -3) {
            y2 = 0;
            while (this.seg_list[segIndex] != -2) {
                boolean in = false;
                x2 = 0;
                while ((com = this.seg_list[segIndex++]) != -1) {
                    if (in) {
                        int outIndex = volOffset + z2 * dxy + y2 * this.dx + x2;
                        Arrays.fill(imageVol, outIndex, outIndex + com, inValue);
                    }
                    x2 += com;
                    in = !in;
                }
                ++y2;
            }
            ++z2;
            ++segIndex;
        }
    }

    public int getNumberOfPoints() {
        return this.point_count;
    }

    @Override
    public boolean getBoundingBox(int[] bbox_origin, int[] bbox_dims) {
        int min_x = this.dx;
        int min_y = this.dy;
        int min_z = this.dz;
        int max_x = 0;
        int max_y = 0;
        int max_z = 0;
        boolean empty = true;
        for (int z2 = 0; z2 < this.dz; ++z2) {
            for (int y2 = 0; y2 < this.dy; ++y2) {
                int start = this.first_seg[z2 * this.dy + y2];
                int x2 = this.seg_list[start];
                if (x2 < 0) continue;
                if (x2 < min_x) {
                    min_x = x2;
                }
                if (y2 < min_y) {
                    min_y = y2;
                }
                if (z2 < min_z) {
                    min_z = z2;
                }
                if (x2 > max_x) {
                    max_x = x2;
                }
                if (y2 > max_y) {
                    max_y = y2;
                }
                if (z2 > max_z) {
                    max_z = z2;
                }
                empty = false;
            }
        }
        if (!empty) {
            bbox_origin[0] = min_x;
            bbox_origin[1] = min_y;
            bbox_origin[2] = min_z;
            bbox_dims[0] = max_x - min_x + 1;
            bbox_dims[1] = max_y - min_y + 1;
            bbox_dims[2] = max_z - min_z + 1;
        }
        return !empty;
    }

    public void and(byte[] bingrid) {
        int list_in_idx = 0;
        int bitlen = 0;
        int czerorun = 0;
        short[] list_in = this.seg_list;
        int zeroed = 0;
        do {
            short com;
            boolean zero = true;
            while ((com = list_in[list_in_idx++]) != -2) {
                if (com >= 0) {
                    short length = 0;
                    zero = true;
                    do {
                        if (zero) {
                            czerorun += com;
                        } else {
                            int startIdx = bitlen - czerorun;
                            if (czerorun > 0) {
                                this.fillZeroes(bingrid, startIdx, czerorun);
                            }
                            zeroed += czerorun;
                            czerorun = 0;
                        }
                        length = (short)(length + com);
                        bitlen += com;
                        boolean bl = zero = !zero;
                    } while ((com = list_in[list_in_idx++]) >= 0);
                    int rem = this.dx - length;
                    bitlen += rem;
                    if (!zero) continue;
                    czerorun += rem;
                    continue;
                }
                bitlen += this.dx;
                czerorun += this.dx;
            }
        } while (list_in[list_in_idx] != -3);
        if (czerorun > 0) {
            this.fillZeroes(bingrid, bitlen - czerorun, czerorun);
        }
        zeroed += czerorun;
    }

    private void fillZeroes(byte[] bingrid, int startIdx, int zbits) {
        int rembits;
        int czerorun = zbits;
        int idx = startIdx >> 3;
        int nbits = startIdx % 8;
        if (nbits > 0) {
            int andmask = ~(255 << nbits);
            if (czerorun < 8) {
                int run = (1 << czerorun) - 1;
                andmask = ~(run << nbits);
            }
            byte val = bingrid[idx];
            bingrid[idx] = (byte)(val & andmask);
            ++idx;
            czerorun -= 8 - nbits;
        }
        if (czerorun <= 0) {
            return;
        }
        int nbytes = czerorun >> 3;
        if (nbytes > 0) {
            int toIndex = idx + nbytes;
            Arrays.fill(bingrid, idx, toIndex, (byte)0);
            idx += nbytes;
        }
        if ((rembits = czerorun % 8) > 0) {
            byte val = bingrid[idx];
            bingrid[idx] = (byte)(val & 255 << rembits);
        }
    }

    private static short[] resize(short[] l2, int newlen) {
        if (l2.length != newlen) {
            short[] temp = l2;
            l2 = new short[newlen];
            System.arraycopy(temp, 0, l2, 0, newlen);
        }
        return l2;
    }

    public boolean getSegValue(int x2, int y2, int z2) {
        int startIdx;
        int lineIdx = startIdx = this.first_seg[z2 * this.dy + y2];
        int rowIdx = 0;
        while (this.seg_list[lineIdx] != -1) {
            if (x2 < (rowIdx += this.seg_list[lineIdx++])) {
                return false;
            }
            if (x2 >= (rowIdx += this.seg_list[lineIdx++])) continue;
            return true;
        }
        return false;
    }

    public int getSegIndex(int x2, int y2, int z2) {
        int startIdx;
        int lineIdx = startIdx = this.first_seg[z2 * this.dy + y2];
        int rowIdx = 0;
        while (this.seg_list[lineIdx] != -1) {
            if (x2 < (rowIdx += this.seg_list[lineIdx++])) {
                return -1;
            }
            if (x2 >= (rowIdx += this.seg_list[lineIdx++])) continue;
            return lineIdx - 1;
        }
        return -1;
    }

    public int getNumConnectedComponents() {
        if (this.cc_label_map == null) {
            this.labelConnectedComponents();
        }
        return this.numCC;
    }

    public int getConnectedComponentSize(int ccIdx) {
        if (this.cc_label_map == null) {
            this.labelConnectedComponents();
        }
        return this.cc_sizes[ccIdx];
    }

    public int[] getConnectedComponentSizes() {
        if (this.cc_label_map == null) {
            this.labelConnectedComponents();
        }
        int[] sizes = new int[this.cc_sizes.length];
        System.arraycopy(this.cc_sizes, 0, sizes, 0, this.cc_sizes.length);
        return sizes;
    }

    public int[] getConnectedLabels() {
        if (this.cc_label_map == null) {
            this.labelConnectedComponents();
        }
        int[] label_map = new int[this.cc_label_map.length];
        System.arraycopy(this.cc_label_map, 0, label_map, 0, this.cc_label_map.length);
        return label_map;
    }

    public BinSeg selectConnectedComponents(boolean[] selection) {
        short com;
        if (this.cc_label_map == null) {
            this.labelConnectedComponents();
        }
        if (selection.length != this.numCC) {
            return null;
        }
        int new_seg_count = this.numSegmentsInSelectedConnectedComponents(selection);
        if (new_seg_count == 0) {
            String msg = "No segments found in connected components given by selection indices: [";
            for (int i2 = 0; i2 < selection.length; ++i2) {
                if (!selection[i2]) continue;
                msg = msg + " " + i2;
            }
            msg = msg + " ].";
            LOGGER.warning(msg);
            BinSeg fullSeg = new BinSeg(this.voldata, this.vol_offset, this.dx, this.dy, this.dz);
            BinSeg emptySeg = fullSeg.not();
            return emptySeg;
        }
        short[] seg_out = new short[new_seg_count];
        int cseg_in_idx = 0;
        int cseg_out_idx = 0;
        while ((com = this.seg_list[cseg_in_idx++]) != -3) {
            int n2;
            if (com < 0) {
                seg_out[cseg_out_idx++] = com;
                continue;
            }
            short length = 0;
            do {
                length = (short)(length + com);
                com = this.seg_list[cseg_in_idx];
                if (selection[this.cc_label_map[cseg_in_idx / 2] - 1]) {
                    seg_out[cseg_out_idx++] = length;
                    seg_out[cseg_out_idx++] = com;
                    length = 0;
                } else {
                    length = (short)(length + com);
                }
                n2 = ++cseg_in_idx;
                ++cseg_in_idx;
            } while ((com = this.seg_list[n2]) >= 0);
            seg_out[cseg_out_idx++] = -1;
        }
        seg_out[cseg_out_idx++] = -3;
        BinSeg selected = new BinSeg(this, seg_out);
        return selected;
    }

    public BinSeg selectConnectedComponent(int x2, int y2, int z2) {
        int cseg_in_idx;
        if (this.cc_label_map == null) {
            this.labelConnectedComponents();
        }
        if ((cseg_in_idx = this.getSegIndex(x2, y2, z2)) == -1) {
            return null;
        }
        int ccIndex = this.cc_label_map[cseg_in_idx / 2];
        boolean[] selection = new boolean[this.getNumConnectedComponents()];
        selection[ccIndex - 1] = true;
        return this.selectConnectedComponents(selection);
    }

    protected synchronized int labelConnectedComponents() {
        int label;
        int com;
        int[] llist = null;
        int[] slist = null;
        int[] elist = null;
        int segIdx = -1;
        int nlineIdx = -1;
        int ylineIdx = -1;
        int zlineIdx = -1;
        int start_of_lineIdx = -1;
        if (this.cc_label_map != null) {
            return -1;
        }
        this.cc_label_map = null;
        this.cc_sizes = null;
        this.numCC = 0;
        llist = new int[this.seg_list.length / 2];
        elist = new int[this.seg_list.length / 2];
        segIdx = 0;
        int cur_label = 0;
        while ((com = this.seg_list[segIdx++]) != -3) {
            start_of_lineIdx = segIdx - 1;
            if (com >= 0) {
                int x1 = 0;
                do {
                    int nlabel;
                    int tmp;
                    elist[label] = label = ++cur_label;
                    if (com == 0 && x1 > 0) {
                        tmp = llist[(segIdx - 2) / 2];
                        while (elist[tmp] != tmp) {
                            tmp = elist[tmp];
                        }
                        elist[label] = elist[tmp] = (nlabel = tmp < label ? tmp : label);
                        label = nlabel;
                    }
                    int x0 = x1 + com;
                    x1 = x0 + this.seg_list[segIdx++];
                    for (int i2 = 0; i2 < 2; ++i2) {
                        int x0n;
                        int n2 = nlineIdx = i2 != 0 ? zlineIdx : ylineIdx;
                        if (nlineIdx == -1) continue;
                        int x1n = 0;
                        while ((com = this.seg_list[nlineIdx++]) != -1 && (x0n = x1n + com) < x1) {
                            if ((x1n = x0n + this.seg_list[nlineIdx++]) <= x0) continue;
                            tmp = llist[(nlineIdx - 1) / 2];
                            while (elist[tmp] != tmp) {
                                tmp = elist[tmp];
                            }
                            elist[label] = elist[tmp] = (nlabel = tmp < label ? tmp : label);
                            label = nlabel;
                        }
                    }
                    llist[(segIdx - 1) / 2] = label;
                    if (label == cur_label) continue;
                    --cur_label;
                } while ((com = this.seg_list[segIdx++]) >= 0);
            }
            ylineIdx = start_of_lineIdx;
            if (zlineIdx != -1) {
                while (this.seg_list[zlineIdx++] >= 0) {
                    ++zlineIdx;
                }
            }
            if (this.seg_list[segIdx - 1] != -2) continue;
            ylineIdx = -1;
            if (zlineIdx != -1) continue;
            zlineIdx = 0;
        }
        ++cur_label;
        label = 0;
        for (com = 1; com < cur_label; ++com) {
            elist[com] = elist[com] == com ? ++label : elist[elist[com]];
        }
        this.numCC = label;
        slist = new int[label + 1];
        segIdx = 0;
        while (true) {
            if ((com = this.seg_list[segIdx++]) < 0) {
                if (com != -3) continue;
                break;
            }
            com = this.seg_list[segIdx];
            label = llist[segIdx / 2];
            llist[segIdx / 2] = label = elist[label];
            int n3 = label;
            slist[n3] = slist[n3] + com;
            ++segIdx;
        }
        this.cc_label_map = llist;
        this.cc_sizes = slist;
        return 0;
    }

    protected int numSegmentsInSelectedConnectedComponents(boolean[] selection) {
        int segIdx = 0;
        int ncount = 0;
        while (true) {
            short com;
            if ((com = this.seg_list[segIdx++]) < 0) {
                if (com != -3) continue;
                break;
            }
            com = this.seg_list[segIdx];
            if (selection[this.cc_label_map[segIdx / 2] - 1]) {
                ++ncount;
            }
            ++segIdx;
        }
        if (ncount == 0) {
            return ncount;
        }
        ncount *= 2;
        ncount += this.dy * this.dz;
        ncount += this.dz;
        return ++ncount;
    }

    public void clearConnectComponentsCache() {
        this.cc_label_map = null;
        this.cc_sizes = null;
        this.numCC = -1;
    }

    public BinSeg vol_vfilter(int min_size) {
        int lcount = this.getNumConnectedComponents();
        boolean[] selection = new boolean[lcount];
        int scount = 0;
        for (int i2 = 0; i2 < lcount; ++i2) {
            if (this.cc_sizes[i2 + 1] < min_size) continue;
            selection[i2] = true;
            ++scount;
        }
        if (scount == 0) {
            return null;
        }
        BinSeg result = this.selectConnectedComponents(selection);
        return result;
    }

    public BinSeg vol_vfilter_spread(BinSeg vol_seed) {
        int lcount = this.getNumConnectedComponents();
        System.out.println("vol_vfilter found " + lcount + " initial connected components");
        boolean[] selection = new boolean[lcount];
        int scount = 0;
        int[] label_list = this.cc_label_map;
        int cseg_seed = 0;
        short[] seed_seglist = vol_seed.seg_list;
        short com_seed = seed_seglist[cseg_seed++];
        int z2 = 0;
        while (com_seed != -3) {
            int y2 = 0;
            while (com_seed != -2) {
                if (com_seed >= 0) {
                    int cseg = this.first_seg[z2 * this.dy + y2];
                    int x1_seed = 0;
                    do {
                        int x0;
                        short com;
                        int nline = cseg;
                        int x0_seed = x1_seed + com_seed;
                        x1_seed = x0_seed + seed_seglist[cseg_seed++];
                        int x1 = 0;
                        while ((com = this.seg_list[nline++]) != -1 && (x0 = x1 + com) < x1_seed) {
                            if ((x1 = x0 + this.seg_list[nline++]) <= x0_seed) continue;
                            int selidx = label_list[(nline - 1) / 2] - 1;
                            selection[selidx] = true;
                            ++scount;
                        }
                    } while ((com_seed = seed_seglist[cseg_seed++]) >= 0);
                }
                ++y2;
                com_seed = seed_seglist[cseg_seed++];
            }
            ++z2;
            com_seed = seed_seglist[cseg_seed++];
        }
        System.out.println("vol_vfilter selecting " + scount + " components");
        if (scount == 0) {
            return null;
        }
        BinSeg result = this.selectConnectedComponents(selection);
        System.err.println(">>>> result=" + result);
        return result;
    }

    public void fillStatVTableT(int valMax, boolean[] selection, double[] sum, double[] sumSq, int[] sizeT) {
        if (this.cc_label_map == null) {
            this.labelConnectedComponents();
        }
        short[] vol_data = (short[])this.voldata;
        int cseg = 0;
        int offset = 0;
        int[] maxvals = new int[10];
        int[] minvals = new int[10];
        int[] idx = new int[10];
        int[] idx1 = new int[10];
        int[] labels = this.cc_label_map;
        int d2 = this.vol_offset;
        for (int i2 = 0; i2 < 10; ++i2) {
            maxvals[i2] = -9999999;
            minvals[i2] = 99999999;
        }
        int com = this.seg_list[cseg++];
        while (com != -3) {
            if (com >= 0) {
                int l2 = labels[cseg / 2];
                if (selection[l2]) {
                    int x2 = 0;
                    double val = 0.0;
                    int size = sizeT[l2];
                    double v2 = sum[l2];
                    double s2 = sumSq[l2];
                    int values = d2 + this.offlist[offset++];
                    com = this.seg_list[cseg++];
                    for (x2 = 0; x2 < com; ++x2) {
                        double d3;
                        val = vol_data[values + x2];
                        if (!(d3 < (double)valMax)) continue;
                        if (l2 < 10) {
                            if ((double)minvals[l2] > val) {
                                minvals[l2] = (int)val;
                                idx1[l2] = values - d2 + x2;
                            }
                            if ((double)maxvals[l2] < val) {
                                maxvals[l2] = (int)val;
                                idx[l2] = values - d2 + x2;
                            }
                        }
                        v2 += val;
                        s2 += val * val;
                        ++size;
                    }
                    sizeT[l2] = size;
                    sum[l2] = v2;
                    sumSq[l2] = s2;
                } else {
                    ++offset;
                }
            }
            int n2 = ++cseg;
            ++cseg;
            com = this.seg_list[n2];
        }
    }

    public void calcCovariability(int thresh, boolean[] selection, int distance, double[] cov0, double[] cov45, double[] cov90, double[] cov135) {
        int baseSeg;
        short[] vdata = (short[])this.voldata;
        int lSize = this.dy;
        int count = this.dz;
        int decal0 = distance;
        int decal45 = this.dx - distance;
        int decal90 = this.dx;
        int decal135 = this.dx + distance;
        int cseg = baseSeg = 0;
        int offIndex = 0;
        int offset = 0;
        int d2 = this.vol_offset;
        int sizeMDist = lSize - distance;
        int[] labels = this.cc_label_map;
        for (int z2 = 0; z2 < count; ++z2) {
            for (int y2 = distance; y2 < sizeMDist; ++y2) {
                int com;
                int hbase = y2 + z2 * this.dy;
                cseg = this.first_seg[hbase];
                int x2 = com = this.seg_list[cseg++];
                if (com < 0) continue;
                offIndex = this.first_offptr[hbase] - offset;
                do {
                    int l2 = labels[(cseg - baseSeg) / 2];
                    com = this.seg_list[cseg++];
                    if (selection[l2]) {
                        double c0 = cov0[l2];
                        double c45 = cov45[l2];
                        double c90 = cov90[l2];
                        double c135 = cov135[l2];
                        short val = 0;
                        int i2 = 0;
                        while (i2 < distance) {
                            ++i2;
                            ++x2;
                        }
                        while (i2 < com - distance && x2 < sizeMDist) {
                            int validx = d2 + this.offlist[offset + offIndex] + i2;
                            val = vdata[validx];
                            if (val < thresh) {
                                c0 += Math.abs((double)(val - vdata[validx - decal0]));
                                c45 += Math.abs((double)(val - vdata[validx - decal45]));
                                c90 += Math.abs((double)(val - vdata[validx - decal90]));
                                c135 += Math.abs((double)(val - vdata[validx - decal135]));
                            }
                            ++i2;
                            ++x2;
                        }
                        cov0[l2] = c0;
                        cov45[l2] = c45;
                        cov90[l2] = c90;
                        cov135[l2] = c135;
                    } else {
                        x2 += com;
                    }
                    ++offIndex;
                    com = this.seg_list[cseg++];
                    x2 += com;
                } while (com >= 0);
            }
        }
    }

    public JFrame display() {
        return this.display("Binary Segmentation");
    }

    public JFrame display(String title) {
        JFrame jf = new JFrame(title);
        ImgPanel ip = new ImgPanel(jf, this, title);
        ip.setPreferredSize(new Dimension(this.dx, this.dy));
        jf.setContentPane(ip);
        jf.pack();
        jf.setVisible(true);
        return jf;
    }

    public static void main(String[] args) {
        int dx = 512;
        int dy = 512;
        int dz = 263;
        int PAD = 524288;
        short[] data = new short[69992448];
        int mx = 256;
        int my = 256;
        int mz = 131;
        for (int z2 = 0; z2 < 263; ++z2) {
            int rz = Math.abs(131 - z2);
            int pgsize = 262144;
            int PGOFFSET = 524288 + z2 * 262144;
            for (int y2 = 0; y2 < 512; ++y2) {
                int ry = Math.abs(256 - y2);
                int OFFSET = PGOFFSET + y2 * 512;
                for (int x2 = 0; x2 < 512; ++x2) {
                    int rx = Math.abs(256 - x2);
                    double rad = Math.sqrt(rx * rx + ry * ry);
                    if (rad < 48.0) {
                        data[OFFSET + x2] = 30000;
                        continue;
                    }
                    if (rad < 96.0) {
                        data[OFFSET + x2] = 16000;
                        continue;
                    }
                    if (rad < 132.0) {
                        data[OFFSET + x2] = 12000;
                        continue;
                    }
                    if (!(rad < 261.0)) continue;
                    data[OFFSET + x2] = 8000;
                }
            }
        }
        BinSeg bseg = new BinSeg(data, 524288, 512, 512, 263);
        BinSeg thresh0bs = bseg.threshold(29000, 31000);
        BinSeg thresh1bs = bseg.threshold(11000, 13000);
        thresh0bs.display("Thresholded0").setDefaultCloseOperation(3);
        BinSeg dilatebs = thresh0bs;
        long t0 = System.currentTimeMillis();
        int DILATE_TIMES = 10;
        for (int i2 = 0; i2 < 10; ++i2) {
            dilatebs = dilatebs.dilate();
        }
        long t1 = System.currentTimeMillis();
        double avg = (double)(t1 - t0) / 10.0;
        System.err.println("^^^ time dilate = " + avg);
        dilatebs.display("Dilate").setDefaultCloseOperation(3);
        BinSeg diff = thresh1bs.diff(dilatebs);
        diff.display("Difference").setDefaultCloseOperation(3);
    }

    public BinSeg clone_w_densities() {
        short[] vol_data = (short[])this.voldata;
        short[] vdata = null;
        if (this.voldata != null) {
            vdata = new short[vol_data.length];
            System.arraycopy(vol_data, this.vol_offset, vdata, this.vol_offset, this.dx * this.dy * this.dz);
        }
        BinSeg cseg = new BinSeg(vdata, this.vol_offset, this.dx, this.dy, this.dz);
        cseg.seg_list = new short[this.seg_list.length];
        System.arraycopy(this.seg_list, 0, cseg.seg_list, 0, this.seg_list.length);
        cseg.offlist = new int[this.offlist.length];
        System.arraycopy(this.offlist, 0, cseg.offlist, 0, this.offlist.length);
        cseg.first_seg = new int[this.first_seg.length];
        System.arraycopy(this.first_seg, 0, cseg.first_seg, 0, this.first_seg.length);
        cseg.last_seg = new int[this.last_seg.length];
        System.arraycopy(this.last_seg, 0, cseg.last_seg, 0, this.last_seg.length);
        cseg.first_offptr = new int[this.first_offptr.length];
        System.arraycopy(this.first_offptr, 0, cseg.first_offptr, 0, this.first_offptr.length);
        cseg.last_offptr = new int[this.last_offptr.length];
        System.arraycopy(this.last_offptr, 0, cseg.last_offptr, 0, this.last_offptr.length);
        cseg.last_pos = new int[this.last_pos.length];
        System.arraycopy(this.last_pos, 0, cseg.last_pos, 0, this.last_pos.length);
        return cseg;
    }

    public BinSeg shallowCopy() {
        BinSeg cseg = new BinSeg(this.voldata, this.vol_offset, this.dx, this.dy, this.dz);
        cseg.seg_list = new short[this.seg_list.length];
        System.arraycopy(this.seg_list, 0, cseg.seg_list, 0, this.seg_list.length);
        cseg.offlist = new int[this.offlist.length];
        System.arraycopy(this.offlist, 0, cseg.offlist, 0, this.offlist.length);
        cseg.first_seg = new int[this.first_seg.length];
        System.arraycopy(this.first_seg, 0, cseg.first_seg, 0, this.first_seg.length);
        cseg.last_seg = new int[this.last_seg.length];
        System.arraycopy(this.last_seg, 0, cseg.last_seg, 0, this.last_seg.length);
        cseg.first_offptr = new int[this.first_offptr.length];
        System.arraycopy(this.first_offptr, 0, cseg.first_offptr, 0, this.first_offptr.length);
        cseg.last_offptr = new int[this.last_offptr.length];
        System.arraycopy(this.last_offptr, 0, cseg.last_offptr, 0, this.last_offptr.length);
        cseg.last_pos = new int[this.last_pos.length];
        System.arraycopy(this.last_pos, 0, cseg.last_pos, 0, this.last_pos.length);
        return cseg;
    }

    static {
        bcw = new BinsegCreateWorker[ParallelTaskManager.NCPUS > 4 ? 4 : ParallelTaskManager.NCPUS];
        for (int i2 = 0; i2 < bcw.length; ++i2) {
            BinSeg.bcw[i2] = new BinsegCreateWorker(i2);
        }
    }

    private static class ImgPanel
    extends JPanel
    implements KeyListener,
    MouseListener,
    MouseMotionListener {
        private BufferedImage bitimg = null;
        private short[] ccMap = null;
        private int[] ccSizes = null;
        private BinSeg bs = null;
        private int sliceNo = 0;
        private String origTitle = "";
        private JFrame jf = null;
        private int mx = -1;
        private int my = -1;

        public ImgPanel(JFrame jf, BinSeg bs, String title) {
            this.addKeyListener(this);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.bs = bs;
            this.jf = jf;
            this.origTitle = title;
            int[] sizes = bs.getConnectedComponentSizes();
            this.bitimg = new BufferedImage(bs.dx, bs.dy, 12);
            this.ccMap = new short[bs.dx * bs.dy];
            this.ccSizes = new int[bs.dx * bs.dy];
            this.sync();
        }

        @Override
        public void paintComponent(Graphics g2) {
            Graphics2D g22 = (Graphics2D)g2;
            if (this.jf != null) {
                this.jf.setTitle(this.origTitle + "  [" + this.sliceNo + "]");
            }
            g22.drawRenderedImage(this.bitimg, null);
            if (this.mx >= 0 && this.my >= 0) {
                short ccNum = this.ccMap[this.my * this.bs.dx + this.mx];
                int ccSize = this.ccSizes[this.my * this.bs.dx + this.mx];
                if (ccNum >= 0) {
                    g22.setColor(Color.green);
                    g22.drawString("cc=" + ccNum + " size=" + ccSize, this.mx, this.my);
                }
            }
        }

        private void sync() {
            byte[] bitdata = ((DataBufferByte)this.bitimg.getRaster().getDataBuffer()).getData();
            Arrays.fill(bitdata, (byte)0);
            Arrays.fill(this.ccMap, (short)-1);
            Arrays.fill(this.ccSizes, -1);
            int dy = this.bs.dy;
            int dx = this.bs.dx;
            short[] seg_list = this.bs.seg_list;
            int[] labels = this.bs.cc_label_map;
            int[] sizes = this.bs.cc_sizes;
            for (int y2 = 0; y2 < this.bs.dy; ++y2) {
                int start = this.bs.first_seg[this.sliceNo * dy + y2];
                int end = this.bs.last_seg[this.sliceNo * dy + y2];
                boolean in = false;
                int offset = 0;
                for (int i2 = start; i2 <= end; ++i2) {
                    if (in) {
                        for (int x2 = offset; x2 < offset + seg_list[i2]; ++x2) {
                            int idx = y2 * dx + x2;
                            int bit = idx & 7;
                            int pos = idx >> 3;
                            bitdata[pos] = (byte)(bitdata[pos] | 1 << 7 - bit);
                            if (labels == null) continue;
                            int l2 = labels[i2 / 2];
                            this.ccMap[y2 * this.bs.dx + x2] = (short)l2;
                            this.ccSizes[y2 * this.bs.dx + x2] = sizes[l2];
                        }
                    }
                    offset += seg_list[i2];
                    in = !in;
                }
            }
        }

        private void calcCC(int _mx, int _my) {
            this.mx = _mx;
            this.my = _my;
        }

        @Override
        public void keyPressed(KeyEvent e2) {
            int key = e2.getKeyCode();
            switch (key) {
                case 34: 
                case 40: {
                    ++this.sliceNo;
                    if (this.sliceNo < this.bs.dz) break;
                    this.sliceNo = 0;
                    break;
                }
                case 33: 
                case 38: {
                    --this.sliceNo;
                    if (this.sliceNo >= 0) break;
                    this.sliceNo = this.bs.dz - 1;
                }
            }
            this.sync();
            this.repaint();
        }

        @Override
        public void keyReleased(KeyEvent e2) {
        }

        @Override
        public void keyTyped(KeyEvent e2) {
        }

        @Override
        public void mouseClicked(MouseEvent e2) {
            this.requestFocus();
        }

        @Override
        public void mouseEntered(MouseEvent e2) {
            this.calcCC(e2.getX(), e2.getY());
            this.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e2) {
            this.my = -1;
            this.mx = -1;
            this.repaint();
        }

        @Override
        public void mousePressed(MouseEvent e2) {
            this.requestFocus();
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
        }

        @Override
        public void mouseDragged(MouseEvent e2) {
        }

        @Override
        public void mouseMoved(MouseEvent e2) {
            this.calcCC(e2.getX(), e2.getY());
            this.repaint();
        }
    }

    private static class BinsegCreateWorker
    extends Worker {
        public BinsegCreateWorker(int workerId) {
            super(ptm, workerId);
        }

        @Override
        public void work(int workerId, int nWorkers, Object data) {
            BinsegCreateData bcd = (BinsegCreateData)data;
            int dx = bcd.dx;
            int dy = bcd.dy;
            int dz = bcd.dz;
            int PGSIZE = dx * dy;
            byte[] bingrid = bcd.bingrid;
            int[] seg_lineCnt = bcd.seg_lineCnt;
            short[][] seg_lines = bcd.seg_lines;
            for (int z2 = 0; z2 < dz; ++z2) {
                int zoffset = z2 * PGSIZE;
                int cntoffset = z2 * dy;
                for (int y2 = workerId; y2 < dy; y2 += nWorkers) {
                    int crun = 0;
                    int offset = zoffset + y2 * dx;
                    int seg_lineIdx = cntoffset + y2;
                    int sgidx = 0;
                    boolean onerun = false;
                    for (int x2 = 0; x2 < dx; ++x2) {
                        int idx = offset + x2;
                        int bidx = idx >> 3;
                        int mod = idx & 7;
                        if (onerun) {
                            if ((bingrid[bidx] & 1 << mod) != 0) {
                                ++crun;
                                continue;
                            }
                            seg_lines[seg_lineIdx][sgidx++] = (short)crun;
                            crun = 1;
                            onerun = false;
                            continue;
                        }
                        if ((bingrid[bidx] & 1 << mod) == 0) {
                            ++crun;
                            continue;
                        }
                        seg_lines[seg_lineIdx][sgidx++] = (short)crun;
                        crun = 1;
                        onerun = true;
                    }
                    if (crun > 0 && onerun) {
                        seg_lines[seg_lineIdx][sgidx++] = (short)crun;
                    }
                    seg_lines[seg_lineIdx][sgidx++] = -1;
                    seg_lineCnt[seg_lineIdx] = sgidx;
                }
            }
        }
    }

    private static class BinsegCreateData {
        public short[][] seg_lines = null;
        public int[] seg_lineCnt = null;
        public byte[] bingrid = null;
        public int dx = 0;
        public int dy = 0;
        public int dz = 0;

        public BinsegCreateData(byte[] bingrid, int dx, int dy, int dz) {
            this.seg_lines = new short[dy * dz][128];
            this.seg_lineCnt = new int[dy * dz];
            this.bingrid = bingrid;
            this.dx = dx;
            this.dy = dy;
            this.dz = dz;
        }
    }

    public static interface SegAlgorithm {
        public String getName();

        public BinSeg segment(BinSeg var1, Object[] var2, TaskMonitor var3);
    }
}

