/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.seg;

import com.ge.med.idc.TaskMonitor;
import com.ge.med.terra.jami.seg.SegGrid;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import javax.swing.JFrame;
import javax.swing.JPanel;

public abstract class LabelGrid
extends SegGrid {
    public LabelGrid(Object voldata, int vol_offset, int dx, int dy, int dz) {
        super(voldata, vol_offset, dx, dy, dz);
    }

    public static SegAlgorithm createSegAlgorithm(String className) {
        try {
            Class<?> cl = Class.forName(className);
            Constructor<?> c2 = cl.getConstructor(null);
            SegAlgorithm sa = (SegAlgorithm)c2.newInstance(null);
            return sa;
        }
        catch (ClassNotFoundException e2) {
            e2.printStackTrace();
        }
        catch (SecurityException e3) {
            e3.printStackTrace();
        }
        catch (NoSuchMethodException e4) {
            e4.printStackTrace();
        }
        catch (IllegalArgumentException e5) {
            e5.printStackTrace();
        }
        catch (InstantiationException e6) {
            e6.printStackTrace();
        }
        catch (IllegalAccessException e7) {
            e7.printStackTrace();
        }
        catch (InvocationTargetException e8) {
            e8.printStackTrace();
        }
        return null;
    }

    public JFrame display() {
        return this.display("Label Segmentation");
    }

    public JFrame display(String title) {
        JFrame jf = new JFrame(title);
        ImgPanel ip = new ImgPanel(jf, this, title);
        ip.setPreferredSize(new Dimension(this.dx, this.dy));
        jf.setContentPane(ip);
        jf.pack();
        jf.setVisible(true);
        return jf;
    }

    public static void main(String[] args) {
        int dx = 256;
        int dy = 256;
        int dz = 128;
        int PAD = 131072;
        short[] data = new short[0x840000];
        int mx = 128;
        int my = 128;
        int mz = 64;
        for (int z2 = 0; z2 < 128; ++z2) {
            int pgsize = 65536;
            int PGOFFSET = 131072 + z2 * 65536;
            for (int y2 = 0; y2 < 256; ++y2) {
                int ry = Math.abs(128 - y2);
                int OFFSET = PGOFFSET + y2 * 256;
                for (int x2 = 0; x2 < 256; ++x2) {
                    int rx = Math.abs(128 - x2);
                    double rad = Math.sqrt(rx * rx + ry * ry);
                    if (rad < 48.0) {
                        data[OFFSET + x2] = 30000;
                        continue;
                    }
                    if (rad < 96.0) {
                        data[OFFSET + x2] = 16000;
                        continue;
                    }
                    if (rad < 132.0) {
                        data[OFFSET + x2] = 12000;
                        continue;
                    }
                    if (!(rad < 126.0)) continue;
                    data[OFFSET + x2] = 8000;
                }
            }
        }
        Byte bseg = new Byte(data, 131072, 256, 256, 128);
        for (int i2 = 0; i2 < 0x800000; ++i2) {
            if (data[131072 + i2] < 8001) {
                bseg.labels[131072 + i2] = 1;
                continue;
            }
            if (data[131072 + i2] < 12001) {
                bseg.labels[131072 + i2] = 2;
                continue;
            }
            if (data[131072 + i2] < 16001) {
                bseg.labels[131072 + i2] = 3;
                continue;
            }
            if (data[131072 + i2] >= 30001) continue;
            bseg.labels[131072 + i2] = 4;
        }
        bseg.display("cmap").setDefaultCloseOperation(3);
    }

    private static class ImgPanel
    extends JPanel
    implements KeyListener,
    MouseListener {
        private BufferedImage labimg = null;
        private LabelGrid lg = null;
        private int sliceNo = 0;
        private String origTitle = "";
        private JFrame jf = null;
        private static int[] cmap = new int[]{-16777216, -65536, -16711936, -16776961, -256, -16711681, -65281, -1, -16740608, -7405568, -16777073, -7368817, -7368960, -16740465};

        public ImgPanel(JFrame jf, LabelGrid lg, String title) {
            this.addKeyListener(this);
            this.addMouseListener(this);
            this.lg = lg;
            this.jf = jf;
            this.origTitle = title;
            this.labimg = new BufferedImage(lg.dx, lg.dy, 1);
            this.sync();
        }

        @Override
        public void paintComponent(Graphics g2) {
            Graphics2D g22 = (Graphics2D)g2;
            if (this.jf != null) {
                this.jf.setTitle(this.origTitle + "  [" + this.sliceNo + "]");
            }
            g22.drawRenderedImage(this.labimg, null);
        }

        private void sync() {
            block4: {
                int[] ldata = ((DataBufferInt)this.labimg.getRaster().getDataBuffer()).getData();
                Arrays.fill(ldata, 0);
                int dz = this.lg.dz;
                int dy = this.lg.dy;
                int dx = this.lg.dx;
                if (this.sliceNo < 0 || this.sliceNo >= dz) break block4;
                int offset = this.lg.vol_offset + this.sliceNo * dx * dy;
                if (this.lg instanceof Byte) {
                    byte[] data = ((Byte)this.lg).labels;
                    for (int i2 = 0; i2 < dx * dy; ++i2) {
                        int idx = (data[offset + i2] & 0xFF) % cmap.length;
                        ldata[i2] = cmap[idx];
                    }
                } else {
                    short[] data = ((Short)this.lg).labels;
                    for (int i3 = 0; i3 < dx * dy; ++i3) {
                        short v2 = data[offset + i3];
                        if (v2 < 0) continue;
                        int idx = v2 % cmap.length;
                        ldata[i3] = cmap[idx];
                    }
                }
            }
        }

        @Override
        public void keyPressed(KeyEvent e2) {
            int key = e2.getKeyCode();
            switch (key) {
                case 34: 
                case 40: {
                    ++this.sliceNo;
                    if (this.sliceNo < this.lg.dz) break;
                    this.sliceNo = 0;
                    break;
                }
                case 33: 
                case 38: {
                    --this.sliceNo;
                    if (this.sliceNo >= 0) break;
                    this.sliceNo = this.lg.dz - 1;
                }
            }
            this.sync();
            this.repaint();
        }

        @Override
        public void keyReleased(KeyEvent e2) {
        }

        @Override
        public void keyTyped(KeyEvent e2) {
        }

        @Override
        public void mouseClicked(MouseEvent e2) {
            this.requestFocus();
        }

        @Override
        public void mouseEntered(MouseEvent e2) {
        }

        @Override
        public void mouseExited(MouseEvent e2) {
        }

        @Override
        public void mousePressed(MouseEvent e2) {
            this.requestFocus();
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
        }
    }

    public static class Short
    extends LabelGrid {
        public short[] labels = null;

        public Short(Object voldata, int vol_offset, int dx, int dy, int dz) {
            super(voldata, vol_offset, dx, dy, dz);
            int len = dx * dy * dz;
            this.labels = new short[2 * vol_offset + len];
            Arrays.fill(this.labels, (short)0);
        }
    }

    public static class Byte
    extends LabelGrid {
        public byte[] labels = null;

        public Byte(Object voldata, int vol_offset, int dx, int dy, int dz) {
            super(voldata, vol_offset, dx, dy, dz);
            int len = dx * dy * dz;
            this.labels = new byte[2 * vol_offset + len];
            Arrays.fill(this.labels, (byte)0);
        }
    }

    public static interface SegAlgorithm {
        public String getName();

        public LabelGrid segment(Object[] var1, TaskMonitor var2);
    }
}

