/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm;

import com.ge.med.terra.tap.dm.DMEventListener;
import com.ge.med.terra.tap.dm.DMId;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.peer.DMiSelection;
import java.util.HashMap;

public class DMSelection {
    DMiSelection peer = null;
    static HashMap factory = new HashMap(10);
    public static final int PATIENT = 1;
    public static final int STUDY = 2;
    public static final int SERIES = 3;
    public static final int IMAGE = 4;

    public DMSelection() {
        this.peer = DMSelection.getSession("default");
    }

    public static void insertSession(String name, String className) {
        factory.put(name, className);
    }

    private static DMiSelection getSession(String type) {
        DMiSelection se;
        try {
            Class<?> c2;
            String className = (String)factory.get(type);
            if (className == null) {
                className = type;
            }
            if ((c2 = Class.forName(className)) == null) {
                throw new RuntimeException("Unable to create selection");
            }
            se = (DMiSelection)c2.newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to create selection");
        }
        return se;
    }

    public DMSelection(String[] args) {
        this.peer = DMSelection.getSession(args[0]);
        this.peer.init(args);
    }

    public void setSelection(DMId[] id) {
        this.peer.setSelection(id);
    }

    public DMId[] getSelection() {
        return this.peer.getSelection();
    }

    public void addSelectionListener(DMEventListener l2) {
        this.peer.addSelectionListener(l2);
    }

    public void requestNextSelection(int type) {
        this.peer.requestNextSelection(type);
    }

    public void requestPreviousSelection(int type) {
        this.peer.requestPreviousSelection(type);
    }

    public boolean hasNextSelection(int type) {
        return this.peer.hasNextSelection(type);
    }

    public boolean hasPreviousSelection(int type) {
        return this.peer.hasPreviousSelection(type);
    }

    public void setSession(DMSession session) {
        this.peer.setSession(session);
    }

    public String[] getAvailableSort(int level) {
        return this.peer.getAvailableSort(level);
    }

    public void setAvailableSort(int level, String[] availsort) {
        this.peer.setAvailableSort(level, availsort);
    }

    public void setSort(int level, String sort) {
        this.peer.setSort(level, sort);
    }

    public String getSort(int level) {
        return this.peer.getSort(level);
    }

    static {
        DMSelection.insertSession("udp", "com.ge.med.terra.tap.dm.selection.SimpleUDP");
        DMSelection.insertSession("ios", "com.ge.med.xjplugins.tap.util.ios.IosSelection");
    }
}

