/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm;

import com.ge.med.idc.XjLoader;
import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.DMComposite;
import com.ge.med.terra.tap.dm.DMEventListener;
import com.ge.med.terra.tap.dm.DMJob;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMObjectReceiver;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMUtils;
import com.ge.med.terra.tap.dm.peer.DMiComposite;
import com.ge.med.terra.tap.dm.peer.DMiJob;
import com.ge.med.terra.tap.dm.peer.DMiObject;
import com.ge.med.terra.tap.dm.peer.DMiObjectReceiver;
import com.ge.med.terra.tap.dm.peer.DMiSession;
import com.ge.med.terra.tap.dm.sessionNull.nullSession;
import com.ge.med.terra.tap.util.SimpleUtilities;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;

public class DMSession {
    DMiSession peer;
    public static boolean TAP_TRACE_FLAG;
    private static HashMap<String, String> factory;
    private static HashMap<List<String>, DMSession> factorymap;
    private Hashtable properties = new Hashtable();

    public static void insertSession(String type, String className) {
        factory.put(type, className);
    }

    private static DMiSession getSession(String type) {
        DMiSession se;
        try {
            Class<?> c2;
            String className = factory.get(type);
            if (className == null) {
                className = type;
            }
            if ((c2 = Class.forName(className)) == null) {
                Tap.log.log(Level.WARNING, "Error: Unable to find session of type: " + type + ". Using \"null\" session.");
                return new nullSession();
            }
            se = (DMiSession)c2.newInstance();
        }
        catch (Exception ex) {
            Tap.log.log(Level.WARNING, "Error: Unable to create session of type: " + type + ". Using \"null\" session. ", ex);
            return new nullSession();
        }
        return se;
    }

    public static DMSession getSession(String[] args) {
        List<String> l2 = Arrays.asList(args);
        if (!factorymap.containsKey(l2)) {
            factorymap.put(l2, new DMSession(args));
        }
        return factorymap.get(l2);
    }

    public static void removeSession(DMSession dms) {
        if (!factorymap.containsValue(dms)) {
            return;
        }
        List<String> theKey = null;
        for (List<String> key : factorymap.keySet()) {
            DMSession d2 = factorymap.get(key);
            if (d2 != dms) continue;
            theKey = key;
            break;
        }
        if (theKey != null) {
            factorymap.remove(theKey);
        }
    }

    public static void removeSession(DMiSession dms) {
        List<String> theKey = null;
        for (List<String> key : factorymap.keySet()) {
            DMSession d2 = factorymap.get(key);
            if (d2.peer != dms) continue;
            theKey = key;
            break;
        }
        if (theKey != null) {
            factorymap.remove(theKey);
        }
    }

    public DMSession() {
        this.peer = DMSession.getSession("default");
    }

    public DMSession(DMiSession peer) {
        this.peer = peer;
    }

    public DMSession(String[] config) {
        String type = null;
        String rep = null;
        String[] args = null;
        if (config.length > 0) {
            type = config[0];
        }
        if (config.length > 1) {
            rep = config[1];
        }
        if (config.length > 2) {
            args = new String[config.length - 2];
            for (int i2 = 2; i2 < config.length; ++i2) {
                args[i2 - 2] = config[i2];
            }
        }
        this.setup(type, rep, args);
    }

    public DMSession(String type, String rep, String[] args) {
        this.setup(type, rep, args);
    }

    public DMSession(String type, String rep, String name, String[] args) {
        String[] nargs = null;
        if (name != null) {
            if (args == null) {
                nargs = new String[]{name};
            } else {
                nargs = new String[1 + args.length];
                nargs[0] = name;
                System.arraycopy(args, 0, nargs, 1, args.length);
            }
        }
        this.setup(type, rep, nargs);
    }

    private void setup(String type, String rep, String[] args) {
        if (type != null) {
            this.setProperty(DMUtils.PROPERTY_SESSION_TYPE, type);
        }
        if (rep != null) {
            this.setProperty(DMUtils.PROPERTY_SESSION_REP, rep);
        }
        if (args != null) {
            this.setProperty(DMUtils.PROPERTY_SESSION_ARGS, args);
        }
        this.peer = DMSession.getSession(type);
        this.peer.init(rep, args);
    }

    public DMComposite[] getComposites() {
        DMiComposite[] ci = this.peer.getComposites();
        DMComposite[] c2 = new DMComposite[ci.length];
        for (int i2 = 0; i2 < c2.length; ++i2) {
            c2[i2] = new DMComposite(ci[i2], this);
        }
        return c2;
    }

    public DMComposite getComposite(String id) {
        DMiComposite ci = this.peer.getComposite(id);
        if (ci == null) {
            return null;
        }
        return new DMComposite(ci, this);
    }

    public int getNumberOfComposites() {
        return this.peer.getNumberOfComposites();
    }

    public DMObject[] getChildren() {
        return this.getChildren(null);
    }

    public DMObject[] getChildren(DMQuery q2) {
        if (TAP_TRACE_FLAG) {
            Tap.log.fine("getChildren(" + q2 + ")");
        }
        DMiObject[] oi = this.peer.getChildren(q2);
        DMObject[] o2 = new DMObject[oi.length];
        for (int i2 = 0; i2 < o2.length; ++i2) {
            o2[i2] = new DMObject(oi[i2], this);
        }
        return o2;
    }

    public void getChildren(DMQuery q2, final DMObjectReceiver cb) {
        if (TAP_TRACE_FLAG) {
            Tap.log.fine("getChildren(" + q2 + ",cb)");
        }
        final DMSession session = this;
        this.peer.getChildren(q2, new DMiObjectReceiver(){

            @Override
            public boolean gotOne(DMiObject o2) {
                return cb.gotOne(new DMObject(o2, session));
            }
        });
    }

    public DMObject[] getRelated(String ieType) {
        return this.getRelated(ieType, null);
    }

    public DMObject[] getRelated(String ieType, DMQuery q2) {
        if (TAP_TRACE_FLAG) {
            Tap.log.fine("getRelated(" + ieType + "," + q2 + ")");
        }
        DMiObject[] oi = this.peer.getRelated(ieType, q2);
        DMObject[] o2 = new DMObject[oi.length];
        for (int i2 = 0; i2 < o2.length; ++i2) {
            o2[i2] = new DMObject(oi[i2], this);
        }
        return o2;
    }

    public void getRelated(String ieType, DMQuery q2, final DMObjectReceiver cb) {
        if (TAP_TRACE_FLAG) {
            Tap.log.fine("getRelated(" + ieType + "," + q2 + ",cb)");
        }
        final DMSession session = this;
        this.peer.getRelated(ieType, q2, new DMiObjectReceiver(){

            @Override
            public boolean gotOne(DMiObject o2) {
                return cb.gotOne(new DMObject(o2, session));
            }
        });
    }

    public void save(DMObject dmo) {
        if (TAP_TRACE_FLAG) {
            Tap.log.fine("save(dmo)");
        }
        Hashtable<String, Object> prop = new Hashtable<String, Object>();
        prop.put("To", this);
        prop.put("From", dmo.getSession());
        prop.put("Date", new Date());
        prop.put("Object", dmo);
        this.peer.save(dmo.peer, prop);
    }

    public void save(DMObject[] dmo) {
        if (TAP_TRACE_FLAG) {
            Tap.log.fine("save([]dmo)");
        }
        Hashtable<String, Object> prop = new Hashtable<String, Object>();
        prop.put("To", this);
        prop.put("From", dmo[0].getSession());
        prop.put("Date", new Date());
        prop.put("Object", dmo);
        DMiObject[] obj = new DMiObject[dmo.length];
        for (int i2 = 0; i2 < dmo.length; ++i2) {
            obj[i2] = dmo[i2].getPeer();
        }
        this.peer.save(obj, prop);
    }

    public void save(DMComposite dmc) {
        if (TAP_TRACE_FLAG) {
            Tap.log.fine("save(DMComposite dmc)");
        }
        Hashtable<String, Object> prop = new Hashtable<String, Object>();
        prop.put("To", this);
        prop.put("From", dmc.getSession());
        prop.put("Date", new Date());
        prop.put("Composite", dmc);
        this.peer.save(dmc.peer, prop);
    }

    public void addDMEventListener(int eventType, DMEventListener listener) {
        this.addDMEventListener(eventType, 0, listener);
    }

    public void addDMEventListener(int eventType, int freq, DMEventListener listener) {
        if (TAP_TRACE_FLAG) {
            Tap.log.fine("addDMEventListener(" + eventType + "," + freq + ",listener)");
        }
        this.peer.addDMEventListener(eventType, freq, listener);
    }

    public void removeDMEventListener(DMEventListener listener) {
        if (TAP_TRACE_FLAG) {
            Tap.log.fine("removeDMEventListener(listener)");
        }
        this.peer.removeDMEventListener(listener);
    }

    public DMiSession getPeer() {
        return this.peer;
    }

    public void ClearCache() {
        this.peer.ClearCache();
    }

    public void install(InputStream is) throws IOException {
        this.peer.install(is);
    }

    public void installFiles(File[] files) throws FileNotFoundException, IOException {
        this.peer.installFiles(files, false);
    }

    public void installFiles(File[] files, boolean destroy) throws FileNotFoundException, IOException {
        if (TAP_TRACE_FLAG) {
            Tap.log.fine("installFiles([" + (files.length > 0 ? files[0] + "..." + files.length : "") + "]," + destroy);
        }
        Vector<Object> vect = new Vector<Object>();
        for (int i2 = 0; i2 < files.length; ++i2) {
            if (files[i2].isDirectory()) {
                vect.add(SimpleUtilities.getFilesRecursively(files[i2]));
                continue;
            }
            vect.add(files[i2]);
        }
        File[] actualFiles = new File[vect.size()];
        for (int i3 = 0; i3 < actualFiles.length; ++i3) {
            actualFiles[i3] = (File)vect.get(i3);
        }
        this.peer.installFiles(actualFiles, destroy);
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public String[] getSessionArgs() {
        String type = (String)this.getProperty(DMUtils.PROPERTY_SESSION_TYPE);
        String rep = (String)this.getProperty(DMUtils.PROPERTY_SESSION_REP);
        String[] args = (String[])this.getProperty(DMUtils.PROPERTY_SESSION_ARGS);
        if (args == null) {
            args = new String[]{};
        }
        String[] ret = new String[2 + args.length];
        ret[0] = type;
        ret[1] = rep;
        System.arraycopy(args, 0, ret, 2, args.length);
        return ret;
    }

    public DMObject getDMObject(String type, String id) {
        DMiObject object = this.peer.getDMiObject(type, id);
        if (object == null) {
            return null;
        }
        return new DMObject(object, this);
    }

    public String[] send(String str) {
        return this.peer.send(str);
    }

    public DMJob asyncSend(String str) {
        return new DMJob(this.peer.asynSend(str));
    }

    public DMJob[] getJobs() {
        DMiJob[] iJobs = this.peer.getJobs();
        if (iJobs != null) {
            DMJob[] jobs = new DMJob[iJobs.length];
            for (int i2 = 0; i2 < jobs.length; ++i2) {
                jobs[i2] = new DMJob(iJobs[i2]);
            }
            return jobs;
        }
        return null;
    }

    public void close() {
        this.peer.close();
        DMSession.removeSession(this);
    }

    static {
        XjLoader.initialize();
        TAP_TRACE_FLAG = Tap.logLevel == Tap.LEVEL_FINEST;
        factory = new HashMap(13);
        DMSession.insertSession("default", "com.ge.med.terra.tap.dm.sessionNull.nullSession");
        DMSession.insertSession("file", "com.ge.med.terra.tap.dm.sessionFile.fileSession");
        DMSession.insertSession("terra", "com.ge.med.xjplugins.tap.dm.terra.terraSession");
        DMSession.insertSession("archive", "com.ge.med.terra.tap.dm.dicomdir.DicomdirSession");
        DMSession.insertSession("dicomdir", "com.ge.med.terra.tap.dm.dicomdir.DicomdirSession");
        DMSession.insertSession("remote", "com.ge.med.terra.tap.dm.rm.RmSession");
        DMSession.insertSession("network", "com.ge.med.terra.tap.dm.network.networkSession");
        DMSession.insertSession("aw", "com.ge.med.terra.tap.dm.aw.AWSession");
        DMSession.insertSession("pesi", "com.ge.med.terra.tap.dm.pesi.PesiSession");
        DMSession.insertSession("umai", "com.ge.med.xjplugins.tap.dm.umai.UMAISession");
        DMSession.insertSession("sql", "com.ge.med.terra.tap.dm.sql.SqlSession");
        DMSession.insertSession("list", "com.ge.med.terra.tap.dm.list.ListSession");
        DMSession.insertSession("hyper", "com.ge.med.terra.tap.dm.hyperpesi.HyperPesiSession");
        DMSession.insertSession("mwl", "com.ge.med.terra.tap.dm.mwl.MwlSession");
        try {
            if (System.getProperty("TAP_TRACE_FLAG", "false").equals("true")) {
                TAP_TRACE_FLAG = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        factorymap = new HashMap();
    }
}

