/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.dicomdir;

import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.dicomdir.DicomdirObject;
import com.ge.med.terra.tap.dm.dicomdir.DicomdirTagValue;
import com.ge.med.terra.tap.dm.dicomdir.DirectoryEntityLevel;
import com.ge.med.terra.tap.dm.dicomdir.DirectoryRecord;
import com.ge.med.terra.tap.dm.dicomdir.DirectoryRecordType;
import com.ge.med.terra.tap.dm.peer.DMiComposite;
import com.ge.med.terra.tap.util.SimpleUtilities;
import com.ge.med.terra.tap.util.dicom.DicomCharSet;
import com.ge.med.terra.tap.util.dicom.UidGenerator;
import com.ge.med.terra.tap.util.dicom.dicomParser;
import com.ge.med.terra.tap.util.dicom.tagValue;
import com.ge.med.terra.tap.version;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import sun.nio.ch.DirectBuffer;

public class Dicomdir {
    public static final String PATIENT_LEVEL = "PATIENT";
    public static final String STUDY_LEVEL = "STUDY";
    public static final String SERIES_LEVEL = "SERIES";
    public static final String IMAGE_LEVEL = "IMAGE";
    public static final String[] LEVEL_NAMES = new String[]{"PATIENT", "STUDY", "SERIES", "IMAGE"};
    public static final String NONE = "NONE";
    public static final String NON_COMPRESSION = "NonCompression";
    public static final String JPEG = "JPEG";
    public static final String JPEG_LOSSLESS = "JPEGLossLess";
    protected static final Locale LOCALE = Locale.ENGLISH;
    protected static final String REMOVE_FILES_DIR = "REMOVE";
    protected static final int ITEM_BEGIN_GROUP = 65534;
    protected static final int ITEM_BEGIN_ELEMENT = 57344;
    protected static final int ITEM_END_GROUP = 65534;
    protected static final int ITEM_END_ELEMENT = 57357;
    protected static final int SEQ_END_GROUP = 65534;
    protected static final int SEQ_END_ELEMENT = 57565;
    private static final String DICOMDIR = "DICOMDIR";
    private static final String AE_TITLE = "TAP_SESSION";
    private static final String FILE_SET_ID = "TAP_DICOMDIR";
    private static final String TAP_VERSION = version.getVersion().getVersionString();
    private static final String PAD = "40000000";
    private String xferSyntax;
    private String implClassUID;
    private String implVerName;
    private String srcAETitle;
    private String fileSetID;
    private String filePath = null;
    private String dirMountPath = null;
    private String encodingScheme = "NonCompression";
    private boolean readOnly = true;
    private boolean isNew = false;
    private boolean littleEndian;
    private boolean explicitVR;
    private final int padsize = Integer.valueOf(Tap.getProperty("tap.dm.dicomdir.map.padsize", "40000000"));
    private int fileLength;
    private int initFileLength = 0;
    private long actualFileLength = 0L;
    private MappedByteBuffer mb = null;
    private RandomAccessFile out;
    private tagValue firstDRTag = new tagValue(4, 4608);
    private int firstPatientOffset = -1;
    private tagValue lastDRTag = new tagValue(4, 4610);
    private int lastPatientOffset = -1;
    private final tagValue[] headerTags = new tagValue[]{new tagValue(2, 0), new tagValue(2, 1), new tagValue(2, 2), new tagValue(2, 3), new tagValue(2, 16), new tagValue(2, 18), new tagValue(2, 19), new tagValue(2, 22), new tagValue(4, 4400), this.firstDRTag, this.lastDRTag, new tagValue(4, 4626)};
    private Map<String, DirectoryRecord> patientDE = new HashMap<String, DirectoryRecord>();
    private Map<String, DirectoryRecord> studyDE = new HashMap<String, DirectoryRecord>();
    private Map<String, DirectoryRecord> seriesDE = new HashMap<String, DirectoryRecord>();
    private Map<String, DirectoryRecord> imageDE = new HashMap<String, DirectoryRecord>();
    private List<Map<String, DirectoryRecord>> directoryEntities = new ArrayList<Map<String, DirectoryRecord>>(4);
    private final DirectoryEntityLevel[] deLevels;

    public Dicomdir(String filePath, Properties sessionProps) {
        this.directoryEntities.add(this.patientDE);
        this.directoryEntities.add(this.studyDE);
        this.directoryEntities.add(this.seriesDE);
        this.directoryEntities.add(this.imageDE);
        this.filePath = this.setupFilePath(filePath);
        this.deLevels = Dicomdir.createDirectoryEntityLevels();
        this.setSessionProperties(sessionProps);
        this.getFileMetaInformationProperties();
        Tap.log.log(Level.INFO, "Session Read-Only = {0}", this.isReadOnly());
        this.mb = this.isReadOnly() ? this.createReader() : this.createWriter();
        Tap.log.log(Level.INFO, "Setting Explicit VR = {0}", this.explicitVR);
        Tap.log.log(Level.INFO, "Setting Little Endian = {0}", this.littleEndian);
        if (!this.isNew()) {
            this.createDirectoryEntities();
            this.loadTagsFromExistingDicomdir();
        }
    }

    private String setupFilePath(String path) {
        String ddir = null;
        String newPath = File.separatorChar == '/' ? path.replace('\\', '/') : path.replace('/', '\\');
        File dicomDirFile = new File(newPath);
        System.out.println("The Mount Directory path = " + newPath);
        if (dicomDirFile.isDirectory()) {
            ddir = DICOMDIR;
            dicomDirFile = new File(dicomDirFile, ddir);
        } else {
            ddir = dicomDirFile.getName();
            if (!ddir.equalsIgnoreCase(DICOMDIR)) {
                Tap.log.warning("File name should be DICOMDIR");
            }
        }
        this.dirMountPath = dicomDirFile.getParent();
        Tap.log.log(Level.INFO, "DICOMDIR path = {0}", dicomDirFile.getAbsolutePath());
        Tap.log.log(Level.INFO, "Work Directory path = {0}", this.dirMountPath);
        if (dicomDirFile.isFile()) {
            this.isNew = false;
            this.fileLength = (int)dicomDirFile.length();
        } else {
            this.isNew = true;
        }
        Tap.log.log(Level.INFO, "New DICOMDIR = {0}", this.isNew);
        return dicomDirFile.getAbsolutePath();
    }

    private static DirectoryEntityLevel[] createDirectoryEntityLevels() {
        int nLevels = LEVEL_NAMES.length;
        DirectoryEntityLevel[] archLevels = new DirectoryEntityLevel[nLevels];
        for (int i2 = 0; i2 < nLevels; ++i2) {
            archLevels[i2] = new DirectoryEntityLevel(LEVEL_NAMES[i2]);
        }
        return archLevels;
    }

    private void setSessionProperties(Properties props) {
        String compressionType = props.getProperty("encoding");
        this.encodingScheme = this.setEncoding(compressionType);
        this.readOnly = props.getProperty("readonly", String.valueOf(this.readOnly)).equalsIgnoreCase("true");
    }

    private MappedByteBuffer createReader() {
        if (this.isNew) {
            throw new IllegalStateException("Need to create \"" + this.filePath + "\", but session is READ-ONLY");
        }
        MappedByteBuffer mb = null;
        try {
            this.readHeader();
            this.out = new RandomAccessFile(this.filePath, "r");
            mb = this.out.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, this.out.length());
            mb.position(this.fileLength);
        }
        catch (IOException ioex) {
            throw new IllegalStateException("Error while opening \"" + this.filePath + "\": ", ioex);
        }
        return mb;
    }

    private MappedByteBuffer createWriter() {
        MappedByteBuffer mb = null;
        try {
            File archFile = new File(this.filePath);
            if (this.isNew) {
                File parentFile = archFile.getParentFile();
                if (null != parentFile && !parentFile.exists()) {
                    parentFile.mkdirs();
                }
                archFile.createNewFile();
                this.out = new RandomAccessFile(archFile.getAbsolutePath(), "rw");
                mb = this.out.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, this.out.length() + (long)this.padsize);
                mb.order(this.littleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
                this.writeHeader(mb);
            } else {
                this.readHeader();
                if (archFile.canWrite()) {
                    this.out = new RandomAccessFile(archFile.getAbsolutePath(), "rw");
                    mb = this.out.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, this.out.length() + (long)this.padsize);
                    mb.order(this.littleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
                    mb.position(this.fileLength);
                }
            }
        }
        catch (IOException ioex) {
            throw new IllegalStateException("Error while creating \"" + this.filePath + "\": ", ioex);
        }
        return mb;
    }

    private void readHeader() {
        dicomParser dp = new dicomParser();
        try {
            dp.setFile(this.filePath);
            dp.fill(this.headerTags);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error while parsing \"" + this.filePath + "\": ", ex);
        }
        finally {
            dp.clearFile();
        }
        this.littleEndian = dp.isFileLittleEndian();
        this.explicitVR = dp.isExplicitVR();
        this.firstPatientOffset = (int)this.firstDRTag.getOffset() + 8;
        this.lastPatientOffset = (int)this.lastDRTag.getOffset() + 8;
        this.initFileLength = this.firstPatientOffset <= 8 ? ((Long)this.lastDRTag.value).intValue() : ((Long)this.firstDRTag.value).intValue();
    }

    private void writeHeader(ByteBuffer mb) throws IOException {
        DicomCharSet[] dicomCharsets = DicomCharSet.getDefaultCharSet();
        byte[] preamble = new byte[128];
        mb.put(preamble, 0, preamble.length);
        mb.put("DICM".getBytes(dicomCharsets[0].getJavaCharsetName()));
        int groupLength = 0;
        DicomdirTagValue element = new DicomdirTagValue(2, 0, "UL", Long.valueOf(groupLength));
        element.write(mb, true, true, dicomCharsets);
        int groupLengthValueOffset = mb.position() - element.len;
        ArrayList<DicomdirTagValue> fileMetaElements = new ArrayList<DicomdirTagValue>(7);
        fileMetaElements.add(new DicomdirTagValue(2, 1, "OB", new byte[]{0, 1}));
        fileMetaElements.add(new DicomdirTagValue(2, 2, "UI", "1.2.840.10008.1.3.10", dicomCharsets));
        fileMetaElements.add(new DicomdirTagValue(2, 3, "UI", UidGenerator.newInstanceUID(), dicomCharsets));
        fileMetaElements.add(new DicomdirTagValue(2, 16, "UI", this.xferSyntax, dicomCharsets));
        fileMetaElements.add(new DicomdirTagValue(2, 18, "UI", this.implClassUID, dicomCharsets));
        fileMetaElements.add(new DicomdirTagValue(2, 19, "SH", this.implVerName, dicomCharsets));
        fileMetaElements.add(new DicomdirTagValue(2, 22, "AE", this.srcAETitle, dicomCharsets));
        for (DicomdirTagValue tag2 : fileMetaElements) {
            groupLength += tag2.write(mb, true, true, dicomCharsets);
        }
        Dicomdir.writeValueAtOffset(mb, groupLengthValueOffset, groupLength);
        new DicomdirTagValue(4, 4400, "CS", this.fileSetID, dicomCharsets).write(mb, this.explicitVR, this.littleEndian, dicomCharsets);
        new DicomdirTagValue(4, 4608, "UL", 0L).write(mb, this.explicitVR, this.littleEndian, dicomCharsets);
        this.firstPatientOffset = mb.position() - 4;
        new DicomdirTagValue(4, 4610, "UL", 0L).write(mb, this.explicitVR, this.littleEndian, dicomCharsets);
        this.lastPatientOffset = mb.position() - 4;
        new DicomdirTagValue(4, 4626, "US", 0).write(mb, this.explicitVR, this.littleEndian, dicomCharsets);
        new DicomdirTagValue(4, 4640, "SQ").write(mb, this.explicitVR, this.littleEndian, dicomCharsets);
        this.initFileLength = mb.position();
        DicomdirTagValue.writeSeqEnd(mb);
        this.actualFileLength = mb.position();
        mb.position(this.initFileLength);
    }

    private void getFileMetaInformationProperties() {
        this.xferSyntax = Tap.getProperty("tap.dm.dicomdir.transfersyntax", "1.2.840.10008.1.2.1");
        this.implClassUID = Tap.getProperty("tap.dm.dicomdir.implclassuid", "1.2.840.113619.6.311");
        this.implVerName = Tap.getProperty("tap.dm.dicomdir.implvername", TAP_VERSION);
        this.srcAETitle = Tap.getProperty("tap.dm.dicomdir.srcaetitle", AE_TITLE);
        this.fileSetID = Tap.getProperty("tap.dm.dicomdir.filesetid", FILE_SET_ID);
        if ("1.2.840.10008.1.2.1".equals(this.xferSyntax)) {
            this.littleEndian = true;
            this.explicitVR = true;
        } else if ("1.2.840.10008.1.2.2".equals(this.xferSyntax)) {
            this.littleEndian = false;
            this.explicitVR = true;
        } else {
            Tap.log.log(Level.WARNING, "Illegal value for tap.dm.dicomdir.transfersyntax=" + this.xferSyntax + " . Defaulting to Explicit Little Endian Transfer Syntax.");
            this.xferSyntax = "1.2.840.10008.1.2.1";
            this.littleEndian = true;
            this.explicitVR = true;
        }
        if ("".equals(this.implClassUID) || !Dicomdir.isValidUID(this.implClassUID) || this.implClassUID.length() > 64) {
            Tap.log.log(Level.WARNING, "Illegal value for tap.dm.dicomdir.implclassuid=" + this.implClassUID + " . Defaulting to TAP Implementation Class UID.");
            this.implClassUID = "1.2.840.113619.6.311";
        }
        if ("".equals(this.implVerName) || !Dicomdir.isPureAscii(this.implVerName) || this.implVerName.length() > 16) {
            Tap.log.log(Level.WARNING, "Illegal value for tap.dm.dicomdir.implvername=" + this.implVerName + " . Defaulting to TAP Implementation Version Name.");
            this.implVerName = TAP_VERSION.length() > 16 ? TAP_VERSION.substring(0, 9) : TAP_VERSION;
        }
        if ("".equals(this.srcAETitle) || !Dicomdir.isPureAscii(this.srcAETitle) || this.srcAETitle.length() > 16) {
            Tap.log.log(Level.WARNING, "Illegal value for tap.dm.dicomdir.srcaetitle=" + this.srcAETitle + " . Defaulting to TAP Application Title.");
            this.srcAETitle = AE_TITLE;
        }
        if ("".equals(this.fileSetID) || !Dicomdir.isPureAscii(this.fileSetID) || this.fileSetID.length() > 16) {
            Tap.log.log(Level.WARNING, "Illegal value for tap.dm.dicomdir.filesetid=" + this.fileSetID + " . Defaulting to TAP FileSet ID.");
            this.fileSetID = FILE_SET_ID;
        }
    }

    public static boolean isValidUID(String uid) {
        boolean valid = true;
        for (int index = 0; valid && index < uid.length(); ++index) {
            char ch = uid.charAt(index);
            valid = Character.isDigit(ch) || '.' == ch;
        }
        return valid;
    }

    public static boolean isPureAscii(String str) {
        byte[] bytearray = str.getBytes();
        CharsetDecoder d2 = Charset.forName("US-ASCII").newDecoder();
        try {
            CharBuffer r2 = d2.decode(ByteBuffer.wrap(bytearray));
            r2.toString();
        }
        catch (CharacterCodingException e2) {
            return false;
        }
        return true;
    }

    private void createDirectoryEntities() {
        List<DirectoryRecord> patientDRs = this.createDirectoryRecords(PATIENT_LEVEL);
        if (patientDRs.size() == 0) {
            return;
        }
        int indexPat = 0;
        for (DirectoryRecord patientDR : patientDRs) {
            patientDR.index = ++indexPat;
            this.addDirectoryRecord(this.patientDE, patientDR);
            DirectoryRecord[] studyDRs = this.getChildDirectoryRecords(patientDR, STUDY_LEVEL);
            int indexStud = 0;
            if (studyDRs.length <= 0) continue;
            for (DirectoryRecord studyDR : studyDRs) {
                studyDR.index = ++indexStud;
                this.addDirectoryRecord(this.studyDE, studyDR);
                DirectoryRecord[] seriesDRs = this.getChildDirectoryRecords(studyDR, SERIES_LEVEL);
                int indexSer = 0;
                if (seriesDRs.length <= 0) continue;
                for (DirectoryRecord seriesDR : seriesDRs) {
                    seriesDR.index = ++indexSer;
                    this.addDirectoryRecord(this.seriesDE, seriesDR);
                    DirectoryRecord[] imageDRs = this.getChildDirectoryRecords(seriesDR, IMAGE_LEVEL);
                    int indexImg = 0;
                    if (imageDRs.length <= 0) continue;
                    for (DirectoryRecord imageDR : imageDRs) {
                        imageDR.index = ++indexImg;
                        this.addDirectoryRecord(this.imageDE, imageDR);
                    }
                }
            }
        }
    }

    private void addDirectoryRecord(Map<String, DirectoryRecord> deMap, DirectoryRecord dr) {
        String key = dr.id;
        if (deMap.containsKey(key)) {
            String msg = this.readOnly ? "." : ". Making DICOMDIR read-only.";
            Tap.log.log(Level.WARNING, "Invalid DICOMDIR. Duplicate Directory Records found for ID: " + key + msg);
            this.readOnly = true;
            key = key + dr.index;
        }
        deMap.put(key, dr);
    }

    private void loadTagsFromExistingDicomdir() {
        ArrayList<String> uniqueTypes = new ArrayList<String>();
        for (int i2 = 0; i2 < LEVEL_NAMES.length; ++i2) {
            Set<String> keys = this.directoryEntities.get(i2).keySet();
            for (String keyStr : keys) {
                DirectoryRecord dr = this.directoryEntities.get(i2).get(keyStr);
                if (uniqueTypes.contains(dr.type)) continue;
                uniqueTypes.add(dr.type);
                DirectoryRecordType drType = this.deLevels[i2].getDirectoryRecordType(dr.type);
                Set<tagValue> tags = drType.getTags();
                for (tagValue t2 : dr.tvs) {
                    if (4 == t2.group) continue;
                    DicomdirTagValue atv = new DicomdirTagValue(t2, 3, false);
                    tags.add(atv);
                }
                drType.setTags(tags);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String setEncoding(String compressionType) {
        if (compressionType == null) return NON_COMPRESSION;
        if (compressionType.equalsIgnoreCase(JPEG)) {
            return JPEG_LOSSLESS;
        }
        if (!compressionType.equalsIgnoreCase(NONE)) throw new IllegalArgumentException("Compression scheme not supported: " + compressionType);
        return NON_COMPRESSION;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getMountFilePath() {
        return this.dirMountPath;
    }

    public tagValue[] getHeaderTags() {
        return this.headerTags;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public DirectoryEntityLevel[] getDirectoryEntityLevels() {
        return this.deLevels;
    }

    public String getEncoding() {
        return this.encodingScheme;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public boolean isLittleEndian() {
        return this.littleEndian;
    }

    public boolean isExplicitVR() {
        return this.explicitVR;
    }

    protected ByteBuffer getBuffer() {
        return this.mb;
    }

    protected int getBufferPosition() {
        return this.mb.position();
    }

    public int getPadSize() {
        return this.padsize;
    }

    public int getInitFileLength() {
        return this.initFileLength;
    }

    public long getActualFileLength() {
        return this.actualFileLength;
    }

    protected void setActualFileLength(long newLength) {
        this.actualFileLength = newLength;
    }

    protected static int readValueAtOffset(ByteBuffer mb, int offset) {
        int currPos = mb.position();
        mb.position(offset);
        int value = mb.getInt() & 0xFFFFFFFF;
        mb.position(currPos);
        return value;
    }

    protected static void writeValueAtOffset(ByteBuffer mb, int offset, int value) {
        int curPos = mb.position();
        mb.position(offset);
        mb.putInt(value);
        mb.position(curPos);
    }

    public int getFirstPatientOffset() {
        return this.firstPatientOffset;
    }

    public int getFirstPatientOffsetValue() {
        return Dicomdir.readValueAtOffset(this.mb, this.firstPatientOffset);
    }

    protected void reWriteFirstPatientDROffset(int offset) {
        Dicomdir.writeValueAtOffset(this.mb, this.firstPatientOffset, offset);
    }

    public int getLastPatientOffset() {
        return this.lastPatientOffset;
    }

    public int getLastPatientOffsetValue() {
        return Dicomdir.readValueAtOffset(this.mb, this.lastPatientOffset);
    }

    protected void reWriteLastPatientDROffset(int offset) {
        Dicomdir.writeValueAtOffset(this.mb, this.lastPatientOffset, offset);
    }

    public DirectoryRecord getDirectoryRecordFromMap(int levelIndex, String id) {
        return this.directoryEntities.get(levelIndex).get(id);
    }

    public DirectoryRecord getDirectoryRecord(String level, long offset) {
        int levelIndex = DirectoryEntityLevel.getIndex(level);
        Map<String, DirectoryRecord> deMap = this.directoryEntities.get(levelIndex);
        Set<String> keys = deMap.keySet();
        for (String key : keys) {
            DirectoryRecord dr = deMap.get(key);
            if (offset != dr.myOffset) continue;
            return dr;
        }
        return null;
    }

    private List<DirectoryRecord> createDirectoryRecords(String level) {
        ArrayList<DirectoryRecord> list = new ArrayList<DirectoryRecord>();
        DirectoryRecord dr = this.readDirectoryRecord(this.initFileLength, null);
        if (dr == null) {
            return list;
        }
        DirectoryRecord[] siblings = this.getSiblingDirectoryRecords(dr, null);
        while (siblings.length > 0 && siblings[0].level != null && !level.equalsIgnoreCase(siblings[0].level)) {
            ArrayList<DirectoryRecord> childList = new ArrayList<DirectoryRecord>();
            for (int i2 = 0; i2 < siblings.length; ++i2) {
                DirectoryRecord[] children = this.getChildDirectoryRecords(siblings[i2]);
                if (children == null) continue;
                for (int j2 = 0; j2 < children.length; ++j2) {
                    childList.add(children[j2]);
                }
            }
            siblings = childList.toArray(new DirectoryRecord[childList.size()]);
        }
        list.addAll(Arrays.asList(siblings));
        return list;
    }

    public List<DirectoryRecord> getDirectoryRecords(String level) {
        int levelIndex = DirectoryEntityLevel.getIndex(level.trim().toUpperCase(LOCALE));
        Map<String, DirectoryRecord> levelMap = this.directoryEntities.get(levelIndex);
        ArrayList<DirectoryRecord> list = new ArrayList<DirectoryRecord>();
        for (String key : levelMap.keySet()) {
            list.add(levelMap.get(key));
        }
        return list;
    }

    public DirectoryRecord readDirectoryRecord(long position, DirectoryRecord parent) {
        int itemlen;
        int currPos = this.mb.position();
        this.mb.position((int)position);
        int group = this.mb.getShort() & 0xFFFF;
        int element = this.mb.getShort() & 0xFFFF;
        if (group != 65534 || element != 57344) {
            this.changeMBEndian();
            this.mb.position((int)position);
            group = this.mb.getShort() & 0xFFFF;
            element = this.mb.getShort() & 0xFFFF;
            if (group != 65534 || element != 57344) {
                this.changeMBEndian();
                this.mb.position(currPos);
                return null;
            }
        }
        int item_end = (itemlen = this.mb.getInt() & 0xFFFFFFFF) != -1 ? this.mb.position() + itemlen : Integer.MAX_VALUE;
        group = this.mb.getShort() & 0xFFFF;
        element = this.mb.getShort() & 0xFFFF;
        if (group == 65534 && element == 57565) {
            this.mb.position(currPos);
            return null;
        }
        TreeSet<DicomdirTagValue> tagList = new TreeSet<DicomdirTagValue>();
        DicomCharSet[] dicomCharsets = DicomCharSet.getDefaultCharSet();
        while (group != 65534 && element != 57344 || group != 65534 && element != 57357) {
            DicomdirTagValue tv = new DicomdirTagValue(group, element, this.mb, dicomCharsets);
            tagList.add(tv);
            if (tv.group == 8 && tv.element == 5) {
                dicomCharsets = DicomCharSet.getDicomCharSets((String)tv.value);
            }
            if (!this.mb.hasRemaining()) {
                return new DirectoryRecord(position, this.mb, this.dirMountPath, tagList, parent);
            }
            group = this.mb.getShort() & 0xFFFF;
            element = this.mb.getShort() & 0xFFFF;
            if (this.mb.position() <= item_end && group != 0) continue;
            break;
        }
        this.mb.getInt();
        this.mb.position(currPos);
        return new DirectoryRecord(position, this.mb, this.dirMountPath, tagList, parent);
    }

    private void changeMBEndian() {
        if (this.mb.order() == ByteOrder.BIG_ENDIAN) {
            this.mb.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            this.mb.order(ByteOrder.BIG_ENDIAN);
        }
    }

    public DirectoryRecord[] getChildDirectoryRecords(DirectoryRecord parent) {
        DirectoryRecord repChild = this.getRepChildDirectoryRecord(parent);
        if (repChild == null) {
            return new DirectoryRecord[0];
        }
        ArrayList<DirectoryRecord> children = new ArrayList<DirectoryRecord>();
        children.add(repChild);
        while (repChild.nextSibling > 0L) {
            repChild = this.readDirectoryRecord(repChild.nextSibling, parent);
            children.add(repChild);
        }
        return children.toArray(new DirectoryRecord[children.size()]);
    }

    public DirectoryRecord[] getChildDirectoryRecords(DirectoryRecord parent, String level) {
        DirectoryRecord[] children = this.getChildDirectoryRecords(parent);
        while (children.length > 0 && null != children[0].level && !level.equalsIgnoreCase(children[0].level)) {
            ArrayList<DirectoryRecord> childList = new ArrayList<DirectoryRecord>();
            for (int i2 = 0; i2 < children.length; ++i2) {
                DirectoryRecord[] lowerChildren = this.getChildDirectoryRecords(children[i2]);
                for (int j2 = 0; j2 < lowerChildren.length; ++j2) {
                    childList.add(lowerChildren[j2]);
                }
            }
            children = childList.toArray(new DirectoryRecord[childList.size()]);
        }
        return children;
    }

    public DirectoryRecord getRepChildDirectoryRecord(DirectoryRecord parent) {
        if (parent.firstChild > 0L) {
            return this.readDirectoryRecord(parent.firstChild, parent);
        }
        return null;
    }

    public DirectoryRecord[] getAllCompositeDirectoryRecords(DirectoryRecord parent) {
        if (null != parent.getRefFileIDPath()) {
            return new DirectoryRecord[]{parent};
        }
        ArrayList<DirectoryRecord> compList = new ArrayList<DirectoryRecord>();
        List<String> childLevels = DirectoryEntityLevel.getChildLevels(parent.level);
        for (String childLevel : childLevels) {
            DirectoryRecord[] children;
            for (DirectoryRecord child : children = this.getChildDirectoryRecords(parent, childLevel)) {
                if (null == child.getRefFileIDPath()) continue;
                compList.add(child);
            }
        }
        return compList.toArray(new DirectoryRecord[compList.size()]);
    }

    public DirectoryRecord[] getSiblingDirectoryRecordsFromFirst(DirectoryRecord dr) {
        ArrayList<DirectoryRecord> sibList = new ArrayList<DirectoryRecord>();
        if (this.directoryEntities.get(0).size() > 0) {
            DirectoryRecord parentDR = dr.parentDR;
            if (null == parentDR) {
                Set<String> keys = this.directoryEntities.get(0).keySet();
                for (String key : keys) {
                    sibList.add(this.directoryEntities.get(0).get(key));
                }
                return sibList.toArray(new DirectoryRecord[sibList.size()]);
            }
            return this.getChildDirectoryRecords(parentDR);
        }
        DirectoryRecord firstDR = null;
        if (PATIENT_LEVEL.equalsIgnoreCase(dr.level)) {
            int firstPatientOffset = this.getFirstPatientOffsetValue();
            firstDR = this.readDirectoryRecord(firstPatientOffset, null);
        } else {
            if (STUDY_LEVEL.equalsIgnoreCase(dr.level)) {
                firstDR = this.getParentDirectoryRecord(dr, PATIENT_LEVEL);
            } else if (SERIES_LEVEL.equalsIgnoreCase(dr.level)) {
                firstDR = this.getParentDirectoryRecord(dr, STUDY_LEVEL);
            } else if (IMAGE_LEVEL.equalsIgnoreCase(dr.level)) {
                firstDR = this.getParentDirectoryRecord(dr, SERIES_LEVEL);
            }
            if (firstDR == null) {
                return null;
            }
            firstDR = this.readDirectoryRecord(firstDR.firstChild, null);
        }
        if (firstDR == null) {
            return null;
        }
        return this.getSiblingDirectoryRecords(firstDR, null);
    }

    public DirectoryRecord[] getSiblingDirectoryRecords(DirectoryRecord dr, DirectoryRecord parent) {
        DirectoryRecord sibling = dr;
        ArrayList<DirectoryRecord> siblingList = new ArrayList<DirectoryRecord>();
        siblingList.add(sibling);
        while (sibling.nextSibling > 0L) {
            sibling = this.readDirectoryRecord(sibling.nextSibling, parent);
            siblingList.add(sibling);
        }
        return siblingList.toArray(new DirectoryRecord[siblingList.size()]);
    }

    public DirectoryRecord getParentDirectoryRecord(DirectoryRecord child, String parentLevel) {
        DirectoryRecord childDR = child;
        if (PATIENT_LEVEL.equalsIgnoreCase(child.level)) {
            childDR = this.patientDE.get(child.id);
        } else if (STUDY_LEVEL.equalsIgnoreCase(child.level)) {
            childDR = this.studyDE.get(child.id);
        } else if (SERIES_LEVEL.equalsIgnoreCase(child.level)) {
            childDR = this.seriesDE.get(child.id);
        } else if (IMAGE_LEVEL.equalsIgnoreCase(child.level)) {
            childDR = this.imageDE.get(child.id);
        }
        int index = DirectoryEntityLevel.getIndex(parentLevel);
        int numParentLevels = DirectoryEntityLevel.getParentLevels(childDR.level).size();
        DirectoryRecord parentDR = childDR.parentDR;
        for (int level = numParentLevels - 1; level >= index; --level) {
            parentDR = childDR.parentDR;
            if (null == parentDR) {
                return null;
            }
            if (level == index) {
                return parentDR;
            }
            childDR = childDR.parentDR;
        }
        return null;
    }

    protected void removeDirectoryRecordAndChildren(int levelIndex, DirectoryRecord dr) {
        ArrayList<DirectoryRecord> drsToRemove = new ArrayList<DirectoryRecord>();
        drsToRemove.add(dr);
        int numChildLevels = DirectoryEntityLevel.getChildLevels(LEVEL_NAMES[levelIndex]).size();
        for (int j2 = levelIndex + 1; j2 <= numChildLevels; ++j2) {
            Set<String> childKeys = this.directoryEntities.get(j2).keySet();
            for (String key : childKeys) {
                if (!drsToRemove.contains(this.directoryEntities.get((int)j2).get((Object)key).parentDR)) continue;
                drsToRemove.add(this.directoryEntities.get(j2).get(key));
            }
        }
        block2: for (DirectoryRecord toRemove : drsToRemove) {
            int thisLevel = DirectoryEntityLevel.getIndex(toRemove.level);
            this.directoryEntities.get(thisLevel).remove(toRemove.id);
            Set<String> keys = this.directoryEntities.get(thisLevel).keySet();
            for (String key : keys) {
                if (this.directoryEntities.get((int)thisLevel).get((Object)key).nextSibling != dr.myOffset) continue;
                this.directoryEntities.get((int)thisLevel).get((Object)key).nextSibling = dr.nextSibling;
                continue block2;
            }
        }
    }

    protected void insertDirectoryRecord(int levelIndex, DirectoryRecord dr) {
        this.directoryEntities.get(levelIndex).put(dr.id, dr);
    }

    protected int getNumberOfPatients() {
        return this.patientDE.size();
    }

    public List<Map<String, DirectoryRecord>> getDirectoryEntities() {
        return this.directoryEntities;
    }

    protected void updateMBAfterDeleteAll() throws IOException {
        this.mb.position(this.initFileLength);
        DicomdirTagValue.writeSeqEnd(this.mb);
        this.actualFileLength = this.mb.position();
    }

    protected void reMapFile(int pos) {
        try {
            this.out = new RandomAccessFile(new File(this.filePath).getAbsolutePath(), "rw");
            this.mb = this.out.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, this.out.length() + (long)this.padsize);
            this.mb.position(pos);
        }
        catch (IOException ioex) {
            Tap.log.log(Level.WARNING, "Unable to remap DICOMDIR buffer at position " + pos + " to be read-write.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        RandomAccessFile thisFile = null;
        try {
            this.actualFileLength = this.mb.position();
            Tap.log.log(Level.INFO, "Closing the file at file length: " + this.actualFileLength);
            this.directoryEntities.clear();
            if (this.mb.isDirect()) {
                ((DirectBuffer)((Object)this.mb)).cleaner().clean();
            }
            System.gc();
            if (!this.isReadOnly()) {
                this.out.getChannel().truncate(this.actualFileLength);
            }
            this.mb = null;
            this.out.close();
            this.out = null;
        }
        catch (IOException ioex) {
            Tap.log.log(Level.WARNING, "Error closing the DICOMDIR handler: ", ioex);
        }
        finally {
            if (null != thisFile) {
                try {
                    thisFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void deletePatient(DirectoryRecord patientDR) {
        boolean deleteAll = false;
        if ((long)this.initFileLength == patientDR.myOffset) {
            if (0L == patientDR.nextSibling) {
                this.reWriteFirstPatientDROffset(this.initFileLength);
                deleteAll = true;
                this.actualFileLength = this.initFileLength;
            } else {
                this.reWriteFirstPatientDROffset((int)patientDR.nextSibling);
            }
        } else {
            DirectoryRecord[] sibDRs = this.getSiblingDirectoryRecordsFromFirst(patientDR);
            for (int i2 = 0; i2 < sibDRs.length; ++i2) {
                if (sibDRs[i2].nextSibling != patientDR.myOffset) continue;
                sibDRs[i2].nextSibling = patientDR.nextSibling;
                sibDRs[i2].writeNextSiblingToDICOMDIR();
                break;
            }
        }
        this.deletePhysicalFiles(patientDR);
        this.removeDirectoryRecordAndChildren(DirectoryEntityLevel.getIndex(patientDR.level), patientDR);
        if (deleteAll) {
            try {
                this.updateMBAfterDeleteAll();
            }
            catch (IOException ioex) {
                Tap.log.log(Level.WARNING, "Unable to delete Directory Record: ", ioex);
            }
        }
    }

    protected void deletePhysicalFiles(DirectoryRecord dr) {
        int i2;
        DicomdirObject obj = new DicomdirObject(dr.level, this, dr.myOffset);
        DMiComposite[] cmps = obj.getComposites(null);
        ArrayList<MovedFile> moved = new ArrayList<MovedFile>();
        File mountDir = new File(this.getMountFilePath());
        int baseIndex = mountDir.getAbsolutePath().length();
        boolean fileMove = true;
        for (i2 = 0; i2 < cmps.length; ++i2) {
            File oldFile;
            String fileName = cmps[i2].getFilePath();
            String mvFile = mountDir.getAbsolutePath() + File.separator + REMOVE_FILES_DIR + fileName.substring(baseIndex, fileName.length());
            File finalFile = new File(mvFile);
            File parentFile = finalFile.getParentFile();
            if (null != parentFile && !parentFile.exists()) {
                parentFile.mkdirs();
            }
            if (!(oldFile = new File(fileName)).renameTo(finalFile)) {
                fileMove = false;
                break;
            }
            moved.add(new MovedFile(oldFile, finalFile));
        }
        if (fileMove) {
            String fileName = cmps[0].getFilePath();
            File parentFile = new File(fileName).getParentFile();
            File[] listFiles = SimpleUtilities.getFilesRecursively(parentFile);
            while (listFiles.length <= 0) {
                File tmp = parentFile.getParentFile();
                parentFile.delete();
                listFiles = SimpleUtilities.getFilesRecursively(tmp);
                parentFile = tmp;
                if (listFiles.length != 0) continue;
                SimpleUtilities.deleteFilesRecursively(tmp);
            }
            SimpleUtilities.deleteFilesRecursively(new File(mountDir.getAbsolutePath() + File.separator + REMOVE_FILES_DIR));
        } else {
            for (i2 = 0; i2 < moved.size(); ++i2) {
                MovedFile f2 = (MovedFile)moved.get(i2);
                f2.oldFile.renameTo(f2.newFile);
            }
        }
    }

    private class MovedFile {
        public File oldFile;
        public File newFile;

        public MovedFile(File oldFile, File newFile) {
            this.oldFile = oldFile;
            this.newFile = newFile;
        }
    }
}

