/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.dicomdir;

import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.util.dicom.DicomBytesBuilder;
import com.ge.med.terra.tap.util.dicom.DicomCharSet;
import com.ge.med.terra.tap.util.dicom.DicomWriter;
import com.ge.med.terra.tap.util.dicom.tagValue;
import com.ge.med.terra.tap.util.dicom.vr;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.logging.Level;

public class DicomdirTagValue
extends tagValue {
    private int type = 1;
    private boolean conditional = false;

    public DicomdirTagValue(tagValue tv) {
        super(tv);
    }

    public DicomdirTagValue(tagValue tv, int type, boolean conditional) {
        super(tv);
        this.type = type;
        this.conditional = conditional;
    }

    public DicomdirTagValue(int grp, int elem, int type, boolean conditional) {
        super(grp, elem);
        this.type = type;
        this.conditional = conditional;
    }

    public DicomdirTagValue(int g2, int e2, ByteBuffer out, DicomCharSet[] dicomCharsets) {
        super(g2, e2);
        this.fillInData(out, dicomCharsets);
    }

    public DicomdirTagValue(int grp, int elem, String vrStr, Integer value) {
        this.copyGEV(grp, elem, vrStr, value);
        switch (this.vrep) {
            case 21331: 
            case 21843: {
                this.len = 2;
                break;
            }
            case 21324: {
                this.len = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("Specified VR not valid for Integer type: \"" + vrStr + "\"");
            }
        }
    }

    public DicomdirTagValue(int grp, int elem, String vrStr, Long value) {
        this.copyGEV(grp, elem, vrStr, value);
        if (21836 != this.vrep) {
            throw new IllegalArgumentException("Specified VR not valid for Long type: " + vrStr);
        }
        this.len = 4;
    }

    public DicomdirTagValue(int grp, int elem, String vrStr, String value, DicomCharSet[] dicomCharsets) {
        this.copyGEV(grp, elem, vrStr, value);
        switch (this.vrep) {
            case 17473: {
                if (null != value && value.length() >= 8) {
                    this.value = value.substring(0, 8);
                    this.len = 8;
                    break;
                }
                throw new IllegalArgumentException("DA value must be 8 characters long: \"" + value + "\"");
            }
            case 16709: 
            case 16723: 
            case 17235: 
            case 17491: 
            case 17492: 
            case 18771: 
            case 19535: 
            case 19540: 
            case 20558: 
            case 21320: 
            case 21332: 
            case 21581: 
            case 21838: 
            case 21844: {
                this.valueAsBytes = DicomBytesBuilder.getDicomBytes(value, dicomCharsets);
                this.len = this.valueAsBytes.length;
                break;
            }
            case 21833: {
                this.valueAsBytes = DicomBytesBuilder.getDicomBytesWithNullPad(value, dicomCharsets);
                this.len = this.valueAsBytes.length;
                break;
            }
            default: {
                throw new IllegalArgumentException("Specified VR not valid for String type: \"" + vrStr + "\"");
            }
        }
    }

    public DicomdirTagValue(int grp, int elem, String vrStr, byte[] value) {
        this.copyGEV(grp, elem, vrStr, value);
        if (20290 != this.vrep) {
            throw new IllegalArgumentException("Specified VR not valid for byte[] type: \"" + vrStr + "\"");
        }
        this.len = value.length;
    }

    public DicomdirTagValue(int grp, int elem, String vrStr) {
        this.copyGEV(grp, elem, vrStr, null);
        if (21329 == this.vrep) {
            this.len = 0;
            if (grp == 4 && elem == 4640) {
                this.len = -1;
            }
        } else {
            throw new IllegalArgumentException("Specified VR not valid for Sequence type: \"" + vrStr + "\"");
        }
    }

    public int getType() {
        return this.type;
    }

    public boolean getConditionality() {
        return this.conditional;
    }

    private void copyGEV(int grp, int elm, String vrStr, Object val) {
        this.group = grp;
        this.element = elm;
        this.vrep = vr.StringVRint(vrStr);
        this.value = val;
    }

    public static void writeUnsignedShort(int value, ByteBuffer out) throws IOException {
        short val = (short)(value & Short.MAX_VALUE);
        if (value > val) {
            val = (short)(val | 0x8000);
        }
        out.putShort(val);
    }

    public static void writeUnsignedInt(long value, ByteBuffer out) throws IOException {
        int val = (int)(value & Integer.MAX_VALUE);
        if (value > (long)val) {
            val |= Integer.MIN_VALUE;
        }
        out.putInt(val);
    }

    private void fillInData(ByteBuffer mbStream, DicomCharSet[] dicomCharsets) {
        this.fileOffset = mbStream.position() - 4;
        if (this.group == 65534 || this.group == 65534) {
            this.len = mbStream.getInt() & 0xFFFFFFFF;
            return;
        }
        this.vrep = this.readVR(mbStream);
        if (this.vrep == 20290 || this.vrep == 20311 || this.vrep == 20294 || this.vrep == 21329 || this.vrep == 21844 || this.vrep == 21838) {
            mbStream.getShort();
            this.len = mbStream.getInt() & 0xFFFFFFFF;
        } else {
            this.len = mbStream.getShort() & 0xFFFF;
        }
        if (this.vrep == 21329) {
            int seq_end = this.len != -1 ? mbStream.position() + this.len : Integer.MAX_VALUE;
            ArrayList<DicomdirTagValue[]> seq = new ArrayList<DicomdirTagValue[]>(10);
            while (mbStream.position() < seq_end && mbStream.hasRemaining()) {
                int item_end;
                int seqGroup = mbStream.getShort() & 0xFFFF;
                int seqElem = mbStream.getShort() & 0xFFFF;
                int itemlen = mbStream.getInt() & 0xFFFFFFFF;
                if (seqGroup == 65534 && seqElem == 57565) break;
                ArrayList<DicomdirTagValue> item = new ArrayList<DicomdirTagValue>(10);
                int n2 = item_end = this.len != -1 ? mbStream.position() + itemlen : Integer.MAX_VALUE;
                while (mbStream.position() < item_end && mbStream.hasRemaining()) {
                    int grp = mbStream.getShort() & 0xFFFF;
                    int elem = mbStream.getShort() & 0xFFFF;
                    DicomdirTagValue st = new DicomdirTagValue(grp, elem, mbStream, dicomCharsets);
                    if (grp == 65534 && elem == 57357) break;
                    item.add(st);
                }
                seq.add(item.toArray(new DicomdirTagValue[item.size()]));
            }
            this.value = seq.toArray();
        } else {
            byte[] data = new byte[this.len];
            mbStream.get(data);
            this.setData(data, 0, mbStream.order() == ByteOrder.LITTLE_ENDIAN, true, dicomCharsets);
        }
    }

    private int readVR(ByteBuffer out) {
        int t1 = out.get() & 0xFF;
        int t2 = out.get() & 0xFF;
        return t1 << 8 | t2;
    }

    public static void writeItemBegin(ByteBuffer out) throws IOException {
        DicomdirTagValue.writeUnsignedShort(65534, out);
        DicomdirTagValue.writeUnsignedShort(57344, out);
        DicomdirTagValue.writeUnsignedInt(0xFFFFFFFFL, out);
    }

    public static void writeItemEnd(ByteBuffer out) throws IOException {
        DicomdirTagValue.writeUnsignedShort(65534, out);
        DicomdirTagValue.writeUnsignedShort(57357, out);
        DicomdirTagValue.writeUnsignedInt(0L, out);
    }

    public static void writeSeqEnd(ByteBuffer out) throws IOException {
        DicomdirTagValue.writeUnsignedShort(65534, out);
        DicomdirTagValue.writeUnsignedShort(57565, out);
        DicomdirTagValue.writeUnsignedInt(0L, out);
    }

    public int write(ByteBuffer out, boolean explicit, boolean littleEndian, DicomCharSet[] dicomCharsets) throws IOException {
        boolean write = true;
        if ((this.type == 1 && this.conditional || this.type == 3 && !this.conditional) && (null == this.value || "".equals(this.value))) {
            write = false;
            Tap.log.log(Level.INFO, "Skipping Tag type " + this.type + (this.conditional ? "C: " : ": ") + this);
        }
        int len = 0;
        if (write) {
            byte[] tagBytes = DicomWriter.getTagAsBytes(this, explicit, littleEndian);
            len += tagBytes.length;
            out.put(tagBytes);
            byte[] valueBytes = DicomWriter.getValueAsBytes(this, explicit, littleEndian, dicomCharsets);
            len += valueBytes.length;
            out.put(valueBytes);
        }
        return len;
    }
}

