/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.dicomdir;

import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.dicomdir.Dicomdir;
import com.ge.med.terra.tap.dm.dicomdir.DicomdirTagValue;
import com.ge.med.terra.tap.dm.dicomdir.DirectoryEntityLevel;
import com.ge.med.terra.tap.dm.dicomdir.EncapDocDirectoryRecordType;
import com.ge.med.terra.tap.dm.dicomdir.FiducialDirectoryRecordType;
import com.ge.med.terra.tap.dm.dicomdir.HL7StrucDocDirectoryRecordType;
import com.ge.med.terra.tap.dm.dicomdir.HangingProtocolDirectoryRecordType;
import com.ge.med.terra.tap.dm.dicomdir.ImageDirectoryRecordType;
import com.ge.med.terra.tap.dm.dicomdir.KeyObjectDocDirectoryRecordType;
import com.ge.med.terra.tap.dm.dicomdir.PaletteDirectoryRecordType;
import com.ge.med.terra.tap.dm.dicomdir.PatientDirectoryRecordType;
import com.ge.med.terra.tap.dm.dicomdir.PresentationDirectoryRecordType;
import com.ge.med.terra.tap.dm.dicomdir.PrivateDirectoryRecordType;
import com.ge.med.terra.tap.dm.dicomdir.RTDoseDirectoryRecordType;
import com.ge.med.terra.tap.dm.dicomdir.RTPlanDirectoryRecordType;
import com.ge.med.terra.tap.dm.dicomdir.RTStructureSetDirectoryRecordType;
import com.ge.med.terra.tap.dm.dicomdir.RTTreatRecordDirectoryRecordType;
import com.ge.med.terra.tap.dm.dicomdir.RawDataDirectoryRecordType;
import com.ge.med.terra.tap.dm.dicomdir.RegistrationDirectoryRecordType;
import com.ge.med.terra.tap.dm.dicomdir.SRDocumentDirectoryRecordType;
import com.ge.med.terra.tap.dm.dicomdir.SeriesDirectoryRecordType;
import com.ge.med.terra.tap.dm.dicomdir.SpectroscopyDirectoryRecordType;
import com.ge.med.terra.tap.dm.dicomdir.StereometricDirectoryRecordType;
import com.ge.med.terra.tap.dm.dicomdir.StudyDirectoryRecordType;
import com.ge.med.terra.tap.dm.dicomdir.ValueMapDirectoryRecordType;
import com.ge.med.terra.tap.dm.dicomdir.WaveformDirectoryRecordType;
import com.ge.med.terra.tap.util.dicom.dicomParser;
import com.ge.med.terra.tap.util.dicom.jdbDicomDict;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Level;

public abstract class DirectoryRecordType {
    public static final String SOP_LUT_FILENAME = "sop_classes.properties";
    public static final String DR_TYPES_TAGS_FILENAME = "directory_record_types.properties";
    public static final String PATIENT = "PATIENT";
    public static final String STUDY = "STUDY";
    public static final String SERIES = "SERIES";
    public static final String IMAGE = "IMAGE";
    public static final String RT_DOSE = "RT DOSE";
    public static final String RT_PLAN = "RT PLAN";
    public static final String RT_STRUC_SET = "RT STRUCTURE SET";
    public static final String RT_TREAT_REC = "RT TREAT RECORD";
    public static final String PRESENTATION = "PRESENTATION";
    public static final String REGISTRATION = "REGISTRATION";
    public static final String WAVEFORM = "WAVEFORM";
    public static final String SR_DOCUMENT = "SR DOCUMENT";
    public static final String PALETTE = "PALETTE";
    public static final String RAW_DATA = "RAW DATA";
    public static final String FIDUCIAL = "FIDUCIAL";
    public static final String HANGING_PROTOCOL = "HANGING PROTOCOL";
    public static final String ENCAP_DOC = "ENCAP DOC";
    public static final String KEY_OBJECT_DOC = "KEY OBJECT DOC";
    public static final String SPECTROSCOPY = "SPECTROSCOPY";
    public static final String VALUE_MAP = "VALUE MAP";
    public static final String STEREOMETRIC = "STEREOMETRIC";
    public static final String HL7_STRUC_DOC = "HL7 STRUC DOC";
    public static final String PRIVATE = "PRIVATE";
    public static final String DATESTR = "18880808";
    public static final String TIMESTR = "000000.000";
    public static final String UNDEFSTR = "UNDEFINED";
    protected static final Locale LOCALE = Locale.ENGLISH;
    protected static final jdbDicomDict dict = new jdbDicomDict();
    protected static final Map<String, Class<?>> drTypeClassMap = new HashMap<String, Class<?>>(){
        {
            this.put(DirectoryRecordType.PATIENT, PatientDirectoryRecordType.class);
            this.put(DirectoryRecordType.STUDY, StudyDirectoryRecordType.class);
            this.put(DirectoryRecordType.SERIES, SeriesDirectoryRecordType.class);
            this.put(DirectoryRecordType.IMAGE, ImageDirectoryRecordType.class);
            this.put(DirectoryRecordType.RT_DOSE, RTDoseDirectoryRecordType.class);
            this.put(DirectoryRecordType.RT_PLAN, RTPlanDirectoryRecordType.class);
            this.put(DirectoryRecordType.RT_STRUC_SET, RTStructureSetDirectoryRecordType.class);
            this.put(DirectoryRecordType.RT_TREAT_REC, RTTreatRecordDirectoryRecordType.class);
            this.put(DirectoryRecordType.PRESENTATION, PresentationDirectoryRecordType.class);
            this.put(DirectoryRecordType.REGISTRATION, RegistrationDirectoryRecordType.class);
            this.put(DirectoryRecordType.WAVEFORM, WaveformDirectoryRecordType.class);
            this.put(DirectoryRecordType.SR_DOCUMENT, SRDocumentDirectoryRecordType.class);
            this.put(DirectoryRecordType.PALETTE, PaletteDirectoryRecordType.class);
            this.put(DirectoryRecordType.RAW_DATA, RawDataDirectoryRecordType.class);
            this.put(DirectoryRecordType.FIDUCIAL, FiducialDirectoryRecordType.class);
            this.put(DirectoryRecordType.HANGING_PROTOCOL, HangingProtocolDirectoryRecordType.class);
            this.put(DirectoryRecordType.ENCAP_DOC, EncapDocDirectoryRecordType.class);
            this.put(DirectoryRecordType.KEY_OBJECT_DOC, KeyObjectDocDirectoryRecordType.class);
            this.put(DirectoryRecordType.SPECTROSCOPY, SpectroscopyDirectoryRecordType.class);
            this.put(DirectoryRecordType.VALUE_MAP, ValueMapDirectoryRecordType.class);
            this.put(DirectoryRecordType.STEREOMETRIC, StereometricDirectoryRecordType.class);
            this.put(DirectoryRecordType.HL7_STRUC_DOC, HL7StrucDocDirectoryRecordType.class);
            this.put(DirectoryRecordType.PRIVATE, PrivateDirectoryRecordType.class);
        }
    };
    private static Properties dicomdirSOPProps = null;
    private static Properties dicomdirTagProps = null;
    private String name;
    private Set<tagValue> tags;
    private static dicomParser dp = new dicomParser();

    public DirectoryRecordType(String drTypeName) {
        this.name = drTypeName.trim().toUpperCase(LOCALE);
        DirectoryRecordType.loadProperties();
        this.tags = this.createDefaultTagList();
        this.tags.addAll(DirectoryRecordType.getOptionalTags(this.name));
    }

    public String getName() {
        return this.name;
    }

    protected abstract Set<tagValue> createDefaultTagList();

    public Set<tagValue> getTags() {
        return this.tags;
    }

    public void setTags(Set<tagValue> tags) {
        this.tags = tags;
    }

    protected Set<tagValue> getValues(String dicomFilePath) {
        this.fillTags(dicomFilePath);
        DicomdirTagValue[] ddirTags = this.tags.toArray(new DicomdirTagValue[0]);
        for (int i2 = 0; i2 < ddirTags.length; ++i2) {
            if (ddirTags[i2].getType() != 1 && ddirTags[i2].getType() != 2 || ddirTags[i2].getConditionality()) continue;
            this.checkAndFixValue(ddirTags[i2]);
        }
        return this.tags;
    }

    public static Set<DicomdirTagValue> getOptionalTags(String drTypeKey) {
        String drKey = DirectoryRecordType.processDirectoryRecordTypeName(drTypeKey);
        String defaultTagStr = dicomdirTagProps.getProperty(drKey);
        String addlTagStr = Tap.getProperty("tap.dm.dicomdir.drtype." + drKey + ".tags");
        TreeSet<DicomdirTagValue> optionalTagSet = new TreeSet<DicomdirTagValue>();
        DirectoryRecordType.addOptionalTags(defaultTagStr, optionalTagSet);
        DirectoryRecordType.addOptionalTags(addlTagStr, optionalTagSet);
        return optionalTagSet;
    }

    private static void addOptionalTags(String tagStr, Set<DicomdirTagValue> tagSet) {
        int type_3 = 3;
        int type_2 = 2;
        String flagStr = "r";
        boolean conditionality = false;
        if (null != tagStr && tagStr.length() > 0) {
            StringTokenizer st = new StringTokenizer(tagStr, "+");
            while (st.hasMoreTokens()) {
                StringTokenizer comma = new StringTokenizer(st.nextToken(), ",");
                String grp = null;
                String elem = null;
                String flag = null;
                int nTokens = comma.countTokens();
                grp = comma.nextToken();
                elem = comma.nextToken();
                if (nTokens == 3) {
                    flag = comma.nextToken();
                }
                tagSet.add(new DicomdirTagValue(Integer.parseInt(grp, 16), Integer.parseInt(elem, 16), "r".equals(flag) ? 2 : 3, false));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillTags(String dicomFilePath) {
        try {
            tagValue[] tagArray = this.tags.toArray(new DicomdirTagValue[0]);
            dp.setFile(dicomFilePath);
            dp.fill(tagArray);
            dp.clearFile();
            if (this.name.equalsIgnoreCase(STUDY)) {
                dp.setFile(dicomFilePath);
                dp.fill(StudyDirectoryRecordType.tagList);
                dp.clearFile();
            }
        }
        catch (FileNotFoundException ex) {
            Tap.log.log(Level.WARNING, "Error loading values for tags: ", ex);
        }
        finally {
            dp.clearFile();
        }
    }

    protected void checkAndFixValue(DicomdirTagValue tag2) {
        Object[] val;
        if (tag2.vrep == 0) {
            tag2.vrep = dict.getVR(tag2.group, tag2.element);
        }
        if (null == tag2.value || "".equals(tag2.value)) {
            tag2.value = this.getDefaultValue(tag2);
            int n2 = tag2.len = null == tag2.value ? 0 : tag2.value.toString().length();
            if ((tag2.len & 1) != 0) {
                ++tag2.len;
            }
            tag2.valueAsBytes = null;
        } else if (tag2.vrep == 21329 && (val = (Object[])tag2.value).length == 0) {
            tag2.len = 0;
            tag2.value = null;
        }
    }

    protected abstract Object getDefaultValue(DicomdirTagValue var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void loadProperties() {
        String addlSOPClassUIDs;
        InputStream inStream;
        if (null == dicomdirTagProps) {
            dicomdirTagProps = new Properties();
            inStream = null;
            try {
                Tap.log.log(Level.INFO, "Loading {0}...", DR_TYPES_TAGS_FILENAME);
                inStream = DirectoryRecordType.class.getResourceAsStream(DR_TYPES_TAGS_FILENAME);
                dicomdirTagProps.load(inStream);
                inStream.close();
            }
            catch (IOException ioex) {
                Tap.log.log(Level.WARNING, "Error loading directory_record_types.properties: ", ioex);
            }
            catch (NullPointerException ex) {
                Tap.log.log(Level.WARNING, "File not found: directory_record_types.properties");
            }
            finally {
                if (null != inStream) {
                    try {
                        inStream.close();
                    }
                    catch (Exception ex) {}
                }
            }
        }
        if (null == dicomdirSOPProps) {
            dicomdirSOPProps = new Properties();
            inStream = null;
            try {
                Tap.log.log(Level.INFO, "Loading {0}...", SOP_LUT_FILENAME);
                inStream = DirectoryRecordType.class.getResourceAsStream(SOP_LUT_FILENAME);
                dicomdirSOPProps.load(inStream);
                inStream.close();
            }
            catch (IOException ioex) {
                Tap.log.log(Level.WARNING, "Error loading sop_classes.properties: ", ioex);
            }
            catch (NullPointerException ex) {
                Tap.log.log(Level.WARNING, "File not found: sop_classes.properties");
            }
            finally {
                if (null != inStream) {
                    try {
                        inStream.close();
                    }
                    catch (Exception ex) {}
                }
            }
        }
        if (null != (addlSOPClassUIDs = Tap.getProperty("tap.dm.dicomdir.sopclass"))) {
            String[] sopDRTypes;
            for (String s2 : sopDRTypes = addlSOPClassUIDs.trim().split("\\+")) {
                String[] arr = s2.split("\\:");
                dicomdirSOPProps.put(arr[0], arr[1]);
            }
        }
    }

    public static String processDirectoryRecordTypeName(String drTypeName) {
        return drTypeName.trim().toUpperCase(LOCALE).replace(" ", "_");
    }

    public static String getDirectoryRecordTypeName(String sopClass) {
        if (null != sopClass && sopClass.length() > 0) {
            DirectoryRecordType.loadProperties();
            String drType = dicomdirSOPProps.getProperty(sopClass);
            if (null != drType) {
                return drType.toUpperCase(LOCALE);
            }
        }
        throw new IllegalArgumentException("Unsupported SOP Class: \"" + sopClass + "\"");
    }

    public static String getLevel(String drTypeName) {
        for (int i2 = 0; i2 < Dicomdir.LEVEL_NAMES.length; ++i2) {
            Set<String> tmpDRTypes = DirectoryEntityLevel.getAllDirectoryRecordTypeNames(Dicomdir.LEVEL_NAMES[i2]);
            if (!tmpDRTypes.contains(drTypeName.trim().toUpperCase(LOCALE))) continue;
            return Dicomdir.LEVEL_NAMES[i2];
        }
        return null;
    }

    public static int getLevelIndex(String drTypeName) {
        String levelName = DirectoryRecordType.getLevel(drTypeName);
        if (null == levelName) {
            throw new IllegalArgumentException("No Directory Entity Level found for Directory Record Type: \"" + drTypeName + "\"");
        }
        return DirectoryEntityLevel.getIndex(levelName);
    }

    public String toString() {
        String str = "[type name=\"" + this.name + "\", # Tags=" + this.tags.size() + "]";
        return str;
    }
}

