/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.dicomdir;

import com.ge.med.terra.tap.dm.dicomdir.DicomdirTagValue;
import com.ge.med.terra.tap.dm.dicomdir.DirectoryRecordType;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.util.Set;
import java.util.TreeSet;

public class RTDoseDirectoryRecordType
extends DirectoryRecordType {
    private static final DicomdirTagValue charSetTag = new DicomdirTagValue(8, 5, 1, true);
    private static final DicomdirTagValue instanceNumberTag = new DicomdirTagValue(32, 19, 1, false);
    private static final DicomdirTagValue doseSummationTag = new DicomdirTagValue(12292, 10, 1, false);
    private static int dummyInstNumber = 9998;

    public RTDoseDirectoryRecordType() {
        super("RT DOSE");
    }

    @Override
    protected Set<tagValue> createDefaultTagList() {
        TreeSet<tagValue> tagSet = new TreeSet<tagValue>();
        tagSet.add(charSetTag);
        tagSet.add(instanceNumberTag);
        tagSet.add(doseSummationTag);
        return tagSet;
    }

    @Override
    protected Object getDefaultValue(DicomdirTagValue atv) {
        if (atv.getType() == 2) {
            return null;
        }
        if (atv.compareTo(instanceNumberTag) == 0) {
            return Integer.toString(++dummyInstNumber);
        }
        if (atv.compareTo(doseSummationTag) == 0) {
            return "UNDEFINED";
        }
        throw new IllegalArgumentException("Unable to provide default value for " + atv);
    }
}

