/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.dmtest;

import com.ge.med.terra.tap.dm.DMEvent;
import com.ge.med.terra.tap.dm.DMEventListener;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.util.SimpleUtilities;
import com.ge.med.terra.tap.util.dicom.ImageCreator;

public class NMPerfCheck {
    long start = 0L;
    long end;
    int[] pttags = new int[]{16, 32, 8, 32, 16, 16, 9, 4123, 9, 4115, 9, 4116};
    int[] imtags = new int[]{16, 16, 16, 32, 9, 4116, 8, 32, 8, 4144, 1, 1};
    DMTag[] ptTags = new DMTag[this.pttags.length / 2];
    DMTag[] imTags = new DMTag[this.imtags.length / 2];
    DMSession ses = new DMSession(new String[]{"terra", "terradb", "localhost"});
    ImageCreator ic;

    public NMPerfCheck() {
        int i2;
        for (i2 = 0; i2 < this.ptTags.length; ++i2) {
            this.ptTags[i2] = new DMTag(this.pttags[2 * i2], this.pttags[2 * i2 + 1]);
        }
        for (i2 = 0; i2 < this.imTags.length; ++i2) {
            this.imTags[i2] = new DMTag(this.imtags[2 * i2], this.imtags[2 * i2 + 1]);
        }
        this.ses.addDMEventListener(1, new DMEventListener(){

            @Override
            public void actionPerformed(DMEvent e2) {
                System.out.println(">>>>start= " + NMPerfCheck.this.start);
                if (NMPerfCheck.this.start > 0L) {
                    NMPerfCheck.this.doPatientTableQuery();
                    System.out.println("elapsed time= " + (NMPerfCheck.this.end - NMPerfCheck.this.start) + " ms");
                }
            }
        });
        this.ses.addDMEventListener(2, new DMEventListener(){

            @Override
            public void actionPerformed(DMEvent e2) {
                System.out.println("General Event: " + e2.getSource());
            }
        });
    }

    public void doPatientTableQuery() {
        DMObject[] studies = this.ses.getRelated("study");
        int i2 = 0;
        for (i2 = 0; i2 < studies.length && i2 < 20; ++i2) {
            for (int j2 = 0; j2 < this.ptTags.length; ++j2) {
                Object value = studies[i2].getValue(this.ptTags[j2]);
            }
        }
        System.out.println("read " + this.ptTags.length + " tags from " + i2 + " studies");
        this.end = System.currentTimeMillis();
    }

    public void doImageManagementQuery() {
        DMObject[] patients = this.ses.getRelated("patient");
        for (int i2 = 0; i2 < patients.length && i2 < 20; ++i2) {
            for (int j2 = 0; j2 < this.imTags.length; ++j2) {
                Object value = patients[i2].getValue(this.imTags[j2]);
            }
        }
        this.end = System.currentTimeMillis();
    }

    public void cleanDB() {
        DMObject[] pats = this.ses.getChildren();
        for (int i2 = 0; i2 < pats.length; ++i2) {
            pats[i2].delete();
        }
    }

    public void setupDB(int patientCnt, int studyCnt, int seriesCnt, int imageCnt) throws Exception {
        if (this.ic == null) {
            this.ic = new ImageCreator();
        }
        this.ic.install(patientCnt, studyCnt, seriesCnt, imageCnt, this.ses);
    }

    public static void main(String[] args) {
        NMPerfCheck nmpt = new NMPerfCheck();
        try {
            nmpt.cleanDB();
            nmpt.setupDB(1, 499, 1, 2);
            SimpleUtilities.sleep(30000L);
            nmpt.start = System.currentTimeMillis();
            nmpt.setupDB(1, 1, 1, 1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

