/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.hyperpesi;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;

public class HyperPesiObjectStore {
    public static final boolean dbg = false;
    private File cacheFile;
    private File deltaFile;
    Hashtable<String, HashMap<String, Object>> cache = new Hashtable();
    public static final String DBCACHE = "vCache";
    public static final String DBDELTA = "vDelta";
    public static final String NULLSTR = "XXnullXX";
    public static final String DELSTR = "DEL";
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public HyperPesiObjectStore(String dir) {
        this.load(dir);
    }

    public File getCacheFile() {
        return this.cacheFile;
    }

    public File getDeltaFile() {
        return this.deltaFile;
    }

    public Hashtable<String, HashMap<String, Object>> getMap() {
        return this.cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reconcile() {
        RandomAccessFile raf = null;
        try {
            boolean rename;
            boolean del;
            FileLock flock = null;
            raf = new RandomAccessFile(this.deltaFile, "rw");
            FileChannel fc = raf.getChannel();
            do {
                if ((flock = fc.tryLock(0L, Long.MAX_VALUE, true)) != null) continue;
                Thread.sleep(10L);
            } while (flock == null);
            this.readProp(this.deltaFile);
            raf.setLength(0L);
            flock.release();
            raf.close();
            File tmp = File.createTempFile(DBCACHE, "tmp", this.cacheFile.getParentFile());
            this.writeCache(tmp);
            if (this.cacheFile.exists() && !(del = this.cacheFile.delete())) {
                StackTraceElement st = new Throwable().getStackTrace()[0];
                System.err.println("(" + st.getFileName() + ":" + st.getLineNumber() + ") " + "delete fail " + this.cacheFile);
            }
            if (!(rename = tmp.renameTo(this.cacheFile))) {
                System.err.println("rename fail " + tmp);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            if (null != raf) {
                try {
                    raf.close();
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                }
            }
        }
    }

    protected void load(String dir) {
        this.cacheFile = new File(dir, DBCACHE);
        this.deltaFile = new File(dir, DBDELTA);
        this.readProp(this.cacheFile);
        this.readProp(this.deltaFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readProp(File propFile) {
        Properties prop = new Properties(){

            @Override
            public synchronized Object put(Object key, Object value) {
                String skey = (String)key;
                String[] s2 = skey.split("\\.");
                if (HyperPesiObjectStore.NULLSTR.equals(value)) {
                    HyperPesiObjectStore.this.setValue(s2[0], s2[1], null);
                } else {
                    HyperPesiObjectStore.this.setValue(s2[0], s2[1], value);
                }
                return value;
            }
        };
        FileReader fr = null;
        try {
            if (propFile.exists()) {
                fr = new FileReader(propFile);
                prop.load(fr);
                fr.close();
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            if (null != fr) {
                try {
                    fr.close();
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                }
            }
        }
    }

    private static String saveConvert(String theString) {
        boolean escapeSpace = true;
        boolean escapeUnicode = false;
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuffer outBuffer = new StringBuffer(bufLen);
        block8: for (int x2 = 0; x2 < len; ++x2) {
            char aChar = theString.charAt(x2);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue;
                }
                outBuffer.append(aChar);
                continue;
            }
            switch (aChar) {
                case ' ': {
                    if (x2 == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    outBuffer.append('\\');
                    outBuffer.append(aChar);
                    continue block8;
                }
                default: {
                    if ((aChar < ' ' || aChar > '~') & escapeUnicode) {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(HyperPesiObjectStore.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(HyperPesiObjectStore.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(HyperPesiObjectStore.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(HyperPesiObjectStore.toHex(aChar & 0xF));
                        continue block8;
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    protected void setValue(String pseid, String tag2, Object value) {
        HashMap<String, Object> map = this.cache.get(pseid);
        if (map == null) {
            map = new HashMap();
            this.cache.put(pseid, map);
        }
        map.put(tag2, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(String pseid, int group, int element, Object value) {
        String tag2 = this.buildTag(group, element);
        this.setValue(pseid, tag2, value);
        OutputStreamWriter fw = null;
        try {
            if (!this.deltaFile.exists()) {
                this.deltaFile.createNewFile();
            }
            fw = new FileWriter(this.deltaFile, true);
            fw.write(pseid + "." + this.buildTag(group, element) + "=" + (value == null ? NULLSTR : HyperPesiObjectStore.saveConvert(value.toString())) + "\n");
            fw.close();
        }
        catch (IOException e2) {
            System.err.println("For file " + this.deltaFile.getAbsolutePath());
            e2.printStackTrace();
        }
        finally {
            if (null != fw) {
                try {
                    fw.close();
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                }
            }
        }
    }

    protected String buildTag(int group, int element) {
        return "0x" + Integer.toHexString(group) + "_0x" + Integer.toHexString(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCache(File f2) {
        FileWriter fw = null;
        try {
            fw = new FileWriter(f2, true);
            Enumeration<String> keys = this.cache.keys();
            String toWrite = null;
            while (keys.hasMoreElements()) {
                String pseid = keys.nextElement();
                HashMap<String, Object> valueMap = this.cache.get(pseid);
                Set<String> keys2 = valueMap.keySet();
                for (String tag2 : keys2) {
                    String value = (String)valueMap.get(tag2);
                    toWrite = pseid + "." + tag2 + "=" + value + "\n";
                    fw.write(toWrite);
                }
            }
            fw.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        finally {
            if (null != fw) {
                try {
                    fw.close();
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                }
            }
        }
    }

    public Object getValue(String pseid, int group, int element) {
        HashMap<String, Object> c2 = this.cache.get(pseid);
        if (c2 == null) {
            return null;
        }
        Object o2 = c2.get(this.buildTag(group, element));
        return o2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String pseid) {
        this.cache.remove(pseid);
        BufferedReader reader = null;
        BufferedWriter writer = null;
        try {
            String currentLine;
            File tmp = File.createTempFile(DBDELTA, "tmpDelta", this.deltaFile.getParentFile());
            reader = new BufferedReader(new FileReader(this.deltaFile));
            writer = new BufferedWriter(new FileWriter(tmp));
            while ((currentLine = reader.readLine()) != null) {
                String trimmedLine = currentLine.trim();
                if (trimmedLine.indexOf(pseid) >= 0) continue;
                writer.write(currentLine + "\n");
            }
            writer.close();
            reader.close();
            this.deltaFile.delete();
            tmp.renameTo(this.deltaFile);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                }
            }
            if (null != writer) {
                try {
                    writer.close();
                }
                catch (Exception e4) {
                    e4.printStackTrace();
                }
            }
        }
    }

    public static void dumpFile(String file) {
        System.out.println("================= " + file + " =================");
        try {
            String s2;
            FileReader fr = new FileReader(file);
            LineNumberReader lnr = new LineNumberReader(fr);
            while ((s2 = lnr.readLine()) != null) {
                System.out.println(s2);
            }
            lnr.close();
            fr.close();
        }
        catch (Exception e2) {
            System.out.println("Not found " + e2);
        }
        System.out.println("=============================================");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Properties prop = new Properties();
        prop.setProperty("P32.0x" + Integer.toHexString(16) + "_0x" + Integer.toHexString(16) + "", "Billy^bob");
        prop.setProperty("P2.0x" + Integer.toHexString(16) + "_0x" + Integer.toHexString(16) + "", "Wrong^Name");
        prop.setProperty("P1.0x" + Integer.toHexString(16) + "_0x" + Integer.toHexString(16) + "", "test");
        String dir = System.getProperty("java.io.tmpdir");
        String cacheName = dir + DBCACHE;
        String deltaName = dir + DBDELTA;
        new File(deltaName).delete();
        System.out.println("using \"" + dir + "\"");
        FileOutputStream c2 = null;
        try {
            c2 = new FileOutputStream(cacheName);
            prop.store(c2, "test");
            c2.close();
            HyperPesiObjectStore.dumpFile(cacheName);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        finally {
            if (null != c2) {
                try {
                    c2.close();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        System.out.println("read HpObjectStore");
        HyperPesiObjectStore dprop = new HyperPesiObjectStore(dir);
        System.out.println("Loaded Cache into HashMap...");
        System.out.println("Printing HashMap Contents.....");
        System.out.println("using cache P2.0x10_0x10   = " + dprop.getValue("P2", 16, 16));
        System.out.println("using cache P32.0x10_0x10  = " + dprop.getValue("P32", 16, 16));
        System.out.println("using cache P1.0x10_0x10 = " + dprop.getValue("P1", 16, 16));
        HyperPesiObjectStore hprop = new HyperPesiObjectStore(dir);
        hprop.setValue("P2", 16, 16, "Right^Name");
        hprop.setValue("P3", 16, 16, "New^Name");
        System.out.println("Printing Delta Text file contents....");
        HyperPesiObjectStore.dumpFile(cacheName);
        HyperPesiObjectStore.dumpFile(deltaName);
        System.out.println("using cache P2.0x10_0x10    = " + hprop.getValue("P2", 16, 16));
        System.out.println("using cache P32.0x10_0x10   = " + hprop.getValue("P32", 16, 16));
        System.out.println("using cache P1.0x10_0x10    = " + hprop.getValue("P1", 16, 16));
        System.out.println("using cache P1.0x10_0x10    = " + hprop.getValue("P3", 16, 16));
        hprop.reconcile();
        HyperPesiObjectStore.dumpFile(cacheName);
        HyperPesiObjectStore.dumpFile(deltaName);
    }
}

