/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.list;

import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import com.ge.med.terra.tap.dm.list.ListComposite;
import com.ge.med.terra.tap.dm.list.ListSession;
import com.ge.med.terra.tap.dm.peer.DMiComposite;
import com.ge.med.terra.tap.dm.peer.DMiImage;
import com.ge.med.terra.tap.dm.peer.DMiObject;
import com.ge.med.terra.tap.dm.peer.DMiObjectReceiver;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class ListObject
implements DMiObject,
DMTagValueInterface {
    protected ListSession session;
    protected DMiObject dmo;
    protected String id;

    public ListObject(String id, DMiObject dmo, ListSession session) {
        this.id = id;
        this.dmo = dmo;
        this.session = session;
    }

    @Override
    public void attach() {
        this.dmo.attach();
    }

    @Override
    public void delete() {
        this.session.dbData.remove(this.id);
    }

    @Override
    public void detach() {
        this.dmo.detach();
    }

    @Override
    public DMiComposite[] getComposites(DMQuery q2) {
        DMiComposite[] dmc = this.dmo.getComposites(q2);
        DMiComposite[] result = new ListComposite[dmc.length];
        for (int i2 = 0; i2 < dmc.length; ++i2) {
            result[i2] = new ListComposite(this.getID() + "|" + dmc[i2].getID(), dmc[i2], this.session);
        }
        return result;
    }

    protected String getOriginalId() {
        return this.dmo.getID();
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public DMiImage[] getImages(DMTag[] tags) {
        ListComposite[] dmc = (ListComposite[])this.getComposites(null);
        ArrayList<DMiImage> result = new ArrayList<DMiImage>(dmc.length);
        for (int i2 = 0; i2 < dmc.length; ++i2) {
            DMiImage[] images = dmc[i2].getImages(tags);
            for (int j2 = 0; j2 < images.length; ++j2) {
                result.add(images[j2]);
            }
        }
        return result.toArray(new DMiImage[result.size()]);
    }

    @Override
    public int getLock() {
        return this.dmo.getLock();
    }

    @Override
    public int getNumberOfComposites(DMQuery q2) {
        return this.dmo.getNumberOfComposites(q2);
    }

    @Override
    public int getNumberOfRelated(String ieType, DMQuery q2) {
        return this.dmo.getNumberOfRelated(ieType, q2);
    }

    @Override
    public BufferedImage[] getPixelData(DMTag[] tags) {
        return this.dmo.getPixelData(tags);
    }

    @Override
    public void getRelated(String type, DMQuery q2, DMiObjectReceiver cb) {
        final DMiObjectReceiver orgCb = cb;
        DMiObjectReceiver dor = new DMiObjectReceiver(){

            @Override
            public boolean gotOne(DMiObject dmo) {
                return orgCb.gotOne(ListObject.this.session.createListObject(ListObject.this.getID(), dmo));
            }
        };
        this.dmo.getRelated(type, q2, dor);
    }

    @Override
    public DMiObject[] getRelated(String ieType, DMQuery q2) {
        DMiObject[] related = this.dmo.getRelated(ieType, q2);
        DMiObject[] result = new ListObject[related.length];
        for (int i2 = 0; i2 < related.length; ++i2) {
            result[i2] = this.session.createListObject(this.getID(), related[i2]);
        }
        return result;
    }

    @Override
    public DMTag[] getTags() {
        return this.dmo.getTags();
    }

    @Override
    public String getType() {
        return this.dmo.getType();
    }

    @Override
    public Object getValue(DMTag t2) {
        return this.dmo.getValue(t2);
    }

    @Override
    public void getValues(DMElement[] elements) {
        this.dmo.getValues(elements);
    }

    @Override
    public void setLock(int lockType) {
        this.dmo.setLock(lockType);
    }

    @Override
    public void setValues(DMElement[] elements) {
        this.dmo.setValues(elements);
    }
}

