/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.mem;

import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import com.ge.med.terra.tap.dm.mem.MemImage;
import com.ge.med.terra.tap.dm.mem.MemSession;
import com.ge.med.terra.tap.dm.mem.memBuffer;
import com.ge.med.terra.tap.dm.peer.DMiComposite;
import com.ge.med.terra.tap.dm.peer.DMiImage;
import com.ge.med.terra.tap.dm.sessionFile.dicomImageGen;
import com.ge.med.terra.tap.dm.sessionFile.fileSequence;
import com.ge.med.terra.tap.util.dicom.DicomComposite;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;

public class MemComposite
implements DMiComposite,
DMTagValueInterface {
    memBuffer data;
    MemSession ses;
    public static DMTag sopInstance = new DMTag(8, 24);
    HashMap cache = new HashMap();
    static tagValue tv = new tagValue();
    static tagValue[] tva = new tagValue[]{tv};

    public MemComposite(MemSession ses, memBuffer data) {
        this.data = data;
        this.ses = ses;
    }

    @Override
    public Object getValue(DMTag t2) {
        if (this.cache.containsKey(t2)) {
            return this.cache.get(t2);
        }
        MemComposite.tv.group = t2.getGroup();
        MemComposite.tv.element = t2.getElement();
        try {
            this.ses.oparser.setFile(this.data.getInputStream());
        }
        catch (FileNotFoundException ex) {
            // empty catch block
        }
        this.ses.oparser.fill(tva);
        this.ses.oparser.clearFile();
        Object o2 = MemComposite.tv.vrep == 21329 ? new fileSequence(tv) : MemComposite.tv.value;
        this.cache.put(t2, o2);
        return o2;
    }

    @Override
    public void getValues(DMElement[] elements) {
        this.getValues((tagValue[])elements);
    }

    public void getValues(tagValue[] elements) {
        Arrays.sort(elements);
        try {
            this.ses.oparser.setFile(this.data.getInputStream());
        }
        catch (FileNotFoundException ex) {
            // empty catch block
        }
        this.ses.oparser.fill(elements);
        this.ses.oparser.clearFile();
        for (int i2 = 0; i2 < elements.length; ++i2) {
            if (elements[i2].vrep == 21329) {
                elements[i2].value = new fileSequence(elements[i2]);
            }
            this.cache.put(new DMTag(elements[i2].group, elements[i2].element), elements[i2].value);
        }
    }

    @Override
    public void setValues(DMElement[] elements) {
        DicomComposite obj = new DicomComposite();
        try {
            InputStream fis = this.data.getInputStream();
            obj.read(fis);
            fis.close();
            for (int j2 = 0; j2 < elements.length; ++j2) {
                System.out.println("Updating: \n" + elements[j2]);
                obj.setValue(elements[j2].group, elements[j2].element, elements[j2].value);
            }
            OutputStream fos = this.data.getOutputStream();
            obj.write(fos, true);
            fos.close();
            for (int i2 = 0; i2 < elements.length; ++i2) {
                DMTag t2 = new DMTag(elements[i2].group, elements[i2].element);
                if (!this.cache.containsKey(t2)) continue;
                this.cache.put(t2, elements[i2].value);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public String getType() {
        return "composite";
    }

    @Override
    public DMTag[] getTags() {
        try {
            this.ses.oparser.setFile(this.data.getInputStream());
        }
        catch (Exception ex) {
            // empty catch block
        }
        tagValue[] tv = this.ses.oparser.getTags();
        this.ses.oparser.clearFile();
        DMTag[] dt = new DMTag[tv.length];
        for (int i2 = 0; i2 < tv.length; ++i2) {
            dt[i2] = new DMTag(tv[i2].group, tv[i2].element, tv[i2].vrString());
        }
        return dt;
    }

    @Override
    public void delete() {
        this.ses.compHash.remove(this.getID());
        this.data = null;
    }

    private void debugComposite() {
        try {
            this.ses.oparser.setFile(this.data.getInputStream());
        }
        catch (FileNotFoundException ex) {
            // empty catch block
        }
        while (this.ses.oparser.hasMoreTags()) {
            tagValue tv = this.ses.oparser.readNext();
            System.out.println(tv.fileOffset + ">" + tv);
        }
        this.ses.oparser.clearFile();
        System.out.flush();
    }

    @Override
    public BufferedImage[] getPixelData(DMTag[] tags) {
        this.debugComposite();
        System.err.println(">" + this.getID());
        try {
            this.ses.oparser.setFile(this.data.getInputStream());
        }
        catch (FileNotFoundException ex) {
            // empty catch block
        }
        BufferedImage[] bi = dicomImageGen.getImages(this.ses.oparser, tags);
        this.ses.oparser.clearFile();
        System.err.println(">" + this.getID());
        return bi;
    }

    @Override
    public String getID() {
        return (String)this.getValue(sopInstance);
    }

    @Override
    public InputStream getInputStream() {
        return this.data.getInputStream();
    }

    @Override
    public DMiImage[] getImages(DMTag[] tags) {
        return MemImage.wrap(this, this.getPixelData(tags));
    }

    @Override
    public String getFilePath() {
        throw new UnsupportedOperationException("Method getFilePath() not yet implemented.");
    }
}

