/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.network;

import com.archimed.dicom.network.Association;
import com.ge.med.terra.tap.Tap;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.logging.Level;

public class NWUtils {
    static int DEFAULT_SOCKET_TMO = Integer.parseInt(Tap.getProperty("tap.dm.nw.socketTmo", "-1"));
    private static String implclassuid = Tap.getProperty("tap.dm.nw.implclassuid");

    private NWUtils() {
    }

    public static String getImplementationClassUID() {
        return implclassuid;
    }

    public static void setImplementationClassUID(String implClassUID) {
        implclassuid = null != implClassUID ? implClassUID.trim() : null;
        Tap.log.log(Level.INFO, "Updating Implementation Class UID to [{0}]", implclassuid);
    }

    static Socket getNWSocket(String host, int port, int timeout) {
        Socket s2 = null;
        try {
            Tap.log.fine("creating socket...");
            if (timeout <= 0) {
                s2 = new Socket(host, port);
            } else {
                s2 = new Socket();
                s2.connect(new InetSocketAddress(host, port), timeout);
            }
            Tap.log.fine("new socket created.");
        }
        catch (IOException ioex) {
            Tap.log.log(Level.WARNING, "Cannot create TAP network socket: " + host + ":" + port);
            if (null != s2) {
                try {
                    s2.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            throw new RuntimeException(ioex);
        }
        return s2;
    }

    static Association createAssociation(Socket socket) throws IOException {
        Association as = new Association(socket.getInputStream(), socket.getOutputStream());
        if (null != implclassuid) {
            Tap.log.log(Level.INFO, "Current Association Implementation Class UID = " + as.getImplementationClassUID());
            as.setImplementationClassUID(implclassuid);
            Tap.log.log(Level.INFO, "Updated Association Implementation Class UID = " + as.getImplementationClassUID());
        } else {
            Tap.log.log(Level.INFO, "Using Default Association Implementation Class UID = " + as.getImplementationClassUID());
        }
        return as;
    }
}

