/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.network;

import com.archimed.dicom.DicomObject;
import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.UID;
import com.archimed.dicom.network.Abort;
import com.archimed.dicom.network.Acknowledge;
import com.archimed.dicom.network.Association;
import com.archimed.dicom.network.DimseUtil;
import com.archimed.dicom.network.Reject;
import com.archimed.dicom.network.Request;
import com.archimed.dicom.network.Response;
import com.archimed.dicom.network.ResponsePolicy;
import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.network.DicomObjectReceiver;
import com.ge.med.terra.tap.dm.network.NWUtils;
import com.ge.med.terra.tap.dm.network.networkSession;
import com.ge.med.terra.tap.util.dicom.SOPClassUtil;
import com.ge.med.terra.tap.util.socket.SocketUtil;
import java.io.IOException;
import java.net.Socket;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import java.util.logging.Level;

public class cfind {
    public static final int OK = 0;
    public static final int NOT_OK = 1;
    public static final int C_FIND_FAIL_RESOURCES = 42752;
    public static final int C_FIND_FAIL_MATCH = 43264;
    public static final int C_FIND_FAIL_PROCESS = 53247;
    public static final int C_FIND_CANCEL = 65024;
    public static final int C_FIND_COMPLETED = 0;
    public static final int C_FIND_PENDING_OK = 65280;
    public static final int C_FIND_PENDING_WARNING = 65281;
    public static final Integer DATA = new Integer(0);
    public static final Integer NO_DATA = new Integer(257);
    Association as;
    private Random rand = new Random();
    private int range = 100;
    private int maxPduSize = Integer.parseInt(Tap.getProperty("tap.dm.scu.cfindMaxPduSize", "16352"));
    private boolean debug = Tap.getProperty("tap.dm.nw.debug", "false").equalsIgnoreCase("true");
    private int socketTmo = Integer.parseInt(Tap.getProperty("tap.dm.nw.socketTmo", "0"));
    private int pContext = 4135;
    private int[] tsids = new int[]{8193, 8195};
    private Vector<DicomObject> vect = new Vector();
    private String called;
    private String calling;
    private String host;
    private int port;
    private Socket socket;
    private boolean isSecureNode;

    cfind(String calledTitle, String calledHost, int port, String callingTitle, String repType, Properties props) throws Exception {
        int[] arr;
        this.called = calledTitle;
        this.calling = callingTitle;
        this.host = calledHost;
        this.port = port;
        if (repType != null && repType.equalsIgnoreCase("mwl")) {
            System.out.println("cfind - repository type is MWL.");
            this.setQueryRetrieveInfoModel(4141);
        } else {
            int[] arr2 = SOPClassUtil.parseSOPClasses(Tap.getProperty("tap.dm.scu.cfindContext"));
            if (arr2 != null && arr2.length > 1) {
                this.setQueryRetrieveInfoModel(arr2[0]);
            }
        }
        String tp = null;
        if (props != null) {
            String tmo;
            tp = props.getProperty("TransferParams");
            if (tp != null) {
                this.tsids = networkSession.parseTransferParams(tp);
            }
            if ((tmo = props.getProperty("socketTmo")) != null) {
                this.socketTmo = Integer.parseInt(tmo);
            }
        }
        if ((props == null || tp == null) && (arr = SOPClassUtil.parseSOPClasses(Tap.getProperty("tap.dm.scu.cfindTS"))) != null) {
            this.tsids = arr;
        }
    }

    public cfind(String calledAE, String calledHost, int calledPort, String callingAE, boolean isSecureNode, String repType, Properties props) throws Exception {
        this(calledAE, calledHost, calledPort, callingAE, repType, props);
        this.isSecureNode = isSecureNode;
    }

    public void setQueryRetrieveInfoModel(int i2) {
        this.pContext = i2;
    }

    public int getQueryRetrieveInfoModel() {
        return this.pContext;
    }

    public int makeAssociation() throws Exception {
        if (this.socket != null && this.as != null) {
            return 0;
        }
        SocketUtil sockUtil = new SocketUtil();
        this.socket = this.isSecureNode ? sockUtil.getSSLSocket(this.host, this.port, this.socketTmo) : sockUtil.getSocket(this.host, this.port, this.socketTmo);
        this.as = NWUtils.createAssociation(this.socket);
        Request request = new Request();
        request.setCalledTitle(this.called);
        request.setCallingTitle(this.calling);
        request.setMaxPduSize(this.maxPduSize);
        request.addPresentationContext(this.pContext, this.tsids);
        if (this.debug) {
            System.out.println(" Request Packet is \n" + request.toString());
        }
        this.as.sendAssociateRequest(request);
        Response response = this.as.receiveAssociateResponse();
        if (this.debug) {
            System.out.println(" Response Packet is \n" + response.toString());
        }
        if (response instanceof Acknowledge) {
            Acknowledge ack = (Acknowledge)response;
            int result = ResponsePolicy.getResultForAbstractSyntax(request, ack, this.pContext);
            switch (result) {
                case 0: {
                    if (this.debug) {
                        System.out.println("C-FIND: Association accepted");
                    }
                    return 0;
                }
                case 3: {
                    Tap.log.log(Level.WARNING, "C-FIND: abstract syntax not supported");
                    return 1;
                }
                case 4: {
                    Tap.log.log(Level.WARNING, "C-FIND: transfer syntaxes not supported");
                    return 1;
                }
                case 1: {
                    Tap.log.log(Level.WARNING, "C-FIND: user rejection of presentation context");
                    return 1;
                }
                case 2: {
                    Tap.log.log(Level.WARNING, "C-FIND: presentation context refused, no reason given");
                    return 1;
                }
            }
            Tap.log.log(Level.WARNING, "C-FIND: Unknown Result for Abstract Syntax");
            return 1;
        }
        if (response instanceof Reject) {
            Tap.log.log(Level.WARNING, "C-FIND: association rejected: " + response);
            return 1;
        }
        if (response instanceof Abort) {
            Tap.log.log(Level.WARNING, "C-FIND: association aborted: " + response);
            return 1;
        }
        Tap.log.log(Level.WARNING, "C-FIND: unknown error");
        return 1;
    }

    public void releaseAssociation() throws IOException, IllegalValueException {
        if (this.socket != null && this.as != null) {
            this.as.sendReleaseRequest();
            this.as.receiveReleaseResponse();
            this.socket.close();
            this.as = null;
            this.socket = null;
        }
    }

    public void abortAssociation() throws IOException {
        if (this.socket != null && this.as != null) {
            this.as.sendAbort(Abort.DICOM_UL_SERVICE_USER, Abort.REASON_NOT_SPECIFIED);
            this.socket.close();
            this.as = null;
            this.socket = null;
        }
    }

    public int doFind(DicomObject dataSet) {
        this.vect.clear();
        DicomObjectReceiver r2 = new DicomObjectReceiver(){

            @Override
            public boolean gotOne(DicomObject obj) {
                cfind.this.vect.add(obj);
                return true;
            }
        };
        return this.doFind(dataSet, r2);
    }

    public int doFind(DicomObject dataSet, DicomObjectReceiver r2) {
        try {
            String sopclass;
            DicomObject req = DimseUtil.createFindRequest(new Integer(this.rand.nextInt(this.range)), new Integer(this.pContext), new Integer(0));
            if (this.debug) {
                System.out.println("cfind: request:");
                req.dumpVRs(System.out);
                System.out.println("cfind: data:");
                dataSet.dumpVRs(System.out);
            }
            this.as.send(this.pContext, req, dataSet);
            DicomObject res = this.as.receiveCommand();
            int commandfield = res.getI(3);
            if (commandfield != 32800) {
                Tap.log.log(Level.WARNING, "No C-FIND RESPONSE command field : " + Integer.toHexString(commandfield));
                this.abortAssociation();
            }
            if ((sopclass = res.getS(1)) != null && UID.getUIDEntry(sopclass).getConstant() != this.pContext) {
                Tap.log.log(Level.WARNING, "Affected SOP Class UID in C-FIND RESPONSE wrong: " + sopclass);
                this.abortAssociation();
            }
            int status = res.getI(9);
            while ((status == 65280 || status == 65281) && res != null) {
                res = this.as.receiveData();
                if (res == null) continue;
                if (this.debug) {
                    System.out.println("C-FIND got one:");
                    res.dumpVRs(System.out);
                }
                if (!r2.gotOne(res)) break;
                res = this.as.receiveCommand();
                status = res.getI(9);
            }
            if (this.debug) {
                System.out.println("C-FIND got " + this.vect.size() + " objects");
            }
            if (status == 0) {
                return 0;
            }
            return 1;
        }
        catch (Exception ex) {
            Tap.log.log(Level.SEVERE, "Error during C-FIND: ", ex);
            throw new DMException(ex);
        }
    }

    public String[] getSOPInstanceUIDs() {
        String[] str = new String[this.vect.size()];
        for (int i2 = 0; i2 < str.length; ++i2) {
            str[i2] = (String)this.vect.get(i2).get(63);
        }
        return str;
    }

    public DicomObject[] getObjects() {
        DicomObject[] obj = new DicomObject[this.vect.size()];
        for (int i2 = 0; i2 < obj.length; ++i2) {
            obj[i2] = this.vect.get(i2);
        }
        return obj;
    }

    public void dumpVRs() {
        for (int i2 = 0; i2 < this.vect.size(); ++i2) {
            System.out.println("");
            try {
                this.vect.get(i2).dumpVRs(System.out);
                continue;
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    public void dumpSOPInstances() {
        for (int i2 = 0; i2 < this.vect.size(); ++i2) {
            try {
                System.out.println(this.vect.get(i2).get(63));
                continue;
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length < 4) {
                System.out.println("Usage: " + cfind.class.getName() + " calledAE calledHost calledPort callingAE");
                return;
            }
            cfind cf = new cfind(args[0], args[1], Integer.parseInt(args[2]), args[3], null, null);
            cf.setQueryRetrieveInfoModel(4132);
            if (cf.makeAssociation() == 0) {
                DicomObject dataSet = new DicomObject();
                System.out.println("Querying for all images on " + args[0]);
                dataSet.set(78, "IMAGE");
                dataSet.set(147, null);
                dataSet.set(148, null);
                dataSet.set(425, null);
                dataSet.set(426, null);
                dataSet.set(63, null);
                dataSet.set(430, null);
                if (cf.doFind(dataSet) == 0) {
                    System.out.println("C-FIND Successful");
                    System.out.println("Recieved SOP ID's:");
                    cf.dumpSOPInstances();
                    cf.releaseAssociation();
                } else {
                    System.out.println("C-FIND Failed");
                    cf.abortAssociation();
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }
}

