/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.network;

import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.network.Abort;
import com.archimed.dicom.network.Acknowledge;
import com.archimed.dicom.network.Association;
import com.archimed.dicom.network.DimseUtil;
import com.archimed.dicom.network.Reject;
import com.archimed.dicom.network.Request;
import com.archimed.dicom.network.Response;
import com.archimed.dicom.network.ResponsePolicy;
import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.network.NWUtils;
import com.ge.med.terra.tap.dm.network.cfind;
import com.ge.med.terra.tap.dm.network.networkSession;
import com.ge.med.terra.tap.util.dicom.UidGenerator;
import java.io.IOException;
import java.net.Socket;
import java.util.Properties;
import java.util.Random;

public class cmove {
    public static int OK = 0;
    public static int NOT_OK = 1;
    private Random rand = new Random();
    private Association as;
    private int pContext = 4136;
    private int[] tsids = new int[]{8193};
    private String called;
    private String calling;
    private String dest;
    private String host;
    private int port;
    private Socket socket;
    private boolean debug = Tap.getProperty("tap.dm.nw.debug", "false").equalsIgnoreCase("true");

    public cmove(String calledTitle, String calledHost, int port, String callingTitle, String destTitle) throws Exception {
        this(calledTitle, calledHost, port, callingTitle, destTitle, null);
    }

    public cmove(String calledTitle, String calledHost, int port, String callingTitle, String destTitle, Properties props) throws Exception {
        String tp;
        this.called = calledTitle;
        this.calling = callingTitle;
        this.dest = destTitle;
        this.host = calledHost;
        this.port = port;
        if (props != null && (tp = props.getProperty("TransferParams")) != null) {
            this.tsids = networkSession.parseTransferParams(tp);
        }
    }

    public int makeAssociation() throws Exception {
        if (this.socket != null) {
            this.socket.close();
        }
        this.socket = new Socket(this.host, this.port);
        this.as = NWUtils.createAssociation(this.socket);
        Request request = new Request();
        request.setCalledTitle(this.called);
        request.setCallingTitle(this.calling);
        request.setMaxPduSize(16352);
        request.addPresentationContext(this.pContext, this.tsids);
        this.as.sendAssociateRequest(request);
        Response response = this.as.receiveAssociateResponse();
        if (response instanceof Acknowledge) {
            Acknowledge ack = (Acknowledge)response;
            int result = ResponsePolicy.getResultForAbstractSyntax(request, ack, this.pContext);
            switch (result) {
                case 0: {
                    return OK;
                }
                case 3: {
                    Tap.log.warning("abstract syntax not supported");
                    return NOT_OK;
                }
                case 4: {
                    Tap.log.warning("transfer syntaxes not supported");
                    return NOT_OK;
                }
                case 1: {
                    Tap.log.warning("user rejection of presentation context");
                    return NOT_OK;
                }
                case 2: {
                    Tap.log.warning("presentation context refused, no reason given");
                    return NOT_OK;
                }
            }
            Tap.log.warning("Unknown Result for Abstract Syntax");
            return NOT_OK;
        }
        if (response instanceof Reject) {
            Tap.log.warning("association rejected: " + response);
            return NOT_OK;
        }
        if (response instanceof Abort) {
            Tap.log.warning("association aborted: " + response);
            return NOT_OK;
        }
        Tap.log.warning("unknown error");
        return NOT_OK;
    }

    public void releaseAssociation() throws IOException, IllegalValueException {
        if (this.socket != null && this.as != null) {
            this.as.sendReleaseRequest();
            this.as.receiveReleaseResponse();
            this.socket.close();
            this.as = null;
            this.socket = null;
        }
    }

    public void abortAssociation() throws IOException {
        if (this.socket != null && this.as != null) {
            this.as.sendAbort(Abort.DICOM_UL_SERVICE_USER, Abort.REASON_NOT_SPECIFIED);
            this.socket.close();
            this.as = null;
            this.socket = null;
        }
    }

    public int doMove(DicomObject dataSet) {
        try {
            int commandfield;
            String sop = UidGenerator.newInstanceUID();
            int mid = sop == null ? this.rand.nextInt(Integer.MAX_VALUE) : sop.hashCode();
            mid &= 0xFFFF;
            if (Tap.logLevel <= Tap.LEVEL_FINE) {
                Tap.log.fine(" imseUtil.createMoveRequest( " + new Integer(mid) + "," + new Integer(this.pContext) + "," + new Integer(0) + "," + this.dest + ");");
            }
            DicomObject req = DimseUtil.createMoveRequest(new Integer(mid), new Integer(this.pContext), new Integer(0), this.dest);
            if (this.debug) {
                Tap.log.info("cmove: sending request:");
                req.dumpVRs(System.err);
                Tap.log.info("cmove: sending data:");
                dataSet.dumpVRs(System.err);
            }
            this.as.send(this.pContext, req, dataSet);
            DicomObject res = this.as.receiveCommand();
            if (this.debug) {
                Tap.log.info("cmove: received command:");
                res.dumpVRs(System.err);
            }
            if ((commandfield = res.getI(3)) != 32801) {
                Tap.log.warning("No C-MOVE response command field : " + Integer.toHexString(commandfield));
                this.abortAssociation();
                return NOT_OK;
            }
            int status = cmove.getStatus(res, this.debug);
            while ((status == 65280 || status == 65281) && res != null) {
                try {
                    res = this.as.receiveCommand();
                }
                catch (Exception e2) {
                    break;
                }
                if (res == null) continue;
                status = cmove.getStatus(res, this.debug);
            }
            Tap.log.info("C-MOVE Final Status = " + Integer.toHexString(status));
            if (status == 0) {
                return OK;
            }
            return NOT_OK;
        }
        catch (Exception e3) {
            e3.printStackTrace();
            return NOT_OK;
        }
    }

    private static int getStatus(DicomObject res, boolean debug) throws DicomException, IOException {
        int status = res.getI(9);
        String msg = "C-MOVE Status = " + Integer.toHexString(status) + ": ";
        if (42753 == status) {
            msg = msg + "FAILURE - Refused: Out of Resources - Unable to calculate number of matches";
        } else if (42754 == status) {
            msg = msg + "FAILURE - Refused: Out of Resources - Unable to perform sub-operations";
        } else if (43009 == status) {
            msg = msg + "FAILURE - Refused: Move Destination unknown";
        } else if (43264 == status) {
            msg = msg + "FAILURE - Identifier does not match SOP Class";
        } else if (49152 <= status && status <= 53247) {
            msg = msg + "FAILURE - Unable to Process";
        } else if (65024 == status) {
            msg = msg + "CANCEL - Sub-operations terminated due to Cancel Indication";
        } else if (45056 == status) {
            msg = msg + "WARNING - Sub-operations Complete - One or more Failures or Warnings";
        } else if (65280 == status) {
            int completed = (Integer)res.get_ge(0, 4129);
            int remaining = (Integer)res.get_ge(0, 4128);
            int total = completed + remaining;
            msg = msg + "PENDING - Sub-operations are continuing (" + completed + "/" + total + ")";
        } else if (0 == status) {
            msg = msg + "SUCCESS - Sub-operations Complete - No Failures or Warnings";
        }
        Tap.log.info(msg);
        if (debug) {
            res.dumpVRs(System.err);
        }
        return status;
    }

    public static void main(String[] args) {
        try {
            if (args.length < 5) {
                System.out.println("Usage: com.ge.med.terra.tap.dm.network.cmove calledAE calledHost calledPort callingAE destAE");
                return;
            }
            cmove cm = new cmove(args[0], args[1], Integer.parseInt(args[2]), args[3], args[4]);
            cfind cf = new cfind(args[0], args[1], Integer.parseInt(args[2]), args[3], null, null);
            DicomObject dataSet = new DicomObject();
            dataSet.set(78, "IMAGE");
            dataSet.set(63, null);
            if (cf.makeAssociation() == 0) {
                if (cf.doFind(dataSet) != 0) {
                    System.out.println("Failed in C-FIND");
                    return;
                }
            } else {
                System.out.println("Failed in making C-FIND association");
                return;
            }
            DicomObject[] images = cf.getObjects();
            cf.releaseAssociation();
            if (images == null || images.length <= 0) {
                return;
            }
            DicomObject dataSet2 = new DicomObject();
            dataSet2.set(78, "IMAGE");
            for (int i2 = 0; i2 < 1; ++i2) {
                System.out.println("SOPInstance UID= " + images[i2].get(63));
                dataSet2.set(63, images[i2].get(63));
                if (cm.makeAssociation() != OK) continue;
                System.out.println("C-MOVE Association OK");
                if (cm.doMove(dataSet2) == OK) {
                    System.out.println("C-MOVE Successful");
                    cm.releaseAssociation();
                    continue;
                }
                System.out.println("C-MOVE Failed");
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }
}

