/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.network;

import com.archimed.dicom.DDate;
import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.Person;
import com.archimed.dicom.TagValue;
import com.archimed.dicom.charset.DicomCharset;
import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.network.DicomObjectReceiver;
import com.ge.med.terra.tap.dm.network.cmove;
import com.ge.med.terra.tap.dm.network.networkComposite;
import com.ge.med.terra.tap.dm.network.networkSequence;
import com.ge.med.terra.tap.dm.network.networkSession;
import com.ge.med.terra.tap.dm.peer.DMiComposite;
import com.ge.med.terra.tap.dm.peer.DMiImage;
import com.ge.med.terra.tap.dm.peer.DMiObject;
import com.ge.med.terra.tap.dm.peer.DMiObjectReceiver;
import com.ge.med.terra.tap.util.dicom.DicomData;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Level;

public class networkObject
implements DMiObject {
    private final String type;
    private final networkSession session;
    private final DicomObject dicomObject;
    private int refCount = 0;
    private boolean debug = false;
    private final Object statusLock = new Object();

    public networkObject(String t2, networkSession s2, DicomObject o2) {
        this.type = t2;
        this.session = s2;
        this.dicomObject = o2;
        this.debug = networkSession.debug();
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Object getValue(DMTag t2) {
        return networkObject.getValueFromDicomObject(this.dicomObject, t2);
    }

    @Override
    public void setLock(int lockType) {
        throw new UnsupportedOperationException("Method getLock() not yet implemented.");
    }

    @Override
    public int getLock() {
        throw new UnsupportedOperationException("Method getLock() not yet implemented.");
    }

    @Override
    public void getValues(DMElement[] elements) {
        block7: {
            DicomCharset[] s2 = this.dicomObject.dicomCharsets();
            if (s2.length > 0 && s2[0] == null) {
                try {
                    s2[0] = DicomCharset.DEFAULT;
                    try {
                        String o2 = this.dicomObject.getString(57, 0, true);
                        if ("ISO_IR100".equals(o2)) {
                            Tap.log.warning("Fixing invalid ISO_IR100 character set to use ISO_IR 100");
                            this.dicomObject.setString(57, "ISO_IR 100", 0);
                            break block7;
                        }
                        Tap.log.warning("Unsupported CharacterSet = " + o2 + ". Using US-ASCII.");
                        this.dicomObject.setString(57, "US-ASCII", 0);
                    }
                    catch (DicomException e2) {
                        e2.printStackTrace();
                    }
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                }
            }
        }
        for (int i2 = 0; i2 < elements.length; ++i2) {
            elements[i2].value = this.dicomObject.get_ge(elements[i2].group, elements[i2].element);
        }
    }

    @Override
    public void setValues(DMElement[] elements) {
        if (elements == null) {
            return;
        }
        for (int i2 = 0; i2 < elements.length; ++i2) {
            try {
                this.dicomObject.set_ge(elements[i2].group, elements[i2].element, elements[i2].value);
                continue;
            }
            catch (DicomException e2) {
                e2.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DMiComposite[] getComposites(DMQuery q2) {
        networkComposite[] objs;
        block31: {
            objs = null;
            if (Tap.logLevel <= Tap.LEVEL_FINE) {
                Tap.log.fine("getComposites");
            }
            Socket s2 = null;
            ObjectInputStream ois = null;
            ObjectOutputStream oos = null;
            try {
                s2 = new Socket("localhost", 4921);
                ois = new ObjectInputStream(s2.getInputStream());
                oos = new ObjectOutputStream(s2.getOutputStream());
                String clientID = "DMComposite-" + this.getID();
                oos.writeObject(clientID);
                DicomObject dataSet = new DicomObject();
                dataSet.set(78, "IMAGE");
                dataSet.set(63, "");
                this.setQueryFields(dataSet, this.type);
                if (q2 != null) {
                    DicomData dc = new DicomData(dataSet);
                    q2.writeDicom(dc);
                }
                if (Tap.logLevel <= Tap.LEVEL_FINE) {
                    Tap.log.fine(" c-find request");
                }
                if (this.session.cf.makeAssociation() == 0) {
                    if (this.session.cf.doFind(dataSet) != 0) break block31;
                    this.session.cf.releaseAssociation();
                    DicomObject[] o2 = this.session.cf.getObjects();
                    objs = new networkComposite[o2.length];
                    if (Tap.logLevel <= Tap.LEVEL_FINE) {
                        Tap.log.fine("make " + o2.length + " c-moves");
                    }
                    for (int i2 = 0; i2 < o2.length; ++i2) {
                        oos.writeObject(o2[i2].get(63));
                        String res = (String)ois.readObject();
                        if (Tap.logLevel > Tap.LEVEL_FINE) continue;
                        Tap.log.fine("Got result: " + res);
                    }
                    WriteThread writeThread = new WriteThread(clientID, this.statusLock, this, this.session.callingAE);
                    writeThread.start();
                    ReadThread readThread = new ReadThread(clientID, this.statusLock, ois, objs, this.session);
                    readThread.start();
                    Object object = this.statusLock;
                    synchronized (object) {
                        do {
                            this.statusLock.wait();
                            if (AbstractStatusThread.Status.DONE_WITH_FAILURES == writeThread.getStatus()) {
                                Tap.log.warning("C-MOVE Failed in getComposites. Aborting the Composite Creation Task.");
                                readThread.abortTask();
                                Tap.log.warning(readThread.getErrorMessage());
                                throw new DMException(writeThread.getErrorMessage() + " in getComposites()");
                            }
                            if (AbstractStatusThread.Status.DONE_WITH_FAILURES != readThread.getStatus()) continue;
                            Tap.log.warning("Composite Creation Failed.  Aborting the C-MOVE Task.");
                            writeThread.abortTask();
                            Tap.log.warning(writeThread.getErrorMessage());
                            throw new DMException(readThread.getErrorMessage() + " in getComposites()");
                        } while (AbstractStatusThread.Status.DONE != writeThread.getStatus() || AbstractStatusThread.Status.DONE != readThread.getStatus());
                        Tap.log.info("C-MOVE and Composite Creation Finished Successfully");
                        break block31;
                    }
                }
                Tap.log.warning("Failed to make C-FIND association in getComposites()");
            }
            catch (Exception ex) {
                Tap.log.log(Level.SEVERE, "Unable to get composites: ", ex);
                throw new DMException(ex);
            }
            finally {
                if (null != oos) {
                    try {
                        oos.close();
                    }
                    catch (IOException ioex) {
                        Tap.log.log(Level.WARNING, "Unable to close socket's output stream: ", ioex);
                    }
                }
                if (null != ois) {
                    try {
                        ois.close();
                    }
                    catch (IOException ioex) {
                        Tap.log.log(Level.WARNING, "Unable to close socket's input stream: ", ioex);
                    }
                }
                if (null != s2) {
                    try {
                        s2.close();
                    }
                    catch (IOException ioex) {
                        Tap.log.log(Level.WARNING, "Unable to close network socket: ", ioex);
                    }
                }
            }
        }
        return objs;
    }

    public boolean moveTo(String destAE) {
        int res = cmove.NOT_OK;
        cmove cm = null;
        if (Tap.logLevel <= Tap.LEVEL_FINE) {
            Tap.log.fine("Moving to ... " + destAE);
        }
        try {
            cm = new cmove(this.session.calledAE, this.session.calledHost, this.session.calledPort, this.session.callingAE, destAE, this.session.props);
            res = cm.makeAssociation();
            if (res == cmove.OK) {
                DicomObject movePacket = new DicomObject();
                movePacket.set(78, this.type.toUpperCase());
                movePacket.set(63, "");
                this.setQueryFields(movePacket, this.type);
                if (cm.doMove(movePacket) == cmove.OK) {
                    if (Tap.logLevel <= Tap.LEVEL_FINE) {
                        Tap.log.fine("C-MOVE Successful");
                    }
                    cm.releaseAssociation();
                    return true;
                }
                Tap.log.warning("C-MOVE Failed in doMove()");
                cm.abortAssociation();
                return false;
            }
            Tap.log.warning("Unable to make C-MOVE Association");
            return false;
        }
        catch (Exception e2) {
            Tap.log.warning("C-MOVE Failed: " + e2);
            if (cm != null && res == cmove.OK) {
                try {
                    cm.abortAssociation();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    public void setQueryFields(DicomObject dataSet, String type) throws DicomException {
        block5: {
            block7: {
                block6: {
                    block4: {
                        if (!type.equalsIgnoreCase("Patient")) break block4;
                        dataSet.set(57, this.dicomObject.get(57));
                        dataSet.set(147, this.dicomObject.get(147));
                        dataSet.set(148, this.dicomObject.get(148));
                        dataSet.set(150, this.dicomObject.get(150));
                        int[][] ge = this.session.prefetch[0];
                        for (int i2 = 0; null != ge && i2 < ge.length; ++i2) {
                            if (ge[i2][0] <= 1) continue;
                        }
                        break block5;
                    }
                    if (!type.equalsIgnoreCase("Study") && !type.equalsIgnoreCase("Exam")) break block6;
                    dataSet.set(425, this.dicomObject.get(425));
                    int[][] ge = this.session.prefetch[1];
                    for (int i3 = 0; null != ge && i3 < ge.length; ++i3) {
                        if (ge[i3][0] <= 1) continue;
                        dataSet.set_ge(ge[i3][0], ge[i3][1], null);
                    }
                    break block5;
                }
                if (!type.equalsIgnoreCase("Series")) break block7;
                dataSet.set(426, this.dicomObject.get(426));
                dataSet.set(425, this.dicomObject.get(425));
                int[][] ge = this.session.prefetch[2];
                for (int i4 = 0; null != ge && i4 < ge.length; ++i4) {
                    if (ge[i4][0] <= 1) continue;
                    dataSet.set_ge(ge[i4][0], ge[i4][1], null);
                }
                break block5;
            }
            if (!type.equalsIgnoreCase("Image")) break block5;
            dataSet.set(426, this.dicomObject.get(426));
            dataSet.set(425, this.dicomObject.get(425));
            dataSet.set(63, this.dicomObject.get(63));
            int[][] ge = this.session.prefetch[3];
            for (int i5 = 0; null != ge && i5 < ge.length; ++i5) {
                if (ge[i5][0] <= 1) continue;
                dataSet.set_ge(ge[i5][0], ge[i5][1], null);
            }
        }
    }

    @Override
    public int getNumberOfComposites(DMQuery q2) {
        return this.getComposites(q2).length;
    }

    @Override
    public DMiObject[] getRelated(String ieType, DMQuery q2) {
        return this.internalGetRelated(ieType, q2, null);
    }

    @Override
    public void getRelated(String ieType, DMQuery q2, DMiObjectReceiver cb) {
        this.internalGetRelated(ieType, q2, cb);
    }

    private networkObject[] internalGetRelated(String t2, DMQuery q2, DMiObjectReceiver cb) {
        final String ieType = t2;
        final DMiObjectReceiver callback = cb;
        DicomObjectReceiver r2 = new DicomObjectReceiver(){

            @Override
            public boolean gotOne(DicomObject obj) {
                return callback.gotOne(new networkObject(ieType, networkObject.this.session, obj));
            }
        };
        try {
            DicomObject dataSet = this.session.tapToDicomQuery(ieType, q2);
            this.setQueryFields(dataSet, this.type);
            if (this.session.cf.makeAssociation() == 0) {
                if (callback == null) {
                    this.session.cf.doFind(dataSet);
                    DicomObject[] objs = this.session.cf.getObjects();
                    networkObject[] nObjs = new networkObject[objs.length];
                    for (int i2 = 0; i2 < objs.length; ++i2) {
                        nObjs[i2] = new networkObject(ieType, this.session, objs[i2]);
                    }
                    return nObjs;
                }
                this.session.cf.doFind(dataSet, r2);
                return null;
            }
            Tap.log.warning("Failed to make C-FIND association in internalGetRelated()");
        }
        catch (Exception ex) {
            throw new DMException(ex.getMessage());
        }
        return null;
    }

    @Override
    public int getNumberOfRelated(String ieType, DMQuery q2) {
        throw new UnsupportedOperationException("Method getNumberOfRelated() not yet implemented.");
    }

    @Override
    public void delete() {
        throw new UnsupportedOperationException("Method delete() not yet implemented.");
    }

    public void save(DMiObject o2) {
        throw new UnsupportedOperationException("Method save() not yet implemented.");
    }

    public void save(DMiComposite o2) {
        throw new UnsupportedOperationException("Method save() not yet implemented.");
    }

    @Override
    public DMTag[] getTags() {
        ArrayList<DMTag> al2 = new ArrayList<DMTag>();
        Enumeration vrs = this.dicomObject.enumerateVRs(false);
        int i2 = 0;
        while (vrs.hasMoreElements()) {
            TagValue tv = (TagValue)vrs.nextElement();
            al2.add(new DMTag(tv.getGroup(), tv.getElement()));
            ++i2;
        }
        return al2.toArray(new DMTag[al2.size()]);
    }

    @Override
    public BufferedImage[] getPixelData(DMTag[] tags) {
        DMiComposite[] comps = this.getComposites(null);
        ArrayList<BufferedImage> list = new ArrayList<BufferedImage>(10);
        for (int i2 = 0; comps != null && i2 < comps.length; ++i2) {
            BufferedImage[] imgs = comps[i2].getPixelData(tags);
            for (int j2 = 0; imgs != null && j2 < imgs.length; ++j2) {
                list.add(imgs[j2]);
            }
        }
        return list.toArray(new BufferedImage[list.size()]);
    }

    @Override
    public void attach() {
        ++this.refCount;
    }

    @Override
    public void detach() {
        --this.refCount;
    }

    @Override
    public String getID() {
        if (this.type.equalsIgnoreCase("Patient")) {
            return "P|" + this.dicomObject.get(147) + "|" + this.dicomObject.get(148) + "|" + this.dicomObject.get(150);
        }
        if (this.type.equalsIgnoreCase("Study") || this.type.equalsIgnoreCase("Exam")) {
            return "E|" + this.dicomObject.get(425);
        }
        if (this.type.equalsIgnoreCase("Series")) {
            return "S|" + this.dicomObject.get(426);
        }
        if (this.type.equalsIgnoreCase("Image")) {
            return "I|" + this.dicomObject.get(63);
        }
        return "UNKNOWN";
    }

    @Override
    public DMiImage[] getImages(DMTag[] tags) {
        DMiComposite[] comps = this.getComposites(null);
        ArrayList<DMiImage> list = new ArrayList<DMiImage>(10);
        for (int i2 = 0; comps != null && i2 < comps.length; ++i2) {
            DMiImage[] imgs = comps[i2].getImages(tags);
            for (int j2 = 0; imgs != null && j2 < imgs.length; ++j2) {
                list.add(imgs[j2]);
            }
        }
        return list.toArray(new DMiImage[list.size()]);
    }

    public networkSession getSession() {
        return this.session;
    }

    public void dump() {
        try {
            this.dicomObject.dumpVRs(System.out);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    static Object getValueFromDicomObject(DicomObject o2, DMTag t2) {
        Object obj = o2.get_ge(t2.getGroup(), t2.getElement());
        if (obj instanceof DicomObject) {
            return new networkSequence(o2, t2.getGroup(), t2.getElement());
        }
        if (obj instanceof Person) {
            return ((Person)obj).toDICOMString();
        }
        if (obj instanceof DDate) {
            return ((DDate)obj).toDICOMString();
        }
        return obj;
    }

    private static class ReadThread
    extends AbstractStatusThread {
        private final ObjectInputStream ois;
        private final networkComposite[] comps;
        private final networkSession session;

        public ReadThread(String name, Object statusLock, ObjectInputStream ois, networkComposite[] comps, networkSession session) {
            super("Read Thread - " + name, statusLock);
            this.ois = ois;
            this.comps = comps;
            this.session = session;
        }

        @Override
        public void run() {
            int i2;
            int totalComposites = this.comps.length;
            try {
                this.setStatus(AbstractStatusThread.Status.RUNNING);
                Tap.log.info("Waiting for " + totalComposites + " SOP-UIDs");
                for (i2 = 0; i2 < totalComposites; ++i2) {
                    String fname = (String)this.ois.readObject();
                    Tap.log.fine("Got composite #" + i2 + ": " + fname);
                    Tap.log.finer("Creating DMComposite...");
                    this.comps[i2] = new networkComposite(new File(fname), this.session);
                }
                this.setStatus(AbstractStatusThread.Status.DONE);
            }
            catch (IOException ioex) {
                this.setStatus(AbstractStatusThread.Status.DONE_WITH_FAILURES, "Unable to create composite #" + i2 + ": " + ioex);
            }
            catch (ClassNotFoundException cnfex) {
                this.setStatus(AbstractStatusThread.Status.DONE_WITH_FAILURES, "Unable to create composite #" + i2 + ": " + cnfex);
            }
        }

        @Override
        public void abortTask() {
            if (AbstractStatusThread.Status.RUNNING == this.getStatus()) {
                String errorMessage;
                try {
                    this.ois.close();
                    errorMessage = "Aborted Composite Creation Thread";
                }
                catch (IOException ioex) {
                    errorMessage = "Unable to Abort Composite Creation Thread: " + ioex;
                }
                this.setStatus(AbstractStatusThread.Status.DONE_WITH_FAILURES, errorMessage);
            }
        }
    }

    private static class WriteThread
    extends AbstractStatusThread {
        private final networkObject networkObject;
        private final String callingAE;

        public WriteThread(String name, Object statusLock, networkObject networkObject2, String callingAE) {
            super("Write Thread - " + name, statusLock);
            this.networkObject = networkObject2;
            this.callingAE = callingAE;
        }

        @Override
        public void run() {
            this.setStatus(AbstractStatusThread.Status.RUNNING);
            if (this.networkObject.moveTo(this.callingAE)) {
                this.setStatus(AbstractStatusThread.Status.DONE);
            } else {
                this.setStatus(AbstractStatusThread.Status.DONE_WITH_FAILURES, "C-MOVE Failed");
            }
        }

        @Override
        public void abortTask() {
            if (AbstractStatusThread.Status.RUNNING == this.getStatus()) {
                String errorMessage = "Unable to abort C-MOVE Thread: Functionality not supported yet.";
                this.setStatus(AbstractStatusThread.Status.DONE_WITH_FAILURES, errorMessage);
            }
        }
    }

    private static abstract class AbstractStatusThread
    extends Thread {
        private final Object statusLock;
        private Status status;
        private String errorMessage;

        protected AbstractStatusThread(String name, Object statusLock) {
            super(name);
            this.statusLock = statusLock;
            this.status = Status.IDLE;
            this.errorMessage = null;
        }

        public Status getStatus() {
            return this.status;
        }

        protected void setStatus(Status status) {
            this.setStatus(status, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setStatus(Status status, String errorMessage) {
            this.status = status;
            this.errorMessage = errorMessage;
            Object object = this.statusLock;
            synchronized (object) {
                this.statusLock.notifyAll();
            }
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public abstract void abortTask();

        public static enum Status {
            IDLE,
            RUNNING,
            DONE,
            DONE_WITH_FAILURES;

        }
    }
}

