/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.rm;

import java.util.Arrays;
import java.util.Random;

public class IntHashSet {
    private int[][] table;
    private int size;
    static long oldptime = System.nanoTime();

    public IntHashSet(int initCapacity) {
        this.table = new int[initCapacity * 20][];
    }

    public final synchronized void clear() {
        Arrays.fill((Object[])this.table, null);
        this.size = 0;
    }

    public final synchronized int size() {
        return this.size;
    }

    public final synchronized boolean isEmpty() {
        return this.size == 0;
    }

    public final synchronized boolean contains(int key) {
        int index = this.hash(key);
        int[] array = this.table[index];
        if (array != null) {
            for (int i2 = 0; i2 < array.length; ++i2) {
                if (array[i2] != key) continue;
                return true;
            }
        }
        return false;
    }

    private final int hash(int key) {
        return Math.abs(key) % this.table.length;
    }

    public final synchronized boolean add(int key) {
        int i2;
        int index = this.hash(key);
        if (this.table[index] == null) {
            this.table[index] = new int[2];
            this.table[index][0] = key;
            ++this.size;
            return true;
        }
        int[] array = this.table[index];
        for (i2 = 0; i2 < array.length; ++i2) {
            if (array[i2] != key) continue;
            return false;
        }
        for (i2 = 0; i2 < array.length; ++i2) {
            if (array[i2] != 0) continue;
            ++this.size;
            array[i2] = key;
            return true;
        }
        array = new int[array.length * 2];
        System.arraycopy(this.table[index], 0, array, 0, this.table[index].length);
        array[this.table[index].length] = key;
        this.table[index] = array;
        ++this.size;
        return true;
    }

    public final synchronized boolean remove(int key) {
        int index = this.hash(key);
        int[] array = this.table[index];
        if (array == null) {
            return false;
        }
        for (int i2 = 0; i2 < array.length; ++i2) {
            if (array[i2] != key) continue;
            array[i2] = 0;
            --this.size;
            return true;
        }
        return false;
    }

    static void ptime(String msg) {
        long ptime = System.nanoTime();
        if (msg != null) {
            System.out.println(msg + " " + (float)(ptime - oldptime) * 1.0E-9f + " sec");
        }
        oldptime = ptime;
    }

    public static void main(String[] args) {
        int i2;
        IntHashSet.ptime(null);
        int N = 10000;
        IntHashSet h2 = new IntHashSet(N);
        Random r2 = new Random(12317L);
        int[] data = new int[N];
        IntHashSet.ptime("      setup:");
        for (i2 = 0; i2 < data.length; ++i2) {
            data[i2] = r2.nextInt();
            if (h2.add(data[i2])) continue;
            System.out.println("i##t has it " + data[i2]);
        }
        IntHashSet.ptime("     adding:");
        for (i2 = 0; i2 < data.length; ++i2) {
            if (h2.contains(data[i2])) continue;
            System.out.println("##should contain " + data[i2]);
        }
        IntHashSet.ptime("   contains:");
        for (i2 = 0; i2 < data.length / 2; ++i2) {
            if (h2.remove(data[i2])) continue;
            System.out.println("##should contain " + data[i2]);
        }
        IntHashSet.ptime("half remove:");
        h2.size();
        IntHashSet.ptime("       size:");
        h2.isEmpty();
        IntHashSet.ptime("    isEmpty:");
        for (i2 = 0; i2 < data.length; ++i2) {
            boolean in = h2.contains(data[i2]);
            if (i2 >= data.length / 2) {
                if (in) continue;
                System.out.println("##should contain " + data[i2]);
                continue;
            }
            if (!in) continue;
            System.out.println("##should not contain " + data[i2]);
        }
        IntHashSet.ptime("   contains:");
        h2.clear();
        IntHashSet.ptime("      clear:");
    }
}

