/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.rm;

import com.ge.med.terra.tap.dm.rm.RmComposite;
import com.ge.med.terra.tap.dm.rm.RmSession;
import com.ge.med.terra.tap.dm.rm.RmState;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Vector;

public class RmCompositeManager {
    private Vector list;
    private Thread loader;
    private long maxMemory;
    private long minMemory;
    private long curMemory;
    private RmSession session;
    private boolean sleep = true;
    private Object lock = new Object();
    private int accessCount = 0;
    final HashMap cache = new HashMap();

    RmCompositeManager(RmSession session) {
        this(session, 2000);
    }

    RmCompositeManager(RmSession session, int maxMemory) {
        this.list = new Vector();
        this.session = session;
        this.maxMemory = maxMemory * 0x100000;
        this.minMemory = this.maxMemory * 3L / 4L;
        this.loader = new Thread(){

            @Override
            public void run() {
                RmCompositeManager.this.fileLoader();
            }
        };
        this.loader.setName("RmCompositeManager File Loader");
        this.loader.setDaemon(true);
        this.loader.setPriority(1);
        this.loader.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fileLoader() {
        while (true) {
            this.curMemory = this.calcMemory(this.session);
            try {
                Object object = this.lock;
                synchronized (object) {
                    if (!this.sleep) {
                        Thread.sleep(1L);
                    }
                    while (this.sleep) {
                        try {
                            this.lock.wait();
                        }
                        catch (InterruptedException ex) {
                            System.err.println("interrupted");
                        }
                    }
                    this.sleep = true;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            RmComposite max = this.maxUnLoaded();
            RmComposite min = this.minLoaded();
            if (max != null) {
                if (this.minMemory > this.curMemory || this.maxMemory > this.curMemory && RmState.isMustLoad(max)) {
                    this.load(max);
                    this.sleep = false;
                    continue;
                }
                if (!RmState.isMustLoad(max)) continue;
                if (min != null) {
                    this.unload(min);
                }
                this.load(max);
                this.sleep = false;
                continue;
            }
            if (min == null || this.maxMemory >= this.curMemory) continue;
            this.unload(min);
            this.sleep = false;
        }
    }

    private RmComposite maxUnLoaded() {
        int max = 1;
        RmComposite maxrc = null;
        int i2 = 0;
        while (i2 < this.list.size()) {
            WeakReference w2 = (WeakReference)this.list.get(i2);
            RmComposite rc = (RmComposite)w2.get();
            if (rc == null) {
                this.list.remove(i2);
                continue;
            }
            if (rc.getState() > max || rc.getState() == max && (maxrc == null || rc.getAccess() < maxrc.getAccess())) {
                max = rc.getState();
                maxrc = rc;
            }
            ++i2;
        }
        return maxrc;
    }

    private RmComposite minLoaded() {
        int min = -1;
        RmComposite minrc = null;
        int i2 = 0;
        while (i2 < this.list.size()) {
            WeakReference w2 = (WeakReference)this.list.get(i2);
            RmComposite rc = (RmComposite)w2.get();
            if (rc == null) {
                this.list.remove(i2);
                continue;
            }
            if (rc.getState() < min || rc.getState() == min && (minrc == null || rc.getAccess() < minrc.getAccess())) {
                min = rc.getState();
                minrc = rc;
            }
            ++i2;
        }
        return minrc;
    }

    void reloadComposite(RmComposite rc) {
        if (!RmState.isLoaded(rc)) {
            RmState.setInitalState(rc);
            this.wake();
        }
    }

    public void addComposite(RmComposite rc) {
        RmState.setInitalState(rc);
        this.list.add(new WeakReference<RmComposite>(rc));
        this.wake();
    }

    public void access(RmComposite rc) {
        ++this.accessCount;
        rc.setAccess(this.accessCount);
    }

    public void setPreLoad(RmComposite rc) {
        RmState.setPreLoad(rc);
        this.access(rc);
    }

    public void setPreUnload(RmComposite rc) {
        RmState.setPreUnload(rc);
        this.access(rc);
    }

    public void startLoading() {
        this.wake();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wake() {
        Object object = this.lock;
        synchronized (object) {
            this.sleep = false;
            this.lock.notifyAll();
        }
    }

    private int calcMemory(RmSession session) {
        return 100;
    }

    private void load(RmComposite rc) {
        String path = (String)this.cache.get(rc.getID());
        rc.loadComposite(path);
        RmState.setLoad(rc);
        if (path == null) {
            this.cache.put(rc.getID(), rc.composite.getFilePath());
        }
    }

    private void unload(RmComposite comp) {
        comp.unloadComposite();
        RmState.setUnload(comp);
        this.cache.remove(comp.getID());
    }
}

