/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.rm;

import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.peer.DMiComposite;
import com.ge.med.terra.tap.dm.peer.DMiImage;
import com.ge.med.terra.tap.dm.rm.RmMFComposite;
import com.ge.med.terra.tap.dm.rm.RmMFImageBase;
import com.ge.med.terra.tap.dm.rm.RmObject;
import com.ge.med.terra.tap.util.clientServer.DicomTransfer;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;

public class RmMFImage
extends RmMFImageBase
implements DMiImage {
    DicomTransfer mt;
    RmMFComposite composite;
    DMiImage image;
    RmObject dmoImage;
    int frameNumber;
    private int state;

    public RmMFImage(RmObject dmoImage, int frameNumber) {
        this.dmoImage = dmoImage;
        this.frameNumber = frameNumber;
        this.mt = dmoImage.session.getTransfer();
        this.composite = dmoImage.session.getMfComposite(dmoImage.filePath);
        Tap.log.log(Level.FINE, "new RmMFImage( frame #={0} )", frameNumber);
        if (this.composite == null) {
            File file;
            try {
                file = File.createTempFile("rmimage.", "", dmoImage.session.DIR);
            }
            catch (IOException e2) {
                throw new DMException(e2);
            }
            file.deleteOnExit();
            if (dmoImage.filePath == null) {
                throw new DMException("dmoImage.filePath should not be null");
            }
            int id = dmoImage.session.getTransfer().requestTransfer(dmoImage.filePath, file.getAbsolutePath());
            this.composite = new RmMFComposite(dmoImage.filePath, file.getAbsolutePath(), id, dmoImage.session);
            dmoImage.session.putMfComposite(dmoImage.filePath, this.composite);
        }
    }

    @Override
    public int getIconHeight() {
        return this.getImage().getIconHeight();
    }

    @Override
    public int getIconWidth() {
        return this.getImage().getIconWidth();
    }

    @Override
    public Object getProperty(Object key) {
        this.waitForHeader();
        if ("waitForImage".equals(key)) {
            try {
                this.composite.waitForFrame(this.frameNumber);
            }
            catch (InterruptedException e2) {
                throw new DMException(e2);
            }
            return null;
        }
        if ("download".equals(key)) {
            this.composite.topPriority(this.frameNumber);
            return null;
        }
        return this.getImage().getProperty(key);
    }

    @Override
    public void preLoad() {
        this.waitForHeader();
        this.composite.preLoad(this.frameNumber);
    }

    @Override
    public void preUnload() {
        this.waitForHeader();
        this.composite.preUnload(this.frameNumber);
    }

    @Override
    public void refresh() {
        this.waitForHeader();
        this.composite.refresh(this.frameNumber);
    }

    protected void waitForHeader() {
        if (this.composite == null) {
            return;
        }
        this.composite.topPriority(0);
        try {
            this.composite.waitForFrame(0);
        }
        catch (InterruptedException e2) {
            throw new DMException(e2);
        }
    }

    protected void waitForFrame() {
        Tap.log.log(Level.FINER, "waiting for frame {0}", this.frameNumber);
        if (this.composite == null) {
            return;
        }
        this.composite.topPriority(this.frameNumber);
        try {
            this.composite.waitForFrame(this.frameNumber);
            Tap.log.log(Level.FINER, "gotFrame {0}", this.frameNumber);
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
            throw new DMException(e2);
        }
    }

    @Override
    public Object getValue(DMTag tag2) {
        if (this.dmoImage != null && this.dmoImage.cacheContains(tag2)) {
            return this.dmoImage.getValue(tag2);
        }
        this.waitForHeader();
        return this.composite.getValue(tag2);
    }

    @Override
    public DMiComposite getComposite() {
        this.waitForHeader();
        return this.composite;
    }

    @Override
    public void setAccess(int access) {
    }

    @Override
    public int getAccess() {
        return 0;
    }

    @Override
    public int memorySize() {
        return 0;
    }

    @Override
    public void unloadImage() {
    }

    @Override
    public void loadImage() {
        this.waitForFrame();
    }

    @Override
    public int getFrameNumber() {
        return this.frameNumber;
    }

    @Override
    protected DMiImage getImage() {
        if (this.image == null) {
            this.waitForFrame();
            this.image = this.composite.getImage(null, this.frameNumber);
        }
        return this.image;
    }

    @Override
    public void setState(int state) {
        this.state = state;
    }

    @Override
    public int getState() {
        return this.state;
    }

    static class Info
    implements Serializable {
        public String cid;
        public int frameNumber;

        public Info(String cid, int frameNumber) {
            this.cid = cid;
            this.frameNumber = frameNumber;
        }
    }
}

