/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.selection;

import com.ge.med.terra.tap.dm.DMEvent;
import com.ge.med.terra.tap.dm.DMEventListener;
import com.ge.med.terra.tap.dm.DMId;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.peer.DMiSelection;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.util.Vector;

public class SimpleUDP
implements DMiSelection {
    DMId[] sel = new DMId[0];
    static final int broadCastNo = 6324;
    static final String broadCastIP = "229.5.6.8";
    InetAddress addr;
    private MulticastSocket ms;
    String dir;
    Thread daemon;
    byte[] myaddr;
    private final byte SEL_SETDATA = (byte)24;
    private final byte SEL_NEXT = (byte)25;
    private final byte SEL_PREV = (byte)26;
    private final byte SEL_RESEND = (byte)27;
    Vector listeners = new Vector();

    public SimpleUDP() {
        try {
            this.myaddr = InetAddress.getLocalHost().getAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.setupP2P();
    }

    @Override
    public void init(String[] args) {
        System.out.println("setup simple UDP");
    }

    @Override
    public void setSelection(DMId[] id) {
        this.sendMessage(this.SEL_SETDATA, id);
        this.sel = id;
    }

    @Override
    public DMId[] getSelection() {
        return this.sel;
    }

    @Override
    public void addSelectionListener(DMEventListener l2) {
        this.listeners.add(l2);
    }

    public void fireEvent(int id, String str) {
        for (DMEventListener l2 : this.listeners) {
            l2.actionPerformed(new DMEvent(id, str));
        }
    }

    @Override
    public void requestNextSelection(int type) {
        this.sendMessage(this.SEL_NEXT);
    }

    @Override
    public void requestPreviousSelection(int type) {
        this.sendMessage(this.SEL_PREV);
    }

    @Override
    public boolean hasNextSelection(int type) {
        return true;
    }

    @Override
    public boolean hasPreviousSelection(int type) {
        return true;
    }

    @Override
    public void setSession(DMSession session) {
    }

    public void setSession(String[] sessionParams) {
    }

    public void killThread() {
        this.daemon.interrupt();
        try {
            this.ms.leaveGroup(this.addr);
        }
        catch (Exception e2) {
            System.out.println("Exception when peerToPeerComm tried to leave group");
        }
    }

    public void sendMessage(int type, Object o2) {
        ByteArrayOutputStream b2 = null;
        try {
            b2 = new ByteArrayOutputStream();
            ObjectOutputStream s2 = new ObjectOutputStream(b2);
            s2.writeObject(o2);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.sendMessage(type, b2.toByteArray());
    }

    public void sendMessage(int type) {
        this.sendMessage(type, new byte[0]);
    }

    public void sendMessage(int type, byte[] msg) {
        byte[] data = new byte[5 + msg.length];
        data[0] = this.myaddr[0];
        data[1] = this.myaddr[1];
        data[2] = this.myaddr[2];
        data[3] = this.myaddr[3];
        data[4] = (byte)type;
        for (int i2 = 0; i2 < msg.length; ++i2) {
            data[5 + i2] = msg[i2];
        }
        DatagramPacket dp = new DatagramPacket(data, data.length, this.addr, 6324);
        try {
            if (this.ms != null) {
                this.ms.send(dp);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void setupP2P() {
        block4: {
            try {
                this.addr = InetAddress.getByName(broadCastIP);
                this.ms = new MulticastSocket(6324);
                try {
                    this.ms.joinGroup(this.addr);
                }
                catch (Exception e2) {
                    System.out.println("Exception when peerToPeerComm tried to join group");
                    return;
                }
                this.daemon = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        SimpleUDP.this.serverListen();
                    }
                });
                this.daemon.setName("peerToPeerComm Listen for event");
                this.daemon.setDaemon(true);
                this.daemon.start();
            }
            catch (Exception ex) {
                if (ex instanceof InterruptedIOException) break block4;
                ex.printStackTrace();
            }
        }
    }

    void processData(byte[] data, int len) {
        switch (data[4]) {
            case 24: {
                try {
                    ObjectInputStream o2 = new ObjectInputStream(new ByteArrayInputStream(data, 5, len - 5));
                    this.sel = (DMId[])o2.readObject();
                    this.fireEvent(4, new String(data, 5, len - 5));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                break;
            }
            case 25: {
                this.fireEvent(5, new String(data, 5, len - 5));
                break;
            }
            case 26: {
                this.fireEvent(6, new String(data, 5, len - 5));
                break;
            }
            case 27: {
                this.fireEvent(7, new String(data, 5, len - 5));
            }
        }
    }

    void serverListen() {
        byte[] buf = new byte[1000];
        try {
            DatagramPacket rp = new DatagramPacket(buf, buf.length);
            while (true) {
                this.ms.receive(rp);
                byte[] data = rp.getData();
                if (rp.getLength() >= 5) {
                    if (data[3] != this.myaddr[3] || data[2] != this.myaddr[2] || data[1] != this.myaddr[1] || data[0] != this.myaddr[0]) continue;
                    this.processData(data, rp.getLength());
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public String[] getAvailableSort(int level) {
        return null;
    }

    @Override
    public void setAvailableSort(int level, String[] availsort) {
    }

    @Override
    public void setSort(int level, String sort) {
    }

    @Override
    public String getSort(int level) {
        return null;
    }
}

