/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.sessionFile;

import com.archimed.dicom.codec.Compression;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.DMSequence;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMUtils;
import com.ge.med.terra.tap.dm.sessionFile.fileSequence;
import com.ge.med.terra.tap.dm.sessionFile.jport;
import com.ge.med.terra.tap.util.SimpleUtilities;
import com.ge.med.terra.tap.util.dicom.PersonName;
import com.ge.med.terra.tap.util.dicom.dicomParser;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;

public class dicomImageGen {
    private static dicomParser dp = new dicomParser();
    private static final int[][] tags = new int[][]{{2, 16}, {16, 16}, {40, 2}, {40, 4}, {40, 8}, {40, 16}, {40, 17}, {40, 18}, {40, 256}, {40, 257}, {40, 258}, {40, 259}, {32736, 16}};
    private static final Set<String> supportedImageTypes = new HashSet<String>(){
        {
            this.add("MONOCHROME1");
            this.add("MONOCHROME2");
            this.add("RGB");
        }
    };

    public static Object get(tagValue[] t2, int g2, int e2) {
        for (int i2 = 0; i2 < t2.length; ++i2) {
            if (t2[i2].group != g2 || t2[i2].element != e2) continue;
            return t2[i2].value;
        }
        return null;
    }

    private static int getVR(tagValue[] t2, int g2, int e2) {
        for (int i2 = 0; i2 < t2.length; ++i2) {
            if (t2[i2].group != g2 || t2[i2].element != e2) continue;
            return t2[i2].vrep;
        }
        return -1;
    }

    private static BufferedImage uncompress2BufferedImage(int frameNo, byte[] compressedFrame, String transferSyntax, boolean littleEndian, String imgType, int bits, int w2, int h2, Hashtable prop) {
        try {
            byte[] uncompressedFrame;
            if (transferSyntax.indexOf(DMUtils.TS_JPEGLossless) != -1) {
                uncompressedFrame = Compression.decompressFrame(8197, compressedFrame, w2, h2);
            } else if (transferSyntax.indexOf(DMUtils.TS_RLELossless) != -1) {
                uncompressedFrame = Compression.decompressFrame(8198, compressedFrame, w2, h2);
            } else if (transferSyntax.indexOf(DMUtils.TS_JPEGBaseline) != -1) {
                uncompressedFrame = Compression.decompressFrame(8196, compressedFrame, w2, h2);
            } else {
                throw new RuntimeException("Unsupported transfer syntax : " + transferSyntax);
            }
            if (imgType.equals("MONOCHROME2") || imgType.equals("MONOCHROME1")) {
                if (bits == 16) {
                    ByteBuffer bff = ByteBuffer.wrap(uncompressedFrame);
                    if (littleEndian) {
                        bff.order(ByteOrder.LITTLE_ENDIAN);
                    } else {
                        bff.order(ByteOrder.BIG_ENDIAN);
                    }
                    ShortBuffer ib = bff.asShortBuffer();
                    short[] sbuffer = new short[uncompressedFrame.length / 2];
                    ib.get(sbuffer);
                    prop.put("0,1", new Integer(1 + frameNo));
                    return dicomImageGen.build16bitImage(w2, h2, sbuffer, 0, 0, (Hashtable)prop.clone());
                }
                prop.put("0,1", new Integer(1 + frameNo));
                return dicomImageGen.build8bitImage(w2, h2, uncompressedFrame, 0, (Hashtable)prop.clone());
            }
            if (imgType.equals("RGB")) {
                prop.put("0,1", new Integer(1 + frameNo));
                return dicomImageGen.buildRGBImage(w2, h2, uncompressedFrame, 0, (Hashtable)prop.clone());
            }
            throw new RuntimeException("Unsupported image type \"" + imgType + "\"");
        }
        catch (Exception ex) {
            throw new DMException(ex);
        }
    }

    private static BufferedImage[] getCompressedImages(FileInputStream fis, long pixOffset, int numFrames, int dimx, int dimy, String imgType, int bits, boolean littleEndian, String transferSyntax, Hashtable prop) {
        ArrayList<BufferedImage> buffImgList;
        block9: {
            buffImgList = new ArrayList<BufferedImage>();
            try {
                int sizeOfGroupElemVrLen = 12;
                long offset = pixOffset + (long)sizeOfGroupElemVrLen;
                MappedByteBuffer mbb = fis.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, fis.getChannel().size());
                if (littleEndian) {
                    mbb.order(ByteOrder.LITTLE_ENDIAN);
                } else {
                    mbb.order(ByteOrder.BIG_ENDIAN);
                }
                mbb.position((int)offset);
                int group = mbb.getShort() & 0xFFFF;
                int elem = mbb.getShort() & 0xFFFF;
                if (group != 65534 || elem != 57344) break block9;
                int len = mbb.getInt();
                if (len > 0) {
                    int[] tableValues = new int[len / 4];
                    for (int i2 = 0; i2 < tableValues.length; ++i2) {
                        tableValues[i2] = mbb.getInt();
                    }
                    int startingPos = mbb.position();
                    for (int i3 = 0; i3 < tableValues.length; ++i3) {
                        mbb.position(startingPos + tableValues[i3] + 4);
                        byte[] compressedFrame = new byte[mbb.getInt()];
                        mbb.get(compressedFrame);
                        buffImgList.add(dicomImageGen.uncompress2BufferedImage(i3, compressedFrame, transferSyntax, littleEndian, imgType, bits, dimx, dimy, prop));
                    }
                    break block9;
                }
                int i4 = 0;
                while (true) {
                    group = mbb.getShort() & 0xFFFF;
                    elem = mbb.getShort() & 0xFFFF;
                    if (group == 65534 && elem == 57344) {
                        byte[] compressedFrame = new byte[mbb.getInt()];
                        mbb.get(compressedFrame);
                        buffImgList.add(dicomImageGen.uncompress2BufferedImage(i4, compressedFrame, transferSyntax, littleEndian, imgType, bits, dimx, dimy, prop));
                        ++i4;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                throw new DMException(ex);
            }
        }
        return buffImgList.toArray(new BufferedImage[buffImgList.size()]);
    }

    public static BufferedImage[] getCompressedImages(String imageName, long pixOffset, int numFrames, int dimx, int dimy, String imgType, int bits, boolean littleEndian, String transferSyntax, Hashtable prop) {
        FileInputStream fis = null;
        BufferedImage[] imgs = null;
        try {
            fis = new FileInputStream(new File(imageName));
            imgs = dicomImageGen.getCompressedImages(fis, pixOffset, numFrames, dimx, dimy, imgType, bits, littleEndian, transferSyntax, prop);
        }
        catch (Exception ex) {
            throw new DMException(ex);
        }
        finally {
            if (null != fis) {
                try {
                    fis.close();
                }
                catch (IOException ioex) {}
            }
        }
        return imgs;
    }

    public static BufferedImage[] getImages(String imageName, DMTag[] dmtags) {
        BufferedImage[] imgs = null;
        try {
            dp.clearFile();
            dp.setFile(imageName);
            imgs = dicomImageGen.getImages(dp, dmtags);
        }
        catch (Exception ex) {
            throw new DMException(ex);
        }
        finally {
            dp.clearFile();
        }
        return imgs;
    }

    public static BufferedImage[] getImages(dicomParser dp, DMTag[] dmtags) {
        BufferedImage[] imgs;
        block19: {
            Object pixData;
            int adjustedVrep;
            int actualVrep;
            int size;
            Hashtable<String, Object> prop;
            int frames;
            int dimx;
            int dimy;
            String imgType;
            block18: {
                int i2;
                int extra = dmtags != null ? dmtags.length : 0;
                Object[] tget = new tagValue[tags.length + extra];
                for (i2 = 0; i2 < tags.length; ++i2) {
                    tget[i2] = new tagValue(tags[i2][0], tags[i2][1]);
                }
                if (dmtags != null) {
                    for (i2 = 0; i2 < dmtags.length; ++i2) {
                        tget[dicomImageGen.tags.length + i2] = new tagValue(dmtags[i2].getGroup(), dmtags[i2].getElement());
                    }
                    Arrays.sort(tget);
                }
                dp.fill((tagValue[])tget);
                String transferSyntax = (String)dicomImageGen.get((tagValue[])tget, 2, 16);
                imgType = (String)dicomImageGen.get((tagValue[])tget, 40, 4);
                if (!supportedImageTypes.contains(imgType)) {
                    System.err.println("The Image type in tag (0028,0004) is: " + imgType + ". Returning an empty array of Buffered images.");
                    return new BufferedImage[0];
                }
                dimy = (Integer)dicomImageGen.get((tagValue[])tget, 40, 16);
                dimx = (Integer)dicomImageGen.get((tagValue[])tget, 40, 17);
                int pixRep = (Integer)dicomImageGen.get((tagValue[])tget, 40, 259);
                frames = dicomImageGen.get((tagValue[])tget, 40, 8) != null ? Integer.parseInt((String)dicomImageGen.get((tagValue[])tget, 40, 8)) : 1;
                prop = new Hashtable<String, Object>(1 + extra);
                try {
                    prop.put("16,16", PersonName.toFormattedString(((String)dicomImageGen.get((tagValue[])tget, 16, 16)).trim()));
                }
                catch (Exception e2) {
                    System.out.println("Patient Name (0x0010,0x0010) not found!");
                }
                for (int i3 = 0; i3 < extra; ++i3) {
                    Object value = dicomImageGen.get((tagValue[])tget, dmtags[i3].getGroup(), dmtags[i3].getElement());
                    if (value == null) continue;
                    if (value.getClass() == Object[].class) {
                        prop.put(dmtags[i3].getGroup() + "," + dmtags[i3].getElement(), new DMSequence(new fileSequence((Object[])value)));
                        continue;
                    }
                    prop.put(dmtags[i3].getGroup() + "," + dmtags[i3].getElement(), value);
                }
                imgs = null;
                size = dimx * dimy;
                if (null != transferSyntax && (transferSyntax.indexOf(DMUtils.TS_JPEGBaseline) != -1 || transferSyntax.indexOf(DMUtils.TS_JPEGLossless) != -1 || transferSyntax.indexOf(DMUtils.TS_RLELossless) != -1)) {
                    InputStream is = dp.getInputStream();
                    if (is instanceof FileInputStream) {
                        FileInputStream fis = (FileInputStream)is;
                        return dicomImageGen.getCompressedImages(fis, ((tagValue)tget[tget.length - 1]).fileOffset, frames, dimx, dimy, imgType, (int)((Integer)dicomImageGen.get((tagValue[])tget, 40, 256)), ((tagValue)tget[tget.length - 1]).isLittleEndian(), transferSyntax, prop);
                    }
                    System.err.println("Could not find file input stream associated with dicom parser. Unable to get buffered images. Returning empty frame(s).");
                    imgs = new BufferedImage[frames];
                    for (int i4 = 0; i4 < frames; ++i4) {
                        byte[] tmpData = new byte[size];
                        imgs[i4] = dicomImageGen.build8bitImage(dimx, dimy, tmpData, 0, (Hashtable)prop.clone());
                    }
                    return imgs;
                }
                imgs = new BufferedImage[frames];
                int bitsAllocated = (Integer)dicomImageGen.get((tagValue[])tget, 40, 256);
                actualVrep = dicomImageGen.getVR((tagValue[])tget, 32736, 16);
                adjustedVrep = bitsAllocated <= 8 ? 20290 : 20311;
                pixData = dicomImageGen.get((tagValue[])tget, 32736, 16);
                if (!imgType.equals("MONOCHROME2") && !imgType.equals("MONOCHROME1")) break block18;
                if (adjustedVrep == 20311) {
                    short[] data = null;
                    data = adjustedVrep == actualVrep ? (short[])pixData : SimpleUtilities.bytesToShort((byte[])pixData, dp.isGuessBigEndian());
                    for (int i5 = 0; i5 < frames; ++i5) {
                        short[] tmpData = new short[size];
                        if (data.length < size) {
                            System.err.println("Pixel data too short: " + data.length + " < " + size + ". Returning empty frame.");
                        } else {
                            System.arraycopy(data, i5 * size, tmpData, 0, size);
                        }
                        prop.put("0,1", new Integer(1 + i5));
                        imgs[i5] = dicomImageGen.build16bitImage(dimx, dimy, tmpData, 0, pixRep, (Hashtable)prop.clone());
                    }
                } else {
                    byte[] data = null;
                    data = adjustedVrep == actualVrep ? (byte[])pixData : SimpleUtilities.shortToByte((short[])pixData, dp.isGuessBigEndian());
                    for (int i6 = 0; i6 < frames; ++i6) {
                        prop.put("0,1", new Integer(1 + i6));
                        imgs[i6] = dicomImageGen.build8bitImage(dimx, dimy, data, i6 * size, (Hashtable)prop.clone());
                    }
                }
                break block19;
            }
            if (!imgType.equals("RGB") || adjustedVrep != 20290) break block19;
            byte[] data = null;
            data = adjustedVrep == actualVrep ? (byte[])pixData : SimpleUtilities.shortToByte((short[])pixData, dp.isGuessBigEndian());
            for (int i7 = 0; i7 < frames; ++i7) {
                prop.put("0,1", new Integer(1 + i7));
                imgs[i7] = dicomImageGen.buildRGBImage(dimx, dimy, data, i7 * size * 3, (Hashtable)prop.clone());
            }
        }
        return imgs;
    }

    public static BufferedImage buildRGBImage(int dimx, int dimy, byte[] data, int offset, Hashtable properties) {
        DataBufferByte dbs = new DataBufferByte(data, dimx * dimy * 3, offset);
        int[] bandOffsets = new int[]{0, 1, 2};
        WritableRaster wr = Raster.createInterleavedRaster(dbs, dimx, dimy, dimx * 3, 3, bandOffsets, null);
        ColorSpace cs = ColorSpace.getInstance(1000);
        int[] bits = new int[]{8, 8, 8};
        ComponentColorModel cm = new ComponentColorModel(cs, bits, false, false, 1, 0);
        try {
            properties.put("PROPERTY_HASH", properties.keys());
        }
        catch (Exception e2) {
            // empty catch block
        }
        BufferedImage img = new BufferedImage(cm, wr, cm.isAlphaPremultiplied(), properties);
        return img;
    }

    public static BufferedImage build16bitImage(int dimx, int dimy, short[] data, int offset, Hashtable properties) {
        return dicomImageGen.build16bitImage(dimx, dimy, data, offset, 0, properties);
    }

    public static BufferedImage build16bitImage(int dimx, int dimy, short[] data, int offset, int pixRep, Hashtable properties) {
        DataBufferUShort dbs = new DataBufferUShort(data, dimx * dimy, offset);
        int[] bandOffsets = new int[]{0};
        WritableRaster wr = Raster.createInterleavedRaster(dbs, dimx, dimy, dimx, 1, bandOffsets, null);
        ColorSpace cs = ColorSpace.getInstance(1003);
        int[] bits = new int[]{16};
        ComponentColorModel cm = new ComponentColorModel(cs, bits, false, false, 1, 1);
        try {
            properties.put("PROPERTY_HASH", properties.keys());
        }
        catch (Exception e2) {
            // empty catch block
        }
        BufferedImage img = new BufferedImage(cm, wr, cm.isAlphaPremultiplied(), properties);
        return img;
    }

    public static BufferedImage build8bitImage(int dimx, int dimy, byte[] data, int offset, Hashtable properties) {
        DataBufferByte dbs = new DataBufferByte(data, dimx * dimy, offset);
        int[] bandOffsets = new int[]{0};
        WritableRaster wr = Raster.createInterleavedRaster(dbs, dimx, dimy, dimx, 1, bandOffsets, null);
        ColorSpace cs = ColorSpace.getInstance(1003);
        int[] bits = new int[]{8};
        ComponentColorModel cm = new ComponentColorModel(cs, bits, false, false, 1, 0);
        try {
            properties.put("PROPERTY_HASH", properties.keys());
        }
        catch (Exception e2) {
            // empty catch block
        }
        BufferedImage img = new BufferedImage(cm, wr, cm.isAlphaPremultiplied(), properties);
        return img;
    }

    public static BufferedImage build32bitImage(int dimx, int dimy, int[] data, int offset, Hashtable properties) {
        DataBufferInt dbs = new DataBufferInt(data, dimx * dimy, offset);
        int[] bandOffsets = new int[]{0};
        WritableRaster wr = Raster.createInterleavedRaster(dbs, dimx, dimy, dimx, 1, bandOffsets, null);
        ColorSpace cs = ColorSpace.getInstance(1003);
        int[] bits = new int[]{32};
        ComponentColorModel cm = new ComponentColorModel(cs, bits, false, false, 1, 3);
        try {
            properties.put("PROPERTY_HASH", properties.keys());
        }
        catch (Exception e2) {
            // empty catch block
        }
        BufferedImage img = new BufferedImage(cm, wr, cm.isAlphaPremultiplied(), properties);
        return img;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            return;
        }
        String[] str = args;
        dicomParser dp = new dicomParser();
        BufferedImage[] imgs = null;
        for (int i2 = 0; i2 < str.length; ++i2) {
            try {
                dp.setFile(str[i2]);
                imgs = dicomImageGen.getImages(dp, null);
                dp.clearFile();
                jport.display(imgs);
                continue;
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
            }
        }
    }
}

