/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.sessionFile;

import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import com.ge.med.terra.tap.dm.peer.DMiComposite;
import com.ge.med.terra.tap.dm.peer.DMiImage;
import com.ge.med.terra.tap.dm.sessionFile.fileCompositeBase;
import com.ge.med.terra.tap.dm.sessionFile.fileImage;
import com.ge.med.terra.tap.dm.sessionFile.fileImageManager;
import com.ge.med.terra.tap.dm.sessionFile.fileObject;
import com.ge.med.terra.tap.dm.sessionFile.fileSequence;
import com.ge.med.terra.tap.dm.sessionFile.fileSession;
import com.ge.med.terra.tap.util.dicom.TagValueList;
import com.ge.med.terra.tap.util.dicom.jdbCIOD;
import com.ge.med.terra.tap.util.dicom.jdbIE;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class fileComposite
extends fileCompositeBase
implements DMiComposite,
DMTagValueInterface {
    protected final String fileName;
    private jdbCIOD ciod = null;
    private fileSession session = null;
    private HashMap<DMTag, tagValue> elemCache = new HashMap(ciodKey.length);
    private static short[][] ciodKey = new short[][]{{8, 22}, {8, 24}, {16, 16}, {16, 32}, {16, 48}, {32, 13}, {32, 14}};
    private static tagValue[] tget = new tagValue[ciodKey.length];

    public void setCIOD(jdbCIOD ciod) {
        this.ciod = ciod;
    }

    @Override
    public String getType() {
        if (this.ciod == null) {
            return null;
        }
        return this.ciod.getCiodName();
    }

    public jdbCIOD getCIOD() {
        return this.ciod;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    public String getUrl() {
        return this.url == null ? null : this.url.getProtocol() + "://" + this.url.getHost() + ":" + this.url.getPath();
    }

    public TagValueList getUniqueValues(String ieName) {
        TagValueList uniqueTags = null;
        if (this.ciod == null) {
            return null;
        }
        jdbIE ie = this.ciod.getIE(ieName);
        if (ie != null && ie.getIEName().equalsIgnoreCase(ieName)) {
            uniqueTags = new TagValueList(ie.getUniqueTags());
        }
        if (uniqueTags != null) {
            this.getValues(uniqueTags);
        }
        return uniqueTags;
    }

    public fileComposite(fileSession session, File fp) throws FileNotFoundException {
        this.session = session;
        this.fileName = fp.getAbsolutePath();
        this.setup();
    }

    public fileComposite(fileSession session, URL url) throws FileNotFoundException {
        this.session = session;
        this.fileName = null;
        this.url = url;
        this.setup();
    }

    public fileComposite(fileSession session, String f2) throws FileNotFoundException {
        this.session = session;
        this.fileName = f2;
        this.setup();
    }

    protected void setup() throws FileNotFoundException {
        try {
            if (this.fileName != null) {
                parser.setFile(this.fileName);
            } else {
                try {
                    parser.setFile(this.url.openStream());
                }
                catch (Exception ex) {
                    System.out.println(this.url);
                    ex.printStackTrace();
                }
            }
            parser.fill(tget);
            for (int i2 = 0; i2 < ciodKey.length; ++i2) {
                DMTag tag2 = new DMTag(ciodKey[i2][0], ciodKey[i2][1]);
                this.elemCache.put(tag2, new tagValue(tget[i2]));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            parser.clearFile();
        }
    }

    public void printCacheForDebugging() {
        RuntimeException e2 = new RuntimeException();
        StackTraceElement[] ste = e2.getStackTrace();
        System.out.println(ste[2]);
        Set<DMTag> keys = this.elemCache.keySet();
        Iterator<DMTag> it = keys.iterator();
        System.out.println("=========================");
        System.out.println("this.hashCode= " + this.hashCode());
        while (it.hasNext()) {
            System.out.println(this.elemCache.get(it.next()));
        }
        System.out.println("=========================");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValue(DMTag tag2) {
        if (this.elemCache.containsKey(tag2)) {
            return this.elemCache.get((Object)tag2).value;
        }
        try {
            if (this.fileName != null) {
                parser.setFile(this.fileName);
            } else {
                try {
                    parser.setFile(this.url.openStream());
                }
                catch (Exception ex) {
                    System.out.println(this.url);
                    ex.printStackTrace();
                }
            }
            tagValue tv = new tagValue(tag2.getGroup(), tag2.getElement());
            parser.fill(new tagValue[]{tv});
            if (tv.vrep == 21329) {
                tv.value = new fileSequence(tv);
            }
            if (tag2.getGroup() < 200) {
                this.elemCache.put(new DMTag(tag2.getGroup(), tag2.getElement()), tv);
            }
            Object object = tv.value;
            return object;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        finally {
            parser.clearFile();
        }
        return null;
    }

    @Override
    public void getValues(DMElement[] elements) {
        int size = elements.length;
        boolean[] isFilled = new boolean[size];
        ArrayList<DMElement> tagsToFill = new ArrayList<DMElement>();
        for (int i2 = 0; i2 < elements.length; ++i2) {
            DMTag tag2 = new DMTag(elements[i2].group, elements[i2].element);
            if (this.elemCache.containsKey(tag2)) {
                tagValue tval = this.elemCache.get(tag2);
                tagValue.copyFillData(tval, elements[i2]);
                isFilled[i2] = true;
                continue;
            }
            isFilled[i2] = false;
            tagsToFill.add(elements[i2]);
        }
        if (!tagsToFill.isEmpty()) {
            try {
                if (this.fileName == null && this.url != null) {
                    try {
                        parser.setFile(this.url.openStream());
                    }
                    catch (Exception ex) {
                        throw new DMException(ex);
                    }
                } else {
                    parser.setFile(this.fileName);
                }
                Object[] tgs = tagsToFill.toArray(new DMElement[tagsToFill.size()]);
                Arrays.sort(tgs);
                parser.fill((tagValue[])tgs);
                int oldg = -1;
                int olde = -1;
                for (int i3 = 0; i3 < tgs.length; ++i3) {
                    if (((DMElement)tgs[i3]).vrep == 21329) {
                        ((DMElement)tgs[i3]).value = new fileSequence((tagValue)tgs[i3]);
                    }
                    if (oldg != ((DMElement)tgs[i3]).group || olde != ((DMElement)tgs[i3]).element) {
                        DMTag tag3 = new DMTag(((DMElement)tgs[i3]).group, ((DMElement)tgs[i3]).element);
                        this.elemCache.put(tag3, new tagValue((tagValue)tgs[i3]));
                    }
                    oldg = ((DMElement)tgs[i3]).group;
                    olde = ((DMElement)tgs[i3]).element;
                }
            }
            catch (FileNotFoundException ex) {
                throw new DMException(ex);
            }
            finally {
                parser.clearFile();
            }
        }
    }

    public void getValues(TagValueList list) {
        ArrayList<tagValue> al2 = new ArrayList<tagValue>();
        for (int i2 = 0; i2 < list.group.length; ++i2) {
            DMTag tag2 = new DMTag(list.group[i2], list.element[i2]);
            if (this.elemCache.containsKey(tag2)) {
                list.value[i2] = this.elemCache.get((Object)tag2).value;
                continue;
            }
            al2.add(new tagValue(list.group[i2], list.element[i2]));
        }
        if (al2.size() > 0) {
            tagValue[] tv = new tagValue[al2.size()];
            Iterator iter = al2.iterator();
            int count = 0;
            while (iter.hasNext()) {
                tv[count++] = (tagValue)iter.next();
            }
            try {
                if (this.fileName != null) {
                    parser.setFile(this.fileName);
                } else {
                    try {
                        parser.setFile(this.url.openStream());
                    }
                    catch (Exception ex) {
                        System.out.println(this.url);
                        ex.printStackTrace();
                    }
                }
                parser.fill(tv);
                parser.clearFile();
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
            }
            for (int j2 = 0; j2 < tv.length; ++j2) {
                for (int i3 = 0; i3 < list.group.length; ++i3) {
                    if (list.group[i3] != tv[j2].group || list.element[i3] != tv[j2].element) continue;
                    list.value[i3] = tv[j2].value;
                    DMTag tag3 = new DMTag(list.group[i3], list.element[i3]);
                    this.elemCache.put(tag3, tv[j2]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DMTag[] getTags() {
        try {
            if (this.fileName != null) {
                parser.setFile(this.fileName);
            } else {
                try {
                    parser.setFile(this.url.openStream());
                }
                catch (Exception ex) {
                    System.out.println(this.url);
                    ex.printStackTrace();
                }
            }
            tagValue[] tv = parser.getTags();
            DMTag[] dt = new DMTag[tv.length];
            for (int i2 = 0; i2 < tv.length; ++i2) {
                dt[i2] = new DMTag(tv[i2].group, tv[i2].element, tv[i2].vrString());
            }
            DMTag[] dMTagArray = dt;
            return dMTagArray;
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        finally {
            parser.clearFile();
        }
        return null;
    }

    public void save() {
    }

    @Override
    public void delete() {
        Iterator i2 = this.session.getListOfFileObjects();
        fileComposite[] c2 = new fileComposite[]{this};
        while (i2.hasNext()) {
            ((fileObject)i2.next()).delete(c2, null);
        }
        this.deleteFile();
    }

    public void deleteFile() {
        if (this.fileName == null) {
            return;
        }
        File f2 = new File(this.fileName);
        File trash = new File(this.session.dir, f2.getName());
        boolean b2 = f2.renameTo(trash);
        if (!b2) {
            System.out.println("unable to move \"" + this.fileName + "\" to \"" + trash.getAbsolutePath() + "\"");
        }
        if (!(b2 = trash.delete())) {
            System.out.println("unable to delete \"" + trash.getAbsolutePath() + "\"");
        }
        this.ciod = null;
        this.elemCache.clear();
    }

    @Override
    public void setValues(DMElement[] elements) {
    }

    @Override
    public InputStream getInputStream() {
        try {
            if (this.fileName == null) {
                return this.url.openStream();
            }
            return new FileInputStream(this.fileName);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.toString());
        }
    }

    @Override
    public String getID() {
        if (this.fileName != null) {
            return "C|" + this.getValue(new DMTag(8, 24));
        }
        return "C|" + this.getValue(new DMTag(8, 24));
    }

    @Override
    public DMiImage[] getImages(DMTag[] tags) {
        fileImageManager.getInstance().setPause(true);
        DMiImage[] imgs = fileImage.getImages(this, tags);
        fileImageManager.getInstance().setPause(false);
        return imgs;
    }

    @Override
    public String getFilePath() {
        return this.fileName != null ? this.fileName : this.url.toString();
    }

    void clearCache() {
        this.elemCache.clear();
    }

    void removeTagFromCache(DMTag tag2) {
        this.elemCache.remove(tag2);
    }

    static {
        for (int i2 = 0; i2 < ciodKey.length; ++i2) {
            fileComposite.tget[i2] = new tagValue(ciodKey[i2][0], ciodKey[i2][1]);
        }
    }
}

