/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.sessionFile;

import com.ge.med.terra.tap.dm.DMEvent;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.DMJob;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.peer.DMiComposite;
import com.ge.med.terra.tap.dm.peer.DMiJob;
import com.ge.med.terra.tap.dm.peer.DMiObject;
import com.ge.med.terra.tap.dm.peer.DMiSession;
import com.ge.med.terra.tap.dm.sessionFile.fileSession;
import java.util.Hashtable;

public class fileJob
implements DMiJob {
    public static final int SAVE_OBJECT = 0;
    public static final int SAVE_COMPOSITE = 1;
    public static final int DO_SEND = 2;
    public static final int JOB_PAUSED = 3;
    public static final int JOB_FAILED = 4;
    public static final int JOB_SUCEEDED = 0;
    public static final int JOB_INPROGRESS = 1;
    public static final int JOB_PENDING = 2;
    public static final int JOB_CANCELLED = 6;
    DMiObject o;
    DMiComposite c;
    fileSession session;
    long jobHandle;
    int jobType;
    int state;
    int imagesSaved = 0;
    int totalImages = 0;
    boolean pauseFlag = false;
    boolean cancelFlag = false;
    private Hashtable properties = new Hashtable();

    public fileJob(fileSession s2, int jobType, Object jobParam) {
        this.session = s2;
        this.jobType = jobType;
        if (jobParam instanceof DMiObject) {
            this.o = (DMiObject)jobParam;
        } else if (jobParam instanceof DMiComposite) {
            this.c = (DMiComposite)jobParam;
        }
        this.state = 2;
        this.jobHandle = this.hashCode();
    }

    public void setSession(fileSession s2) {
        this.session = s2;
    }

    public void setJobHandle(long h2) {
        this.jobHandle = h2;
    }

    public void start() {
        this.run();
    }

    public void run() {
        switch (this.jobType) {
            case 0: {
                this.saveObject();
                break;
            }
            case 1: {
                this.saveComposite();
                break;
            }
            case 2: {
                this.doSend();
                break;
            }
            default: {
                System.out.println("Unrecognized jobTyp");
            }
        }
        if (this.state == 0 || this.state == 4) {
            DMEvent dme = new DMEvent(3, "Job Completed Event");
            dme.setSource(new DMJob(this));
            this.session.fireEvent(dme);
            this.session.removeJob(this);
            this.o = null;
            this.c = null;
            this.session = null;
        }
    }

    public DMiSession getSession() {
        return this.session;
    }

    @Override
    public long getJobHandle() {
        return this.jobHandle;
    }

    @Override
    public void cancel() {
        if (this.state == 1 || this.state == 2 || this.state == 3) {
            this.cancelFlag = true;
            this.state = 6;
        } else {
            System.out.println("Not cancelling because status= " + this.getStatusString());
        }
    }

    public int getStatus() {
        return this.state;
    }

    @Override
    public void executeImmediately() {
    }

    @Override
    public void waitForCompletion() {
        while (this.state == 1 || this.state == 3 || this.state == 2) {
            try {
                Thread.currentThread();
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void pause() {
        if (this.state == 1 || this.state == 2) {
            this.pauseFlag = true;
            this.state = 3;
        } else {
            System.out.println("Not pausing because status= " + this.getStatusString());
        }
    }

    @Override
    public void resume() {
        if (this.state == 3) {
            this.pauseFlag = false;
            this.state = 2;
        } else {
            System.out.println("Not resuming because status= " + this.getStatusString());
        }
    }

    private void saveObject() {
        if (this.state == 6) {
            return;
        }
        this.state = 1;
        this.save(this.o);
        this.state = 0;
    }

    private void saveComposite() {
        if (this.state == 6) {
            return;
        }
        this.state = 1;
        this.save(this.c);
        this.state = 0;
    }

    private void doSend() {
        System.out.println("doSend() Not Yet Implemented");
    }

    public String getJobName() {
        String name = "";
        name = this.o != null ? name + this.o.getRelated("PATIENT", null)[0].getValue(new DMTag(16, 16)) : (this.c != null ? name + this.c.getValue(new DMTag(16, 16)) : "Job- " + Long.toString(this.getJobHandle()));
        return name;
    }

    @Override
    public String getStatusString() {
        switch (this.state) {
            case 3: {
                return "Paused";
            }
            case 4: {
                return "Failed";
            }
            case 0: {
                return "Successfully Completed";
            }
            case 1: {
                String str = "In progress";
                if (this.o != null && this.totalImages != 0) {
                    str = str + "(" + this.imagesSaved + " of " + this.totalImages + " images done)";
                }
                return str;
            }
            case 2: {
                return "Pending";
            }
            case 6: {
                return "Cancelled";
            }
        }
        return "UNKNOWN";
    }

    public void save(DMiObject o2) {
        DMiComposite[] comp = o2.getComposites(null);
        for (int i2 = 0; i2 < comp.length; ++i2) {
            this.save(comp[i2]);
        }
    }

    public void save(DMiComposite o2) {
        try {
            this.session.install(o2.getInputStream());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.state = 4;
            throw new DMException(ex);
        }
    }

    public String toString() {
        return this.getJobName() + " [Status- " + this.getStatusString() + "]";
    }

    @Override
    public String[] getResultString() {
        return null;
    }

    @Override
    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    @Override
    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    @Override
    public int getState() {
        return this.state;
    }
}

