/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.sessionFile;

import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import com.ge.med.terra.tap.dm.peer.DMiComposite;
import com.ge.med.terra.tap.dm.peer.DMiImage;
import com.ge.med.terra.tap.dm.peer.DMiObject;
import com.ge.med.terra.tap.dm.peer.DMiObjectReceiver;
import com.ge.med.terra.tap.dm.sessionFile.fileComposite;
import com.ge.med.terra.tap.dm.sessionFile.fileImage;
import com.ge.med.terra.tap.dm.sessionFile.fileImageManager;
import com.ge.med.terra.tap.dm.sessionFile.fileObjectBase;
import com.ge.med.terra.tap.dm.sessionFile.fileSession;
import com.ge.med.terra.tap.util.dicom.DicomComposite;
import com.ge.med.terra.tap.util.dicom.TagValueList;
import com.ge.med.terra.tap.util.dicom.jdbIE;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.util.HashMap;
import java.util.Iterator;

public class fileObject
extends fileObjectBase
implements DMiObject,
DMTagValueInterface {
    protected fileSession session;
    jdbIE ie;
    private static String[] levels = new String[]{"patient", "study", "series", "image"};
    HashMap allChildObjects = new HashMap();
    HashMap tmpContainer = new HashMap();
    static boolean OLD_GETRELATED = false;
    ServerSocket socket;
    int refCount = 0;

    public fileObject(fileSession session, fileComposite c2, jdbIE ie) {
        this.session = session;
        this.compList = new fileComposite[1];
        this.compList[0] = c2;
        this.ie = ie;
        session.addFileObject(c2.getUniqueValues(this.getType()), this);
    }

    protected void addCompositeIfValid(fileComposite c2) {
        TagValueList tvl_b;
        TagValueList tvl_a = this.compList[0].getUniqueValues(this.getType());
        if (tvl_a.equals(tvl_b = c2.getUniqueValues(this.getType()))) {
            this.addComposite(c2);
        }
    }

    @Override
    public DMiObject[] getRelated(String IEType, DMQuery query) {
        if (IEType.equals(this.ie.getIEName())) {
            return new fileObject[]{this};
        }
        HashMap childList = this.createHashmap(IEType);
        fileObject[] fileObjs = new fileObject[childList.size()];
        Iterator i2 = childList.values().iterator();
        int count = 0;
        while (i2.hasNext()) {
            Object obj = i2.next();
            fileObject o2 = (fileObject)obj;
            if (query != null && !query.valid(o2)) continue;
            fileObjs[count++] = o2;
        }
        DMiObject[] out = new fileObject[count];
        System.arraycopy(fileObjs, 0, out, 0, count);
        return out;
    }

    private boolean isBelowMe(String ieType) {
        String mytype = this.getType();
        boolean found = false;
        for (int i2 = 0; i2 < levels.length; ++i2) {
            if (levels[i2].equalsIgnoreCase(mytype)) {
                found = true;
            }
            if (!levels[i2].equalsIgnoreCase(ieType) || !found) continue;
            return true;
        }
        return false;
    }

    private HashMap createHashmap(String ieType) {
        if (this.isBelowMe(ieType)) {
            if (this.allChildObjects.containsKey(ieType)) {
                return (HashMap)this.allChildObjects.get(ieType);
            }
            HashMap<TagValueList, fileObject> childList = new HashMap<TagValueList, fileObject>();
            for (int i2 = 0; i2 < this.compList.length; ++i2) {
                TagValueList tl = this.compList[i2].getUniqueValues(ieType);
                if (childList.containsKey(tl)) {
                    ((fileObject)childList.get(tl)).addComposite(this.compList[i2]);
                    continue;
                }
                fileObject newobj = this.session.getFileObject(tl);
                if (newobj == null) {
                    newobj = new fileObject(this.session, this.compList[i2], this.compList[i2].getCIOD().getIE(ieType));
                    this.session.addFileObject(tl, newobj);
                }
                childList.put(tl, newobj);
            }
            this.allChildObjects.put(ieType, childList);
            return childList;
        }
        TagValueList tl = this.compList[0].getUniqueValues(ieType);
        fileObject fo = this.session.getFileObject(tl);
        if (fo == null) {
            TagValueList pval = this.compList[0].getUniqueValues("patient");
            fileObject pat = this.session.getFileObject(pval);
            pat.getRelated(ieType, null);
            fo = this.session.getFileObject(tl);
        }
        this.tmpContainer.clear();
        this.tmpContainer.put(ieType, fo);
        return this.tmpContainer;
    }

    @Override
    public void setLock(int lockType) {
        throw new UnsupportedOperationException("Method getLock() not yet implemented.");
    }

    @Override
    public int getLock() {
        throw new UnsupportedOperationException("Method getLock() not yet implemented.");
    }

    @Override
    public void getRelated(final String type, final DMQuery q2, final DMiObjectReceiver cb) {
        Runnable r2 = new Runnable(){

            @Override
            public void run() {
                HashMap childList = fileObject.this.createHashmap(type);
                for (Object obj : childList.values()) {
                    fileObject o2 = (fileObject)obj;
                    if (q2 != null && !q2.valid(o2) || cb.gotOne(o2)) continue;
                    break;
                }
            }
        };
        if (OLD_GETRELATED) {
            new Thread(r2).start();
        } else {
            r2.run();
        }
    }

    @Override
    public String getType() {
        return this.ie.getIEName();
    }

    protected void addComposite(DMiComposite comp) {
        for (int i2 = 0; i2 < this.compList.length; ++i2) {
            if (comp != this.compList[i2]) continue;
            return;
        }
        fileComposite[] c2 = new fileComposite[this.compList.length + 1];
        System.arraycopy(this.compList, 0, c2, 0, this.compList.length);
        c2[this.compList.length] = (fileComposite)comp;
        this.compList = c2;
    }

    @Override
    public Object getValue(DMTag t2) {
        if (this.compList.length > 0) {
            return this.compList[0].getValue(t2);
        }
        return null;
    }

    @Override
    public void getValues(DMElement[] elements) {
        if (this.compList != null && this.compList.length > 0) {
            this.compList[0].getValues(elements);
        }
    }

    private File[] setupCrashRecovery(DMElement[] elements) throws Exception {
        int portNum = fileSession.updateFlagSocket;
        this.socket = new ServerSocket(portNum);
        File sessionDir = this.session.dir;
        if (sessionDir == null) {
            sessionDir = new File(((fileComposite)this.session.getComposites()[0]).fileName).getParentFile();
        }
        File stageDir = new File(sessionDir, fileSession.stageFiles);
        stageDir.mkdir();
        File updateDir = new File(stageDir, fileSession.updateFiles);
        updateDir.mkdir();
        File modifiedDir = new File(updateDir, fileSession.modifiedFiles);
        modifiedDir.mkdir();
        String curTime = Long.toString(System.currentTimeMillis());
        File elemsFile = new File(updateDir, curTime + ".elems");
        File ridFile = new File(updateDir, curTime + ".rid");
        FileOutputStream fout = new FileOutputStream(elemsFile);
        ObjectOutputStream out = new ObjectOutputStream(fout);
        out.writeObject(elements);
        out.close();
        fout.close();
        fout = new FileOutputStream(ridFile);
        out = new ObjectOutputStream(fout);
        out.writeObject(new String[]{this.getType(), this.getID()});
        out.close();
        fout.close();
        return new File[]{elemsFile, ridFile};
    }

    private void cleanupCrashRecovery(File[] backupFiles) throws IOException {
        for (int i2 = 0; i2 < backupFiles.length; ++i2) {
            backupFiles[i2].delete();
        }
        if (this.socket != null) {
            this.socket.close();
        } else {
            System.out.println("socket was already null!! ??");
        }
        this.socket = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setValues(DMElement[] elements) {
        File[] backupFiles = null;
        try {
            System.out.println("In setValues()");
            backupFiles = this.setupCrashRecovery(elements);
            this.setValuesWork(elements);
        }
        catch (Exception e2) {
            try {
                throw new DMException("Update failed ... someone else may be updating" + e2.getLocalizedMessage());
            }
            catch (Throwable throwable) {
                try {
                    this.cleanupCrashRecovery(backupFiles);
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new DMException("crash recovery cleanup failed: " + ex.getLocalizedMessage());
                }
            }
        }
        try {
            this.cleanupCrashRecovery(backupFiles);
        }
        catch (IOException ex) {
            throw new DMException("crash recovery cleanup failed: " + ex.getLocalizedMessage());
        }
        this.session.sendEvent(2, "Update", this.getID());
    }

    private void setValuesWork(DMElement[] elements) {
        File sessionDir = this.session.dir;
        if (sessionDir == null) {
            sessionDir = new File(((fileComposite)this.session.getComposites()[0]).fileName).getParentFile();
        }
        File stageDir = new File(sessionDir, fileSession.stageFiles);
        stageDir.mkdir();
        File updateDir = new File(stageDir, fileSession.updateFiles);
        updateDir.mkdir();
        File modifiedDir = new File(updateDir, fileSession.modifiedFiles);
        modifiedDir.mkdir();
        fileComposite[] comps = (fileComposite[])this.getComposites(null);
        for (int i2 = 0; i2 < comps.length; ++i2) {
            try {
                DicomComposite data = new DicomComposite();
                FileInputStream fis = new FileInputStream(comps[i2].getFileName());
                data.read(fis);
                fis.close();
                data.setValues(elements);
                File f2 = new File(modifiedDir, new File(comps[i2].getFileName()).getName());
                f2.createNewFile();
                FileOutputStream fos = new FileOutputStream(f2);
                data.write(fos, true);
                fos.close();
                continue;
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        File[] updatedFiles = modifiedDir.listFiles();
        for (int i3 = 0; i3 < updatedFiles.length; ++i3) {
            final String fileName = updatedFiles[i3].getName();
            File[] orig = sessionDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.equals(fileName);
                }
            });
            if (orig.length == 0) {
                orig = new File(sessionDir + File.separator + fileSession.newFiles).listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.equals(fileName);
                    }
                });
            }
            orig[0].delete();
            if (updatedFiles[i3].renameTo(orig[0])) continue;
            throw new DMException("Unable to update " + updatedFiles[i3].getName());
        }
        if (!modifiedDir.delete()) {
            System.out.println("Unable to delete " + modifiedDir.getAbsolutePath());
        }
        if (!updateDir.delete()) {
            System.out.println("Unable to delete " + updateDir.getAbsolutePath());
        }
        if (!stageDir.delete()) {
            System.out.println("Unable to delete " + stageDir.getAbsolutePath());
        }
    }

    @Override
    public DMiComposite[] getComposites(DMQuery q2) {
        if (q2 == null) {
            return this.compList;
        }
        fileComposite[] tmp = new fileComposite[this.compList.length];
        int count = 0;
        for (int i2 = 0; i2 < this.compList.length; ++i2) {
            tmp[count++] = this.compList[i2];
        }
        DMiComposite[] res = new fileComposite[count];
        System.arraycopy(tmp, 0, res, 0, count);
        return res;
    }

    @Override
    public int getNumberOfComposites(DMQuery q2) {
        return this.compList.length;
    }

    @Override
    public int getNumberOfRelated(String ieType, DMQuery q2) {
        return this.getRelated(ieType, q2).length;
    }

    public String getFileNames() {
        String fileNames = null;
        for (int i2 = 0; i2 < this.compList.length; ++i2) {
            String file = this.compList[i2].getFileName();
            if (file == null) {
                file = this.compList[i2].getUrl();
            }
            fileNames = fileNames == null ? file : fileNames + "|" + file;
        }
        return fileNames;
    }

    @Override
    public DMTag[] getTags() {
        return null;
    }

    public String getIdString() {
        TagValueList tvl = this.compList[0].getUniqueValues(this.getType());
        return tvl.toString();
    }

    void delete(fileComposite[] clist, fileObject tobeDel) {
        fileComposite[] tmpList = new fileComposite[this.compList.length];
        int count = 0;
        for (int i2 = 0; i2 < this.compList.length; ++i2) {
            boolean found = false;
            for (int j2 = 0; j2 < clist.length; ++j2) {
                if (this.compList[i2] != clist[j2]) continue;
                found = true;
                break;
            }
            if (found) continue;
            tmpList[count++] = this.compList[i2];
        }
        fileComposite[] newList = new fileComposite[count];
        System.arraycopy(tmpList, 0, newList, 0, count);
        this.compList = newList;
        if (tobeDel == null) {
            return;
        }
        block2: for (HashMap item : this.allChildObjects.values()) {
            if (!item.containsValue(tobeDel)) continue;
            for (Object key : item.keySet()) {
                if (!item.get(key).equals(tobeDel)) continue;
                item.remove(key);
                continue block2;
            }
        }
    }

    @Override
    public void delete() {
        for (int i2 = 0; i2 < this.compList.length; ++i2) {
            this.compList[i2].deleteFile();
        }
        this.compList = new fileComposite[0];
        this.session.removeCach(this);
        Iterator i3 = this.session.getListOfFileObjects();
        while (i3.hasNext()) {
            ((fileObject)i3.next()).delete(this.compList, this);
        }
        this.session.sendEvent(2, this.ie.getIEName() + " removed", this.getID());
    }

    @Override
    public void attach() {
        ++this.refCount;
    }

    @Override
    public void detach() {
        --this.refCount;
    }

    @Override
    public String getID() {
        if (this.getType().equalsIgnoreCase("Patient")) {
            return "P|" + this.getValue(new DMTag(16, 16)) + "|" + this.getValue(new DMTag(16, 32)) + "|" + this.getValue(new DMTag(16, 48));
        }
        if (this.getType().equalsIgnoreCase("Study") || this.getType().equalsIgnoreCase("Exam")) {
            return "E|" + this.getValue(new DMTag(32, 13));
        }
        if (this.getType().equalsIgnoreCase("Series")) {
            return "S|" + this.getValue(new DMTag(32, 14));
        }
        if (this.getType().equalsIgnoreCase("Image")) {
            return "I|" + this.getValue(new DMTag(8, 24));
        }
        return "UNKNOWN";
    }

    @Override
    public DMiImage[] getImages(DMTag[] tags) {
        fileImageManager.getInstance().setPause(true);
        DMiImage[] imgs = new DMiImage[this.compList.length];
        int count = 0;
        for (int i2 = 0; i2 < this.compList.length; ++i2) {
            fileImage[] img = fileImage.getImages(this.compList[i2], tags);
            if (img == null) continue;
            if (img.length + count > imgs.length) {
                DMiImage[] new_imgs = new DMiImage[img.length + count + 20];
                System.arraycopy(imgs, 0, new_imgs, 0, count);
                imgs = new_imgs;
            }
            System.arraycopy(img, 0, imgs, count, img.length);
            count += img.length;
        }
        DMiImage[] new_imgs = new DMiImage[count];
        System.arraycopy(imgs, 0, new_imgs, 0, count);
        fileImageManager.getInstance().setPause(false);
        return new_imgs;
    }
}

