/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.sessionFile;

import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMEvent;
import com.ge.med.terra.tap.dm.DMEventListener;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.peer.DMiComposite;
import com.ge.med.terra.tap.dm.peer.DMiJob;
import com.ge.med.terra.tap.dm.peer.DMiObject;
import com.ge.med.terra.tap.dm.peer.DMiObjectReceiver;
import com.ge.med.terra.tap.dm.peer.DMiSession;
import com.ge.med.terra.tap.dm.sessionFile.fileComposite;
import com.ge.med.terra.tap.dm.sessionFile.fileJob;
import com.ge.med.terra.tap.dm.sessionFile.fileObject;
import com.ge.med.terra.tap.dm.sessionFile.peerToPeerComm;
import com.ge.med.terra.tap.util.SimpleUtilities;
import com.ge.med.terra.tap.util.URLReader;
import com.ge.med.terra.tap.util.dicom.TagValueList;
import com.ge.med.terra.tap.util.dicom.jdbCIOD;
import com.ge.med.terra.tap.util.dicom.jdbCIODs;
import com.ge.med.terra.tap.util.dicom.jdbIE;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;

public class fileSession
implements DMiSession {
    public static final String GET_FILE_PATH_CMD = "GetFilePath";
    public static final String PRINT_COMP_CACHE_CMD = "PrintCompCache";
    public static final String REMOVE_TAG_FROM_COMP_CACHE_CMD = "RemoveTagFromCompCache";
    public static final String CLEAR_COMP_CACHE_CMD = "ClearCompCache";
    protected File dir;
    public static String newFiles = "new";
    public static String stageFiles = "stage";
    public static String updateFiles = "update";
    public static String modifiedFiles = "modified";
    public static int updateFlagSocket = 8917;
    protected fileComposite[] comp;
    protected HashMap pat = new HashMap(20);
    protected Vector objectList = new Vector();
    protected static jdbCIODs iods = new jdbCIODs();
    protected HashMap allFileObjects = new HashMap(200);
    protected String session;
    protected String[] args;
    protected ArrayList jobs = new ArrayList();
    protected static DMTag classID = new DMTag(8, 22);
    protected TagValueList olist = null;
    private byte[] bbuff = new byte[32768];
    Vector[] listenerList = new Vector[10];
    protected peerToPeerComm p2pcomm;
    Thread th = null;
    boolean closeCalled = false;

    void addFileObject(TagValueList tvl, fileObject o2) {
        this.allFileObjects.put(tvl, o2);
    }

    fileObject getFileObject(TagValueList tvl) {
        return (fileObject)this.allFileObjects.get(tvl);
    }

    Iterator getListOfFileObjects() {
        return this.allFileObjects.values().iterator();
    }

    private void mapComposites() {
        for (int i2 = 0; i2 < this.comp.length; ++i2) {
            this.addComposites(this.comp[i2]);
        }
    }

    void addFileObject(fileObject fo) {
        this.objectList.add(fo);
    }

    protected void addComposites(fileComposite c2) {
        jdbCIOD ciod;
        int count;
        Object o2 = c2.getValue(classID);
        String str = null;
        str = o2 != null ? ((String)o2).trim() : "0.0.0.0";
        jdbCIOD found = null;
        for (count = 0; count != fileSession.iods.ciodList.size(); ++count) {
            ciod = (jdbCIOD)fileSession.iods.ciodList.elementAt(count);
            if (!ciod.getUid().equals(str)) continue;
            found = ciod;
            break;
        }
        if (found == null) {
            str = "0.0.0.0";
        }
        for (count = 0; count != fileSession.iods.ciodList.size(); ++count) {
            ciod = (jdbCIOD)fileSession.iods.ciodList.elementAt(count);
            if (!ciod.getUid().equals(str)) continue;
            c2.setCIOD(ciod);
            jdbIE ie = null;
            for (int i2 = 0; i2 < ciod.ieList.size() && !(ie = (jdbIE)ciod.ieList.get(i2)).getIEName().equalsIgnoreCase("Patient"); ++i2) {
            }
            TagValueList tlist = new TagValueList(ie.getUniqueTags());
            c2.getValues(tlist);
            fileObject pobj = (fileObject)this.pat.get(tlist);
            if (pobj == null) {
                if (this.olist != null) {
                    this.olist = tlist;
                }
                pobj = new fileObject(this, c2, ie);
                this.pat.put(tlist, pobj);
                break;
            }
            pobj.addComposite(c2);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retryUpdates() {
        if (this.session != null && this.session.equals("URL")) {
            return;
        }
        File updateDir = new File(this.dir + File.separator + stageFiles, updateFiles);
        File modifiedDir = new File(updateDir, modifiedFiles);
        File[] updatedFiles = modifiedDir.listFiles();
        for (int i2 = 0; updatedFiles != null && i2 < updatedFiles.length; ++i2) {
            final String fileName = updatedFiles[i2].getName();
            File[] orig = this.dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.equals(fileName);
                }
            });
            if (orig.length == 0) {
                orig = new File(this.dir + File.separator + newFiles).listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.equals(fileName);
                    }
                });
            }
            orig[0].delete();
            if (updatedFiles[i2].renameTo(orig[0])) continue;
            throw new DMException("Unable to update " + updatedFiles[i2].getName());
        }
        modifiedDir.delete();
        File[] list = updateDir.listFiles();
        for (int i3 = 0; list != null && i3 < list.length; ++i3) {
            if (!list[i3].getName().endsWith(".elems")) continue;
            FileInputStream fis = null;
            ObjectInputStream in = null;
            try {
                String prefix = list[i3].getName().substring(0, list[i3].getName().indexOf("."));
                fis = new FileInputStream(updateDir + File.separator + prefix + ".elems");
                in = new ObjectInputStream(fis);
                DMElement[] elems = (DMElement[])in.readObject();
                in.close();
                fis = null;
                in = null;
                fis = new FileInputStream(updateDir + File.separator + prefix + ".rid");
                in = new ObjectInputStream(fis);
                String[] rid = (String[])in.readObject();
                in.close();
                DMiObject obj = this.getDMiObject(rid[0], rid[1]);
                if (obj != null) {
                    ((fileObject)obj).setValues(elems);
                }
                File f2 = new File(updateDir + File.separator + prefix + ".elems");
                f2.delete();
                f2 = new File(updateDir + File.separator + prefix + ".rid");
                f2.delete();
                continue;
            }
            catch (Exception e2) {
                e2.printStackTrace();
                continue;
            }
            finally {
                if (null != in) {
                    try {
                        in.close();
                    }
                    catch (IOException ioex) {}
                }
            }
        }
        updateDir.delete();
    }

    @Override
    public void init(String session_, String[] args_) {
        int i2;
        this.session = session_;
        if (args_ != null) {
            this.args = new String[args_.length];
            System.arraycopy(args_, 0, this.args, 0, args_.length);
        }
        ArrayList<Serializable> a2 = new ArrayList<Serializable>();
        if (this.session != null && !this.session.equals("URL")) {
            this.dir = new File(this.session);
            this.buildCompositeList(a2, this.dir);
        } else if (this.session != null) {
            URLReader urlr = new URLReader();
            for (i2 = 0; i2 < this.args.length; ++i2) {
                try {
                    if (this.args[i2].endsWith("/")) {
                        String[] children = urlr.getFilesAsUrl(this.args[i2]);
                        for (int j2 = 0; children != null && j2 < children.length; ++j2) {
                            a2.add(new URL(children[j2]));
                        }
                        continue;
                    }
                    a2.add(new URL(this.args[i2]));
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        } else {
            for (int i3 = 0; i3 < this.args.length; ++i3) {
                if (new File(this.args[i3]).isDirectory()) {
                    File[] files = SimpleUtilities.getFilesRecursively(new File(this.args[i3]));
                    for (int j3 = 0; j3 < files.length; ++j3) {
                        a2.add(files[j3]);
                    }
                    continue;
                }
                a2.add(new File(this.args[i3]));
            }
        }
        ArrayList<fileComposite> complist = new ArrayList<fileComposite>(a2.size());
        for (i2 = 0; i2 < a2.size(); ++i2) {
            try {
                fileComposite c2 = this.session != null && this.session.equals("URL") ? new fileComposite(this, (URL)a2.get(i2)) : new fileComposite(this, (File)a2.get(i2));
                complist.add(c2);
                this.addComposites(c2);
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        this.comp = complist.toArray(new fileComposite[complist.size()]);
        if (this.p2pcomm == null) {
            this.p2pcomm = new peerToPeerComm(this.session, this);
        }
        this.addDMEventListener(1, 0, new DMEventListener(){

            @Override
            public void actionPerformed(DMEvent e2) {
                fileSession.this.newdata();
            }
        });
        this.setupJobManager();
        this.retryUpdates();
    }

    private void reInit() {
        int i2;
        ArrayList<Serializable> a2 = new ArrayList<Serializable>();
        if (this.session != null && !this.session.equals("URL")) {
            this.dir = new File(this.session);
            this.buildCompositeList(a2, this.dir);
        } else if (this.session != null) {
            for (i2 = 0; i2 < this.args.length; ++i2) {
                try {
                    a2.add(new URL(this.args[i2]));
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        } else {
            for (i2 = 0; i2 < this.args.length; ++i2) {
                a2.add(new File(this.args[i2]));
            }
        }
        ArrayList<fileComposite> complist = new ArrayList<fileComposite>(a2.size());
        for (int i3 = 0; i3 < a2.size(); ++i3) {
            try {
                fileComposite c2 = this.session != null && this.session.equals("URL") ? new fileComposite(this, (URL)a2.get(i3)) : new fileComposite(this, (File)a2.get(i3));
                complist.add(c2);
                this.addComposites(c2);
                continue;
            }
            catch (Exception ex) {
                System.err.println("File = " + ((File)a2.get(i3)).getAbsolutePath());
                ex.printStackTrace();
            }
        }
        this.comp = complist.toArray(new fileComposite[complist.size()]);
    }

    private void buildCompositeList(AbstractCollection a2, File dir) {
        if (dir.isDirectory()) {
            File[] fd;
            if (!dir.getName().equals(stageFiles) && (fd = dir.listFiles()) != null) {
                for (int i2 = 0; i2 < fd.length; ++i2) {
                    this.buildCompositeList(a2, fd[i2]);
                }
            }
        } else {
            a2.add(dir);
        }
    }

    public fileComposite addComposite(String filename) {
        fileComposite c2 = null;
        try {
            c2 = new fileComposite(this, filename);
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
        fileComposite[] newcomplist = new fileComposite[this.comp.length + 1];
        System.arraycopy(this.comp, 0, newcomplist, 0, this.comp.length);
        newcomplist[this.comp.length] = c2;
        this.comp = newcomplist;
        this.addComposites(c2);
        for (fileObject fo : this.objectList) {
            fo.addCompositeIfValid(c2);
        }
        return c2;
    }

    @Override
    public DMiComposite getComposite(String id) {
        fileComposite fileComp = null;
        DMiComposite[] fc = this.getComposites();
        for (int i2 = 0; i2 < fc.length; ++i2) {
            if (!((fileComposite)fc[i2]).getID().equals(id)) continue;
            fileComp = (fileComposite)fc[i2];
            return fileComp;
        }
        return fileComp;
    }

    @Override
    public DMiComposite[] getComposites() {
        return this.comp;
    }

    @Override
    public int getNumberOfComposites() {
        return this.comp.length;
    }

    @Override
    public DMiObject[] getRelated(String ieType, DMQuery query) {
        if (ieType.equalsIgnoreCase("patient")) {
            return this.getChildren(query);
        }
        HashMap<TagValueList, fileObject> childList = new HashMap<TagValueList, fileObject>();
        for (int i2 = 0; i2 < this.comp.length; ++i2) {
            TagValueList tl;
            try {
                tl = this.comp[i2].getUniqueValues(ieType);
            }
            catch (NullPointerException ex) {
                System.out.println("for the " + i2 + " file =" + this.comp[i2].fileName);
                throw ex;
            }
            if (childList.containsKey(tl)) {
                ((fileObject)childList.get(tl)).addComposite(this.comp[i2]);
                continue;
            }
            fileObject fo = this.getFileObject(tl);
            if (fo != null) {
                fo.addComposite(this.comp[i2]);
                childList.put(tl, fo);
                continue;
            }
            if (tl == null || tl.value[0] == null) continue;
            childList.put(tl, new fileObject(this, this.comp[i2], this.comp[i2].getCIOD().getIE(ieType)));
        }
        fileObject[] fileObjs = new fileObject[childList.size()];
        int count = 0;
        for (Object obj : childList.values()) {
            fileObject o2 = (fileObject)obj;
            if (query != null && !query.valid(o2)) continue;
            fileObjs[count++] = o2;
        }
        DMiObject[] out = new fileObject[count];
        System.arraycopy(fileObjs, 0, out, 0, count);
        return out;
    }

    @Override
    public void getRelated(String type, DMQuery q2, DMiObjectReceiver cb) {
        DMiObject[] io = this.getRelated(type, q2);
        for (int i2 = 0; i2 < io.length && cb.gotOne(io[i2]); ++i2) {
        }
    }

    @Override
    public void getChildren(DMQuery q2, DMiObjectReceiver cb) {
        DMiObject[] io = this.getChildren(q2);
        for (int i2 = 0; i2 < io.length && cb.gotOne(io[0]); ++i2) {
        }
    }

    @Override
    public DMiObject[] getChildren(DMQuery q2) {
        DMiObject[] out;
        if (this.pat.size() == 0) {
            this.init(this.session, this.args);
        }
        Iterator i2 = this.pat.keySet().iterator();
        DMiObject[] fileArray = new DMiObject[this.pat.size()];
        int count = 0;
        while (i2.hasNext()) {
            fileObject f2 = (fileObject)this.pat.get(i2.next());
            if (q2 != null && !q2.valid(f2)) continue;
            fileArray[count++] = f2;
        }
        if (this.pat.size() != count) {
            out = new DMiObject[count];
            System.arraycopy(fileArray, 0, out, 0, count);
        } else {
            out = fileArray;
        }
        for (int x2 = 0; x2 < out.length; ++x2) {
        }
        return out;
    }

    public int getNumberOfChildren() {
        return this.pat.size();
    }

    @Override
    public void install(InputStream is) throws IOException {
        File newdir = new File(this.dir, newFiles);
        File stagedir = new File(this.dir, stageFiles);
        if (!newdir.exists()) {
            newdir.mkdir();
        }
        if (!stagedir.exists()) {
            stagedir.mkdir();
        }
        File newFile = File.createTempFile("comp", ".dcm", stagedir);
        File finalFile = null;
        FileOutputStream fos = new FileOutputStream(newFile);
        int len = 1;
        while (len != -1) {
            len = is.read(this.bbuff);
            if (len <= 0) continue;
            fos.write(this.bbuff, 0, len);
        }
        fos.close();
        is.close();
        finalFile = new File(newdir, newFile.getName());
        newFile.renameTo(finalFile);
        fileComposite c2 = this.addComposite(finalFile.getAbsolutePath());
        String msg = finalFile.getAbsolutePath().replace('\\', '/');
        this.sendEvent(1, msg, c2.getID());
    }

    @Override
    public void installFiles(File[] files, boolean destroy) throws FileNotFoundException, IOException {
        File finalFile = null;
        File newdir = null;
        File stagedir = null;
        if (this.dir != null) {
            newdir = new File(this.dir, newFiles);
            stagedir = new File(this.dir, stageFiles);
            newdir.mkdir();
            stagedir.mkdir();
        }
        for (int i2 = 0; i2 < files.length; ++i2) {
            if (this.dir != null) {
                File inputFile = files[i2];
                File newFile = new File(stagedir, inputFile.getName());
                if (destroy) {
                    if (!inputFile.renameTo(newFile)) {
                        System.err.println("failed to move. file will be copied: " + inputFile.getAbsolutePath());
                        SimpleUtilities.copyFile(inputFile.getAbsolutePath(), newFile.getAbsolutePath());
                        inputFile.delete();
                    }
                } else {
                    FileOutputStream fos = new FileOutputStream(newFile);
                    FileInputStream fis = new FileInputStream(inputFile);
                    int len = 1;
                    while (len != -1) {
                        len = fis.read(this.bbuff);
                        if (len <= 0) continue;
                        fos.write(this.bbuff, 0, len);
                    }
                    fos.close();
                    fis.close();
                }
                finalFile = new File(newdir, newFile.getName());
                newFile.renameTo(finalFile);
            } else {
                finalFile = files[i2];
            }
            fileComposite c2 = this.addComposite(finalFile.getAbsolutePath());
            String msg = finalFile.getAbsolutePath().replace('\\', '/');
            this.sendEvent(1, msg, c2.getID());
        }
    }

    @Override
    public DMiObject getDMiObject(String type, String id) {
        fileObject obj = null;
        Iterator it = this.getListOfFileObjects();
        while (it.hasNext()) {
            obj = (fileObject)it.next();
            if (!obj.getType().equalsIgnoreCase(type) || !obj.getID().equals(id)) continue;
            return obj;
        }
        return null;
    }

    protected void newdata() {
        int i2;
        ArrayList newList = new ArrayList();
        HashSet<String> oldList = new HashSet<String>();
        this.buildCompositeList(newList, this.dir);
        for (i2 = 0; i2 < this.comp.length; ++i2) {
            oldList.add(this.comp[i2].getFileName());
        }
        for (i2 = 0; i2 < newList.size(); ++i2) {
            if (oldList.contains(((File)newList.get(i2)).getAbsolutePath())) continue;
            this.addComposite(((File)newList.get(i2)).getAbsolutePath());
        }
    }

    public DMiObject getDmObject(String idString) {
        StringTokenizer tok = new StringTokenizer(idString, "|");
        String level = tok.nextToken();
        String id = tok.nextToken();
        if (level.equalsIgnoreCase("P")) {
            String query = "(0x10, 0x10) = " + id + " && (0x10, 0x20) = " + tok.nextToken() + " && (0x10, 0x30) = " + tok.nextToken();
            return this.getRelated("patient", new DMQuery(query))[0];
        }
        if (level.equalsIgnoreCase("E")) {
            return this.getRelated("study", new DMQuery("(0x20, 0x0D) = " + id))[0];
        }
        if (level.equalsIgnoreCase("S")) {
            return this.getRelated("series", new DMQuery("(0x20, 0x0E) = " + id))[0];
        }
        if (level.equalsIgnoreCase("I")) {
            return this.getRelated("image", new DMQuery("(0x08, 0x18) = " + id))[0];
        }
        return null;
    }

    @Override
    public void addDMEventListener(int eventType, int freq, DMEventListener listener) {
        if (this.listenerList[eventType] == null) {
            this.listenerList[eventType] = new Vector();
            if (this.p2pcomm == null) {
                this.p2pcomm = new peerToPeerComm(this.dir.getAbsolutePath(), this);
            }
        }
        this.listenerList[eventType].add(listener);
    }

    @Override
    public void removeDMEventListener(DMEventListener l2) {
        if (this.listenerList != null) {
            for (int i2 = 0; i2 < this.listenerList.length; ++i2) {
                if (this.listenerList[i2] == null) continue;
                this.listenerList[i2].remove(l2);
            }
        }
    }

    private void clearDMEventListener() {
        if (null != this.listenerList) {
            for (int i2 = 0; i2 < this.listenerList.length; ++i2) {
                if (null == this.listenerList[i2]) continue;
                this.listenerList[i2].clear();
            }
        }
    }

    public void fireEvent(DMEvent event) {
        try {
            if (this.listenerList[event.getID()] == null) {
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return;
        }
        Iterator i2 = this.listenerList[event.getID()].iterator();
        while (i2.hasNext()) {
            ((DMEventListener)i2.next()).actionPerformed(event);
        }
    }

    public void sendEvent(int eventType, String msg, Object source) {
        this.fireEvent(new DMEvent(eventType, msg, source));
        this.p2pcomm.sendMessage("" + eventType + "|" + source.toString() + "|" + msg);
    }

    public void recivedEvent(String str) {
        StringTokenizer st = new StringTokenizer(str, "|");
        String code = st.nextToken();
        String source = st.nextToken() + "|" + st.nextToken();
        int type = Integer.parseInt(code);
        String rstr = st.nextToken();
        if (rstr.equals("Update")) {
            this.ClearCache();
        }
        this.fireEvent(new DMEvent(type, rstr, source));
    }

    public void removeCach(fileObject patient2) {
        Object[] keys = new Object[this.pat.size()];
        int count = 0;
        if (this.pat.containsValue(patient2)) {
            for (Object key : this.pat.keySet()) {
                if (!this.pat.get(key).equals(patient2)) continue;
                keys[count++] = key;
            }
        }
        for (int i2 = 0; i2 < count; ++i2) {
            this.pat.remove(keys[i2]);
        }
    }

    private fileComposite findComposite(String id) {
        fileObject obj;
        fileComposite comp = (fileComposite)this.getComposite(id);
        if (comp == null && null != (obj = (fileObject)this.getDmObject(id))) {
            fileComposite[] comps = (fileComposite[])obj.getComposites(null);
            comp = comps != null && comps.length > 0 ? comps[0] : null;
        }
        return comp;
    }

    @Override
    public String[] send(String str) {
        String[] ret = null;
        try {
            if ("OLD_GETRELATED".equals(str)) {
                fileObject.OLD_GETRELATED = true;
            } else if (str.startsWith(GET_FILE_PATH_CMD)) {
                String rid = str.substring(GET_FILE_PATH_CMD.length(), str.length());
                fileComposite comp = this.findComposite(rid);
                ret = null == comp ? new String[]{"-1"} : new String[]{"0", comp.getFileName()};
            } else if (str.startsWith(PRINT_COMP_CACHE_CMD)) {
                String rid = str.substring(PRINT_COMP_CACHE_CMD.length(), str.length());
                fileComposite comp = this.findComposite(rid);
                ret = new String[1];
                if (null == comp) {
                    ret[0] = "-1";
                } else {
                    ret[0] = "0";
                    comp.printCacheForDebugging();
                }
            } else if (str.startsWith(REMOVE_TAG_FROM_COMP_CACHE_CMD)) {
                String idAndTag = str.substring(REMOVE_TAG_FROM_COMP_CACHE_CMD.length(), str.length());
                String[] tokens = idAndTag.split(",");
                fileComposite comp = null;
                if (tokens.length == 3) {
                    comp = this.findComposite(tokens[0]);
                }
                ret = new String[1];
                if (null == comp) {
                    ret[0] = "-1";
                } else {
                    ret[0] = "0";
                    int group = Integer.decode(tokens[1]);
                    int element = Integer.decode(tokens[2]);
                    comp.removeTagFromCache(new DMTag(group, element));
                }
            } else if (str.startsWith(CLEAR_COMP_CACHE_CMD)) {
                String rid = str.substring(CLEAR_COMP_CACHE_CMD.length(), str.length());
                fileComposite comp = this.findComposite(rid);
                ret = new String[1];
                if (null == comp) {
                    ret[0] = "-1";
                } else {
                    ret[0] = "0";
                    comp.clearCache();
                }
            }
        }
        catch (Exception ex) {
            Tap.log.log(Level.WARNING, "Error during command execution: ", ex);
        }
        return ret;
    }

    @Override
    public DMiJob asynSend(String str) {
        return null;
    }

    @Override
    public void ClearCache() {
        this.objectList.clear();
        this.olist = null;
        Set keys = this.pat.keySet();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            fileComposite[] comps = (fileComposite[])((fileObject)this.pat.get(it.next())).getComposites(null);
            if (comps == null || comps.length <= 0) continue;
            for (int i2 = 0; i2 < comps.length; ++i2) {
                comps[i2].clearCache();
            }
        }
        this.pat.clear();
        keys = this.allFileObjects.keySet();
        it = keys.iterator();
        while (it.hasNext()) {
            fileObject fo = (fileObject)this.allFileObjects.get(it.next());
            fo.allChildObjects.clear();
            fileComposite[] comps = (fileComposite[])fo.getComposites(null);
            if (comps == null || comps.length <= 0) continue;
            for (int i3 = 0; i3 < comps.length; ++i3) {
                comps[i3].clearCache();
            }
        }
        this.allFileObjects.clear();
        this.reInit();
    }

    @Override
    public DMiJob[] getJobs() {
        DMiJob[] jbs = new DMiJob[this.jobs.size()];
        for (int i2 = 0; i2 < this.jobs.size(); ++i2) {
            jbs[i2] = (DMiJob)this.jobs.get(i2);
        }
        return jbs;
    }

    public String getRootDir() {
        return this.dir.getAbsolutePath();
    }

    @Override
    public void save(DMiObject o2, Hashtable prop) {
        fileJob j2 = new fileJob(this, 0, o2);
        Enumeration v2 = prop.keys();
        String key = null;
        while (v2.hasMoreElements()) {
            key = (String)v2.nextElement();
            j2.setProperty(key, prop.get(key));
        }
        j2.setJobHandle(j2.hashCode());
        this.addJob(j2);
        j2.waitForCompletion();
    }

    @Override
    public void save(DMiObject[] o2, Hashtable prop) {
        for (int i2 = 0; i2 < o2.length; ++i2) {
            this.save(o2[i2], prop);
        }
    }

    @Override
    public void save(DMiComposite o2, Hashtable prop) {
        fileJob j2 = new fileJob(this, 1, o2);
        Enumeration en = prop.keys();
        String key = null;
        while (en.hasMoreElements()) {
            key = (String)en.nextElement();
            j2.setProperty(key, prop.get(key));
        }
        j2.setJobHandle(j2.hashCode());
        this.addJob(j2);
        j2.waitForCompletion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJob(fileJob j2) {
        ArrayList arrayList = this.jobs;
        synchronized (arrayList) {
            this.jobs.add(j2);
            this.jobs.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJob(fileJob j2) {
        ArrayList arrayList = this.jobs;
        synchronized (arrayList) {
            this.jobs.remove(j2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearJobs() {
        ArrayList arrayList = this.jobs;
        synchronized (arrayList) {
            this.jobs.clear();
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private void setupJobManager() {
        this.th = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!fileSession.this.closeCalled) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(200L);
                        ArrayList arrayList = fileSession.this.jobs;
                        synchronized (arrayList) {
                            if (fileSession.this.jobs.isEmpty()) {
                                fileSession.this.jobs.wait();
                            } else {
                                for (int i2 = 0; i2 < fileSession.this.jobs.size(); ++i2) {
                                    if (((fileJob)fileSession.this.jobs.get(i2)).getState() != 2) continue;
                                    ((fileJob)fileSession.this.jobs.get(i2)).start();
                                    break;
                                }
                            }
                        }
                    }
                    catch (Exception e2) {
                        if (e2 instanceof InterruptedException) continue;
                        e2.printStackTrace();
                    }
                }
            }
        }, "fileSession.JobMgr");
        this.th.setDaemon(true);
        this.th.start();
    }

    @Override
    public void close() {
        if (!this.closeCalled) {
            this.closeCalled = true;
            this.p2pcomm.killThread();
            this.clearDMEventListener();
            try {
                this.th.interrupt();
            }
            catch (Exception e2) {
                System.out.println("Handled Exception: " + e2.getMessage());
            }
            this.clearJobs();
        }
    }
}

