/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.sessionFile;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.Timer;

class jport
extends JPanel {
    private scene s = new scene();
    Object r_hint = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
    private BufferedImage[] imgSet;
    private int frame;
    private boolean cine = false;
    private int cineRate = 100;
    Timer timer1;
    byte[] r = new byte[65536];
    byte[] g = new byte[65536];
    byte[] b = new byte[65536];
    long[] t = new long[10];
    int c = 0;
    Dimension _d = new Dimension();
    AffineTransform _tx = new AffineTransform();
    BufferedImage finalimage;
    int mx;
    int my;
    int mouse;
    int orig_w_max = 0;
    int orig_w_min = 0;
    double orig_zoom = 0.0;

    public static void display(BufferedImage[] imgs) {
        JFrame tframe = new JFrame("TEST JPORT"){

            @Override
            protected void processWindowEvent(WindowEvent e2) {
                this.enableEvents(64L);
                super.processWindowEvent(e2);
                if (e2.getID() == 201) {
                    System.exit(0);
                }
            }
        };
        jport jport1 = new jport();
        if (imgs != null) {
            jport1.setImages(imgs);
        }
        tframe.getContentPane().add(jport1);
        tframe.setSize(300, 300);
        tframe.setVisible(true);
    }

    public jport() {
        this.resetTransForm();
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    void cineStep() {
        ++this.frame;
        this.frame %= this.imgSet.length;
        this.repaint();
    }

    public void setCineRate(int delay) {
        this.cineRate = delay;
        if (this.timer1 != null) {
            this.timer1.setDelay(delay);
        }
    }

    public boolean getCine() {
        return this.cine;
    }

    public void setCine(boolean cine) {
        this.cine = cine;
        if (this.timer1 == null) {
            this.timer1 = new Timer(this.cineRate, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    jport.this.cineStep();
                }
            });
        }
        if (cine) {
            this.timer1.start();
        } else {
            this.timer1.stop();
        }
    }

    public void resetTransForm() {
        this.s.zoom = 1.4;
        this.s.window_min = 0;
        this.s.window_max = 255;
        this.s.pan_x = 0.0;
        this.s.pan_y = 0.0;
        this.frame = 0;
        this.s.rotate = 0.0;
    }

    public void setImages(BufferedImage[] imgSet) {
        this.imgSet = imgSet;
    }

    private void fillRGB() {
        int i2;
        if (this.s.window_min < 0) {
            this.s.window_min = 0;
        }
        if (this.s.window_max < 0) {
            this.s.window_max = 0;
        }
        for (i2 = 0; i2 < this.s.window_min; ++i2) {
            this.b[i2] = 0;
            this.g[i2] = 0;
            this.r[i2] = 0;
        }
        for (i2 = this.s.window_min; i2 < this.s.window_max; ++i2) {
            this.g[i2] = this.b[i2] = (byte)(255 * (i2 - this.s.window_min) / (this.s.window_max - this.s.window_min));
            this.r[i2] = this.b[i2];
        }
        for (i2 = this.s.window_max; i2 < 65536; ++i2) {
            this.b[i2] = -1;
            this.g[i2] = -1;
            this.r[i2] = -1;
        }
    }

    @Override
    public void paint(Graphics gr) {
        this.t[this.c] = System.currentTimeMillis();
        this.getSize(this._d);
        int size = this._d.width < this._d.height ? this._d.width : this._d.height;
        Graphics2D g2 = (Graphics2D)gr.create();
        this.fillRGB();
        this._tx.setToIdentity();
        this._tx.translate(this._d.width / 2, this._d.height / 2);
        this._tx.rotate(this.s.rotate * Math.PI / 180.0);
        this._tx.scale(this.s.zoom, this.s.zoom);
        this._tx.translate(this.s.pan_x * (double)this._d.width / 2.0, this.s.pan_y * (double)this._d.height / 2.0);
        this._tx.translate(-this._d.width / 2, -this._d.height / 2);
        g2.transform(this._tx);
        if (this.imgSet != null) {
            if (this.imgSet[this.frame].getColorModel().getPixelSize() == 16) {
                IndexColorModel cm = new IndexColorModel(16, 65536, this.r, this.g, this.b);
                this.finalimage = new BufferedImage(cm, this.imgSet[this.frame].getRaster(), false, null);
            } else {
                this.finalimage = this.imgSet[this.frame];
            }
            gr.clearRect(0, 0, this._d.width, this._d.height);
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.r_hint);
            g2.drawImage(this.finalimage, (this._d.width - size) / 2, (this._d.height - size) / 2, size, size, null);
        }
        this.paintChildren(gr);
        this.c = (this.c + 1) % 10;
        if (this.c == 0) {
            long sum = 0L;
            for (int i2 = 0; i2 < 9; ++i2) {
                sum += this.t[this.c + 1] - this.t[this.c];
            }
        }
    }

    private void jbInit() throws Exception {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e2) {
                jport.this.mykeyPressed(e2);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e2) {
                jport.this.this_mousePressed(e2);
            }

            @Override
            public void mouseReleased(MouseEvent e2) {
                jport.this.grabFocus();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e2) {
                jport.this.this_mouseDragged(e2);
            }
        });
    }

    void this_mouseDragged(MouseEvent e2) {
        if (0 != (this.mouse & 0x10)) {
            this.s.pan_x = (double)(e2.getX() - this.mx) / 100.0;
            this.s.pan_y = (double)(e2.getY() - this.my) / 100.0;
            this.repaint();
        }
        if (0 != (this.mouse & 8)) {
            int delta_level = e2.getY() - this.my;
            int delta_width = this.mx - e2.getX();
            this.s.window_max = this.orig_w_max + delta_level + delta_width;
            this.s.window_min = this.orig_w_min + delta_level - delta_width;
            if (this.s.window_max <= this.s.window_min) {
                this.s.window_min = (this.s.window_max + this.s.window_min) / 2;
                this.s.window_max = this.s.window_min - 1;
            }
            this.repaint();
        }
        if (0 != (this.mouse & 4)) {
            double delta = 1.0 + (double)(this.my - e2.getY()) / 100.0;
            if (delta <= 0.0) {
                delta = 0.01;
            }
            this.s.zoom = this.orig_zoom * delta;
            if (this.s.zoom < 0.001) {
                this.s.zoom = 0.001;
            }
            if (this.s.zoom > 20.0) {
                this.s.zoom = 20.0;
            }
            this.repaint();
        }
    }

    void this_mousePressed(MouseEvent e2) {
        this.mx = e2.getX();
        this.my = e2.getY();
        this.orig_w_max = this.s.window_max;
        this.orig_w_min = this.s.window_min;
        this.orig_zoom = this.s.zoom;
        this.mouse = e2.getModifiers();
    }

    public void mykeyPressed(KeyEvent e2) {
        if (e2.getKeyCode() == 39) {
            this.setCine(true);
            this.repaint();
        }
        if (e2.getKeyCode() == 37) {
            this.setCine(false);
            this.repaint();
        }
        if (e2.getKeyCode() == 40) {
            this.s.rotate -= 0.2;
            this.repaint();
        }
        if (e2.getKeyCode() == 38) {
            this.s.rotate += 0.2;
            this.repaint();
        }
    }

    public class scene {
        public double zoom;
        public int window_min;
        public int window_max;
        public double pan_x;
        public double pan_y;
        public double rotate;
    }
}

