/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.sql;

import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.peer.DMiComposite;
import com.ge.med.terra.tap.dm.sql.SqlComposite;
import com.ge.med.terra.tap.dm.sql.SqlObject;
import com.ge.med.terra.tap.dm.sql.SqlSeriesObject;
import com.ge.med.terra.tap.dm.sql.SqlSession;
import com.ge.med.terra.tap.dm.sql.SqlUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SqlImageObject
extends SqlObject {
    public static final String[] TABLES = new String[]{"ctimage", "mrimage", "rtgeimage", "rtimage", "dpoimage", "crimage", "mgimage", "nmimage", "ptimage", "scptimage", "svimage", "xaimage", "rfimage", "srimage", "usimage"};
    static final Map tagToColumnMap = new HashMap();
    static final Map columnToTagMap;
    private String path;
    private int numberOfFrames = 1;

    public SqlImageObject(SqlSession session, ResultSet rs, String tableName) throws SQLException {
        super(session, rs, columnToTagMap);
        this.level = 3;
        this.id = tableName + '|' + this.cache.get(new DMTag(1, 4096));
        this.parentId = (String)this.cache.get(new DMTag(1, 4097));
        this.path = (String)this.cache.get(new DMTag(1, 4099));
        String numFrames = (String)this.cache.get(new DMTag(40, 8));
        if (numFrames != null) {
            this.numberOfFrames = Integer.parseInt(numFrames);
        }
    }

    @Override
    protected SqlObject getParent() {
        SqlSeriesObject parent = null;
        try {
            ResultSet rs = this.session.getSeries(this.parentId);
            if (rs.next()) {
                parent = new SqlSeriesObject(this.session, rs);
            }
            rs.close();
        }
        catch (SQLException e2) {
            throw new DMException(e2);
        }
        return parent;
    }

    @Override
    protected List getChildren(DMQuery q2) {
        return null;
    }

    @Override
    public DMiComposite[] getComposites(DMQuery q2) {
        if (q2 == null || q2.valid(this.getComposite())) {
            return new SqlComposite[]{this.getComposite()};
        }
        return null;
    }

    @Override
    protected SqlComposite getComposite() {
        if (this.composite == null || !this.composite.file.exists()) {
            this.composite = this.session.makeNewSqlComposite(this.path, this.getID(), this.numberOfFrames);
        }
        return this.composite;
    }

    static {
        tagToColumnMap.put(new DMTag(8, 24), "d_im_instance_uid");
        tagToColumnMap.put(new DMTag(8, 50), "object_date");
        tagToColumnMap.put(new DMTag(8, 96), "object_type");
        tagToColumnMap.put(new DMTag(32, 19), "rank_in_series");
        tagToColumnMap.put(new DMTag(1, 4096), "object_id");
        tagToColumnMap.put(new DMTag(1, 4097), "series_id");
        tagToColumnMap.put(new DMTag(1, 4098), "object_key");
        tagToColumnMap.put(new DMTag(1, 4099), "local_path");
        tagToColumnMap.put(new DMTag(1, 4100), "archive_flag");
        tagToColumnMap.put(new DMTag(1, 4101), "application_name");
        tagToColumnMap.put(new DMTag(1, 4102), "db_creation_date");
        tagToColumnMap.put(new DMTag(1, 4103), "ddf_prefix");
        tagToColumnMap.put(new DMTag(1, 4104), "update_timestamp");
        tagToColumnMap.put(new DMTag(1, 4105), "delete");
        tagToColumnMap.put(new DMTag(1, 4112), "hidden");
        tagToColumnMap.put(new DMTag(1, 4113), "committed");
        tagToColumnMap.put(new DMTag(1, 4114), "print");
        tagToColumnMap.put(new DMTag(1, 4115), "sent");
        tagToColumnMap.put(new DMTag(1, 4116), "object_desc");
        tagToColumnMap.put(new DMTag(24, 80), "thck");
        tagToColumnMap.put(new DMTag(32, 4161), "loc");
        tagToColumnMap.put(new DMTag(40, 8), "numberofframes");
        tagToColumnMap.put(new DMTag(1, 4117), "phase_location");
        columnToTagMap = SqlUtils.getReverse(tagToColumnMap);
    }
}

