/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.sql;

import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.peer.DMiComposite;
import com.ge.med.terra.tap.dm.sql.SqlComposite;
import com.ge.med.terra.tap.dm.sql.SqlImageObject;
import com.ge.med.terra.tap.dm.sql.SqlObject;
import com.ge.med.terra.tap.dm.sql.SqlSession;
import com.ge.med.terra.tap.dm.sql.SqlStudyObject;
import com.ge.med.terra.tap.dm.sql.SqlUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SqlSeriesObject
extends SqlObject {
    static final Map tagToColumnMap = new HashMap();
    static final Map columnToTagMap;
    static final DMTag phaseTag;

    public SqlSeriesObject(SqlSession session, ResultSet rs) throws SQLException {
        super(session, rs, columnToTagMap);
        this.level = 2;
        this.id = (String)this.cache.get(new DMTag(1, 768));
        this.parentId = (String)this.cache.get(new DMTag(1, 769));
    }

    @Override
    protected SqlObject getParent() {
        SqlStudyObject parent = null;
        try {
            ResultSet rs = this.session.getStudy(this.parentId);
            if (rs.next()) {
                parent = new SqlStudyObject(this.session, rs);
            }
            rs.close();
        }
        catch (SQLException e2) {
            throw new DMException(e2);
        }
        return parent;
    }

    @Override
    protected List getChildren(DMQuery q2) {
        ArrayList<SqlImageObject> children = new ArrayList<SqlImageObject>();
        String tableName = (String)this.cache.get(columnToTagMap.get("image_table"));
        String str = SqlUtils.getSqlString(q2, SqlImageObject.columnToTagMap);
        str = str.length() > 0 ? " AND " + str : str;
        String sort = (String)SqlImageObject.tagToColumnMap.get(this.session.getSortTag(3));
        sort = sort == null ? "" : " ORDER BY " + sort;
        String query = "SELECT * FROM " + tableName + " WHERE series_id = '" + this.id + "'" + str + sort + ";";
        try {
            ResultSet rs = this.session.con.createStatement().executeQuery(query);
            while (rs.next()) {
                children.add(new SqlImageObject(this.session, rs, tableName));
            }
            rs.close();
        }
        catch (SQLException e2) {
            throw new DMException(e2);
        }
        return children;
    }

    @Override
    public DMiComposite[] getComposites(DMQuery q2) {
        String tableName = (String)this.cache.get(columnToTagMap.get("image_table"));
        return this.filterComposites(this.getComposites(q2, this.id, tableName), q2);
    }

    @Override
    protected SqlComposite getComposite() {
        if (this.composite == null || !this.composite.file.exists()) {
            String tableName = (String)this.cache.get(columnToTagMap.get("image_table"));
            this.composite = this.getComposite(this.id, tableName);
        }
        return this.composite;
    }

    @Override
    public Object getValue(DMTag t2) {
        if (phaseTag.equals(t2)) {
            String tableName = (String)this.cache.get(columnToTagMap.get("image_table"));
            String str = "";
            boolean hasLoc = false;
            boolean hasPhase = false;
            if (tableName.equalsIgnoreCase("mrimage")) {
                str = str + ", loc";
                hasLoc = true;
            } else if (tableName.equalsIgnoreCase("ctimage") || tableName.equalsIgnoreCase("ptimage")) {
                str = str + ", loc, phase_location";
                hasLoc = true;
                hasPhase = true;
            }
            HashMap<String, ArrayList<Phase>> map = new HashMap<String, ArrayList<Phase>>();
            ArrayList<ArrayList<Phase>> data = new ArrayList<ArrayList<Phase>>();
            String sql = "SELECT rank_in_series" + str + " FROM " + tableName + " WHERE series_id='" + this.id + "' ORDER BY rank_in_series;";
            try {
                ResultSet rs = this.session.con.createStatement().executeQuery(sql);
                while (rs.next()) {
                    int imageNumber = rs.getInt("rank_in_series");
                    String location = hasLoc ? rs.getString("loc") : "";
                    String phaseLocation = hasPhase ? rs.getString("phase_location") : "";
                    Phase phase = new Phase(imageNumber, phaseLocation, location);
                    ArrayList<Phase> list = (ArrayList<Phase>)map.get(phaseLocation);
                    if (list == null) {
                        list = new ArrayList<Phase>();
                        map.put(phaseLocation, list);
                        data.add(list);
                    }
                    list.add(phase);
                }
                rs.close();
            }
            catch (SQLException e2) {
                throw new DMException(e2);
            }
            String[] result = new String[data.size()];
            for (int i2 = 0; i2 < data.size(); ++i2) {
                int minNumber;
                ArrayList list = (ArrayList)data.get(i2);
                Phase elem = (Phase)list.get(0);
                int maxNumber = minNumber = elem.imageNumber;
                for (int j2 = 1; j2 < list.size(); ++j2) {
                    Phase phase = (Phase)list.get(j2);
                    if (minNumber > phase.imageNumber) {
                        minNumber = phase.imageNumber;
                    }
                    if (maxNumber >= phase.imageNumber) continue;
                    maxNumber = phase.imageNumber;
                }
                String startLocation = "";
                String endLocation = "";
                if (elem.location.length() > 0) {
                    double minLocation = Double.parseDouble(elem.location);
                    double maxLocation = minNumber;
                    for (int j3 = 1; j3 < list.size(); ++j3) {
                        Phase phase = (Phase)list.get(j3);
                        double value = Double.parseDouble(phase.location);
                        if (minLocation > value) {
                            maxLocation = value;
                        }
                        if (!(maxLocation < value)) continue;
                        maxLocation = value;
                    }
                    startLocation = startLocation + minLocation;
                    endLocation = endLocation + maxLocation;
                }
                result[i2] = elem.phaseLocation + "," + minNumber + "," + maxNumber + "," + startLocation + "," + endLocation;
            }
            return result;
        }
        return super.getValue(t2);
    }

    static {
        tagToColumnMap.put(new DMTag(8, 33), "series_date");
        tagToColumnMap.put(new DMTag(8, 96), "modality");
        tagToColumnMap.put(new DMTag(8, 112), "manufacturer");
        tagToColumnMap.put(new DMTag(8, 4158), "series_desc");
        tagToColumnMap.put(new DMTag(32, 14), "original_series_id");
        tagToColumnMap.put(new DMTag(32, 17), "original_ser_nu");
        tagToColumnMap.put(new DMTag(37, 4103), "images_in_series");
        tagToColumnMap.put(new DMTag(84, 4096), "series_type");
        tagToColumnMap.put(new DMTag(1, 768), "series_id");
        tagToColumnMap.put(new DMTag(1, 769), "folder_id");
        tagToColumnMap.put(new DMTag(1, 770), "series_key");
        tagToColumnMap.put(new DMTag(1, 771), "series_path");
        tagToColumnMap.put(new DMTag(1, 772), "d_series_instance");
        tagToColumnMap.put(new DMTag(1, 773), "series_lock");
        tagToColumnMap.put(new DMTag(1, 774), "body_part");
        tagToColumnMap.put(new DMTag(1, 775), "archive_flag");
        tagToColumnMap.put(new DMTag(1, 776), "delete");
        tagToColumnMap.put(new DMTag(1, 777), "hidden");
        tagToColumnMap.put(new DMTag(1, 784), "update_timestamp");
        tagToColumnMap.put(new DMTag(1, 785), "committed");
        tagToColumnMap.put(new DMTag(1, 786), "print");
        tagToColumnMap.put(new DMTag(1, 787), "sent");
        tagToColumnMap.put(new DMTag(1, 788), "manuf_model_name");
        tagToColumnMap.put(new DMTag(1, 789), "image_table");
        tagToColumnMap.put(new DMTag(1, 790), "db_creation_date");
        tagToColumnMap.put(new DMTag(1, 791), "sop_class");
        columnToTagMap = SqlUtils.getReverse(tagToColumnMap);
        phaseTag = new DMTag(1, 921);
    }

    private class Phase {
        int imageNumber;
        String phaseLocation;
        String location;

        public Phase(int imageNumber, String phaseLocation, String location) {
            this.imageNumber = imageNumber;
            this.phaseLocation = phaseLocation;
            this.location = location;
        }
    }
}

