/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.sql;

import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.peer.DMiComposite;
import com.ge.med.terra.tap.dm.sql.SqlComposite;
import com.ge.med.terra.tap.dm.sql.SqlObject;
import com.ge.med.terra.tap.dm.sql.SqlPatientObject;
import com.ge.med.terra.tap.dm.sql.SqlSeriesObject;
import com.ge.med.terra.tap.dm.sql.SqlSession;
import com.ge.med.terra.tap.dm.sql.SqlUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SqlStudyObject
extends SqlObject {
    static final Map tagToColumnMap = new HashMap();
    static final Map columnToTagMap;

    public SqlStudyObject(SqlSession session, ResultSet rs) throws SQLException {
        super(session, rs, columnToTagMap);
        this.level = 1;
        this.id = (String)this.cache.get(new DMTag(1, 512));
        this.parentId = (String)this.cache.get(new DMTag(1, 513));
    }

    @Override
    protected SqlObject getParent() {
        SqlPatientObject parent = null;
        try {
            ResultSet rs = this.session.getPatient(this.parentId);
            if (rs.next()) {
                parent = new SqlPatientObject(this.session, rs);
            }
            rs.close();
        }
        catch (SQLException e2) {
            throw new DMException(e2);
        }
        return parent;
    }

    @Override
    protected List getChildren(DMQuery q2) {
        ArrayList<SqlSeriesObject> children = new ArrayList<SqlSeriesObject>();
        try {
            String str = SqlUtils.getSqlString(q2, tagToColumnMap);
            String sort = (String)SqlSeriesObject.tagToColumnMap.get(this.session.getSortTag(2));
            sort = sort == null ? "" : " ORDER BY " + sort;
            str = str.length() > 0 ? " AND " + str : str;
            String query = "SELECT * FROM series_environment WHERE folder_id = '" + this.id + "'" + str + sort + ";";
            ResultSet rs = this.session.con.createStatement().executeQuery(query);
            while (rs.next()) {
                children.add(new SqlSeriesObject(this.session, rs));
            }
            rs.close();
        }
        catch (SQLException e2) {
            throw new DMException(e2);
        }
        return children;
    }

    @Override
    public DMiComposite[] getComposites(DMQuery q2) {
        ArrayList list = new ArrayList();
        try {
            ResultSet rs = this.session.getStudyComponents(this.id);
            while (rs.next()) {
                String seriesId = rs.getString(1);
                String tableName = rs.getString(2);
                list.addAll(this.getComposites(q2, seriesId, tableName));
            }
            rs.close();
        }
        catch (SQLException e2) {
            throw new DMException(e2);
        }
        return this.filterComposites(list, q2);
    }

    @Override
    protected SqlComposite getComposite() {
        if (this.composite == null || !this.composite.file.exists()) {
            try {
                ResultSet rs = this.session.getAStudyComposite(this.id);
                if (rs.next()) {
                    String seriesId = rs.getString(1);
                    String tableName = rs.getString(2);
                    this.composite = this.getComposite(seriesId, tableName);
                }
                rs.close();
            }
            catch (SQLException e2) {
                throw new DMException(e2);
            }
        }
        return this.composite;
    }

    static {
        tagToColumnMap.put(new DMTag(16, 16), "patient_name");
        tagToColumnMap.put(new DMTag(16, 32), "orgl_patient_id");
        tagToColumnMap.put(new DMTag(16, 48), "birthdate");
        tagToColumnMap.put(new DMTag(8, 32), "original_exam_date");
        tagToColumnMap.put(new DMTag(8, 80), "d_accession_nu");
        tagToColumnMap.put(new DMTag(8, 4144), "exam_desc");
        tagToColumnMap.put(new DMTag(8, 4176), "radiologist_name");
        tagToColumnMap.put(new DMTag(8, 4192), "reading_physician");
        tagToColumnMap.put(new DMTag(32, 16), "d_study_instance");
        tagToColumnMap.put(new DMTag(32, 13), "original_exam_id");
        tagToColumnMap.put(new DMTag(1, 512), "folder_id");
        tagToColumnMap.put(new DMTag(1, 513), "patient_id");
        tagToColumnMap.put(new DMTag(1, 514), "folder_key");
        tagToColumnMap.put(new DMTag(1, 515), "examfolder_path");
        tagToColumnMap.put(new DMTag(1, 516), "creation_date");
        tagToColumnMap.put(new DMTag(1, 517), "modality");
        tagToColumnMap.put(new DMTag(1, 518), "folder_status");
        tagToColumnMap.put(new DMTag(1, 519), "series_in_study");
        tagToColumnMap.put(new DMTag(1, 520), "exam_lock");
        tagToColumnMap.put(new DMTag(1, 521), "procedure_code");
        tagToColumnMap.put(new DMTag(1, 528), "procedure_t_code");
        tagToColumnMap.put(new DMTag(1, 529), "procedure_meaning");
        tagToColumnMap.put(new DMTag(1, 530), "report_status");
        tagToColumnMap.put(new DMTag(1, 531), "localisation");
        tagToColumnMap.put(new DMTag(1, 532), "exam_code");
        tagToColumnMap.put(new DMTag(1, 533), "archive_flag");
        tagToColumnMap.put(new DMTag(1, 534), "delete");
        tagToColumnMap.put(new DMTag(1, 535), "hidden");
        tagToColumnMap.put(new DMTag(1, 536), "update_timestamp");
        tagToColumnMap.put(new DMTag(1, 537), "committed");
        tagToColumnMap.put(new DMTag(1, 544), "print");
        tagToColumnMap.put(new DMTag(1, 545), "sent");
        columnToTagMap = SqlUtils.getReverse(tagToColumnMap);
    }
}

