/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.tools;

import com.ge.med.terra.tap.util.dicom.dicomParser;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class SnapDb {
    File dbroot;
    File dbsnap;
    String snap;
    String db;
    dicomParser parser = new dicomParser();
    tagValue pnameTag = new tagValue(16, 16);
    tagValue pixelTag = new tagValue(32736, 16);
    byte[] buff = new byte[32768];
    boolean doAnon = true;

    public SnapDb(File dbroot, File dbsnap) {
        this.dbroot = dbroot;
        this.dbsnap = dbsnap;
        this.snap = dbsnap.getAbsolutePath();
        this.db = dbroot.getAbsolutePath();
        this.pixelTag.setFillValue(false);
        System.out.println("DB   dir= " + dbroot.getAbsolutePath());
        System.out.println("Snap dir= " + dbsnap.getAbsolutePath());
    }

    public static void abort(String msg) {
        System.out.println(msg);
        System.exit(1);
    }

    public String getSnapPath(String givenPath) {
        return this.snap + File.separator + givenPath.substring(this.db.length() + 1);
    }

    private void anonymizeName(byte[] name) {
        int i2 = 0;
        while (i2 < name.length) {
            int n2 = i2++;
            name[n2] = (byte)(name[n2] + 1);
        }
    }

    private void plianCopy(InputStream in, OutputStream out) throws Exception {
        int len;
        while ((len = in.read(this.buff)) >= 0) {
            out.write(this.buff, 0, len);
        }
    }

    public void copy(File src) throws Exception {
        int len;
        String givenPath = src.getAbsolutePath();
        String givenName = src.getName();
        String newName = this.getSnapPath(givenPath);
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(newName);
        int pixOffset = -1;
        if (!givenName.startsWith("cmp") || !givenName.endsWith(".tdb")) {
            this.plianCopy(in, out);
            in.close();
            out.close();
            return;
        }
        this.parser.setFile(givenPath);
        try {
            this.parser.fill(new tagValue[]{this.pnameTag, this.pixelTag});
        }
        catch (Exception e2) {
            System.out.println("Unable to parse: " + givenPath + " ... copying as-is");
            this.parser.clearFile();
        }
        if (this.pixelTag.len > 0) {
            pixOffset = (int)this.pixelTag.getOffset();
        }
        this.parser.clearFile();
        int totalRead = 0;
        while ((len = in.read(this.buff)) >= 0) {
            if ((totalRead += len) > pixOffset) {
                out.write(this.buff, 0, totalRead - pixOffset);
                break;
            }
            out.write(this.buff, 0, len);
        }
        in.close();
        out.close();
        if (this.doAnon && this.pnameTag.len > 0) {
            try {
                RandomAccessFile rf = new RandomAccessFile(new File(newName), "rw");
                long nameOffset = this.pnameTag.getOffset();
                rf.seek(nameOffset += 8L);
                byte[] name = ((String)this.pnameTag.value).getBytes();
                this.anonymizeName(name);
                rf.write(name);
                rf.close();
            }
            catch (Exception e3) {
                System.out.println("Failed to anonymize: " + newName);
            }
        }
    }

    public void snap(File root) {
        this.snap(root, 0);
    }

    public void snap(File root, int level) {
        if (root.isDirectory()) {
            String newPath;
            for (int i2 = 0; i2 < level; ++i2) {
                System.out.print("\t");
            }
            String givenPath = root.getAbsolutePath();
            System.out.println("Processing: " + givenPath);
            if (root.compareTo(this.dbroot) != 0 && !new File(newPath = this.getSnapPath(givenPath)).mkdir()) {
                SnapDb.abort("Failed to create: " + newPath);
            }
            File[] children = root.listFiles();
            for (int i3 = 0; i3 < children.length; ++i3) {
                this.snap(children[i3], level + 1);
            }
        } else {
            try {
                this.copy(root);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                SnapDb.abort("");
            }
        }
    }

    public static void main(String[] args) {
        File snap;
        File root;
        String dbroot = null;
        boolean noannon = false;
        if (args.length == 1 && args[0].startsWith("-h")) {
            SnapDb.abort("Usage: java com.gem.med.terra.tap.dm.tools.SnapDb [-noanon] [/db/root/dir]");
        }
        if (args.length > 0 && args[0].startsWith("-noanon")) {
            noannon = true;
            String[] nargs = new String[args.length - 1];
            for (int i2 = 1; i2 < args.length; ++i2) {
                nargs[i2 - 1] = args[i2];
            }
            args = nargs;
        }
        if (!(root = new File(dbroot = args.length > 0 ? args[0] : (System.getProperty("os.name").startsWith("Windows") ? "d:/var/tmp/db" : "/export/home1/sdc_image_pool/db"))).exists() || !root.isDirectory()) {
            SnapDb.abort("db root directory: " + dbroot + " not found ... aborting!");
        }
        if ((snap = new File(root.getParent() + File.separator + "db_snap")).exists()) {
            SnapDb.abort(snap.getAbsolutePath() + " already exists ... aborting!");
        } else if (!snap.mkdir()) {
            SnapDb.abort("Unable to make snap dir: " + snap.getAbsolutePath() + " ... aborting");
        }
        System.out.println("Starting snap ...");
        long start = System.currentTimeMillis();
        SnapDb s2 = new SnapDb(root, snap);
        s2.doAnon = !noannon;
        System.out.println("Annonimization= " + (s2.doAnon ? "ON" : "OFF"));
        System.out.println("");
        s2.snap(root);
        long elapsed = System.currentTimeMillis() - start;
        System.out.println("Snap completed in " + elapsed + " ms");
    }
}

