/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.volume;

import com.ge.med.idc.XjImage;
import com.ge.med.idc.XjTagValue;
import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMUtils;
import com.ge.med.terra.tap.dm.DMVolume;
import com.ge.med.terra.tap.dm.pesi.VheadersAuxObject;
import com.ge.med.terra.tap.dm.sessionFile.dicomImageGen;
import com.ge.med.terra.tap.dm.sessionFile.fileImage;
import com.ge.med.terra.tap.dm.volume.ImageWrap;
import com.ge.med.terra.tap.dm.volume.VolumeInfo;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public class VheadersObjVolume
extends DMVolume {
    public static final int flip;
    IImage[] slices;
    int width;
    int height;
    boolean littleEndian;
    int bitsPerPix = -1;
    int pixType = 0;
    VheadersAuxObject vao;
    double[] ras_xdir = new double[3];
    double[] ras_ydir = new double[3];
    VolumeInfo vinfo;

    private void filldoubles(String str, double[] dv) {
        String[] s2 = str.split("\\\\");
        for (int i2 = 0; i2 < s2.length; ++i2) {
            dv[i2] = Double.parseDouble(s2[i2]);
        }
    }

    public VheadersObjVolume(DMObject dmo) {
        this(new Object[]{dmo});
    }

    public VheadersObjVolume(Object[] obj) {
        if (obj.length != 1) {
            throw new IllegalArgumentException("Object must be a single series or VheadersAuxObject");
        }
        if (obj[0] instanceof DMObject) {
            DMObject dmo = (DMObject)obj[0];
            if (!"series".equalsIgnoreCase(dmo.getType())) {
                throw new IllegalArgumentException("Object must be a single series or VheadersAuxObject");
            }
            VheadersAuxObject vao = (VheadersAuxObject)dmo.getAuxObject("vheaders", null);
            this.init(vao, null);
        } else if (obj[0] instanceof VheadersAuxObject) {
            this.init((VheadersAuxObject)obj[0], null);
        } else {
            throw new IllegalArgumentException("Object must be a single series or VheadersAuxObject");
        }
    }

    public VheadersObjVolume(VheadersAuxObject vao) {
        this.init(vao, null);
    }

    private void init(VheadersAuxObject vao, DMTag[] neededtags) {
        double[] ras_xy = new double[6];
        double[] pixSpac = new double[2];
        this.vao = vao;
        int noi = vao.getNumberOfImage();
        ArrayList<IImage> al2 = new ArrayList<IImage>(noi);
        double[] topLeft = new double[3];
        int i2 = 0;
        while (i2 < noi) {
            String path = vao.getFilePath(i2);
            tagValue[] tget = fileImage.buildNeededTag(neededtags);
            vao.getImageTags(i2, (DMElement[])tget);
            String imgType = ((String)dicomImageGen.get(tget, 40, 4)).trim();
            int dimy = (Integer)dicomImageGen.get(tget, 40, 16);
            int dimx = (Integer)dicomImageGen.get(tget, 40, 17);
            if (i2 == 0) {
                Object str = dicomImageGen.get(tget, 32, 55);
                if (str != null) {
                    this.filldoubles(str.toString(), ras_xy);
                } else {
                    ras_xy = null;
                }
                str = dicomImageGen.get(tget, 40, 48);
                if (str != null) {
                    this.filldoubles(str.toString(), pixSpac);
                } else {
                    pixSpac = null;
                }
                this.bitsPerPix = fileImage.getBitsPerPix((DMElement[])tget);
                if ("MONOCHROME2".equalsIgnoreCase(imgType)) {
                    this.pixType = 1;
                } else if ("RGB".equalsIgnoreCase(imgType)) {
                    this.pixType = 2;
                } else if ("PALETTE COLOR".equalsIgnoreCase(imgType)) {
                    this.pixType = 3;
                }
            }
            tagValue tv = DMUtils.findtag(tget, 32, 50);
            this.littleEndian = tget[15].isLittleEndian();
            if (tv != null) {
                String str = (String)tv.value;
                this.filldoubles(str, topLeft);
            }
            this.width = dimx;
            this.height = dimy;
            IImage img = new IImage();
            img.filename = path;
            System.arraycopy(topLeft, 0, img.topLeft, 0, 3);
            img.topLeft[0] = -img.topLeft[0];
            img.topLeft[1] = -img.topLeft[1];
            img.offset = vao.getOffset(i2);
            img.imgNo = i2++;
            al2.add(img);
        }
        this.slices = al2.toArray(new IImage[al2.size()]);
        if (ras_xy != null) {
            this.ras_xdir[0] = -ras_xy[0] * pixSpac[0];
            this.ras_xdir[1] = -ras_xy[1] * pixSpac[0];
            this.ras_xdir[2] = ras_xy[2] * pixSpac[0];
            this.ras_ydir[0] = -ras_xy[3] * pixSpac[1];
            this.ras_ydir[1] = -ras_xy[4] * pixSpac[1];
            this.ras_ydir[2] = ras_xy[5] * pixSpac[1];
        }
        final double[] v2 = new double[]{this.slices[0].topLeft[0] - this.slices[1].topLeft[0], this.slices[0].topLeft[1] - this.slices[1].topLeft[1], this.slices[0].topLeft[2] - this.slices[1].topLeft[2]};
        double[] t2 = VheadersObjVolume.crossProduct3(null, this.ras_xdir, this.ras_ydir);
        double k2 = this.dot(t2, v2);
        if ((double)flip * k2 > 0.0) {
            v2[0] = -v2[0];
            v2[1] = -v2[1];
            v2[2] = -v2[2];
        }
        final double[] p2 = new double[]{this.slices[0].topLeft[0], this.slices[0].topLeft[1], this.slices[0].topLeft[2]};
        Arrays.sort(this.slices, new Comparator(){
            double[] tmp = new double[3];

            public int compare(Object o1, Object o2) {
                IImage i1 = (IImage)o1;
                IImage i2 = (IImage)o2;
                VheadersObjVolume.this.sub(i1.topLeft, p2, this.tmp);
                double t1 = VheadersObjVolume.this.dot(this.tmp, v2);
                VheadersObjVolume.this.sub(i2.topLeft, p2, this.tmp);
                double t2 = VheadersObjVolume.this.dot(this.tmp, v2);
                return Double.compare(t2, t1);
            }
        });
    }

    private void sub(double[] a2, double[] b2, double[] out) {
        out[0] = a2[0] - b2[0];
        out[1] = a2[1] - b2[1];
        out[2] = a2[2] - b2[2];
    }

    private double dot(double[] a2, double[] b2) {
        return a2[0] * b2[0] + a2[1] * b2[1] + a2[2] * b2[2];
    }

    public static double[] crossProduct3(double[] out, double[] a2, double[] b2) {
        if (out == null) {
            out = new double[]{a2[1] * b2[2] - b2[1] * a2[2], a2[2] * b2[0] - b2[2] * a2[0], a2[0] * b2[1] - b2[0] * a2[1]};
        }
        return out;
    }

    @Override
    public int[] getVolumeDimensions(int[] dims) {
        if (dims == null) {
            dims = new int[]{this.width, this.height, this.slices.length};
        }
        return dims;
    }

    @Override
    public double[] getRASOfOrigin(double[] doubleArray) {
        if (doubleArray == null) {
            doubleArray = this.slices[0].topLeft;
        } else {
            System.arraycopy(this.slices[0].topLeft, 0, doubleArray, 0, 3);
        }
        return doubleArray;
    }

    @Override
    public double[] getXDirectionRAS(double[] ras_dx) {
        if (ras_dx == null) {
            ras_dx = this.ras_xdir;
        } else {
            System.arraycopy(this.ras_xdir, 0, ras_dx, 0, 3);
        }
        return ras_dx;
    }

    @Override
    public double[] getYDirectionRAS(double[] ras_dy) {
        if (ras_dy == null) {
            ras_dy = this.ras_ydir;
        } else {
            System.arraycopy(this.ras_ydir, 0, ras_dy, 0, 3);
        }
        return ras_dy;
    }

    @Override
    public double[] getZDirectionRAS(double[] ras_dz) {
        if (ras_dz == null) {
            ras_dz = new double[]{this.slices[1].topLeft[0] - this.slices[0].topLeft[0], this.slices[1].topLeft[1] - this.slices[0].topLeft[1], this.slices[1].topLeft[2] - this.slices[0].topLeft[2]};
        }
        return ras_dz;
    }

    @Override
    public int getValues(XjTagValue[] xjTagValueArray) {
        DMElement[] data = DMElement.genDMelements(xjTagValueArray);
        this.vao.getImageTags(0, data);
        return DMElement.getXjTagValue(data, xjTagValueArray);
    }

    @Override
    public long getVSliceOffset(int slice) {
        return this.slices[slice].offset;
    }

    @Override
    public String getVSlicePath(int slice) {
        return this.slices[slice].filename;
    }

    @Override
    public int getBitsPerVoxel() {
        return this.bitsPerPix;
    }

    @Override
    public int getPixelType() {
        return this.pixType;
    }

    @Override
    public boolean isVolumeLittleEndian() {
        return this.littleEndian;
    }

    @Override
    public Object getVSliceValue(int sliceNo, int group, int element) {
        DMElement[] dme = new DMElement[]{new DMElement(group, element)};
        this.vao.getImageTags(sliceNo, dme);
        return dme[0].value;
    }

    @Override
    public void getVSliceValues(int sliceNo, DMElement[] dme) {
        this.vao.getImageTags(sliceNo, dme);
    }

    @Override
    public Object getValue(int group, int element) {
        return this.getVSliceValue(0, group, element);
    }

    @Override
    public String getRelatedComposite() {
        return this.slices[0].filename;
    }

    @Override
    public VolumeInfo getInfoFileName() {
        if (this.vinfo != null) {
            return this.vinfo;
        }
        try {
            this.vinfo = VolumeInfo.createTmpInfo(this);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return this.vinfo;
    }

    public XjImage getImage(int slice) {
        return new ImageWrap(this, slice);
    }

    static {
        String s2 = null;
        try {
            s2 = System.getProperty("tap.flipVolume");
        }
        catch (Exception exception) {
            // empty catch block
        }
        flip = s2 != null ? -1 : 1;
    }

    class IImage {
        double[] topLeft = new double[3];
        int imgNo;
        String filename;
        long offset;

        IImage() {
        }
    }
}

