/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.volume;

import com.ge.med.terra.tap.dm.volume.VolumeInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;

public abstract class Vinfo {
    protected final int GROUP = this.getGroup();
    protected final int ELEMENT = this.getElement();
    protected int len = 0;
    protected int offset = 0;
    protected FileChannel channel;
    protected MappedByteBuffer map;
    protected String name;
    int base_offset;
    static Vinfo[] types = new Vinfo[]{new VolumeInfo()};
    protected HashMap<String, Vinfo> all;

    public Vinfo getHeader(String name) {
        return this.all.get(name);
    }

    abstract void fillFromFile(int var1, int var2, HashMap<String, Vinfo> var3, String var4, FileChannel var5, MappedByteBuffer var6);

    protected abstract int getGroup();

    protected abstract int getElement();

    public static Vinfo atach(String name) throws FileNotFoundException, IOException {
        File f2 = new File(name);
        long flen = f2.length();
        RandomAccessFile r2 = new RandomAccessFile(f2, "rw");
        HashMap<String, Vinfo> hash = new HashMap<String, Vinfo>();
        FileChannel channel = r2.getChannel();
        MappedByteBuffer map = channel.map(FileChannel.MapMode.READ_WRITE, 0L, f2.length());
        int len = 0;
        int offset = 0;
        int[] intBuff = new int[3];
        Vinfo first = null;
        Vinfo.setOrder(map);
        do {
            map.asIntBuffer().get(intBuff, offset, 3);
            len = intBuff[2];
            for (int i2 = 0; i2 < types.length; ++i2) {
                if (intBuff[0] != Vinfo.types[i2].GROUP || intBuff[1] != Vinfo.types[i2].ELEMENT) continue;
                try {
                    Vinfo c2 = (Vinfo)types[i2].getClass().newInstance();
                    if (first == null) {
                        first = c2;
                    }
                    c2.fillFromFile(len, offset, hash, name, channel, map);
                    hash.put(types[i2].getClass().getName(), c2);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                offset += len;
            }
        } while ((long)offset < flen);
        r2.close();
        return first;
    }

    private static void setOrder(MappedByteBuffer map) {
        int[] intBuff = new int[3];
        map.order(ByteOrder.LITTLE_ENDIAN);
        map.asIntBuffer().get(intBuff, 0, 3);
        if (intBuff[2] < 0) {
            map.order(ByteOrder.BIG_ENDIAN);
        }
        System.out.println("Using map byte order to read: " + map.order());
    }
}

