/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.volume;

import com.ge.med.idc.XjImage;
import com.ge.med.idc.XjTagValue;
import com.ge.med.idc.XjVolume;
import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMVolume;
import com.ge.med.terra.tap.dm.volume.DMinfoVolume;
import com.ge.med.terra.tap.dm.volume.Vinfo;
import com.ge.med.terra.tap.util.dicom.dicomParser;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;

public class VolumeInfo
extends Vinfo
implements XjVolume {
    protected int len = 0;
    protected int offset = 0;
    protected FileChannel channel;
    protected MappedByteBuffer map;
    int base_offset;
    int[] intBuff = new int[6];
    String basePath = null;
    byte[] bytBuf = new byte[128];
    static dicomParser dp = new dicomParser();
    private static final int off_dim = 12;
    private static final int off_oneFile = 24;
    private static final int off_pixelType = 28;
    private static final int off_BitsPerVoxel = 32;
    private static final int off_VolumeLittleEndian = 36;
    private static final int off_RASOrigin = 40;
    private static final int off_XDirectionRAS = 64;
    private static final int off_YDirectionRAS = 88;
    private static final int off_ZDirectionRAS = 112;
    private static final int off_refDicomFile = 136;
    private static final int off_baseFileName = 264;
    private static final int off_filename = 392;
    private static final int off_offsets = 392;
    private static final int STRING_SIZE = 128;

    public XjImage getImage(int _int) {
        return null;
    }

    public VolumeInfo() {
    }

    void fillFromFile(int len, int base_offset, HashMap all, String name, FileChannel ch, MappedByteBuffer map) {
        this.len = len;
        this.offset = base_offset;
        this.all = all;
        this.channel = ch;
        this.map = map;
        this.name = name;
    }

    private void getBasePath() {
        this.map.position(264);
        this.map.get(this.bytBuf);
        this.basePath = new String(this.bytBuf).trim();
    }

    @Override
    public int[] getVolumeDimensions(int[] intArray) {
        if (intArray == null) {
            intArray = new int[3];
        }
        this.map.position(12);
        this.map.asIntBuffer().get(intArray);
        return intArray;
    }

    @Override
    public double[] getRASOfOrigin(double[] doubleArray) {
        if (doubleArray == null) {
            doubleArray = new double[3];
        }
        this.map.position(40);
        this.map.asDoubleBuffer().get(doubleArray);
        return doubleArray;
    }

    @Override
    public double[] getXDirectionRAS(double[] doubleArray) {
        if (doubleArray == null) {
            doubleArray = new double[3];
        }
        this.map.position(64);
        this.map.asDoubleBuffer().get(doubleArray);
        return doubleArray;
    }

    @Override
    public double[] getYDirectionRAS(double[] doubleArray) {
        if (doubleArray == null) {
            doubleArray = new double[3];
        }
        this.map.position(88);
        this.map.asDoubleBuffer().get(doubleArray);
        return doubleArray;
    }

    @Override
    public double[] getZDirectionRAS(double[] doubleArray) {
        if (doubleArray == null) {
            doubleArray = new double[3];
        }
        this.map.position(112);
        this.map.asDoubleBuffer().get(doubleArray);
        return doubleArray;
    }

    @Override
    public long getVSliceOffset(int slice) {
        int[] dim = this.getVolumeDimensions(null);
        int offoff = 392 + dim[2] * 128 + slice * 8;
        this.map.position(offoff);
        return this.map.asLongBuffer().get();
    }

    @Override
    public String getRelatedComposite() {
        this.map.position(136);
        this.map.get(this.bytBuf);
        return new String(this.bytBuf).trim();
    }

    @Override
    public String getVSlicePath(int slice) {
        if (this.basePath == null) {
            this.getBasePath();
        }
        this.map.position(392 + slice * 128);
        this.map.get(this.bytBuf);
        return this.basePath + new String(this.bytBuf).trim();
    }

    @Override
    public int getBitsPerVoxel() {
        this.map.position(32);
        return this.map.asIntBuffer().get();
    }

    @Override
    public int getPixelType() {
        this.map.position(28);
        return this.map.asIntBuffer().get();
    }

    @Override
    public boolean isVolumeLittleEndian() {
        this.map.position(36);
        return this.map.asIntBuffer().get() != 0;
    }

    @Override
    public Object getVSliceValue(int sliceNo, int group, int element) {
        try {
            dp.setFile(this.getRelatedComposite());
            tagValue[] tv = new tagValue[]{new tagValue(group, element)};
            dp.fill(tv);
            dp.clearFile();
            return tv[0].value;
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void getVSliceValues(int sliceNo, DMElement[] dme) {
        try {
            dp.setFile(this.getRelatedComposite());
            dp.fill(dme);
            dp.clearFile();
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String getPath() {
        return this.name;
    }

    @Override
    public Object getValue(int group, int element) {
        return this.getVSliceValue(0, group, element);
    }

    @Override
    public int getValues(XjTagValue[] xjTagValueArray) {
        try {
            dp.setFile(this.getRelatedComposite());
            tagValue[] data = DMElement.genDMelements(xjTagValueArray);
            dp.fill(data);
            dp.clearFile();
            return DMElement.getXjTagValue((DMElement[])data, xjTagValueArray);
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static VolumeInfo createTmpInfo(DMVolume volume) throws IOException {
        File f2 = File.createTempFile("volume", ".vif");
        f2.deleteOnExit();
        return new VolumeInfo(f2.getAbsolutePath(), volume);
    }

    public DMVolume getVolume() {
        return new DMinfoVolume(this);
    }

    public VolumeInfo(String name, DMVolume volume) throws FileNotFoundException, IOException {
        int i2;
        this.name = name;
        int[] iData = new int[10];
        double[] dData = new double[12];
        byte[] sData = null;
        int bitsPerVoxel = volume.getBitsPerVoxel();
        int pixelType = volume.getPixelType();
        boolean littleEndian = volume.isVolumeLittleEndian();
        int[] dim = volume.getVolumeDimensions(null);
        double[] rASOfOrigin = volume.getRASOfOrigin(null);
        double[] xDir = volume.getXDirectionRAS(null);
        double[] yDir = volume.getYDirectionRAS(null);
        double[] zDir = volume.getZDirectionRAS(null);
        String[] fileNames = new String[dim[2]];
        long[] offsets = new long[dim[2]];
        for (int i3 = 0; i3 < offsets.length; ++i3) {
            fileNames[i3] = volume.getVSlicePath(i3);
            offsets[i3] = volume.getVSliceOffset(i3);
        }
        boolean oneFile = true;
        for (int i4 = 0; i4 < fileNames.length; ++i4) {
            if (fileNames[i4].equals(fileNames[0])) continue;
            oneFile = false;
            break;
        }
        String base = fileNames[0];
        if (!oneFile) {
            boolean done = false;
            System.err.println("striping base " + base);
            while (!done) {
                done = true;
                for (i2 = 0; i2 < fileNames.length; ++i2) {
                    if (fileNames[i2].indexOf(base) == 0) continue;
                    done = false;
                }
                if (done) continue;
                base = base.substring(0, base.length() - 1);
            }
            System.err.println("striping base " + base);
        }
        int p2 = 0;
        iData[p2++] = 0;
        iData[p2++] = 0;
        iData[p2++] = -1;
        iData[p2++] = dim[0];
        iData[p2++] = dim[1];
        iData[p2++] = dim[2];
        iData[p2++] = oneFile ? 1 : 0;
        iData[p2++] = pixelType;
        iData[p2++] = bitsPerVoxel;
        iData[p2++] = littleEndian ? 1 : 0;
        p2 = 0;
        for (i2 = 0; i2 < rASOfOrigin.length; ++i2) {
            dData[p2++] = rASOfOrigin[i2];
        }
        for (i2 = 0; i2 < xDir.length; ++i2) {
            dData[p2++] = xDir[i2];
        }
        for (i2 = 0; i2 < yDir.length; ++i2) {
            dData[p2++] = yDir[i2];
        }
        for (i2 = 0; i2 < zDir.length; ++i2) {
            dData[p2++] = zDir[i2];
        }
        VolumeInfo.pl(iData);
        VolumeInfo.pl(dData);
        sData = new byte[(dim[2] + 2) * 128];
        p2 = 0;
        System.err.println("encoding ref \"" + volume.getRelatedComposite() + "\"");
        byte[] rComp = volume.getRelatedComposite().getBytes();
        System.arraycopy(rComp, 0, sData, 128 * p2++, rComp.length);
        System.err.println("encoding base\"" + base + "\"");
        System.arraycopy(base.getBytes(), 0, sData, 128 * p2++, base.length());
        for (int i5 = 0; i5 < fileNames.length; ++i5) {
            System.err.println("encoding file[" + i5 + "]\"" + fileNames[i5] + "\"");
            String sub = fileNames[i5].substring(base.length());
            System.arraycopy(sub.getBytes(), 0, sData, 128 * p2++, sub.length());
        }
        File f2 = new File(name);
        RandomAccessFile r2 = new RandomAccessFile(f2, "rw");
        this.len = iData.length * 4 + dData.length * 8 + sData.length + offsets.length * 8;
        System.err.println("40=" + iData.length * 4);
        System.err.println("96=" + dData.length * 8);
        r2.setLength(this.len);
        iData[2] = this.len;
        this.channel = r2.getChannel();
        this.map = this.channel.map(FileChannel.MapMode.READ_WRITE, 0L, f2.length());
        this.map.position(0);
        this.map.asIntBuffer().put(iData);
        this.map.position(40);
        this.map.asDoubleBuffer().put(dData);
        this.map.position(136);
        this.map.put(sData);
        this.map.position(392 + 128 * fileNames.length);
        System.err.println("length=" + (this.len - this.map.position()));
        this.map.asLongBuffer().put(offsets);
    }

    @Override
    protected int getGroup() {
        return 0;
    }

    @Override
    protected int getElement() {
        return 0;
    }

    public void printData() {
        this.printData(System.out);
    }

    public void debugMap() {
        int[] iData = new int[10];
        double[] dData = new double[12];
        this.map.position(0);
        this.map.asIntBuffer().get(iData);
        VolumeInfo.pl(iData);
        this.map.position(40);
        this.map.asDoubleBuffer().get(dData);
        VolumeInfo.pl(dData);
    }

    public static void pl(int[] a2) {
        for (int i2 = 0; i2 < a2.length; ++i2) {
            System.out.print((i2 == 0 ? "" : ",") + a2[i2]);
        }
        System.out.println();
    }

    public static void pl(double[] a2) {
        for (int i2 = 0; i2 < a2.length; ++i2) {
            System.out.print((i2 == 0 ? "" : ",") + a2[i2]);
        }
        System.out.println();
    }

    public void printData(PrintStream out) {
        out.println(this.GROUP + "," + this.ELEMENT);
        int[] dim = this.getVolumeDimensions(null);
        double[] rASOfOrigin = this.getRASOfOrigin(null);
        double[] xDir = this.getXDirectionRAS(null);
        double[] yDir = this.getYDirectionRAS(null);
        double[] zDir = this.getZDirectionRAS(null);
        out.println("                 dim =" + dim[0] + "x" + dim[1] + "x" + dim[2]);
        out.println("        getPixelType = " + this.getPixelType());
        out.println("isVolumeLittleEndian = " + this.isVolumeLittleEndian());
        out.println("         rASOfOrigin =" + rASOfOrigin[0] + "x" + rASOfOrigin[1] + "x" + rASOfOrigin[2]);
        out.println("                xDir =" + xDir[0] + "x" + xDir[1] + "x" + xDir[2]);
        out.println("                yDir =" + yDir[0] + "x" + yDir[1] + "x" + yDir[2]);
        out.println("                zDir =" + zDir[0] + "x" + zDir[1] + "x" + zDir[2]);
        out.println("                zDir =" + zDir[0] + "x" + zDir[1] + "x" + zDir[2]);
        for (int i2 = 0; i2 < dim[2]; ++i2) {
            out.println("          slice(" + i2 + ") =" + this.getVSlicePath(i2) + "(" + this.getVSliceOffset(i2) + ")");
        }
    }
}

