/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dmui.table;

import com.ge.med.terra.tap.dmui.table.DmuTableColumnModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;

public class DmuTableControlPopup
extends JPopupMenu {
    private ArrayList actions;
    private DmuTableColumnModel model;
    private TableColumnModelListener listener;

    public DmuTableControlPopup(DmuTableColumnModel model) {
        this.model = model;
        this.actions = new ArrayList();
        this.listener = new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e2) {
                DmuTableControlPopup.this.populatePopup();
            }

            @Override
            public void columnMarginChanged(ChangeEvent e2) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent e2) {
                if (e2.getFromIndex() != e2.getToIndex()) {
                    DmuTableControlPopup.this.populatePopup();
                }
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e2) {
                DmuTableControlPopup.this.populatePopup();
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e2) {
            }
        };
        model.addColumnModelListener(this.listener);
    }

    @Override
    public void show(Component invoker, int x2, int y2) {
        if (this.getComponentCount() > 0) {
            super.show(invoker, x2, y2);
        }
    }

    protected void populatePopup() {
        this.removeAll();
        this.actions.clear();
        Enumeration columns = this.model.getColumns(true);
        while (columns.hasMoreElements()) {
            TableColumn column = (TableColumn)columns.nextElement();
            boolean visible = this.model.isColumnVisible(column);
            DmuColumnAction action = new DmuColumnAction(column, visible);
            this.actions.add(action);
            JCheckBoxMenuItem cb = new JCheckBoxMenuItem(action);
            cb.setSelected(visible);
            this.add(cb);
        }
    }

    private void enableLastAction(boolean b2) {
        for (int i2 = 0; i2 < this.actions.size(); ++i2) {
            DmuColumnAction action = (DmuColumnAction)this.actions.get(i2);
            if (action.isSelected() == b2) continue;
            action.setEnabled(b2);
            break;
        }
    }

    private class DmuColumnAction
    extends AbstractAction {
        private TableColumn column;
        private boolean selected;

        public DmuColumnAction(TableColumn column) {
            this.column = column;
            this.selected = true;
            Object value = column.getHeaderValue();
            if (value instanceof Icon) {
                this.putValue("SmallIcon", (Icon)value);
            } else {
                this.putValue("Name", value.toString());
            }
        }

        public DmuColumnAction(TableColumn column, boolean selected) {
            this(column);
            this.selected = selected;
        }

        public boolean isSelected() {
            return this.selected;
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            boolean bl = this.selected = !this.selected;
            if (this.selected) {
                if (DmuTableControlPopup.this.model.getVisibleColumnCount() == 1) {
                    DmuTableControlPopup.this.enableLastAction(true);
                }
                DmuTableControlPopup.this.model.setColumnVisible(this.column);
            } else {
                DmuTableControlPopup.this.model.setColumnHidden(this.column);
                if (DmuTableControlPopup.this.model.getVisibleColumnCount() == 1) {
                    DmuTableControlPopup.this.enableLastAction(false);
                }
            }
        }
    }
}

