/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.ui.listSelect;

import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.ui.listSelect.HeaderConfig;
import com.ge.med.terra.tap.util.SimpleUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.StringTokenizer;

public class TagNameConfig {
    String file;
    Properties hdrProp = new Properties();
    HeaderConfig[] config;

    public TagNameConfig() {
        this.file = SimpleUtilities.getTempDir() + File.separator + "defaultHeader.properties";
        if (new File(this.file).exists()) {
            try {
                this.parseProperties(new FileInputStream(this.file));
            }
            catch (FileNotFoundException e2) {
                e2.printStackTrace();
            }
        } else {
            this.parseProperties(this.getClass().getResourceAsStream("defaultHeader.properties"));
        }
    }

    public TagNameConfig(String file) throws FileNotFoundException {
        this.parseProperties(new FileInputStream(file));
        this.file = file;
    }

    public HeaderConfig getHeaderFor(DMObject o2) {
        if (o2 == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.config.length; ++i2) {
            DMQuery q2;
            if (!this.config[i2].level.equalsIgnoreCase(o2.getType()) || !(q2 = new DMQuery(this.config[i2].query)).valid(o2)) continue;
            return this.config[i2];
        }
        return null;
    }

    public int getLength() {
        return this.config.length;
    }

    public HeaderConfig[] getConfig() {
        return this.config;
    }

    public String[] getTagFormat(String[] grp, String[] elem) {
        String[] tags = new String[grp.length];
        for (int i2 = 0; i2 < grp.length; ++i2) {
            tags[i2] = "0x" + grp[i2] + ", " + "0x" + elem[i2];
        }
        return tags;
    }

    private void parseProperties(InputStream is) {
        try {
            this.hdrProp.load(is);
        }
        catch (FileNotFoundException e2) {
            System.out.println(e2);
        }
        catch (IOException e3) {
            System.out.println(e3);
        }
        String base = this.hdrProp.getProperty("base");
        StringTokenizer st = new StringTokenizer(base, ",");
        int n2 = st.countTokens();
        this.config = new HeaderConfig[n2];
        int i2 = 0;
        while (st.hasMoreTokens()) {
            this.config[i2] = new HeaderConfig();
            this.config[i2].name = (String)st.nextElement();
            this.config[i2].level = this.hdrProp.getProperty(this.config[i2].name + ".level");
            this.config[i2].query = this.hdrProp.getProperty(this.config[i2].name + ".query");
            this.config[i2].title = this.commaToArray(this.hdrProp.getProperty(this.config[i2].name + ".title"));
            this.config[i2].group = this.commaToArray(this.hdrProp.getProperty(this.config[i2].name + ".group"));
            this.config[i2].element = this.commaToArray(this.hdrProp.getProperty(this.config[i2].name + ".element"));
            this.config[i2].formatter = this.commaToArray(this.hdrProp.getProperty(this.config[i2].name + ".formatter"));
            if (this.config[i2].formatter != null && this.config[i2].formatter.length < this.config[i2].group.length) {
                String[] temp = new String[this.config[i2].group.length];
                for (int j2 = 0; j2 < this.config[i2].formatter.length; ++j2) {
                    StringTokenizer tokenizer = new StringTokenizer(this.config[i2].formatter[j2], "|");
                    temp[Integer.parseInt((String)tokenizer.nextToken())] = tokenizer.nextToken();
                }
                this.config[i2].formatter = temp;
            }
            this.config[i2].titleWidth = this.commaToIntArray(this.hdrProp.getProperty(this.config[i2].name + ".width"));
            ++i2;
        }
    }

    public void save(HeaderConfig hdr) {
        String level = hdr.level;
        this.hdrProp.setProperty(hdr.name + ".level", hdr.level);
        this.hdrProp.setProperty(hdr.name + ".query", hdr.query);
        String title = new String();
        String group = new String();
        String element = new String();
        String formatter = new String();
        String width = new String();
        for (int i2 = 0; i2 < hdr.title.length; ++i2) {
            title = title + hdr.title[i2] + ",";
            if (hdr.group[i2] != null) {
                group = group + hdr.group[i2] + ",";
            }
            if (hdr.element[i2] != null) {
                element = element + hdr.element[i2] + ",";
            }
            if (hdr.formatter != null && hdr.formatter[i2] != null) {
                formatter = formatter + i2 + "|" + hdr.formatter[i2] + ",";
            }
            width = width + hdr.titleWidth[i2] + ",";
        }
        this.hdrProp.setProperty(hdr.name + ".title", title);
        this.hdrProp.setProperty(hdr.name + ".group", group);
        this.hdrProp.setProperty(hdr.name + ".element", element);
        this.hdrProp.setProperty(hdr.name + ".formatter", formatter);
        this.hdrProp.setProperty(hdr.name + ".width", width);
        try {
            FileOutputStream fout = new FileOutputStream(this.file);
            this.hdrProp.store(fout, null);
            fout.close();
            System.out.println("save to=" + this.file);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private int[] commaToIntArray(String str) {
        StringTokenizer st = new StringTokenizer(str, ",");
        int[] ina = new int[st.countTokens()];
        int i2 = 0;
        while (st.hasMoreTokens()) {
            ina[i2++] = Integer.parseInt(st.nextToken());
        }
        return ina;
    }

    private String[] commaToArray(String str) {
        if (str == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(str, ",");
        String[] strs = new String[st.countTokens()];
        int i2 = 0;
        while (st.hasMoreTokens()) {
            strs[i2++] = st.nextToken();
        }
        return strs;
    }

    public static void main(String[] args) {
        TagNameConfig config = new TagNameConfig();
        System.out.println("Length= " + config.getLength());
        HeaderConfig[] hconfigs = config.getConfig();
        for (int i2 = 0; i2 < hconfigs.length; ++i2) {
            int j2;
            System.out.println("Level- " + hconfigs[i2].level);
            System.out.println("Name - " + hconfigs[i2].name);
            System.out.println("Query- " + hconfigs[i2].query);
            for (j2 = 0; j2 < hconfigs[i2].title.length; ++j2) {
                System.out.println("Title- " + hconfigs[i2].title[j2] + " (width= " + hconfigs[i2].titleWidth[j2] + ")");
            }
            for (j2 = 0; j2 < hconfigs[i2].group.length; ++j2) {
                System.out.println("(" + hconfigs[i2].group[j2] + ", " + hconfigs[i2].element[j2] + ")");
            }
            for (j2 = 0; hconfigs[i2].formatter != null && j2 < hconfigs[i2].formatter.length; ++j2) {
                System.out.println("Formatter[" + j2 + "]- " + hconfigs[i2].formatter[j2]);
            }
        }
    }
}

