/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.clientServer;

import com.ge.med.terra.tap.util.clientServer.Utils;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;

public class CompressedOutputStream
extends FilterOutputStream {
    private byte[] inBuf;
    private byte[] outBuf;
    private int count;
    private int size;
    private Deflater deflater;

    public CompressedOutputStream(OutputStream os) throws IOException {
        this(os, 8192);
    }

    public CompressedOutputStream(OutputStream os, int size) throws IOException {
        this(os, size, 9, 0);
    }

    public CompressedOutputStream(OutputStream os, int size, int level, int strategy) throws IOException {
        super(os);
        if (size <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.size = size;
        this.inBuf = new byte[size];
        this.outBuf = new byte[size + 4];
        this.deflater = new Deflater(level);
        this.deflater.setStrategy(strategy);
    }

    protected void compressAndWrite() throws IOException {
        if (this.count > 0) {
            this.deflater.setInput(this.inBuf, 0, this.count);
            this.deflater.finish();
            int compSize = this.deflater.deflate(this.outBuf, 4, this.size);
            Utils.putInt(this.outBuf, 0, compSize);
            this.out.write(this.outBuf, 0, compSize + 4);
            this.out.flush();
            this.count = 0;
            this.deflater.reset();
        }
    }

    @Override
    public void write(int b2) throws IOException {
        this.inBuf[this.count++] = (byte)b2;
        if (this.count == this.inBuf.length) {
            this.compressAndWrite();
        }
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        while (this.count + len > this.inBuf.length) {
            int copyLen = this.inBuf.length - this.count;
            System.arraycopy(b2, off, this.inBuf, this.count, copyLen);
            this.count += copyLen;
            this.compressAndWrite();
            off += copyLen;
            len -= copyLen;
        }
        System.arraycopy(b2, off, this.inBuf, this.count, len);
        this.count += len;
    }

    @Override
    public void flush() throws IOException {
        this.compressAndWrite();
    }
}

