/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.clientServer;

import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.DMUtils;
import com.ge.med.terra.tap.util.SimpleUtilities;
import com.ge.med.terra.tap.util.clientServer.Utils;
import com.ge.med.terra.tap.util.clientServer.XmBasicService;
import com.ge.med.terra.tap.util.clientServer.XmSession;
import com.ge.med.terra.tap.util.dicom.dicomParser;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;

public class DicomTransfer
extends XmBasicService {
    static String[] mfDicom = new String[]{"\\\\3.70.204.14\\images\\NM\\cmp0000001397_fixed.tdb", "\\\\3.70.204.14\\images\\NM\\cmp0000000790_fixed.tdb", "\\\\3.70.204.14\\images\\NM\\cmp0000001389_fixed.tdb", "\\\\3.70.204.14\\images\\NM\\cmp0000000050.tdb", "\\\\3.70.204.14\\images\\CJK\\Jp_12", "\\\\3.70.204.14\\images\\i18n\\Jp_12", "\\\\3.70.204.14\\images\\hast\\dicom01238.dcm", "\\\\3.70.204.14\\images\\hast\\dicom01239.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00687.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00726.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00240.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00241.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00242.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00243.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00244.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00245.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00246.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00247.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00248.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00249.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00250.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00251.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00252.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00253.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00254.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00256.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00257.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00948.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00949.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00950.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00951.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00264.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00265.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00953.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00266.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00954.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00267.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00955.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00268.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00269.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00270.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00271.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00272.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00273.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00274.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00969.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00970.dcm", "\\\\3.70.204.14\\images\\hast\\dicom00316.dcm", "\\\\3.70.204.14\\images\\hast\\dicom01087.dcm", "\\\\3.70.204.14\\images\\hast\\dicom01090.dcm", "\\\\3.70.204.14\\images\\hast\\dicom01092.dcm", "\\\\3.70.204.14\\images\\hast\\dicom01094.dcm", "\\\\3.70.204.14\\images\\hast\\dicom01095.dcm", "\\\\3.70.204.14\\images\\hast\\dicom01097.dcm", "\\\\3.70.204.14\\images\\hast\\dicom01102.dcm", "\\\\3.70.204.14\\images\\hast\\dicom01104.dcm", "\\\\3.70.204.14\\images\\hast\\dicom01106.dcm", "\\\\3.70.204.14\\images\\hast\\dicom01108.dcm", "\\\\3.70.204.14\\images\\hast\\dicom01109.dcm", "\\\\3.70.204.14\\images\\hast\\dicom01110.dcm", "\\\\3.70.204.14\\images\\hast\\dicom01111.dcm", "\\\\3.70.204.14\\images\\hast\\dicom01114.dcm", "\\\\3.70.204.14\\images\\hast\\dicom01115.dcm", "\\\\3.70.204.14\\images\\hast\\dicom01117.dcm", "\\\\3.70.204.14\\images\\hast\\dicom01118.dcm", "\\\\3.70.204.14\\images\\hast\\dicom01121.dcm", "\\\\3.70.204.14\\images\\hast\\dicom01123.dcm", "\\\\3.70.204.14\\images\\hast\\dicom01126.dcm", "\\\\3.70.204.14\\images\\xray\\00000001", "\\\\3.70.204.14\\images\\mr-mf\\DYNMAMMO", "\\\\3.70.204.14\\images\\mr-mf\\ILIACSUB", "\\\\3.70.204.14\\images\\mr-mf\\MOVEKNEE", "\\\\3.70.204.14\\images\\mr-mf\\MOVEKNIN", "\\\\3.70.204.14\\images\\mr-mf\\MPRSAGBR", "\\\\3.70.204.14\\images\\mr-mf\\VOLBRAIN", "\\\\3.70.204.14\\images\\mr-mf\\VHMFLEGS", "\\\\3.70.204.14\\images\\mr-mf\\BIGHEART", "\\\\3.70.204.14\\images\\mr-mf\\BRFLAIR", "\\\\3.70.204.14\\images\\nmbug\\47200423483531219384.tdb", "\\\\3.70.204.14\\images\\multiframe\\rmimage.3155"};
    byte TRANSFER = 0;
    byte SEND = 1;
    byte TOPP = (byte)2;
    Vector que;
    HashMap files;
    dicomParser parser;
    HashMap map;
    final int HEADER = 20;
    boolean sending;
    static FileFilter mffilter = new FileFilter(){
        tagValue[] tv = new tagValue[]{new tagValue(40, 8)};
        dicomParser parser = new dicomParser();
        HashSet exclude = new HashSet<String>(Arrays.asList(".tar", ".tgz", ".gz"));

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean accept(File pathname) {
            if (pathname.isDirectory()) {
                return true;
            }
            if (550000L > pathname.length()) {
                return false;
            }
            String s2 = pathname.getName();
            int index = s2.lastIndexOf(".");
            if (index > 0 && this.exclude.contains(s2.substring(index))) {
                return false;
            }
            try {
                int frames;
                this.parser.setFile(pathname.getAbsolutePath());
                this.parser.fill(this.tv);
                int n2 = frames = this.tv[0].value != null ? Integer.parseInt((String)this.tv[0].value) : 1;
                if (frames > 1) {
                    System.out.println(pathname.getAbsolutePath());
                    boolean bl = true;
                    return bl;
                }
            }
            catch (FileNotFoundException e2) {
                boolean bl = false;
                return bl;
            }
            finally {
                this.parser.clearFile();
            }
            return false;
        }
    };
    static long lasttime = System.nanoTime();

    public DicomTransfer() {
        this.setMethods(new String[]{"__requestTransfer", "__send", "__highPriority"});
        this.que = new Vector();
        this.files = new HashMap();
        this.que.add(new Packet());
        this.parser = new dicomParser();
        this.map = new HashMap();
        this.HEADER = 20;
        this.sending = false;
    }

    public byte[] __requestTransfer(byte[] data) throws IOException {
        String[] s2 = new String(data).split("\\|");
        DicomFile d2 = this._requestTransfer(Integer.parseInt(s2[0]), s2[1], s2[2]);
        int n2 = d2.noOfFames;
        byte[] ret = new byte[8];
        Utils.putInt(ret, 0, n2);
        Utils.putInt(ret, 4, (int)(d2.startOfFrames + (long)(d2.noOfFames * d2.frameSize)));
        return ret;
    }

    private DicomFile _requestTransfer(int id, String src, String dest) throws IOException {
        DicomFile d2 = new DicomFile(src);
        for (int i2 = 0; i2 <= d2.noOfFames; ++i2) {
            this.que.add(new Packet(id, d2, dest, i2));
        }
        return d2;
    }

    public int requestTransfer(String src, String dest) {
        int id = DicomTransfer.newTid();
        Task t2 = new Task();
        t2.src = src;
        t2.dest = dest;
        this.map.put(new Integer(id), t2);
        String str = id + "|" + src + "|" + dest;
        int tid = this.call(this.TRANSFER, (byte)4, str.getBytes());
        byte[] ret = this.waitForRsp(this.TRANSFER, tid);
        int n2 = Utils.getInt(ret, 0);
        t2.fileLength = Utils.getInt(ret, 4);
        t2.frameLoaded = new byte[n2 + 1];
        return id;
    }

    private void send() throws IOException {
        int ret;
        boolean endOfFrame;
        if (this.que.isEmpty()) {
            this.sending = false;
            return;
        }
        Packet p2 = (Packet)this.que.get(0);
        if (p2.src == null) {
            this.sending = false;
            return;
        }
        this.sending = true;
        File f2 = new File(p2.src);
        if (p2.fis == null) {
            p2.fis = new RandomAccessFile(f2, "r");
        }
        int read = 4096;
        byte[] data = new byte[read + 20];
        long off = p2.offset + (long)p2.partSent;
        boolean bl = endOfFrame = p2.len - p2.partSent <= read;
        if (endOfFrame) {
            read = p2.len - p2.partSent;
            p2.partSent += read;
            this.que.remove(p2);
        } else {
            p2.partSent += read;
        }
        p2.fis.seek(off);
        for (int got = 0; got < read; got += ret) {
            ret = p2.fis.read(data, 20, read);
            if (ret != -1) continue;
            throw new IOException("failed to finish read");
        }
        if (endOfFrame) {
            p2.fis.close();
        }
        ByteBuffer buff = ByteBuffer.wrap(data);
        buff.putLong(off);
        buff.putInt(read);
        buff.putInt(p2.id);
        buff.putInt(endOfFrame ? p2.frame : -1);
        int tid = this.call(this.SEND, (byte)6, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] __send(byte[] data) throws IOException {
        block10: {
            ByteBuffer buff = ByteBuffer.wrap(data);
            long off = buff.getLong();
            int read = buff.getInt();
            int id = buff.getInt();
            int frame = buff.getInt();
            Task t2 = (Task)this.map.get(new Integer(id));
            try {
                if (t2.fos == null) {
                    t2.fos = new RandomAccessFile(t2.dest, "rw");
                    t2.fos.setLength(t2.fileLength);
                }
                t2.fos.seek(off);
                t2.fos.write(data, 20, read);
                if (frame == -1) break block10;
                Tap.log.log(Level.FINER, "Deactivating full bandwidth mode for DicomTransfer");
                this.getParent().setFullBandwidth(false);
                t2.frameLoaded[frame] = 2;
                t2.fos.getChannel().force(true);
                Task task = t2;
                synchronized (task) {
                    t2.notifyAll();
                }
                boolean done = true;
                for (int i2 = 0; i2 < t2.frameLoaded.length; ++i2) {
                    if (2 == t2.frameLoaded[i2]) continue;
                    done = false;
                }
                t2.done = done;
                if (!done) break block10;
                t2.fos.close();
                t2.fos = null;
                Task task2 = t2;
                synchronized (task2) {
                    t2.notifyAll();
                }
            }
            catch (Exception e2) {
                Tap.log.log(Level.WARNING, "Unable to send data: ", e2);
            }
        }
        return null;
    }

    @Override
    protected void messageSent() {
        if (this.que.isEmpty()) {
            return;
        }
        try {
            this.send();
        }
        catch (IOException e2) {
            Tap.log.log(Level.WARNING, "Unable to send packet: ", e2);
        }
    }

    public void topPriority(int id, int frame) {
        Task t2 = (Task)this.map.get(new Integer(id));
        if (0 != t2.frameLoaded[frame]) {
            return;
        }
        t2.frameLoaded[frame] = 1;
        Tap.log.log(Level.FINER, "Activating full bandwidth mode for DicomTransfer");
        this.getParent().setFullBandwidth(true);
        int f2 = this.call(this.TOPP, (byte)6, (t2.src + "|" + frame).getBytes());
    }

    public byte[] __highPriority(byte[] data) throws IOException {
        String[] s2 = new String(data).split("\\|");
        this._highPriority(s2[0], Integer.parseInt(s2[1]));
        return null;
    }

    private void _highPriority(String src, int frame) throws FileNotFoundException {
        int moveto = 0;
        for (int i2 = 0; i2 < this.que.size(); ++i2) {
            Packet p2 = (Packet)this.que.get(i2);
            if (!src.equals(p2.src) || p2.frame != frame && p2.frame != 0) continue;
            this.que.remove(p2);
            if (p2.frame == 0) {
                this.que.add(0, p2);
                moveto = 1;
                if (frame != 0) continue;
                break;
            }
            this.que.add(moveto, p2);
            break;
        }
        try {
            this.send();
        }
        catch (IOException e2) {
            Tap.log.log(Level.WARNING, "Unable to send packet after bumping priority: ", e2);
        }
    }

    private void printQue() {
        for (int i2 = 0; i2 < this.que.size(); ++i2) {
            Packet p2 = (Packet)this.que.get(i2);
            if (p2.src == null) {
                System.out.println("--- stop ---");
            } else {
                System.out.println(p2.src.substring(p2.src.lastIndexOf("/")) + ":" + p2.frame);
            }
            if (i2 <= 4) continue;
            System.out.println("...");
            break;
        }
    }

    public static Object get(tagValue[] t2, int g2, int e2) {
        for (int i2 = 0; i2 < t2.length; ++i2) {
            if (t2[i2].group != g2 || t2[i2].element != e2) continue;
            return t2[i2].value;
        }
        return null;
    }

    public static int getBitsPerPix(tagValue[] tget) {
        int bitsPerPix = 0;
        String imgType = ((String)DicomTransfer.get(tget, 40, 4)).trim();
        if (imgType.equals("MONOCHROME2") || imgType.equals("MONOCHROME1")) {
            bitsPerPix = (Integer)DicomTransfer.get(tget, 40, 256) == 16 ? 16 : 8;
        } else if (imgType.equals("RGB")) {
            bitsPerPix = 24;
        } else if (imgType.equals("PALETTE COLOR")) {
            bitsPerPix = (Integer)DicomTransfer.get(tget, 40, 256) == 16 ? 16 : 8;
        } else {
            System.err.println("could not parse \"" + imgType + "\"");
        }
        return bitsPerPix;
    }

    public static Object get(HashMap map, Integer ge) {
        tagValue tv = (tagValue)map.get(ge);
        if (tv == null) {
            return null;
        }
        return tv.value;
    }

    public tagValue[] getTags() {
        int[][] tags = new int[][]{{2, 16}, {16, 16}, {40, 2}, {40, 4}, {40, 8}, {40, 16}, {40, 17}, {40, 18}, {40, 256}, {40, 257}, {40, 258}, {40, 259}, {32736, 16}};
        tagValue[] tget = new tagValue[tags.length];
        for (int i2 = 0; i2 < tags.length; ++i2) {
            tget[i2] = new tagValue(tags[i2][0], tags[i2][1]);
        }
        tget[tget.length - 1].setFillValue(false);
        return tget;
    }

    public int getTask(String src) {
        Set s2 = this.map.keySet();
        for (Integer element : s2) {
            if (!((Task)this.map.get((Object)element)).src.equals(src)) continue;
            return element;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForTask(int id) {
        Task t2 = (Task)this.map.get(new Integer(id));
        if (t2 == null) {
            throw new NoSuchElementException("no id named " + id);
        }
        try {
            Task task = t2;
            synchronized (task) {
                while (!t2.done) {
                    t2.wait();
                }
            }
        }
        catch (InterruptedException e2) {
            Tap.log.log(Level.WARNING, "Unable to wait for task=" + id + ": ", e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForFrame(int id, long timeout, int frame) throws InterruptedException {
        Task t2 = (Task)this.map.get(new Integer(id));
        if (t2 == null) {
            throw new NoSuchElementException("no id named " + id);
        }
        Task task = t2;
        synchronized (task) {
            while (2 != t2.frameLoaded[frame]) {
                t2.wait(timeout);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForTask(int id, long timeout) {
        Task t2 = (Task)this.map.get(new Integer(id));
        if (t2 == null) {
            throw new NoSuchElementException("no id named " + id);
        }
        try {
            Task task = t2;
            synchronized (task) {
                while (!t2.done) {
                    t2.wait(timeout);
                }
            }
        }
        catch (InterruptedException e2) {
            Tap.log.log(Level.WARNING, "Unable to wait for task=" + id + ", timeout=" + timeout + ": ", e2);
        }
    }

    public static File[] find(File file, FileFilter ff) {
        ArrayList<File> al2 = new ArrayList<File>();
        al2.add(file);
        for (int i2 = 0; i2 < al2.size(); ++i2) {
            file = (File)al2.get(i2);
            System.out.println(i2 + "," + file.getAbsolutePath());
            if (!file.isDirectory()) continue;
            al2.remove(i2);
            --i2;
            al2.addAll(Arrays.asList(file.listFiles(ff)));
        }
        return al2.toArray(new File[al2.size()]);
    }

    public static void ptimer(String s2) {
        if (s2 != null) {
            long now = System.nanoTime() - lasttime;
            System.out.println(lasttime + ": " + (float)now / 1000000.0f + " ms");
        }
        lasttime = System.nanoTime();
    }

    public static void main_OLD(String[] args) {
        DicomTransfer dt = new DicomTransfer();
        long count = 0L;
        File tmp = new File("C:\\MFout");
        tmp.mkdir();
        for (int i2 = 0; i2 < mfDicom.length; ++i2) {
            try {
                DicomTransfer.ptimer(null);
                File out = File.createTempFile("image", "dcm", tmp);
                out.deleteOnExit();
                dt.requestTransfer(mfDicom[i2], out.getAbsolutePath());
                DicomTransfer.ptimer(mfDicom[i2]);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            count += new File(mfDicom[i2]).length();
        }
        System.out.println(count);
    }

    public static void main(String[] args) {
        XmSession xms = null;
        try {
            Tap.setLogLevel(Level.SEVERE);
            xms = SimpleUtilities.startServer();
            DicomTransfer xss = new DicomTransfer();
            xss.installInto(xms);
            File dir = new File("C:\\MFout");
            System.out.println("........");
            Thread.sleep(2000L);
            System.out.println("........");
            dir.mkdir();
            for (int i2 = 0; i2 < mfDicom.length; ++i2) {
                File f2 = new File(mfDicom[i2]);
                if (!f2.exists()) {
                    System.err.println("\"" + f2.getAbsolutePath() + "\" does not exist");
                    continue;
                }
                File tmp = File.createTempFile("multiFrame", ".dcm", dir);
                int id = xss.requestTransfer(mfDicom[i2], tmp.getAbsolutePath());
                xss.waitForTask(id);
                SimpleUtilities.compareFiles(mfDicom[i2], tmp.getAbsolutePath());
                System.out.println("........");
                boolean worked = tmp.delete();
                if (worked) continue;
                System.out.println("fail to delete !!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            }
            System.out.println("........");
            Thread.sleep(2000L);
            System.out.println("........");
            Thread.sleep(1000L);
            SimpleUtilities.endServer(xms);
            SimpleUtilities.sleep(2000L);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            SimpleUtilities.endServer(xms);
        }
    }

    class Task {
        public static final byte DEFAULT = 0;
        public static final byte REQUESTED = 1;
        public static final byte LOADED = 2;
        String src;
        String dest;
        byte[] frameLoaded;
        boolean done;
        long fileLength;
        RandomAccessFile fos;

        Task() {
        }
    }

    class DicomFile {
        String name;
        int noOfFames;
        int frameSize;
        long startOfFrames;

        public DicomFile(String file) throws FileNotFoundException {
            this.name = file;
            DicomTransfer.this.parser.setFile(file);
            tagValue[] tags = DicomTransfer.this.getTags();
            DicomTransfer.this.parser.fill(tags);
            int dimy = (Integer)DicomTransfer.get(tags, 40, 16);
            int dimx = (Integer)DicomTransfer.get(tags, 40, 17);
            int frames = DicomTransfer.get(tags, 40, 8) != null ? Integer.parseInt((String)DicomTransfer.get(tags, 40, 8)) : 1;
            int bits = DicomTransfer.getBitsPerPix(tags);
            this.startOfFrames = tags[tags.length - 1].getOffset();
            String ts = (String)DicomTransfer.get(tags, 2, 16);
            boolean explicitVr = ts.equals(DMUtils.TS_EBE) || ts.equals(DMUtils.TS_ELE);
            this.startOfFrames += (long)(explicitVr ? 12 : 8);
            this.noOfFames = frames;
            this.frameSize = dimx * dimy * (bits / 8);
            DicomTransfer.this.parser.clearFile();
        }

        public String toString() {
            return this.name + "," + this.noOfFames + "," + this.frameSize + "," + this.startOfFrames;
        }
    }

    class Packet {
        String src;
        String dest;
        int frame;
        long offset;
        int partSent = 0;
        int len;
        int id;
        RandomAccessFile fis;

        public String toString() {
            String s2 = this.src.substring(this.src.lastIndexOf(File.separator) + 1) + " ";
            s2 = s2 + "(F" + this.frame + ")";
            return s2;
        }

        public Packet() {
            this.id = -1;
            this.frame = -1;
            this.dest = null;
            this.src = null;
        }

        public Packet(int id, DicomFile file, String dest, int frame) {
            this.id = id;
            this.frame = frame;
            this.dest = dest;
            this.src = file.name;
            if (frame == 0) {
                this.offset = 0L;
                this.len = (int)file.startOfFrames;
                return;
            }
            this.offset = file.startOfFrames + (long)(file.frameSize * (frame - 1));
            this.len = file.frameSize;
        }
    }
}

