/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.clientServer;

import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.util.SimpleUtilities;
import com.ge.med.terra.tap.util.clientServer.Ftp;
import com.ge.med.terra.tap.util.clientServer.RemoteObjectManager;
import com.ge.med.terra.tap.util.clientServer.XmService;
import com.ge.med.terra.tap.util.clientServer.XmServiceStatus;
import com.ge.med.terra.tap.util.clientServer.XmSession;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.table.AbstractTableModel;

public class StatusPanel
extends JPanel {
    JTable tab = new JTable();
    StatsModel model = new StatsModel();
    JTable tab2 = new JTable(){

        @Override
        public String getToolTipText(MouseEvent e2) {
            int row = this.rowAtPoint(e2.getPoint());
            String stack = StatusPanel.this.tmodel2.getStackFor(row);
            return stack;
        }
    };
    ThreadStatsModel tmodel2 = new ThreadStatsModel();
    XmSession xms;
    JLabel totalOutTxt;
    JLabel totalInTxt;
    JLabel packetOutTxt;
    JLabel packetInTxt;
    JLabel outQueTxt;
    Timer timer;
    RuntimeMXBean mxbean = ManagementFactory.getRuntimeMXBean();
    private static JFrame frame = null;

    public void setRun(boolean run) {
        if (run) {
            if (this.xms != null) {
                this.timer.start();
            }
            this.tmodel2.start();
        } else {
            this.timer.stop();
            this.tmodel2.stop();
        }
    }

    void updateModel() {
        long[] lastOut;
        long[] lastIn;
        Object[][] cell;
        this.totalOutTxt.setText(Long.toString(this.xms.writeCounter));
        this.totalInTxt.setText(Long.toString(this.xms.readCounter));
        this.outQueTxt.setText(Integer.toString(this.xms.msgQue.size()));
        this.packetInTxt.setText(Integer.toString(this.xms.writeMsgCounter));
        this.packetOutTxt.setText(Integer.toString(this.xms.readMsgCounter));
        XmService[] s2 = this.xms.services;
        boolean newTable = true;
        if (this.model.cell != null && this.model.cell.length == s2.length) {
            cell = this.model.cell;
            lastIn = this.model.lastIn;
            lastOut = this.model.lastOut;
            newTable = false;
        } else {
            cell = new Object[s2.length][6];
            lastIn = new long[s2.length];
            lastOut = new long[s2.length];
            if (this.model.cell != null) {
                System.arraycopy(this.model.lastIn, 0, lastIn, 0, this.model.lastIn.length);
                System.arraycopy(this.model.lastOut, 0, lastOut, 0, this.model.lastOut.length);
            }
        }
        for (int i2 = 0; i2 < s2.length; ++i2) {
            long in = this.xms.inBytes[i2];
            long out = this.xms.outBytes[i2];
            if (s2[i2] != null) {
                cell[i2][0] = s2[i2].getClass().getName().substring(11);
                if (in - lastIn[i2] > 0L) {
                    cell[i2][0] = "<html><font COLOR=\"#FF0000\">" + cell[i2][0];
                }
                XmServiceStatus ss = s2[i2].getStatus();
                Object object = cell[i2][1] = ss != null ? ss.caller.substring(11) : "----";
                if (in - lastIn[i2] > 0L) {
                    cell[i2][1] = "<html><font COLOR=\"#FF0000\">" + cell[i2][1];
                }
            } else {
                cell[i2][0] = "-";
                cell[i2][1] = "-";
            }
            cell[i2][2] = new Long(in);
            cell[i2][3] = new Long(out);
            cell[i2][4] = new Long(in - lastIn[i2]);
            cell[i2][5] = new Long(out - lastOut[i2]);
            lastIn[i2] = in;
            lastOut[i2] = out;
        }
        if (newTable) {
            this.model.cell = cell;
            this.model.lastIn = lastIn;
            this.model.lastOut = lastOut;
            int cc = this.tab.getColumnCount();
            for (int i3 = 0; i3 < cc; ++i3) {
                this.tab.getColumnModel().getColumn(i3).setPreferredWidth(this.model.getPreferedWidth(i3));
            }
            this.model.fireTableStructureChanged();
        } else {
            this.model.fireTableDataChanged();
        }
    }

    public StatusPanel() {
        this.init();
    }

    public StatusPanel(XmSession xms) {
        this.init();
        this.setSession(xms);
    }

    public void setSession(XmSession xms) {
        this.xms = xms;
    }

    public void init() {
        this.tab.setModel(this.model);
        this.tab2.setModel(this.tmodel2);
        this.tab2.getTableHeader().setPreferredSize(new Dimension(60, 40));
        int cc = this.tab2.getColumnCount();
        for (int i2 = 0; i2 < cc; ++i2) {
            this.tab2.getColumnModel().getColumn(i2).setPreferredWidth(this.tmodel2.getPreferedWidth(i2));
        }
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new GridLayout(3, 4));
        JLabel l1 = new JLabel("   Run:");
        l1.setHorizontalTextPosition(4);
        topPanel.add(l1);
        final JCheckBox cb = new JCheckBox();
        topPanel.add(cb);
        JLabel outQueLabel = new JLabel("   Out Bound Que Size:");
        outQueLabel.setHorizontalTextPosition(4);
        topPanel.add(outQueLabel);
        this.outQueTxt = new JLabel();
        Font bold = this.outQueTxt.getFont().deriveFont(1);
        this.outQueTxt.setFont(bold);
        topPanel.add(this.outQueTxt);
        JLabel totalOutLabel = new JLabel("   Total Bytes Out:");
        totalOutLabel.setHorizontalTextPosition(4);
        topPanel.add(totalOutLabel);
        this.totalOutTxt = new JLabel();
        this.totalOutTxt.setFont(bold);
        topPanel.add(this.totalOutTxt);
        JLabel totalInLabel = new JLabel("   Total Bytes Out:");
        totalInLabel.setHorizontalTextPosition(4);
        topPanel.add(totalInLabel);
        this.totalInTxt = new JLabel();
        this.totalInTxt.setFont(bold);
        topPanel.add(this.totalInTxt);
        JLabel packetOutLabel = new JLabel("   Total packets Out:");
        packetOutLabel.setHorizontalTextPosition(4);
        topPanel.add(packetOutLabel);
        this.packetOutTxt = new JLabel();
        this.packetOutTxt.setFont(bold);
        topPanel.add(this.packetOutTxt);
        JLabel packetInLabel = new JLabel("   Total packets Out:");
        packetInLabel.setHorizontalTextPosition(4);
        topPanel.add(packetInLabel);
        this.packetInTxt = new JLabel();
        this.packetInTxt.setFont(bold);
        topPanel.add(this.packetInTxt);
        cb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                StatusPanel.this.setRun(cb.isSelected());
            }
        });
        JScrollPane pan = new JScrollPane(this.tab);
        JScrollPane pan2 = new JScrollPane(this.tab2);
        JSplitPane sp = new JSplitPane(0);
        sp.add((Component)pan, "bottom");
        sp.add((Component)pan2, "top");
        sp.setDividerLocation(0.5);
        sp.setResizeWeight(0.5);
        this.setLayout(new BorderLayout());
        this.add((Component)topPanel, "North");
        this.add((Component)sp, "Center");
        this.timer = new Timer(200, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                StatusPanel.this.updateModel();
            }
        });
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                StatusPanel.this.check();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }
        });
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e2) {
                Tap.log.fine("stop");
                StatusPanel.this.check();
            }

            @Override
            public void componentMoved(ComponentEvent e2) {
            }

            @Override
            public void componentResized(ComponentEvent e2) {
            }

            @Override
            public void componentShown(ComponentEvent e2) {
                Tap.log.fine("start");
                StatusPanel.this.check();
            }
        });
    }

    public void check() {
    }

    public void dispose() {
    }

    public static void createFrame(XmSession xms, String str) {
        frame = new JFrame(str + ":" + xms.getHostAddress());
        Dimension d2 = Toolkit.getDefaultToolkit().getScreenSize();
        d2.width /= 3;
        d2.height /= 3;
        frame.setBounds(d2.height, d2.height, d2.width, d2.height);
        StatusPanel p2 = new StatusPanel(xms);
        frame.setContentPane(p2);
        frame.setDefaultCloseOperation(3);
        frame.validate();
        frame.setVisible(true);
    }

    public static void destroyFrame() {
        if (null != frame) {
            frame.dispose();
        }
    }

    public static void main(String[] args) {
        JFrame f2 = new JFrame("tank");
        Dimension d2 = Toolkit.getDefaultToolkit().getScreenSize();
        d2.width /= 3;
        d2.height /= 3;
        f2.setBounds(d2.height, d2.height, d2.width, d2.height);
        final XmSession xms = SimpleUtilities.startServer();
        StatusPanel p2 = new StatusPanel(xms);
        f2.setContentPane(p2);
        f2.validate();
        JButton b2 = new JButton("Exit");
        p2.add((Component)b2, "South");
        ActionListener act = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                SimpleUtilities.endServer(xms);
                SimpleUtilities.sleep(2000L);
                Thread[] t2 = new Thread[1000];
                ThreadGroup tg = Thread.currentThread().getThreadGroup();
                while (tg.getParent() != null) {
                    tg = tg.getParent();
                }
                tg.enumerate(t2);
                for (int i2 = 0; i2 < t2.length && t2[i2] != null; ++i2) {
                    System.err.println("Thread: " + t2[i2]);
                }
                System.err.println("============================testFileTransfer======================================");
                System.err.flush();
                System.exit(0);
            }
        };
        b2.addActionListener(act);
        f2.setDefaultCloseOperation(0);
        f2.setVisible(true);
        f2.addWindowStateListener(new WindowStateListener(){

            @Override
            public void windowStateChanged(WindowEvent e2) {
                System.err.println(e2);
            }
        });
        Thread t2 = new Thread(){

            @Override
            public void run() {
                StatusPanel.ssleep(1000);
                StatusPanel.testFileTransfer(xms);
                StatusPanel.ssleep(1000);
                RemoteObjectManager rom = new RemoteObjectManager(xms);
                for (int i2 = 0; i2 < 1000; ++i2) {
                    StatusPanel.ssleep(500);
                    Object o2 = rom.callStaticRMethod(System.class.getName(), "currentTimeMillis", new Object[0]);
                    System.out.println(">" + o2);
                }
            }
        };
        t2.start();
    }

    private static void ssleep(int v2) {
        try {
            Thread.sleep(v2);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testFileTransfer(XmSession xms) {
        FileOutputStream fos = null;
        FileInputStream fis = null;
        try {
            File f2 = File.createTempFile("ftpTest", "txt");
            byte[] data = new byte[1024];
            Random r2 = new Random();
            r2.nextBytes(data);
            fos = new FileOutputStream(f2);
            for (int i2 = 0; i2 < 1024; ++i2) {
                fos.write(data);
            }
            Ftp ftp = new Ftp(xms);
            ftp.putFile(f2.getAbsolutePath(), f2.getAbsolutePath() + "2");
            File f22 = new File(f2.getAbsolutePath() + "2");
            if (f2.length() != f22.length()) {
                throw new RuntimeException("file should be same length" + f2.length() + " = " + f22.length());
            }
            byte[] data2 = new byte[data.length];
            fis = new FileInputStream(f22);
            for (int i3 = 0; i3 < 1024; ++i3) {
                int n2;
                for (int gotten = 0; gotten < data2.length; gotten += n2) {
                    n2 = fis.read(data2, gotten, data2.length - gotten);
                    if (n2 >= 0) continue;
                    throw new IOException("error in reading file " + f22);
                }
                for (int j2 = 0; j2 < data2.length; ++j2) {
                    if (data2[i3] == data[i3]) continue;
                    throw new RuntimeException("data should be the same" + data2[i3] + " = " + data[i3]);
                }
            }
            f22.delete();
            f2.delete();
        }
        catch (FileNotFoundException e2) {
            e2.printStackTrace();
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        finally {
            if (null != fos) {
                try {
                    fos.close();
                }
                catch (IOException ioex) {}
            }
            if (null != fis) {
                try {
                    fis.close();
                }
                catch (IOException ioex) {}
            }
        }
    }

    class StatsModel
    extends AbstractTableModel {
        Object[][] cell;
        long[] lastIn;
        long[] lastOut;
        String[] names = new String[]{"name", "caller", "Total in", "Total Out", "delta in", "delta out"};
        final int[] width = new int[]{600, 600, 100, 100, 100, 100};

        StatsModel() {
        }

        public int getPreferedWidth(int col) {
            if (col < this.width.length) {
                return this.width[col];
            }
            return 100;
        }

        public Class getColumnClass(int columnIndex) {
            return this.cell[0][columnIndex].getClass();
        }

        @Override
        public int getColumnCount() {
            if (this.cell == null) {
                return 0;
            }
            return this.cell[0].length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.names[columnIndex];
        }

        @Override
        public int getRowCount() {
            if (this.cell == null) {
                return 0;
            }
            return this.cell.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.cell[rowIndex][columnIndex];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }

    class ThreadStatsModel
    extends AbstractTableModel {
        ThreadMXBean b = ManagementFactory.getThreadMXBean();
        Object[][] cell = new Object[0][0];
        long[] all;
        HashMap old = new HashMap();
        Timer timer;
        final int[] width = new int[]{40, 300, 150, 100, 100, 100, 100, 100, 40, 100, 100, 40, 100, 40};
        String[] names = new String[]{"id", "name", "state", "CPU Time", "<html>delta<br>CPU", "User Time", "<html>delta<br>User", "<html>Block<br>Count", "<html>Block<br>Time", "Lock name", "<html>Lock owner<br>id", "Lock owner name", "<html>no<br>waits", "wait time"};

        public void start() {
            this.timer.start();
        }

        public void stop() {
            this.timer.stop();
        }

        public ThreadStatsModel() {
            this.timer = new Timer(1000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    ThreadStatsModel.this.update();
                }
            });
        }

        public int getPreferedWidth(int col) {
            if (col < this.width.length) {
                return this.width[col];
            }
            return 100;
        }

        public String getStackFor(int row) {
            if (this.all == null) {
                return "";
            }
            Tap.log.fine("call getStackFor");
            ThreadInfo inf = this.b.getThreadInfo(this.all[row], 100);
            StackTraceElement[] stack = inf.getStackTrace();
            String str = "<html>";
            for (int i2 = 0; i2 < stack.length; ++i2) {
                str = str + stack[i2].toString() + "<br>";
            }
            str = str + "</html>";
            return str;
        }

        public void update() {
            this.all = this.b.getAllThreadIds();
            this.cell = new Object[this.all.length][this.names.length];
            for (int i2 = 0; i2 < this.all.length; ++i2) {
                long[] oldVal;
                int k2 = 0;
                Long id = new Long(this.all[i2]);
                if (this.old.containsKey(id)) {
                    oldVal = (long[])this.old.get(id);
                } else {
                    oldVal = new long[2];
                    this.old.put(id, oldVal);
                }
                this.cell[i2][k2++] = id;
                ThreadInfo inf = this.b.getThreadInfo(this.all[i2], 0);
                long cpu = this.b.getThreadCpuTime(this.all[i2]);
                long dcpu = cpu - oldVal[0];
                oldVal[0] = cpu;
                long usr = this.b.getThreadUserTime(this.all[i2]);
                long dusr = usr - oldVal[1];
                oldVal[1] = usr;
                this.cell[i2][k2++] = dcpu == 0L && dusr == 0L ? inf.getThreadName() : "<html><font COLOR=\"#FF0000\">" + inf.getThreadName();
                this.cell[i2][k2++] = inf.getThreadState().name();
                this.cell[i2][k2++] = new Long(cpu / 1000L);
                this.cell[i2][k2++] = new Long(dcpu / 1000L);
                this.cell[i2][k2++] = new Long(usr / 1000L);
                this.cell[i2][k2++] = new Long(dusr / 1000L);
                this.cell[i2][k2++] = new Long(inf.getBlockedCount());
                this.cell[i2][k2++] = new Long(inf.getBlockedTime());
                this.cell[i2][k2++] = inf.getLockName();
                this.cell[i2][k2++] = new Long(inf.getLockOwnerId());
                this.cell[i2][k2++] = inf.getLockOwnerName();
                this.cell[i2][k2++] = new Long(inf.getWaitedCount());
                this.cell[i2][k2++] = new Long(inf.getWaitedTime());
            }
            this.fireTableDataChanged();
        }

        public Class getColumnClass(int columnIndex) {
            if (this.cell.length == 0) {
                return Object.class;
            }
            try {
                return this.cell[0][columnIndex].getClass();
            }
            catch (Exception e2) {
                return Object.class;
            }
        }

        @Override
        public int getColumnCount() {
            return this.names.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.names[columnIndex];
        }

        @Override
        public int getRowCount() {
            if (this.cell == null) {
                return 0;
            }
            return this.cell.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.cell[rowIndex][columnIndex];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }
}

