/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.dicom;

import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.util.dicom.DicomCharSet;
import java.util.logging.Level;

public final class CJKsupport {
    public static final byte ESC = 27;

    private CJKsupport() {
    }

    @Deprecated
    public static String getUnicode(byte[] buff, int off, int len, boolean littleEndian, String tag_8_5) {
        return CJKsupport.getUnicode(buff, off, len, tag_8_5);
    }

    public static String getUnicode(byte[] buff, int off, int len, String tag_8_5) {
        DicomCharSet[] dicomCharsets = DicomCharSet.getDicomCharSets(tag_8_5);
        return CJKsupport.getUnicode(buff, off, len, dicomCharsets);
    }

    public static String getUnicode(byte[] buff, int off, int len, DicomCharSet[] dicomCharsets) {
        StringBuffer ret = new StringBuffer();
        try {
            int startpos = off;
            int endpos = len + off;
            while (0 == buff[endpos - 1] && endpos - startpos > 0) {
                --endpos;
            }
            String currentCharsetName = dicomCharsets[0].getJavaCharsetName();
            if (1 < dicomCharsets.length) {
                byte[] esc2 = new byte[2];
                byte[] esc3 = new byte[3];
                for (int i2 = startpos; i2 < endpos; ++i2) {
                    if (27 != buff[i2]) continue;
                    ret.append(new String(buff, startpos, i2 - startpos, currentCharsetName));
                    esc2[0] = buff[++i2];
                    esc2[1] = buff[++i2];
                    DicomCharSet dicomCharset = DicomCharSet.get(esc2);
                    if (null == dicomCharset) {
                        esc3[0] = esc2[0];
                        esc3[1] = esc2[1];
                        esc3[2] = buff[++i2];
                        dicomCharset = DicomCharSet.get(esc3);
                        if (null == dicomCharset) {
                            throw new IllegalArgumentException("Unknown escape sequence encountered: " + DicomCharSet.escToString(esc3));
                        }
                    }
                    currentCharsetName = dicomCharset.getJavaCharsetName();
                    startpos = i2 + 1;
                }
            }
            if (startpos < endpos) {
                ret.append(new String(buff, startpos, endpos - startpos, currentCharsetName));
            }
        }
        catch (Exception ex) {
            Tap.log.log(Level.SEVERE, "Decoding \"" + new String(buff, off, len) + "\" using specified character repertoire " + DicomCharSet.getTag85(dicomCharsets) + " failed: " + ex);
            ret.append("(ERROR)");
        }
        return ret.toString().trim();
    }

    private static String getChar(byte val) {
        return 27 == val ? "" : Integer.toHexString(val & 0xFF) + " ";
    }

    private static String escSequenceToString(byte[] escapeSequence) {
        StringBuffer sb = new StringBuffer();
        sb.append("ESC (");
        for (int i2 = 0; i2 < escapeSequence.length; ++i2) {
            if (i2 > 0) {
                sb.append(" ");
            }
            sb.append(Integer.toHexString(escapeSequence[i2] & 0xFF));
        }
        sb.append(") ");
        return sb.toString();
    }

    private static String getDecodeMsg(int start, int offset, int index, String charset) {
        return "decode " + (start - offset) + "-" + (index - start) + " using \"" + charset + "\"";
    }

    private static String getNewCharsetMsg(int index, String charset) {
        return "(" + index + ") will use \"" + charset + "\"";
    }
}

