/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.dicom;

import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.util.dicom.DicomData;
import com.ge.med.terra.tap.util.dicom.WrapperStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DicomComposite
extends DicomData {
    public static String TS_ELE = "1.2.840.10008.1.2.1";
    public static String TS_ILE = "1.2.840.10008.1.2";
    public static String TS_GEBE = "1.2.840.113619.5.2";

    public void getValues(DMElement[] elements) {
        for (int i2 = 0; i2 < elements.length; ++i2) {
            elements[i2].value = this.getValue(elements[i2].group, elements[i2].element);
        }
    }

    @Override
    public String getString(int group, int element) {
        DicomObject dataset = this.obj;
        if (group == 2 && this.obj.getFileMetaInformation() != null) {
            dataset = this.obj.getFileMetaInformation();
        }
        return DicomData.getString(group, element, dataset);
    }

    @Override
    protected void setValue(DMElement de) throws DMException {
        if (null == de.value) {
            this.removeTag(de.group, de.element);
        } else {
            super.setValue(de);
        }
    }

    @Override
    public void setValue(int g2, int e2, int n2, Object val) throws DMException {
        try {
            if (g2 == 2) {
                String verStr;
                Object tagVal = val;
                if (e2 == 19 && null != tagVal && (verStr = (String)val).length() > 16) {
                    tagVal = verStr.substring(0, 15);
                }
                if (this.obj.getFileMetaInformation() != null) {
                    this.obj.getFileMetaInformation().set_ge(g2, e2, tagVal);
                } else {
                    DicomObject filemetainfo = new DicomObject();
                    filemetainfo.set_ge(g2, e2, tagVal);
                    this.obj.setFileMetaInformation(filemetainfo);
                }
            } else if (g2 == 8 && e2 == 22) {
                this.obj.set_ge(g2, e2, val);
                if (this.obj.getFileMetaInformation() != null) {
                    this.obj.getFileMetaInformation().set_ge(2, 2, val);
                }
            } else if (g2 == 8 && e2 == 24) {
                this.obj.set_ge(g2, e2, val);
                if (this.obj.getFileMetaInformation() != null) {
                    this.obj.getFileMetaInformation().set_ge(2, 3, val);
                }
            } else {
                super.setValue(g2, e2, n2, val);
            }
        }
        catch (DicomException ex) {
            throw new DMException(ex.getMessage());
        }
    }

    public InputStream getInputStream() {
        return this.getInputStream(true, null);
    }

    public InputStream getInputStream(String transferSyntaxHint) {
        return this.getInputStream(true, transferSyntaxHint);
    }

    @Override
    public InputStream getInputStream(boolean asPart10File) {
        return this.getInputStream(asPart10File, null);
    }

    public InputStream getInputStream(boolean asPart10File, String transferSyntaxHint) {
        return new WrapperStream(this.obj, transferSyntaxHint);
    }

    @Override
    public void printDebugInfo(OutputStream out) throws IOException {
        this.obj.dumpVRs(out, true);
    }

    public String getID() {
        return (String)this.getValue(8, 24);
    }

    public static void main(String[] args) {
        DicomComposite cmp = new DicomComposite();
        DicomData itm1 = new DicomData();
        DicomData itm2 = new DicomData();
        itm1.setValue(8, 4432, "DetachedStudyManagementSOPClass");
        itm1.setValue(8, 4437, "1.113654.3.13.1079");
        itm2.setValue(8, 4432, "DetachedStudyManagementSOPClass");
        itm2.setValue(8, 4437, "1.113654.3.13.1081");
        cmp.setValue(8, 4368, 0, itm1);
        cmp.setValue(8, 4368, 1, itm2);
        try {
            cmp.printDebugInfo(System.out);
            cmp.removeTag(8, 4368);
            cmp.setValue(8, 4368, 0, itm2);
            cmp.printDebugInfo(System.out);
        }
        catch (IOException ex) {
            // empty catch block
        }
    }
}

