/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.dicom;

import com.archimed.dicom.DDate;
import com.archimed.dicom.DDictBase;
import com.archimed.dicom.DataElement;
import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.Person;
import com.archimed.dicom.charset.DicomCharset;
import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.DMSeqItem;
import com.ge.med.terra.tap.dm.DMSequence;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.peerutils.Util;
import com.ge.med.terra.tap.util.dicom.DicomBytesBuilder;
import com.ge.med.terra.tap.util.dicom.DicomCharSet;
import com.ge.med.terra.tap.util.dicom.JdtExtension;
import com.ge.med.terra.tap.util.dicom.dicomParser;
import com.ge.med.terra.tap.util.dicom.tagValue;
import com.ge.med.terra.tap.util.dicom.vr;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.logging.Level;

public class DicomData {
    public static final SimpleDateFormat DA_FORMAT_PARSE = new SimpleDateFormat("yyyyMMdd");
    public static final SimpleDateFormat TM_FORMAT_PARSE = new SimpleDateFormat("HHmmss.SSS");
    protected DicomObject obj;
    private static final char MULTI_DELIM_CHAR = '\\';
    private static final String MULTI_DELIM = new String(new char[]{'\\', '\\'});

    public DicomData() {
        this(null);
    }

    public DicomData(Object internal) {
        this.obj = internal == null ? new DicomObject() : (DicomObject)internal;
    }

    public DicomCharSet[] dicomCharsets() {
        DicomCharset[] jdtDicomCharsets = this.obj.dicomCharsets();
        int n2 = jdtDicomCharsets.length;
        DicomCharSet[] dicomCharsets = new DicomCharSet[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            dicomCharsets[i2] = DicomCharSet.get(jdtDicomCharsets[i2].getDefinedTerm());
        }
        return dicomCharsets;
    }

    public void setDicomCharsets(DicomCharSet[] dicomCharsets) {
        String[] definedTerms = new String[dicomCharsets.length];
        for (int i2 = 0; i2 < dicomCharsets.length; ++i2) {
            definedTerms[i2] = dicomCharsets[i2].getDefinedTerm();
        }
        this.setValue(8, 5, definedTerms);
    }

    public Object getValue(String tagStr) {
        DMTag tag2;
        Object value = null;
        String[] tagInfo = Util.breakupString(tagStr);
        DicomData data = this;
        int item = 0;
        DicomData seqVal = null;
        for (int i2 = 1; i2 < tagInfo.length && null != data; ++i2) {
            if ((i2 & 1) == 0) {
                tag2 = DMTag.parseTagString(tagInfo[i2 - 2]);
                data = seqVal = (DicomData)data.getValue(tag2.getGroup(), tag2.getElement(), item);
                continue;
            }
            item = Integer.parseInt(tagInfo[i2]);
        }
        if (null != data && tagInfo.length > 0) {
            int element;
            tag2 = DMTag.parseTagString(tagInfo[tagInfo.length - 1]);
            int group = tag2.getGroup();
            int size = data.getSize(group, element = tag2.getElement());
            value = size > 1 ? data.getString(group, element) : data.getValue(group, element);
        }
        return value;
    }

    public Object getValue(DMTag t2) {
        return this.getValue(t2.getGroup(), t2.getElement());
    }

    public Object getValue(int g2, int e2) {
        return this.getValue(g2, e2, 0);
    }

    public Object getValue(int g2, int e2, int n2) {
        Object value = this.obj.get_ge(g2, e2, n2);
        if (value instanceof DicomObject) {
            value = new DicomData(value);
        } else {
            if (value instanceof Person) {
                return ((Person)value).toDICOMString();
            }
            if (value instanceof DDate) {
                return ((DDate)value).toDICOMString();
            }
        }
        return value;
    }

    public Object getValues(int g2, int e2) {
        Object[] dicomVal = null;
        DataElement dataElement = this.obj.getDataElement(g2, e2);
        if (null != dataElement) {
            int size = dataElement.size();
            if (1 == size) {
                dicomVal = dataElement.getValue();
            } else if (1 < size) {
                Object[] values = new Object[size];
                for (int index = 0; index < size; ++index) {
                    values[index] = dataElement.getValue(index);
                }
                dicomVal = values;
            }
        }
        return dicomVal;
    }

    public String getString(int group, int element) {
        return DicomData.getString(group, element, this.obj);
    }

    public static String getString(int group, int element, DicomObject dataset) {
        DataElement dataElement = dataset.getDataElement(group, element);
        if (null == dataElement || 0 == dataElement.size()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int index = 0; index < dataElement.size(); ++index) {
            if (index > 0) {
                sb.append('\\');
            }
            sb.append(dataElement.getString(index, true));
        }
        return sb.toString();
    }

    public void setString(int group, int element, int n2, String str) throws DMException {
        int vrep = dicomParser.dict.getVR(group, element);
        DicomCharSet[] dicomCharsets = this.dicomCharsets();
        this.setString(group, element, n2, vrep, dicomCharsets, str);
    }

    public void setString(int group, int element, int n2, int vrep, DicomCharSet[] dicomCharsets, String str) throws DMException {
        try {
            Object[] values;
            if (null == str || 0 == str.length()) {
                this.obj.set_ge(group, element, str, n2);
                return;
            }
            switch (vrep) {
                case 19535: 
                case 20558: 
                case 21320: {
                    String[] strs = str.split(MULTI_DELIM);
                    values = new Object[strs.length];
                    for (int i2 = 0; i2 < strs.length; ++i2) {
                        values[i2] = DicomBytesBuilder.hasEscapeSequence(strs[i2], dicomCharsets) ? (Object)DicomBytesBuilder.getDicomBytes(strs[i2], dicomCharsets) : strs[i2];
                    }
                    break;
                }
                case 19540: 
                case 21332: 
                case 21844: {
                    values = new Object[1];
                    if (DicomBytesBuilder.hasEscapeSequence(str, dicomCharsets)) {
                        values[0] = DicomBytesBuilder.getDicomBytes(str, dicomCharsets);
                        break;
                    }
                    values[0] = str;
                    break;
                }
                case 17235: {
                    if (8 == group && 5 == element) {
                        values = DicomCharSet.getDefinedTerms(str);
                        break;
                    }
                    values = str.split(MULTI_DELIM);
                    break;
                }
                case 16709: 
                case 17473: 
                case 17491: 
                case 18771: 
                case 21581: 
                case 21833: {
                    values = str.split(MULTI_DELIM);
                    break;
                }
                default: {
                    values = new Object[]{str};
                }
            }
            for (int i3 = 0; i3 < values.length; ++i3) {
                this.obj.set_ge(group, element, values[i3], i3);
            }
        }
        catch (Exception ex) {
            throw new DMException(tagValue.atToString(group, element) + ": " + ex.getMessage(), ex);
        }
    }

    public void setSequence(int group, int element, DMSequence dmSeq) throws DMException {
        int numItems = dmSeq.getNumberOfItems();
        for (int i2 = 0; i2 < numItems; ++i2) {
            DMTag[] tags;
            DicomData data = new DicomData();
            this.setValue(group, element, i2, data);
            DMSeqItem dmSeqItem = dmSeq.getItem(i2);
            for (DMTag tag2 : tags = dmSeqItem.getTags()) {
                Object val = dmSeqItem.getValue(tag2);
                data.setValue(tag2.getGroup(), tag2.getElement(), val);
            }
        }
    }

    public void setSequence(int group, int element, Object[] vals) throws DMException {
        for (int i2 = 0; i2 < vals.length; ++i2) {
            DicomData data = new DicomData();
            this.setValue(group, element, i2, data);
            Object[] tvs = (Object[])vals[i2];
            for (int j2 = 0; j2 < tvs.length; ++j2) {
                tagValue tv = (tagValue)tvs[j2];
                data.setValue(tv.group, tv.element, tv.value);
            }
        }
    }

    public void setDateValue(int group, int element, Date date) {
        String value = DA_FORMAT_PARSE.format(date);
        this.setValue(group, element, value);
    }

    public void setTimeValue(int group, int element, Date time) {
        String value = TM_FORMAT_PARSE.format(time);
        this.setValue(group, element, value);
    }

    public void setValues(DMElement[] elements) throws DMException {
        for (DMElement de : elements) {
            this.setValue(de);
        }
    }

    protected void setValue(DMElement de) throws DMException {
        Object value = null != de.valueAsBytes ? de.valueAsBytes : (Object)de.value;
        this.setValue(de.group, de.element, value);
    }

    public void setValue(String tagStr, Object value) {
        DMTag tag2;
        if (null == tagStr || "".equals(tagStr)) {
            return;
        }
        String[] tagInfo = Util.breakupString(tagStr);
        DicomData data = this;
        int item = 0;
        DicomData seqVal = null;
        for (int i2 = 1; i2 < tagInfo.length; ++i2) {
            if ((i2 & 1) == 0) {
                tag2 = DMTag.parseTagString(tagInfo[i2 - 2]);
                seqVal = (DicomData)data.getValue(tag2.getGroup(), tag2.getElement(), item);
                if (null == seqVal) {
                    seqVal = new DicomData();
                    data.setValue(tag2.getGroup(), tag2.getElement(), item, seqVal);
                }
                data = seqVal;
                continue;
            }
            item = Integer.parseInt(tagInfo[i2]);
        }
        tag2 = DMTag.parseTagString(tagInfo[tagInfo.length - 1]);
        data.setValue(tag2.getGroup(), tag2.getElement(), value);
    }

    public void setValue(int g2, int e2, Object val) throws DMException {
        this.obj.deleteItem_ge(g2, e2);
        this.setValue(g2, e2, 0, val);
    }

    public void setValue(int g2, int e2, int n2, Object val) throws DMException {
        if (0 < n2 && (val instanceof DMSequence || val instanceof Object[] && 1 < ((Object[])val).length)) {
            throw new DMException(tagValue.atToString(g2, e2) + ": Invalid value type " + val.getClass().getName() + " for index > 0");
        }
        try {
            if (val instanceof String) {
                this.setString(g2, e2, n2, (String)val);
            } else if (val instanceof DicomData) {
                this.setValue(g2, e2, n2, (DicomData)val);
            } else if (val instanceof DMSequence) {
                this.setSequence(g2, e2, (DMSequence)val);
            } else if (val instanceof Object[]) {
                Object[] vals = (Object[])val;
                if (vals.length > 0 && vals[0] instanceof Object[]) {
                    this.setSequence(g2, e2, vals);
                } else {
                    for (int i2 = 0; i2 < ((Object[])val).length; ++i2) {
                        this.obj.set_ge(g2, e2, ((Object[])val)[i2], i2);
                    }
                }
            } else {
                this.obj.set_ge(g2, e2, val, n2);
            }
        }
        catch (Exception ex) {
            throw new DMException(tagValue.atToString(g2, e2) + ": " + ex.getMessage(), ex);
        }
    }

    public void setValue(int g2, int e2, int itemNum, DicomData item) throws DMException {
        this.setValue(g2, e2, itemNum, item == null ? null : item.obj);
    }

    public void copyValue(int group, int element, DicomData data) throws DMException {
        Object dicomVal = this.getValues(group, element);
        if (null != dicomVal || null == data.getValue(group, element)) {
            data.setValue(group, element, dicomVal);
        }
    }

    public void removeTag(int g2, int e2) {
        this.obj.deleteItem_ge(g2, e2);
    }

    public void removeItem(int g2, int e2, int i2) {
        this.obj.deleteItem_ge(g2, e2, i2);
    }

    public Enumeration enumerateVRs(boolean grouplens) {
        return this.obj.enumerateVRs(grouplens);
    }

    public int getVR(int group, int element) throws DMException {
        try {
            String vrName = DDictBase.getTypeName(this.obj.getType_ge(group, element));
            int vrep = vr.StringVRint(vrName);
            return vrep;
        }
        catch (DicomException ex) {
            throw new DMException(tagValue.atToString(group, element) + ": " + ex.getMessage(), ex);
        }
    }

    public void setVR(int group, int element, int vrep) throws DMException {
        if (null == this.obj.get_ge(group, element)) {
            this.obj.newDataElement_ge(group, element);
        }
        try {
            this.obj.setType_ge(group, element, JdtExtension.tapToJdtVr(vrep));
        }
        catch (DicomException ex) {
            throw new DMException(tagValue.atToString(group, element) + ": " + ex.getMessage(), ex);
        }
    }

    public void newDataElement(int group, int element) {
        this.obj.newDataElement_ge(group, element);
    }

    public int getSize(int group, int element) {
        return this.obj.getSize_ge(group, element);
    }

    public int numberOfElements() {
        return this.obj.numberOfElements();
    }

    public InputStream getInputStream(boolean asPart10File) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.obj.write(bout, asPart10File);
            byte[] data = bout.toByteArray();
            ByteArrayInputStream bin = new ByteArrayInputStream(data);
            return bin;
        }
        catch (Exception ex) {
            Tap.log.log(Level.WARNING, "Unable to get input stream: ", ex);
            return null;
        }
    }

    public void read(InputStream in) throws DMException {
        try {
            this.obj.read(in);
        }
        catch (Exception ex) {
            throw new DMException(ex.getMessage());
        }
    }

    public void write(OutputStream out, boolean dicomfile) throws DMException {
        try {
            this.obj.write(out, dicomfile);
        }
        catch (Exception ex) {
            throw new DMException(ex.getMessage());
        }
    }

    public void write(OutputStream out, boolean dicomfile, int transfersyntax, boolean sequndef) throws DMException {
        try {
            this.obj.write(out, dicomfile, transfersyntax, sequndef);
        }
        catch (Exception ex) {
            throw new DMException(ex.getMessage());
        }
    }

    public void write(OutputStream out, boolean dicomfile, int transfersyntax, boolean sequndef, boolean grouplens) throws DMException {
        try {
            this.obj.write(out, dicomfile, transfersyntax, sequndef, grouplens);
        }
        catch (Exception ex) {
            throw new DMException(ex.getMessage());
        }
    }

    public void printDebugInfo(OutputStream out) throws IOException {
        this.obj.dumpVRs(out);
    }

    static {
        JdtExtension.updateJDT();
    }
}

